#!/bin/env python
# -*- coding: utf-8 -*-

import difflib
import sys
import argparse
import webbrowser
import os
import filecmp
import subprocess
import platform

bIncludeCi = False
if len(sys.argv) > 1 and sys.argv[1] == "ci":
    bIncludeCi = True

if bIncludeCi == False:
    print(
        "************************************************************\n"
        "如果下面报告类似 ImportError: No module named 'xxx' 的错误，\n"
        "说明 python 运行环境中缺少必要的包。\n"
        "此时可以启动\"安装python包\"任务来修复 python 运行环境(需要连接互联网)。\n"
        "************************************************************\n"
    )

from colorama import Fore, init, AnsiToWin32
init(wrap=False)
stream = AnsiToWin32(sys.stderr).stream

red = lambda text: '\033[0;31;1m' + text + '\033[0m'
green = lambda text: '\033[0;32;1m' + text + '\033[0m'
yellow = lambda text: '\033[0;33;1m' + text + '\033[0m'

# 读取文件
def read_file(file_name):
    try:
        file_desc = open(file_name, 'r')
        # 读取后按行分割
        text = file_desc.read().splitlines()
        file_desc.close()
        return text
    except IOError as error:
        print('Read input file Error: {0}'.format(error))
        sys.exit()



# 比较时忽略行末的空格和文件末尾的回车换行
def advanced_file_compare(file1, file2):
    f1 = open(file1)
    f2 = open(file2)
   
    returnVal = 1

    str1 = []
    for line1 in f1:
        line1 = line1.rstrip()
        line1 = line1.replace('\n', '')
        if len(line1) != 0:
            str1.append(line1)
    str2 = []
    for line2 in f2:
        line2 = line2.rstrip()
        line2 = line2.replace('\n', '')
        if len(line2) != 0:
            str2.append(line2)
    
    count = 0
    if len(str1) == len(str2):
        for line1 in str1:
            if line1 != str2[count]: #文件不同
                returnVal = 0
                break
            else:
                count = count + 1
    else:
        returnVal = 0
           
    f1.close()
    f2.close()
   
    return returnVal

# 比较两个文件并把结果生成一份html文本
def compare_file(file1, file2, seqNum, caseCount, bIncludeCi):
    returnVal = 0
    if file1 == "" or file2 == "":
        print('文件路径不能为空：第一个文件的路径：{0}, 第二个文件的路径：{1} .'.format(file1, file2))
        sys.exit()
    else:
        print("正在比较标准答案输出文件 {0} 和用户编写的应用程序输出文件 {1}".format(file1, file2), end=': ')

    if os.path.isfile(file1) and os.path.isfile(file2) and advanced_file_compare(file1, file2):
        print("文件相同")
        score = 40
        if seqNum == caseCount:
            score = 100
        else:
            score = score + 60 / caseCount * seqNum

        if bIncludeCi :
            promptInfo = "Case{0} 验证成功".format(seqNum)
            outputPromptInfo(bIncludeCi, promptInfo, 1)
            print("exec-score", int(score))
        else:
            promptInfo = "Case{0} 验证成功, 分数: {1}".format(seqNum, int(score))
            outputPromptInfo(bIncludeCi, promptInfo, 1)

        if seqNum == caseCount:
            promptInfo = "恭喜你通过了所有测试！"
            outputPromptInfo(bIncludeCi, promptInfo, 1)

        returnVal = 1
        return returnVal
    else:
        print("文件不同")
        promptInfo = "Case{0} 验证失败".format(seqNum)
        outputPromptInfo(bIncludeCi, promptInfo, 2)

    if bIncludeCi == False:
        text1_lines = read_file(file1)
        text2_lines = read_file(file2)
        diff = difflib.HtmlDiff()    # 创建HtmlDiff 对象
        result = diff.make_file(text1_lines, text2_lines)  # 通过make_file 方法输出 html 格式的对比结果
        # 将结果写入到result_comparation.html文件中
        try:
            with open('result_comparation.html', 'a+', encoding="utf-8") as result_file:
                promptContent = "<p>Case {0} 验证失败。使用的标准输入文件是 intput{0}.txt。</br>标准答案输出文件 output{0}.txt（左边）与用户编写的应用程序输出文件 user_output{0}.txt（右边）的比较结果：</p>".format(seqNum)
                result = promptContent + result
                result_file.write(result)
        except IOError as error:
            print('写入html文件错误：{0}'.format(error))
        finally:
            return returnVal
    else:
        return returnVal



# 1表示绿色,2表示红色,3表示黄色
def outputPromptInfo(bIncludeCi, promptInfo, color):

    if bIncludeCi :
        if color == 1:
            print(green(promptInfo))
        elif color == 2:
            print(red(promptInfo))
        elif color == 3:
            print(yellow(promptInfo))
        else:
            print(promptInfo)
    else:
        if color == 1:
            print(Fore.GREEN + promptInfo, file = stream)
        elif color == 2:
            print(Fore.RED + promptInfo, file = stream)
        elif color == 3:
            print(Fore.YELLOW + promptInfo, file = stream)  
        else:
            print(promptInfo)     
        print(Fore.WHITE, file = stream)
    sys.stdout.flush()


if __name__ == "__main__":
        
    compResultFile = "result_comparation.html"
    if os.path.isfile(compResultFile):
        os.remove(compResultFile)


    promptInfo = "正在使用 makefile 文件生成项目"
    outputPromptInfo(bIncludeCi, promptInfo, 1)
    execResult = os.system("make")

    if execResult != 0:
        errorInfo = "生成项目失败"
        outputPromptInfo(bIncludeCi, errorInfo, 2)
        exit(1) 
    else:
        score = 40
        if not os.path.isfile("output1.txt"):
            score = 100
        if bIncludeCi:
            promptInfo = "生成项目成功"
            outputPromptInfo(bIncludeCi, promptInfo, 1)
            promptInfo = "exec-score {0}".format(score)
            print(promptInfo)
        else:
            promptInfo = "生成项目成功, 分数 {0}".format(score)
            outputPromptInfo(bIncludeCi, promptInfo, 1)
            

    # 获取case的数量
    caseCount = 1
    while 1:
        outputFile = "output{0}.txt".format(caseCount)
        if not os.path.isfile(outputFile):
            caseCount -= 1
            break
        caseCount += 1


    seqNum = 1
    while 1:     
        inputFile = "input{0}.txt".format(seqNum)
        outputFile = "output{0}.txt".format(seqNum)
        useroutputFile = "user_output{0}.txt".format(seqNum)
        if seqNum == 1 and not os.path.isfile(outputFile):
            promptInfo = "该项目未提供自动化验证功能"
            if bIncludeCi :
                print(red(promptInfo))
            else:
                print(Fore.RED + "该项目未提供自动化验证功能", file = stream, end='')
                print(Fore.WHITE, file = stream)
            break
        if not os.path.isfile(outputFile):
            break
        print("正在使用文件 {0} 验证 case{1}".format(inputFile, seqNum))

        runCommand = "./app.exe < {0} > {1}".format(inputFile, useroutputFile)
        if platform.system().lower() == 'windows':
            runCommand = "app.exe < {0} > {1}".format(inputFile, useroutputFile)

        promptInfo = "执行的命令是: {0}".format(runCommand)
        outputPromptInfo(bIncludeCi, promptInfo, 0)

        if bIncludeCi == False:
            promptInfo = "提示：如果验证程序长时间未结束，说明应用程序中可能存在死循环。请停止验证程序(Ctrl+c)，修改应用程序后再验证。"
            outputPromptInfo(bIncludeCi, promptInfo, 3)

        execResult = os.system(runCommand)
        if execResult != 0:
            errorInfo = "应用程序执行异常，返回值：{0}。".format(execResult)
            outputPromptInfo(bIncludeCi, errorInfo, 2)
            exit(1)
 
        if os.path.isfile(outputFile) and os.path.isfile(useroutputFile):
            if compare_file(outputFile, useroutputFile, seqNum, caseCount, bIncludeCi) == 0:
                if bIncludeCi :
                    print("使用的标准输入文件是 intput{0}.txt。\n标准答案输出文件 output{1}.txt（左边）与用户编写的应用程序输出文件 user_output{2}.txt（右边）的比较结果：".format(seqNum, seqNum, seqNum))
                    runCommand = "diff {0} {1} -b -B -y -i -W 100".format(outputFile, useroutputFile)                
                    execResult = os.system(runCommand)
                else:
                    promptInfo = "查看文件比较结果可帮助你查找验证失败的原因。方法是：\n选择 View 菜单中的 Explorer 打开文件列表，右键点击 result_comparation.html 文件，在弹出的菜单中选择 Open Preview"
                    outputPromptInfo(bIncludeCi, promptInfo, 2)
                exit(1)
        seqNum = seqNum + 1
