#!/bin/bash

function wait_emulator_to_be_ready() {
  echo -e "\n\033[0;33;1mEmulator is booting,please wait.\033[0m\n"
  boot_completed=false
  while [ "$boot_completed" == false ]; do
    status=$(adb wait-for-device shell getprop sys.boot_completed | tr -d '\r')
    echo -e -n "\033[0;33;1m. \033[0m"

    if [ "$status" == "1" ]; then
      boot_completed=true
      echo " "
    else
      sleep 1
    fi
  done
}



function disable_animation() {
  adb shell "settings put global window_animation_scale 0.0"
  adb shell "settings put global transition_animation_scale 0.0"
  adb shell "settings put global animator_duration_scale 0.0"
}

sleep $1
wait_emulator_to_be_ready
sleep 1
disable_animation
