/***

Copyright (c) 2008 ӢʱƼ޹˾Ȩ

ֻ EOS ԴЭ飨μ License.txtеʹЩ롣
ܣʹЩ롣

ļ: block.c

: ڸļʵ˿豸㣬豸һ߼㡣
	  
	  ڵ EOS API  ReadFile  WriteFile дļʱջᱻļϵͳ
	  תΪԴĶдԴĶдͨñļе
	  IopReadWriteSector ʵֵġ

	  ͬʱʵȷ (FCFS) ̵㷨



*******************************************************************************/

#include "iop.h"
#include "psp.h"


//
// 豸д̵ȵһ
//
MUTEX DiskScheduleMutex;	// ߳ʹøûź
BOOL IsDeviceBusy;			// 豸æı־
ULONG CurrentCylinder;		// ̵ĴͷǰڵĴŵš
LIST_ENTRY RequestListHead;	// Դ豸дĶС

#ifdef _DEBUG

typedef struct _REQCURCYLINDER
{
	ULONG CurCylinder;
	ULONG ReqCylinder;
	ULONG CurThreadId;
	LONG Offset;
}REQCURCYLINDER,*PREQCURCYLINDER;

volatile INT ThreadSeq = 0;
INT ThreadCount = 0;

REQCURCYLINDER CurReqCy[20];

#endif


VOID
IopInitializeBlockDeviceLayer(
	VOID
	)
/*++


	ʼ豸㡣


	ޡ

ֵ
	ޡ

--*/
{
	PsInitializeMutex(&DiskScheduleMutex, FALSE);
	IsDeviceBusy = FALSE;
	CurrentCylinder = 0;
	ListInitializeHead(&RequestListHead);
}


//
// Դ̵ϢͳƵһ
//
PRIVATE BOOL IsDiskScheduleWorking = FALSE;	// ̵ڹı־
PRIVATE ULONG TotalOffset = 0, GTotalOffset = 0;		// ͷƶ
PRIVATE ULONG TransferTimes = 0, GTransferTimes = 0;	// ͷƶ


PREQUEST
IopReceiveRequest(
	IN ULONG SectorNumber
	)
/*++


	̶߳Կ豸ĶдתΪһ


	SectorNumber -- ߳Ҫдš

ֵ
	ָ롣

--*/
{
	LONG Offset;
	CHAR Direction;
	PREQUEST pRequest;

	//
	// һ󣨷ڴ棩
	//
	pRequest = (PREQUEST)MmAllocateSystemPool(sizeof(REQUEST));

	//
	// ̶߳Կ豸Ķдʼ
	// żŵţĿǰ EOS Ĵ豸ֻһ
	// ֱʹÿŵ18ʹͷ2ӦĴŵš
	//
	pRequest->Cylinder = SectorNumber / 18 / 2;
	PsInitializeEvent(&pRequest->Event, TRUE, TRUE);

	PsWaitForMutex(&DiskScheduleMutex, INFINITE);	// ٽ

	if (IsDeviceBusy) {
		
		//
		// 豸æ˵߳ڷʴ̣е¼ΪЧ
		// ״̬˳ٽ󣬵ǰ̻߳ڸ¼̵ֱ㷨ѡС
		//
		PsResetEvent(&pRequest->Event);

		if (!IsDiskScheduleWorking) {

			//
			// ̵ɷǹ״̬빤״̬
			//
			IsDiskScheduleWorking = TRUE;
		}

	} else {

		//
		// ǰ̶߳ռʴ豸ô豸æ
		//
		IsDeviceBusy = TRUE;
	}

	//
	// 뵽еĩβ
	//
	ListInsertTail(&RequestListHead, &pRequest->ListEntry);

	PsReleaseMutex(&DiskScheduleMutex);		// ˳ٽ

	//
	// ǰ̵߳ȴӦе¼߳ڷʴ̣
	// ǰ߳̾ͻڸ¼̵ֱ㷨ѡС
	//
	PsWaitForEvent(&pRequest->Event, INFINITE);

	if (IsDiskScheduleWorking) {

		//
		// ͷƶ벢жϴͷƶ
		//
		Offset = pRequest->Cylinder - CurrentCylinder;

		if (Offset > 0)
			Direction = '+';	// ŵӡͷƶ
		else if (Offset < 0)
			Direction = '-';	// ŵżСͷƶ
		else
			Direction = '=';	// ŵŲ䡣ͷƶ
	
#ifdef _DEBUG	
		CurReqCy[ThreadSeq].CurCylinder = CurrentCylinder;
		CurReqCy[ThreadSeq].ReqCylinder = pRequest->Cylinder;
		CurReqCy[ThreadSeq].Offset = Offset;
		CurReqCy[ThreadSeq].CurThreadId = ObGetObjectId(PspCurrentThread);
		
		ThreadSeq++;
		ThreadCount = ThreadSeq;

#endif
		//
		// ӴͷƶӴͷƶ
		//
		TotalOffset += abs(Offset);
		TransferTimes++;
	}

	return pRequest;
}


PREQUEST
IopDiskSchedule(
	VOID
	);


VOID
IopProcessNextRequest(
	IN PREQUEST pCurrentRequest
	)
/*++


	ǰ󣬲ʼһ


	pCurrentRequest -- ǰ

ֵ
	ޡ

--*/
{
	PREQUEST pNextRequest;

	ASSERT(pCurrentRequest != NULL);

	PsWaitForMutex(&DiskScheduleMutex, INFINITE);	// ٽ

	//
	// ǰӦ̸߳ոɶԴ̵ķʣ
	// ʵĴŵžǴͷڵĴŵš
	//
	CurrentCylinder = pCurrentRequest->Cylinder;

	//
	// ѴϵĵǰƳͷڴ棩
	//
	ListRemoveEntry(&pCurrentRequest->ListEntry);
	MmFreeSystemPool(pCurrentRequest);

	if (ListIsEmpty(&RequestListHead)) {

		//
		// бΪգ豸˳æ״̬
		//
		IsDeviceBusy = FALSE;
		GTotalOffset = TotalOffset;		
		GTransferTimes = TransferTimes;	

		if (IsDiskScheduleWorking) {

			//
			// ù״̬
			//
			IsDiskScheduleWorking = FALSE;
			TotalOffset = 0;
			TransferTimes = 0;
		}
	
	} else {

		//
		// вգɴ̵㷨ѡҪһ
		//
		pNextRequest = IopDiskSchedule();

		//
		// ѡее¼ΪЧڸ¼ϵ̼߳ɷʴ̡
		//
		PsSetEvent(&pNextRequest->Event);
	}

	PsReleaseMutex(&DiskScheduleMutex);		// ˳ٽ
}


//
// 豸ʹõΨһһ̬䣩
//
PRIVATE BYTE BlockDeviceBuffer[512];


STATUS
IopReadWriteSector(
	IN PDEVICE_OBJECT Device,
	IN ULONG SectorNumber,
	IN ULONG ByteOffset,
	IN OUT PVOID Buffer,
	IN ULONG BytesToRw,
	IN BOOL Read
	)
/*++


	дָ豸ע⣬ÿֻܴһڵݣܿ
	
	ڶȡһʱҪȽ뻺棬ȻٴӻжȡҪݡд
	һʱҲҪȽ뻺棬Ȼ޸Ļеݣٽ
	д豸
	
	ע⣬дʱΪӲ豸дÿαд
	ҪԶڵĲݽдΪ˱֤ͬһڵֽڲ
	󸲸ǣҪȶȡ棬Ȼֻ޸ĻеĲݣ
	д


	Device -- ҪдĿ豸Ӧ豸ָ롣
	SectorNumber -- дλڵš
	ByteOffset -- дλڵֽƫɳС(512)
	Buffer -- ָдڵĻ
	BytesToRw -- дֽByteOffset + BytesToRw ԳСҲ
				˵Կд
	Read -- ǷΪ TRUE жд

ֵ
	ɹ򷵻 STATUS_SUCCESSʾʧܡ

--*/
{
	STATUS Status;
	PREQUEST pCurrentRequest;

	ASSERT(NULL != Device && Device->IsBlockDevice);
	ASSERT(ByteOffset < 512);
	ASSERT(0 < BytesToRw && BytesToRw <= 512);
	ASSERT(ByteOffset + BytesToRw <= 512);

	//
	// ǰ̶߳Դ̵ķתΪһ߳ڷʴ̣
	// ὫУȵ̵㷨ѡкٴ
	//
	pCurrentRequest = IopReceiveRequest(SectorNumber);

	PsWaitForMutex(&Device->Mutex, INFINITE);	// ٽ

	//
	// ÿ豸 Read ܺ뻺档
	//
	Status = Device->DriverObject->Read(Device, NULL, BlockDeviceBuffer, SectorNumber, NULL);
	if (!EOS_SUCCESS(Status))
		goto RETURN;
	
	if (Read) {

		//
		// 
		//
		memcpy(Buffer, BlockDeviceBuffer + ByteOffset, BytesToRw);

	} else {

		//
		// д
		//
		memcpy(BlockDeviceBuffer + ByteOffset, Buffer, BytesToRw);

		//
		// ÿ豸 Write ܺд
		//
		Status = Device->DriverObject->Write(Device, NULL, BlockDeviceBuffer, SectorNumber, NULL);
		if (!EOS_SUCCESS(Status))
			goto RETURN;
	}
	
RETURN:

	PsReleaseMutex(&Device->Mutex);		// ˳ٽ
	
	//
	// ɴ̵㷨ѡҪһ󣬲ʼ
	//
	IopProcessNextRequest(pCurrentRequest);

	return Status;
}


//
// N-Step-SCAN ̵㷨ʹõӶг N
//
#define SUB_QUEUE_LENGTH 6

//
// ¼ N-Step-SCAN ̵㷨һӶʣĳȡ
// ӶгʼΪ Nÿִһδ̵㷨ӶƳһӶ
// ȾҪ 1ȱΪ 0 ʱٽ±Ϊ NʼһӶС
//
ULONG SubQueueRemainLength = SUB_QUEUE_LENGTH;

//
// ɨ㷨дͷƶķ򡣲ϵͳʱʼΪͷƶ
// TRUEͷƶŵӡ
// FALSEͷƶŵż١
//
BOOL ScanInside = TRUE;


PREQUEST
IopDiskSchedule(
	VOID
	)
/*++


	̵ȡڱʵ̵ִֶ㷨
	 FCFSSSTFSCANCSCANN-Step-SCAN ȣ


	ޡ

ֵ
	شѡһҪָ롣

˵
	̵㷨ǸݵǰͷڵĴŵ͸߳ҪʵĴŵ
	еȵġеǰͷڵĴŵȫֱ CurrentCylinder У
	и Cylinder 򱣴˶Ӧ߳ҪʵĴŵ

	ע⣬úֻǴѡһҪ󣬶Ҫѡ
	ƳҲҪӦ̻߳ѡ

--*/
{
	PLIST_ENTRY pListEntry;
	PREQUEST pNextRequest;
	
	//
	// FCFS (First-Come,First-Served) ̵㷨һ򵥵Ĵ̵㷨
	// ѡеĵһ󣬴Ӷ̷߳ʴ̵Ⱥ˳еȡ
	//
	pListEntry = RequestListHead.Next;	// еĵһͷָһ
	
	//
	// ָ
	//
	pNextRequest = CONTAINING_RECORD(pListEntry, REQUEST, ListEntry);
	
	return pNextRequest;
}
