;***
;
; Copyright (c) 2008 ӢʱƼ޹˾Ȩ
;
; ֻ EOS ԴЭ飨μ License.txtеʹЩ롣
; ܣʹЩ롣
;
; ļ: boot.asm
;
; : 
;
; 
;
;*******************************************************************************/

; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;                               boot.asm
;
;     PC ӵCPU ʵģʽֶιڴ棬 1M ַռ䣨û
; д A20 £CPU ִ BIOS  BIOS 豸ȹ
;  BIOS Ϊ BIOS Ὣ̵512 ֽڣ
; صַ 0x7C00 - 0x7DFF Ȼ CPU  CS ĴΪ 0x0000,
;  IP ĴΪ 0x7C00 CPU Ϳʼִеĳ
;     ڶνΪ 64Kڲ޸ĶμĴֻܷ 0x0000  0xFFFF
; ĵַռ䣬ͱص˴˷Χڣһ
; Ҫ޸ĶμĴ
;     ʱڴӦӣ
;
;                 +-------------------------------------+----------------------
;          0x0000 |                                     |
;                 |   BIOS ж (1K)              |
;                 |   BIOS Interrupt Vector Table       |
;                 |                                     |
;                 +-------------------------------------+
;          0x0400 |   BIOS  (512 Bytes)           |
;                 |   BIOS Data Area                    |
;                 +-------------------------------------+
;          0x0600 |                                     |
;                 |                                     |
;                 |             û(1)             |   ڴ (640K)
;                 |                                     |  Conventional Memory
;                 |                                     |
;                 +-------------------------------------+
;          0x7C00 |    (512 Bytes)          |
;                 |   Floppy Boot Sector                |
;                 +-------------------------------------+
;          0x7E00 |                                     |
;                 |                                     |
;                 |             û(2)             |
;                 |                                     |
;                 |                                     |
;                 +-------------------------------------+----------------------
;         0xA0000 |                                     |
;                 |                                     |
;                 |   ϵͳռ (384K)                   |   λڴ (384K)
;                 |                                     |   Upper Memory
;                 |                                     |
;                 +-------------------------------------+----------------------
;        0x100000 |                                     |
;                 |                                     |   չڴ棨ֻн뱣ģʽܷʣ
;                 |                               |  Extended Memory
;                 Z                                     Z
;                 |                                     |
;    ڴ |                                     |
;                 +-------------------------------------+----------------------
;
;     EOS ѡ Loader.bin ӵһû 0x1000 ʼ
; أ 0x1000  0x7BFF Loader ֻΪ 0x7C00 - 0x1000 = 0x6C00
; ֽڡڱģʽа 4K Сзҳ Loader һҳĿʼ
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

	org 0x7C00
	jmp short Start
	nop					;  nop 

; ----------------------------------------------------------------------
; FAT12 ͷ
Oem						db 'Engintim'	; OEM String 8 ֽ
BytesPerSector			dw 512			; ÿֽ					----+
SectorsPerCluster		db 1			; ÿض						|
ReservedSectors			dw 1			; Boot ¼ռö				|
Fats					db 2			; FAT 							|
RootEntries				dw 224			; Ŀ¼ļֵ				|
Sectors					dw 2880			; 							\\ BPB
Media					db 0xF0			; 							// BIOS Parameter Block
SectorsPerFat			dw 9			; ÿ FAT 						|
SectorsPerTrack			dw 18			; ÿŵ						|
Heads					dw 2			; ͷ							|
HiddenSectors			dd 0			; 						|
LargeSectors			dd 0			; Sectors Ϊ 0 ʱʹ	----+
DriveNumber				db 0			; 
Reserved				db 0			; δ
Signature				db 0x29			;  (0x29)
Id						dd 0			; к
VolumeLabel				db 'EOS        '; ꣬ 11 ֽ
SystemId				db 'FAT12   '	; ļϵͳͣ 8 ֽ
;------------------------------------------------------------------------

; FAT12 ļϵͳصһЩ
FirstSectorOfRootDir	dw 0			; Ŀ¼ʼ
RootDirectorySectors	dw 0			; Ŀ¼ռõ
FirstSectorOfFileArea	dw 0			; ʼ
BufferOfFat				dw 0			; FAT ַ
BufferOfRootDir			dw 0			; Ŀ¼ַ

LOADER_ORG				equ	0x1000				; Loader.bin ʼַ
MAX_FILE_SIZE			equ 0x6C00				; Loader.bin ֻռ 0x1000  0x7C00 Ŀռ
wFilePos				dw	LOADER_ORG			; ڼ Loader.bin α
LoaderFileName			db	"LOADER  BIN"		; Loader.bin ļ
strError:				db	"File Loader.bin not found!"

Start:
	; ʼ CPU ĶμĴΪ CS ֵ(0)ջ 64K 
	mov	ax, cs
	mov	ds, ax
	mov	es, ax
	mov	ss, ax
	xor sp, sp
	mov bp, sp

	; ʼĻ
	mov	ax, 0x0600		; AH = 0x06,  AL = 0x00
	mov	bx, 0x0700		; ڵװ(BH = 0x07)
	xor cx, cx			; Ͻ: (к  0, к  0)
	mov	dx, 0x184F		; ½: (к 79, к 24)
	int	0x10
	
	; λ
	xor	ah, ah
	xor	dl, dl
	int	0x13
	
	;
	; Ŀ¼ʼ
	; FirstSectorOfRootDir = ReservedSectors + SectorsPerFat * Fats
	;
	mov ax, word [SectorsPerFat]
	movzx bx, byte [Fats]
	mul bx
	add ax, word [ReservedSectors]
	mov word [FirstSectorOfRootDir], ax
	
	;
	; Ŀ¼ռõ
	; RootDirectorySectors = RootEntries * 32 / BytesPerSector
	;
	mov ax, word [RootEntries]
	shl ax, 5
	mov bx, word [BytesPerSector]
	div bx
	mov word [RootDirectorySectors], ax
	
	;
	; ʼ
	; FirstSectorOfFileArea = FirstSectorOfRootDir + RootDirectorySectors
	;
	add ax, word [FirstSectorOfRootDir]
	mov word [FirstSectorOfFileArea], ax
	
	;
	;  FAT ַ
	; BufferOfFat = 0x7C00 + BytesPerSector * ReservedSectors
	;
	mov ax, word [BytesPerSector]
	mul word [ReservedSectors]
	add ax, 0x7C00
	mov word [BufferOfFat], ax
	
	;
	; Ŀ¼ַ FAT 
	; BufferOfRootDir = BufferOfFat + BytesPerSector * SectorsPerFat
	;
	mov ax, word [BytesPerSector]
	mul word [SectorsPerFat]
	add ax, word [BufferOfFat]
	mov word [BufferOfRootDir], ax
	
	;  FAT1  FAT 
	mov ax, word [ReservedSectors]		; 
	mov cx, word [SectorsPerFat]		; һ FAT 
	mov bx, word [BufferOfFat]			; es:bx ָ FAT 
	call ReadSector
	
	; Ŀ¼뻺
	mov ax, word[FirstSectorOfRootDir]
	mov cx, word[RootDirectorySectors]
	mov bx, word[BufferOfRootDir]
	call ReadSector
	
	; ڸĿ¼в Loader.bin ļ
FindFile:
	mov	bx, word [BufferOfRootDir]		; bx ָһĿ¼
	mov dx, word [RootEntries]			; Ŀ¼
	cld

CompareNextDirEntry:
	mov	si, LoaderFileName				; si -> "LOADER  BIN"
	mov di, bx							; di -> Ŀ¼ļַ
	mov	cx, 11							; ļַĳ
	repe cmpsb							; ַȽ
	cmp	cx, 0
	je	CheckFileSize					; Ƚ 11 ַ, ʾҵļ
	
	; ļһ£ȽһĿ¼
	add bx, 0x20						; bx ָһĿ¼
	dec dx								; СʣĿ¼
	jnz CompareNextDirEntry
	
	; Ŀ¼ûҵļʾ
	jmp	Error

	; ҵļ󣬼ļĴС
CheckFileSize:
	mov eax, dword [bx + 0x1C]			; õļĴС
	test eax, eax
	jz Error
	cmp eax, MAX_FILE_SIZE
	ja Error
	
	; ʼļ
	mov	ax, word [bx + 0x1A]			; ʼ ax Ϊļĵһغ
ReadNextCluster:
	push ax								; ҪȡĴغ
	
	;
	;  ax ŴضӦţ = ʼ + غ - 2 * ÿ
	;
	sub ax, 2
	movzx cx, byte [SectorsPerCluster]
	mul	cx
	add ax, word [FirstSectorOfFileArea]
	
	mov bx, word [wFilePos];			; ļַ
	
	call ReadSector						; һ
	
	;
	; ļλƶһصĴС
	; wFilePos = wFilePos + BytesPerSector * SectorsPerCluster
	;
	mov ax, word [BytesPerSector]
	movzx bx, byte [SectorsPerCluster]
	mul bx
	add ax, word [wFilePos];
	mov word [wFilePos], ax		
	
	;  FAT һҪȡĴ
	pop ax								; նȡĴغ
	mov bx, 3
	mul bx
	mov bx, 2
	div bx
	mov bx, word [BufferOfFat]
	add bx, ax
	mov ax, word [bx]
	test dx, dx
	jz EvenClusterNo
	shr	ax, 4
	jmp CheckEOC
EvenClusterNo:
	and ax, 0x0FFF
	
	; ݴغжļǷûȡ
CheckEOC:
	cmp ax, 0x0FF7
	jb	ReadNextCluster
	
	; ļȡϣر
	mov	dx, 0x03F2
	xor	al, al
	out	dx, al
	
	; Loader.bin ϣת Loader.bin ִ
	jmp	0:LOADER_ORG
	
	; ĻϽʾϢַѭ
Error:	
	mov bp, strError
	mov	ax, 0x1301				; AH = 0x13,  AL = 0x01
	mov	bx, 0x0007				; ҳΪ 0 (BH = 0x00)ڵװ (BL = 0x07)
	mov cx, 26					; ַ
	xor dx, dx
	int	0x10
	jmp $

;----------------------------------------------------------------------------
; : ReadSector
;   : ӵ ax  Sector ʼ,  cl  Sector  es:bx 
;----------------------------------------------------------------------------
ReadSector:
	push bp
	mov	bp, sp
	push cx						;  cl
	push bx						;  bx
	
	;
	;  šʼ  ͷ
	; Ϊ x
	;                             = y >> 1
	;       x             y 
	; -------------- =>        ͷ = y & 1
	;  ÿŵ     
	;                     z => ʼ = z + 1
	;
	mov	bl, [SectorsPerTrack]	; bl: 
	div	bl						; y  al , z  ah 
	inc	ah						; z ++
	mov	cl, ah					; cl <- ʼ
	mov	dh, al					; dh <- y
	shr	al, 1					; y >> 1 (ʵ y / Heads,  Heads = 2)
	mov	ch, al					; ch <- 
	and	dh, 1					; dh & 1 = ͷ
	mov	dl, [DriveNumber]		;  (0 ʾ A )
	pop bx						; ָ bx
	
.GoOnReading:
	mov	ah, 2					; 
	mov	al, byte [bp-2]			;  al 
	int	0x13
	jc	.GoOnReading			; ȡ CF ᱻΪ 1, ʱͲͣض, ֱȷΪֹ

	; ָջ
	pop cx
	pop	bp
	ret

	;
	; ʣµĿռ䣬ʹɵĶƴǡΪ 512 ֽ
	;
	times 	510-($-$$)	db	0
	dw 	0xaa55					; ־
