/***

Copyright (c) 2008 ӢʱƼ޹˾Ȩ

ֻ EOS ԴЭ飨μ License.txtеʹЩ롣
ܣʹЩ롣

ļ: create.c

: ̵̡߳Ĵ



*******************************************************************************/

#include "psp.h"

PPROCESS PspSystemProcess = NULL;

VOID
PsCreateSystemProcess(
	IN PTHREAD_START_ROUTINE StartAddr
	)
/*++


	ϵͳ̡


	StartAddr -- ϵͳڵַ

ֵ
	ޡ

--*/
{
	STATUS Status;
	PTHREAD Thread;

	//
	// ϵͳΨһֻܱһΡ
	//
	ASSERT(NULL == PspSystemProcess);

	//
	// ̻
	//
	Status = PspCreateProcessEnvironment(24, NULL, NULL, &PspSystemProcess);

	ASSERT(EOS_SUCCESS(Status));

	//
	// ̵̡߳
	//
	Status = PspCreateThread( PspSystemProcess,
							  0,
							  StartAddr,
							  NULL,
							  0,
							  &Thread );

	ASSERT(EOS_SUCCESS(Status));

	PspSystemProcess->PrimaryThread = Thread;
}

STATUS
PsCreateProcess(
	IN PCSTR ImageName,
	IN PCSTR CmdLine OPTIONAL,
	IN ULONG CreateFlags,
	IN PSTARTUPINFO StartupInfo,
	OUT PPROCESS_INFORMATION ProcInfo
	)
/*++


	һӦý̡


	ImageName -- ̵Ŀִļȫ·ƣMAX_PATHΪա
	CmdLine -- в1024ַΪNULL
	CreateFlags -- Ŀǰ޲ѡ
	StartupInfo -- ½ṹ壬½Ҫʹõı׼
	ProcInfo -- ָ룬ָڱ̴ϢĽṹ塣

ֵ
	ɹ򷵻STATUS_SUCCESS

--*/
{
	STATUS Status;
	PVOID StdInputObject = NULL;
	PVOID StdOutputObject = NULL;
	PVOID StdErrorObject = NULL;
	PPROCESS ProcessObject = NULL;
	PTHREAD ThreadObject =NULL;
	HANDLE ProcessHandle = NULL;
	HANDLE ThreadHandle = NULL;

	if (NULL == ImageName || NULL == StartupInfo) {
		return STATUS_INVALID_PARAMETER;
	}

	do {

		//
		// ڸǰ̵ľΪӽԼӽ̵̶߳
		//
		Status = ObAllocateHandleEx(PspCurrentProcess->ObjectTable, &ProcessHandle);
		if (!EOS_SUCCESS(Status)) {
			break;
		}

		Status = ObAllocateHandleEx(PspCurrentProcess->ObjectTable, &ThreadHandle);
		if (!EOS_SUCCESS(Status)) {
			break;
		}

		//
		// ָı׼õָ룬ǷΪ
		// ЧĿɶд
		//
		Status = ObRefObjectByHandleEx( PspCurrentProcess->ObjectTable,
										StartupInfo->StdInput,
										NULL,
										&StdInputObject);
		if (!EOS_SUCCESS(Status)) {
			break;
		}
		if ((ObGetAccessMask(StdInputObject) & OB_READ_ACCESS) == 0) {
			Status = STATUS_INVALID_HANDLE;
			break;
		}

		Status = ObRefObjectByHandleEx( PspCurrentProcess->ObjectTable,
										StartupInfo->StdOutput,
										NULL,
										&StdOutputObject);
		if (!EOS_SUCCESS(Status)) {
			break;
		}
		if ((ObGetAccessMask(StdOutputObject) & OB_WRITE_ACCESS) == 0) {
			Status = STATUS_INVALID_HANDLE;
			break;
		}

		Status = ObRefObjectByHandleEx( PspCurrentProcess->ObjectTable,
										StartupInfo->StdError,
										NULL,
										&StdErrorObject);
		if (!EOS_SUCCESS(Status)) {
			break;
		}
		if ((ObGetAccessMask(StdErrorObject) & OB_WRITE_ACCESS) == 0) {
			Status = STATUS_INVALID_HANDLE;
			break;
		}

		//
		// һ̵̻ĿƿԼ̵ĵַռ;
		//
		Status = PspCreateProcessEnvironment(8, ImageName, CmdLine, &ProcessObject);

		if (!EOS_SUCCESS(Status)) {
			break;
		}

		//
		// ½̵ľΪ׼󴴽
		// Ϊ½̵ľĿǰǿյģԴ϶ʧܡ
		//
		Status = ObCreateHandleEx( ProcessObject->ObjectTable,
								   StdInputObject,
								   &ProcessObject->StdInput);
		ASSERT(EOS_SUCCESS(Status));

		Status = ObCreateHandleEx( ProcessObject->ObjectTable,
								   StdOutputObject,
								   &ProcessObject->StdOutput);
		ASSERT(EOS_SUCCESS(Status));

		Status = ObCreateHandleEx( ProcessObject->ObjectTable,
								   StdErrorObject,
								   &ProcessObject->StdError);
		ASSERT(EOS_SUCCESS(Status));

		StdInputObject = NULL;
		StdOutputObject = NULL;
		StdErrorObject = NULL;

		//
		// ؿִӳ񣨳ָݣ½̵ûַռС
		//
		Status = PspLoadProcessImage( ProcessObject,
									  ProcessObject->ImageName,
									  &ProcessObject->ImageBase,
									  (PVOID*)&ProcessObject->ImageEntry );

		if (!EOS_SUCCESS(Status)) {
			break;
		}

		//
		// ½̵̣߳н̵̶߳ӺPspProcessStartupʼִС
		//
		Status = PspCreateThread( ProcessObject,
								  0,
								  PspProcessStartup,
								  NULL,
								  CreateFlags,
								  &ThreadObject );

		if (!EOS_SUCCESS(Status)) {
			break;
		}

		ProcessObject->PrimaryThread = ThreadObject;

		//
		// øеľֵʹָ֮½ӽ̶̶߳
		// ̾ͿͨʺͿӽ̼߳ˡ
		//
		Status = ObSetHandleValueEx(PspCurrentProcess->ObjectTable, ProcessHandle, ProcessObject);
		ASSERT(EOS_SUCCESS(Status));

		Status = ObSetHandleValueEx(PspCurrentProcess->ObjectTable, ThreadHandle, ThreadObject);
		ASSERT(EOS_SUCCESS(Status));

		//
		// ÷ؽӽ̵̼߳ľID
		//
		ProcInfo->ProcessHandle = ProcessHandle;
		ProcInfo->ThreadHandle = ThreadHandle;
		ProcInfo->ProcessId = ObGetObjectId(ProcessObject);
		ProcInfo->ThreadId = ObGetObjectId(ThreadObject);

		Status = STATUS_SUCCESS;

	} while (0);

	//
	// ʧܣѽеĲлع
	//
	if (!EOS_SUCCESS(Status)) {

		if (ProcessHandle != NULL) {
			ObFreeHandleEx(PspCurrentProcess->ObjectTable, ProcessHandle);
		}
		if (ThreadHandle != NULL) {
			ObFreeHandleEx(PspCurrentProcess->ObjectTable, ThreadHandle);
		}
		if (StdInputObject != NULL) {
			ObDerefObject(StdInputObject);
		}
		if (StdOutputObject != NULL) {
			ObDerefObject(StdOutputObject);
		}
		if (StdErrorObject != NULL) {
			ObDerefObject(StdErrorObject);
		}
		if (ProcessObject != NULL) {
			PspDeleteProcessEnvironment(ProcessObject);
		}
	}

	return Status;
}

STATUS
PsCreateThread(
	IN SIZE_T StackSize,
	IN PTHREAD_START_ROUTINE StartAddr,
	IN PVOID ThreadParam,
	IN ULONG CreateFlags,
	OUT PHANDLE ThreadHandle,
	OUT PULONG ThreadId OPTIONAL
	)
/*++


	ڵǰڴһ̡߳


	StackSize -- ûģʽ߳ջĴСǰϵͳ֮Ŀǰ
		̶ִ߳ںջУʱá
	StartAddr -- ߳̿ʼִеĺָ롣
	ThreadParam -- ݸ̺߳Ĳ
	CreateFlags -- Ŀǰ޲ѡ
	ThreadHandle -- ָ룬ָڱ߳̾ı
	ThreadId -- ָ룬ָڱ߳IDıѡ

ֵ
	̳߳ɹ򷵻 STATUS_SUCCESS

--*/
{
	STATUS Status;
	HANDLE Handle;
	PTHREAD ThreadObject;

	if (NULL == StartAddr) {
		return STATUS_INVALID_PARAMETER;
	}

	//
	// Ϊ̶߳һ
	//
	Status = ObAllocateHandleEx(PspCurrentProcess->ObjectTable, &Handle);

	if (!EOS_SUCCESS(Status)) {
		return Status;
	}

	Status = PspCreateThread( PspCurrentProcess,
							  StackSize,
							  StartAddr,
							  ThreadParam,
							  CreateFlags,
							  &ThreadObject );

	//
	// ߳ʧͷ֮ǰľء
	//
	if (!EOS_SUCCESS(Status)) {
		ObFreeHandleEx(PspCurrentProcess->ObjectTable, Handle);
		return Status;
	}

	//
	// þֵʹָ´̶߳
	//
	Status = ObSetHandleValueEx(PspCurrentProcess->ObjectTable, Handle, ThreadObject);
	ASSERT(EOS_SUCCESS(Status));

	*ThreadHandle = Handle;
	if (ThreadId != NULL) {
		*ThreadId = ObGetObjectId(ThreadObject);
	}

	return STATUS_SUCCESS;
}

STATUS
PspCreateProcessEnvironment(
	IN UCHAR Priority,
	IN PCSTR ImageName,
	IN PCSTR CmdLine,
	OUT PPROCESS *Process
	)
/*++


	һ̵̻Ŀƿ顢ַռ;


	Priority -- ̵Ļȼڴ߳̽Ĭϼ̳ȼ
	ImageName -- ̵Ŀִļȫ·ƣMAX_PATHΪա
	CmdLine -- в1024ַΪNULL
	Process -- ̶ָ

ֵ
	ɹ򷵻 STATUS_SUCCESS

--*/
{
	STATUS Status;
	BOOL IntState;
	SIZE_T ImageNameSize;
	SIZE_T CmdLineSize;
	PPROCESS NewProcess;

	ASSERT(Priority <= 31);

	//
	// ִļƺвַռõڴ档
	//
	if (NULL != ImageName) {

		ImageNameSize = strlen(ImageName) + 1;

		if (ImageNameSize > MAX_PATH) {
			return STATUS_PATH_TOO_LONG;
		}

		if (NULL != CmdLine) {

			CmdLineSize = strlen(CmdLine) + 1;

			if (CmdLineSize > 1024) {
				return STATUS_INVALID_COMMAND_LINE;
			}

		} else {

			CmdLineSize = 0;
		}

	} else {

		//
		// ImageName Ϊ NULL  CmdLine
		//
		ImageNameSize = 0;
		CmdLineSize = 0;
	}

	//
	// ʼԭӲֹжϡ
	//
	IntState = KeEnableInterrupts(FALSE);

	do {

		//
		// һ̶
		//
		Status = ObCreateObject( PspProcessType,
								 NULL,
								 sizeof(PROCESS) + ImageNameSize + CmdLineSize,
								 0,
								 (PVOID*)&NewProcess );

		if (!EOS_SUCCESS(Status)) {
			break;
		}

		//
		// ϵͳֱʹϵͳ̵ַռ䣬´һ̵ַռ䡣
		//
		if (NULL == ImageName) {

			NewProcess->Pas = MmGetSystemProcessAddressSpace();

		} else {

			NewProcess->Pas = MmCreateProcessAddressSpace();

			if (NULL == NewProcess->Pas) {

				ObDerefObject(NewProcess);

				Status = STATUS_NO_MEMORY;

				break;
			}
		}

		//
		// Ϊ̷һ
		//
		NewProcess->ObjectTable = ObAllocateHandleTable();

		if (NULL == NewProcess->ObjectTable) {

			if (NULL != ImageName) {
				MmDeleteProcessAddressSpace(NewProcess->Pas);
			}

			ObDerefObject(NewProcess);

			Status = STATUS_NO_MEMORY;

			break;
		}

		//
		// ʼ̿ƿ顣
		//
		NewProcess->System = (ImageName == NULL);
		NewProcess->Priority = Priority;
		NewProcess->PrimaryThread = NULL;
		NewProcess->StdInput = NULL;
		NewProcess->StdOutput = NULL;
		NewProcess->StdError = NULL;
		NewProcess->ExitCode = 0;
		ListInitializeHead(&NewProcess->ThreadListHead);
		ListInitializeHead(&NewProcess->WaitListHead);

		//
		// ִӳвַǿ򿽱֮
		//
		if (NULL != ImageName) {

			NewProcess->ImageName = (PCHAR)NewProcess + sizeof(PROCESS);
			strcpy(NewProcess->ImageName, ImageName);

			if (NULL != CmdLine) {
				NewProcess->CmdLine = NewProcess->ImageName + ImageNameSize;
				strcpy(NewProcess->CmdLine, CmdLine);
			} else {
				NewProcess->CmdLine = NULL;
			}

		} else {

			NewProcess->ImageName = NULL;
			NewProcess->CmdLine = NULL;
		}

		//
		// ڱPspDeleteProcessEnvironment֮ǰһݶԼá
		//
		ObRefObject(NewProcess);

		//
		// ÷ֵ
		//
		*Process = NewProcess;
		Status = STATUS_SUCCESS;

	} while (0);

	KeEnableInterrupts(IntState);	// ԭӲɣָжϡ

	return Status;
}

STATUS
PspCreateThread(
	IN PPROCESS Process,
	IN SIZE_T StackSize,
	IN PTHREAD_START_ROUTINE StartAddr,
	IN PVOID ThreadParam,
	IN ULONG CreateFlags,
	OUT PTHREAD *Thread
	)
/*++


	ָڴһ̡߳


	Process -- ̶ָ룬´̡߳̽
	StackSize -- ûģʽ߳ջСĿǰ̶ִ߳ں̬ʱá
	StartAddr -- ߳̿ʼִеĺָ롣
	ThreadParam -- ݸ̺߳Ĳ
	CreateFlags -- Ŀǰ޲ѡ
	Thread -- ̶ָ߳롣

ֵ
	̳߳ɹ򷵻 STATUS_SUCCESS

--*/
{
	STATUS Status;
	BOOL IntState;
	PTHREAD NewThread;
	SIZE_T KernelStackSize;

	ASSERT(NULL != Process && NULL != StartAddr && NULL != Thread);

	IntState = KeEnableInterrupts(FALSE);

	do {

		//
		// ̶߳
		//
		Status = ObCreateObject( PspThreadType,
								 NULL,
								 sizeof(THREAD),
								 0,
								 (PVOID*)&NewThread );

		if (!EOS_SUCCESS(Status)) {
			break;
		}
	
#ifdef _DEBUG
		MaxTid = ObGetObjectId(NewThread);
		RECORD_TASK_STATE(ObGetObjectId(NewThread) , TS_CREATE, Tick);
#endif		
		
		//
		// Ϊ̷ִ߳ں̬ʱںջ
		// ںջλϵͳַռУĿǰС̶Ϊ8KB
		//
		NewThread->KernelStack = NULL;
		KernelStackSize = KERNEL_STACK_SIZE;

		Status = MmAllocateVirtualMemory( &NewThread->KernelStack,
										  &KernelStackSize,
										  MEM_RESERVE | MEM_COMMIT,
										  TRUE );

		if (!EOS_SUCCESS(Status)) {
			ObDerefObject(NewThread); // ͷѴ̶߳
			break;
		}

		//
		// ụ̂߳ûַռΪ̷߳ûģʽջ
		// Ŀǰ̶߳һֱִںģʽջУûûģʽջԴ˲
		//
		/*if (!Process->System) {
		}*/

		//
		// ʼ߳̿ƿ顣
		//
		NewThread->Process = Process;
		NewThread->Priority = Process->Priority;	// ̼̳߳н̵ȼ
		NewThread->StartAddr = StartAddr;			// ̵߳Ŀʼִеַ
		NewThread->Parameter = ThreadParam;			// ̺߳Ĳ
		NewThread->State = Zero;
		NewThread->RemainderTicks = TICKS_OF_TIME_SLICE;
		NewThread->WaitStatus = 0;
		NewThread->LastError = 0;
		NewThread->ExitCode = 0;
		ListInitializeHead(&NewThread->WaitListHead);
		PspInitializeThreadContext(NewThread);		// ʼ̵߳Ĵġ
		NewThread->AttachedPas = Process->Pas;		// ߳ڽ̵ĵַռִС

		//
		// ̲߳ڽ̵߳
		//
		ListInsertTail(&Process->ThreadListHead, &NewThread->ThreadListEntry);

		//
		// ʹ߳̽״̬
		//
		PspReadyThread(NewThread);
		
		
		//
		// ߳ڽǰһݶԼá
		//
		ObRefObject(NewThread);

		//
		// ߳̽״̵ִ̬߳ȡ
		//
		PspThreadSchedule();

		//
		// ÷ֵ
		//
		*Thread = NewThread;
		Status = STATUS_SUCCESS;

	} while (0);

	KeEnableInterrupts(IntState);

	return Status;
}
