/***

Copyright (c) 2008 ӢʱƼ޹˾Ȩ

ֻ EOS ԴЭ飨μ License.txtеʹЩ롣
ܣʹЩ롣

ļ: delete.c

: ̡߳̽Լغʵ֡



*******************************************************************************/

#include "psp.h"

extern LIST_ENTRY PspTerminatedListHead;

STATUS
PsTerminateProcess(
	IN HANDLE Handle,
	IN ULONG ExitCode
	)
/*++


	ָḶ̌ڽ̻жеá


	Handle -- ̵ľ
	ExitCode -- ̽롣

ֵ
	ɹ򷵻STATUSS_SUCESS

--*/
{
	STATUS Status;
	PPROCESS Process;

	Status = ObRefObjectByHandle(Handle, PspProcessType, (PVOID*)&Process);

	if (EOS_SUCCESS(Status)) {

		if (Process == PspCurrentProcess) {
			ObDerefObject(Process);
		}

		PspTerminateProcess(Process, ExitCode);

		//
		// ǰ̱Ĵûлִˡ
		//
		ObDerefObject(Process);
	}

	return Status;
}

STATUS
PsTerminateThread(
	IN HANDLE Handle,
	IN ULONG ExitCode
	)
/*++


	ָ̡߳


	Handle -- ̵߳ľ
	ExitCode -- ߳̽롣

ֵ
	ɹ򷵻STATUSS_SUCESS

--*/
{
	STATUS Status;
	PTHREAD Thread;

	Status = ObRefObjectByHandle(Handle, PspThreadType, (PVOID*)&Thread);

	if (EOS_SUCCESS(Status)) {

		if (Thread == PspCurrentThread || Thread == PspCurrentProcess->PrimaryThread) {
			ObDerefObject(Thread);
		}

		PspTerminateThread(Thread, ExitCode, FALSE);

		//
		// ǰ̻߳ǰ̱Ĵûлִˡ
		//
		ObDerefObject(Thread);
	}

	return Status;
}

VOID
PsExitProcess(
	IN ULONG ExitCode
	)
/*++


	˳ǰ̡


	ExitCode -- ˳롣

ֵ
	ޡ

--*/
{
	ASSERT(KeGetIntNesting() == 0);
	PspTerminateProcess(PspCurrentProcess, ExitCode);
}

VOID
PsExitThread(
	IN ULONG ExitCode
	)
/*++


	˳ǰ̡߳


	ExitCode -- ̽롣

ֵ
	ޡ

--*/
{
	ASSERT(KeGetIntNesting() == 0);
	PspTerminateThread(PspCurrentThread, ExitCode, FALSE);
}

VOID
PspDeleteProcessEnvironment(
	IN PPROCESS Process
	)
{
	BOOL IntState;

	IntState = KeEnableInterrupts(FALSE);

	//
	// ̵̱߳Ѿȫ߸ûд̡߳
	//
	ASSERT(NULL == Process->PrimaryThread);

	//
	// ܶͬһ̶ظ
	//
	ASSERT(NULL != Process->ObjectTable && NULL != Process->Pas);

	//
	// ͷžرѴ򿪾
	//
	ObFreeHandleTable(Process->ObjectTable);
	Process->ObjectTable = NULL;

	//
	// ǰ̸߳ŵ̵ĵַռִУִ
	//
	PspThreadAttachProcess(Process);

	//
	// ûַռеڴ档
	//
	MmCleanVirtualMemory();

	//
	// ǰ̷߳صԼ̵ĵַռмִС
	// ע⣺ǰ߳ڱŵϵͳ̵ַռмִС
	//
	if (PspCurrentProcess == Process) {
		PspThreadAttachProcess(PspSystemProcess);
	} else {
		PspThreadAttachProcess(PspCurrentProcess);
	}

	//
	// ɾ̵ַռ䡣
	//
	MmDeleteProcessAddressSpace(Process->Pas);
	Process->Pas = NULL;

	//
	// ѾɾٱԼá
	//
	ObDerefObject(Process);

	KeEnableInterrupts(IntState);
}

VOID
PspTerminateProcess(
	IN PPROCESS Process,
	IN ULONG ExitCode
	)
/*++


	ָ̡


	Process -- ̶ָ롣
	ExitCode -- ̽롣

ֵ
	ޡ

--*/
{
	BOOL IntState;
	PTHREAD Thread;

	IntState = KeEnableInterrupts(FALSE);

	if (NULL != Process->PrimaryThread) {

		//
		// ý̽־ָ߳ΪNULLͽ롣
		//
		Process->PrimaryThread = NULL;
		Process->ExitCode = ExitCode;

		//
		// ѵȴ̡̽߳
		//
		while (!ListIsEmpty(&Process->WaitListHead)) {
			PspWakeThread(&Process->WaitListHead, STATUS_SUCCESS);
		}

		//
		// ڵ̡߳
		// ע⣺ڽÿ̵ִ̺߳߳ȣ̶ִ߳
		// һεȼɡ
		//
		while (!ListIsEmpty(&Process->ThreadListHead)) {
			Thread = CONTAINING_RECORD(Process->ThreadListHead.Next, THREAD, ThreadListEntry);
			PspTerminateThread(Thread, ExitCode, TRUE);
		}

		//
		// ɾ̻
		//
		PspDeleteProcessEnvironment(Process);

		//
		// ̵ִ߳ȡ
		//
		PspThreadSchedule();
	}

	KeEnableInterrupts(IntState);
}

VOID
PspTerminateThread(
	IN PTHREAD Thread,
	IN ULONG ExitCode,
	IN BOOL IsTerminatingProcess
	)
/*++


	ָ̡߳


	Thread -- Ŀ̶ָ߳롣
	ExitCode -- ߳̽롣
	IsTerminatingProcess -- ִн̲

ֵ
	ޡ

--*/
{
	STATUS Status;
	BOOL IntState;
	SIZE_T StackSize;

	IntState = KeEnableInterrupts(FALSE);

	ASSERT(Thread->State != Zero);

	if (Thread->State != Terminated) {

		if (Thread == Thread->Process->PrimaryThread) {

			//
			// ߳ڽ̵̣߳߳ڵ̡
			//
			PspTerminateProcess(Thread->Process, ExitCode);

		} else {

			//
			// ѵȴ̡߳̽߳
			//
			while (!ListIsEmpty(&Thread->WaitListHead)) {
				PspWakeThread(&Thread->WaitListHead, STATUS_SUCCESS);
			}

			//
			// ߳Ŀǰ״̬ת״̬
			//
			if(Ready == Thread->State) {
				PspUnreadyThread(Thread);
			} else if (Waiting == Thread->State) {
				PspUnwaitThread(Thread);
			}

			Thread->State = Terminated;	
	
#ifdef	_DEBUG	
			RECORD_TASK_STATE(ObGetObjectId(Thread) , TS_STOPPED, Tick);
#endif
				
			ListInsertTail(&PspTerminatedListHead, &Thread->StateListEntry);

			//
			// ߳̽벢̴߳ӽ̵߳Ƴ
			//
			Thread->ExitCode = ExitCode;
			ListRemoveEntry(&Thread->ThreadListEntry);

			//
			// ͷ̵߳ںģʽջ
			// ע⣺ǰ߳ڽԼͷ߳ʹõںջ
			//
			if (Thread != PspCurrentThread) {

				StackSize = 0;

				Status = MmFreeVirtualMemory( &Thread->KernelStack,
											  &StackSize,
											  MEM_RELEASE,
											  TRUE );
				ASSERT(EOS_SUCCESS(Status));
			}

			//
			// ɾ̲߳ϵͳ̣߳ͷ̵߳ûģʽջĿǰ
			// ̶ִںģʽջУûûģʽջԴ˲
			//
			/*if (!Thread->Process->System) {

				//
				// ûģʽջڽ̵ûַռУǰ߳Ҫŵ
				// ̵ĵַռִС
				//
				PspThreadAttachProcess(Thread->Process);

				//
				// ͷűɾ̵߳ûģʽջ
				//
				
				//
				// ǰ߳·صԼ̵ĵַռִС
				//
				PspThreadAttachProcess(PspCurrentProcess);
			}*/

			//
			// ̲߳̽߳ٱԼá
			//
			ObDerefObject(Thread);	

			//
			// ע⣺ڽʱҪ̵ִ߳ȣΪ̵ִ̺߳ȡ
			//
			if (!IsTerminatingProcess) {
				PspThreadSchedule();
			}
		}
	}

	KeEnableInterrupts(IntState);
}

STATUS
PspOnWaitForProcessObject(
	IN PVOID ProcessObject,
	IN ULONG Milliseconds
	)
/*++


	ȴ̽


	ProcessObject -- ̶ָ롣
	Milliseconds -- ȴʱޣȴʱ򷵻STATUS_TIMEOUTΪINFINIT
		õȴֱȴɹ

ֵ
	STATUS_SUCCESS -- ȴɹ
	STATUS_TIMEOUT -- ȴʱ

--*/
{
	STATUS Status;
	BOOL IntState;

	IntState = KeEnableInterrupts(FALSE);

	//
	// Ѿ̷أڽ̵ĵȴеȴֱ̽
	//
	if (NULL == ((PPROCESS)ProcessObject)->PrimaryThread) {
		Status = STATUS_SUCCESS;
	} else {
		Status = PspWait(&((PPROCESS)ProcessObject)->WaitListHead, Milliseconds);
	}

	KeEnableInterrupts(IntState);

	return Status;
}

STATUS
PspOnWaitForThreadObject(
	IN PVOID ThreadObject,
	IN ULONG Milliseconds
	)
/*++


	ȴ߳̽


	ThreadObject -- ̶ָ߳롣
	Milliseconds -- ȴʱޣȴʱ򷵻STATUS_TIMEOUTΪINFINIT
		õȴֱȴɹ

ֵ
	STATUS_SUCCESS -- ȴɹ
	STATUS_TIMEOUT -- ȴʱ

--*/
{
	STATUS Status;
	BOOL IntState;

	IntState = KeEnableInterrupts(FALSE);

	ASSERT(Zero != ((PTHREAD)ThreadObject)->State);

	//
	// ߳Ѿ̷أڱ̵߳ĵȴеȴ
	//
	if (Terminated == ((PTHREAD)ThreadObject)->State) {
		Status = STATUS_SUCCESS;
	} else {
		Status = PspWait(&((PTHREAD)ThreadObject)->WaitListHead, Milliseconds);
	}

	KeEnableInterrupts(IntState);

	return Status;
}

VOID
PspOnDeleteThreadObject(
	IN PVOID ThreadObject
	)
/*++


	̶߳ɾ̶߳ʱá


	ThreadObject -- ̶ָ߳롣

ֵ
	ޡ

--*/
{
	ASSERT( Zero == ((PTHREAD)ThreadObject)->State ||
			Terminated == ((PTHREAD)ThreadObject)->State );

	//
	// ڽ״̶̬߳ӽ״̬Ƴ
	//
	if (Terminated == ((PTHREAD)ThreadObject)->State) {
		ListRemoveEntry(&((PTHREAD)ThreadObject)->StateListEntry);
	}
}
