/***

Copyright (c) 2008 ӢʱƼ޹˾Ȩ

ֻ EOS ԴЭ飨μ License.txtеʹЩ롣
ܣʹЩ롣

ļ: event.c

: ֮ͬ¼ʵ֡



*******************************************************************************/

#include "psp.h"

VOID
PsInitializeEvent(
	IN PEVENT Event,
	IN BOOL ManualReset,
	IN BOOL InitialState
	)
/*++


	ʼ¼ṹ塣


	Event -- ¼ṹָ롣
	ManualReset -- ǷʼΪֶ¼TRUE ΪֶFALSE ΪԶ
	InitialState -- ¼ʼ״̬TRUE ΪЧFALSE ΪЧ

ֵ
	ޡ

--*/
{
	Event->IsManual = ManualReset;
	Event->IsSignaled = InitialState;
	ListInitializeHead(&Event->WaitListHead);
}

STATUS
PsWaitForEvent(
	IN PEVENT Event,
	IN ULONG Milliseconds
	)
/*++


	ȴ¼ֱ¼Ϊ Signaled ״̬ȴԶ¼ɹȴḴλ
	¼Ϊ Nonsignaled ״̬


	Event -- ¼ṹָ롣
	Milliseconds -- ȴʱޣȴʱ򷵻STATUS_TIMEOUTΪINFINIT
		õȴֱȴɹ

ֵ
	STATUS_SUCCESSʾȴɹSTATUS_TIMEOUTʾȴʱ

--*/
{
	STATUS Status;
	BOOL IntState;

	IntState = KeEnableInterrupts(FALSE);

	//
	// ¼ Signaled ״̬ô̷سɹǰ߳ȴ¼
	//
	if (Event->IsSignaled) {

		//
		// Զ¼ôɹȴͬʱҪλ¼
		//
		if (!Event->IsManual) {
			Event->IsSignaled = FALSE;
		}

		Status = STATUS_SUCCESS;

	} else {

		//
		// FCFSԭ¼ȴеĶβ
		//
		Status = PspWait(&Event->WaitListHead, Milliseconds);
	}

	KeEnableInterrupts(IntState);

	return Status;
}

VOID
PsSetEvent(
	IN PEVENT Event
	)
/*++


	ʹ¼Ϊ Singnaled ״̬¼ĵȴ߳ڵȴȴ߳̽ѡ


	Event -- ¼ṹָ롣

ֵ
	ޡ

--*/
{
	BOOL IntState = KeEnableInterrupts(FALSE);

	//
	// ¼ Nonsignaled ״̬޸¼Ϊ Signaled ״̬
	//
	if (!Event->IsSignaled) {

		Event->IsSignaled = TRUE;

		while (Event->IsSignaled && !ListIsEmpty(&Event->WaitListHead)) {

			//
			// ¼ Signaled ״̬ҵȴзǿգ FCFS ԭѵȴеĶ̡߳
			//
			PspWakeThread(&Event->WaitListHead, STATUS_SUCCESS);

			//
			// Զ¼ô֪ͨһ̺߳¼λΪ Nonsignaled ״̬
			//
			if (!Event->IsManual) {
				Event->IsSignaled = FALSE;
			}
		}

		//
		// ̱߳ѣ̵ִ߳ȡ
		//
		PspThreadSchedule();
	}

	KeEnableInterrupts(IntState);
}

VOID
PsResetEvent(
	IN PEVENT Event
	)
/*++


	λ¼״̬Ϊ Nonsignaled ״̬


	Event -- ¼ṹָ롣

ֵ
	ޡ

--*/
{
	BOOL IntState = KeEnableInterrupts(FALSE);

	Event->IsSignaled = FALSE;

	KeEnableInterrupts(IntState);
}

//////////////////////////////////////////////////////////////////////////
//
// Ǻ¼صĴ롣
//

//
// ¼ָ롣
//
POBJECT_TYPE PspEventType;

VOID
PspOnCreateEventObject(
	IN PVOID EventObject,
	IN ULONG_PTR CreateParam
	)
/*++


	¼Ĺ캯ObCreateObjectá


	EventObject -- ´¼ָ롣
	CreateParam -- λ0־ǷΪֶ¼λ1־ʼ״̬

ֵ
	ޡ

--*/
{
	PsInitializeEvent( (PEVENT)EventObject,
					   (CreateParam & 0x1) != 0,
					   (CreateParam & 0x2) != 0 );
}

VOID
PspCreateEventObjectType(
	VOID
	)
/*++


	¼͡


	ޡ

ֵ
	ޡ

--*/
{
	STATUS Status;
	OBJECT_TYPE_INITIALIZER Initializer;
	
	Initializer.Create = PspOnCreateEventObject;
	Initializer.Delete = NULL;
	Initializer.Wait = (OB_WAIT_METHOD)PsWaitForEvent;
	Initializer.Read = NULL;
	Initializer.Write = NULL;
	
	Status = ObCreateObjectType("EVENT", &Initializer, &PspEventType);

	if (!EOS_SUCCESS(Status)) {
		KeBugCheck("Failed to create event object type!");
	}
}

STATUS
PsCreateEventObject(
	IN BOOL ManualReset,
	IN BOOL InitialState,
	IN PCSTR EventName,
	OUT PHANDLE EventHandle
	)
/*++


	¼


	ManualReset -- ǷʼΪֶ¼
	InitialState -- ¼ʼ״̬
	EventName -- ַָ룬ΪNULL򴴽һ󣬷ԴѴڵ
		󲻴򴴽һµ
	EventHandle -- ´򿪵¼

ֵ
	ɹ򷵻STATUS_SUCCESS

--*/
{
	STATUS Status;
	PVOID EventObject;
	ULONG_PTR CreateParam = 0;

	if (ManualReset) {
		CreateParam |= 0x1;
	}

	if (InitialState) {
		CreateParam |= 0x2;
	}

	//
	// ¼
	//
	Status = ObCreateObject( PspEventType,
							 EventName,
							 sizeof(EVENT),
							 CreateParam,
							 &EventObject );

	if (!EOS_SUCCESS(Status)) {
		return Status;
	}

	//
	// Ϊ¼󴴽
	//
	Status = ObCreateHandle(EventObject, EventHandle);

	if (!EOS_SUCCESS(Status)) {
		ObDerefObject(EventObject);
	}

	return Status;
}

STATUS
PsSetEventObject(
	HANDLE Handle
	)
/*++


	ʹ¼Ϊ Singnaled ״̬¼ĵȴ߳ڵȴȴ߳̽ѡ


	Handle -- ¼ľ

ֵ
	ɹ򷵻STATUS_SUCCESS

--*/
{
	STATUS Status;
	PEVENT Event;

	//
	// ¼õָ롣
	//
	Status = ObRefObjectByHandle(Handle, PspEventType, (PVOID*)&Event);

	if (EOS_SUCCESS(Status)) {

		PsSetEvent(Event);

		//
		// ر¼ָ롣
		//
		ObDerefObject(Event);
	}

	return Status;
}

STATUS
PsResetEventObject(
	HANDLE Handle
	)
/*++


	λ¼״̬Ϊ Nonsignaled ״̬


	Handle -- ¼ľ

ֵ
	ɹ򷵻STATUS_SUCCESS

--*/
{
	STATUS Status;
	PEVENT Event;

	//
	// ¼õָ롣
	//
	Status = ObRefObjectByHandle(Handle, PspEventType, (PVOID*)&Event);

	if (EOS_SUCCESS(Status)) {

		PsResetEvent(Event);

		//
		// رնָ롣
		//
		ObDerefObject(Event);
	}

	return Status;
}
