/***

Copyright (c) 2008 ӢʱƼ޹˾Ȩ

ֻ EOS ԴЭ飨μ License.txtеʹЩ롣
ܣʹЩ롣

ļ: fat12.c

: FAT12 ļϵͳʵ֡



*******************************************************************************/

#include "iop.h"
#include "fat12.h"

VOID
FatInitializeDriver(
	PDRIVER_OBJECT DriverObject
	)
{
	DriverObject->AddDevice = FatAddDevice;
	DriverObject->Create = FatCreate;
	DriverObject->Close = FatClose;
	DriverObject->Read = FatRead;
	DriverObject->Write = FatWrite;
	DriverObject->Query = FatQuery;
	DriverObject->Set = FatSet;
}

//
//  AddDevice ܺ
//
STATUS
FatAddDevice(
	 IN PDRIVER_OBJECT DriverObject,
	 IN PDEVICE_OBJECT NextLayerDevice,
	 IN USHORT DeviceNumber,
	 OUT PDEVICE_OBJECT *DeviceObject
	 )
{
	STATUS Status;
	BOOT_SECTOR BootSector;
	PVCB Vcb;
	PUCHAR Fat;
	PDEVICE_OBJECT FatDevice;
	USHORT i;
	static char DeviceName[] = "A:";

	//
	// FAT12 ļϵͳ²һ豸
	//
	ASSERT(NULL != NextLayerDevice && NextLayerDevice->IsBlockDevice);

	//
	// ȡ0ʼ 62 ֽڣ BPB
	//
	Status = IopReadWriteSector( NextLayerDevice,
								0,
								0,
								&BootSector,
								sizeof(BOOT_SECTOR),
								TRUE );

	if (!EOS_SUCCESS(Status)) {
		return STATUS_WRONG_VOLUME;
	}

	//
	//  FAT12 ļϵͳ򷵻ʧܡ
	//
	if (0 != strnicmp((PCHAR)BootSector.SystemId, "FAT12   ", 8)) {
		return STATUS_WRONG_VOLUME;
	}

	//
	// Ŀǰֻ֧СΪ 512 ֽڵ, FAT12ļϵͳĴصܴﵽ 4085,
	// FATҲܳ 12 
	//
	if (BootSector.Bpb.BytesPerSector != 512
		|| BootSector.Bpb.Media != 0xF0
		|| FatNumberOfClusters(&BootSector.Bpb) >= 4085
		|| BootSector.Bpb.SectorsPerFat > 12 ) {
			return STATUS_WRONG_VOLUME;
	}

	//
	//  FAT 沢 FATǰ 3 ֽӦΪ̶ֵ 0xF0,0xFF,0xFF
	//
	Fat = MmAllocateSystemPool(FatBytesPerFat(&BootSector.Bpb));

	if (NULL == Fat) {
		return STATUS_NO_MEMORY;
	}

	for (i = 0; i < BootSector.Bpb.SectorsPerFat; i++) {

		Status = IopReadWriteSector( NextLayerDevice,
									BootSector.Bpb.ReservedSectors + i,
									0,
									Fat + i * 512,
									512,
									TRUE );

		if (!EOS_SUCCESS(Status)) {
			MmFreeSystemPool(Fat);
			return STATUS_WRONG_VOLUME;
		}
	}

	if (0xF0 != Fat[0] || 0xFF != Fat[1] || 0xFF != Fat[2]) {
		MmFreeSystemPool(Fat);
		return STATUS_WRONG_VOLUME;
	}

	//
	//  FAT12 ļϵͳ豸豸չΪ VCB ṹ塣
	//
	DeviceName[0] += DeviceNumber;
	Status = IopCreateDevice( DriverObject,
							sizeof(VCB),
							DeviceName,
							DeviceNumber,
							FALSE,
							&FatDevice );

	if (!EOS_SUCCESS(Status)) {
		return Status;
	}

	//
	// ʼ VCB
	//
	Vcb = (PVCB)FatDevice->DeviceExtension;
	Vcb->DiskDevice = NextLayerDevice;
	Vcb->Bpb = BootSector.Bpb;
	Vcb->Fat = Fat;
	Vcb->FirstRootDirSector = FatFirstRootDirSector(&BootSector.Bpb);
	Vcb->RootDirSize = FatRootDirSize(&BootSector.Bpb);
	Vcb->FirstDataSector = FatFirstDataSector(&BootSector.Bpb);
	Vcb->NumberOfClusters = (USHORT)FatNumberOfClusters(&BootSector.Bpb);
	ListInitializeHead(&Vcb->FileListHead);

	return STATUS_SUCCESS;
}

//
//  Create ܺ
//
STATUS
FatCreate(
	IN PDEVICE_OBJECT DeviceObject,
	IN PCSTR FileName,
	IN ULONG CreationDisposition,
	IN OUT PFILE_OBJECT FileObject
	)
{
	//
	// ·ǷЧ
	//
	if (!FatCheckPath(FileName, FALSE)) {
		return STATUS_PATH_SYNTAX_BAD;
	}

	//
	// Ŀǰʵ˴ļ
	//
	if (OPEN_EXISTING == CreationDisposition) {

		return FatOpenExistingFile(DeviceObject, FileName, FileObject);

	} else if (CREATE_NEW == CreationDisposition) {

		return STATUS_NOT_SUPPORTED;

	} else if (CREATE_ALWAYS == CreationDisposition) {

		return STATUS_NOT_SUPPORTED;

	} else if (OPEN_ALWAYS == CreationDisposition) {

		return STATUS_NOT_SUPPORTED;

	} else if (TRUNCATE_EXISTING == CreationDisposition) {

		return STATUS_NOT_SUPPORTED;
	}
}

//
//  Close ܺ
//
VOID
FatClose(
	IN PDEVICE_OBJECT DeviceObject,
	IN OUT PFILE_OBJECT FileObject
	)
{
	FatCloseFile((PFCB)FileObject->FsContext);
}

//
//  Read ܺ
//
STATUS
FatRead(
	IN PDEVICE_OBJECT DeviceObject,
	IN PFILE_OBJECT FileObject,
	OUT PVOID Buffer,
	IN ULONG Request,
	OUT PULONG Result
	)
{
	return FatReadFile( (PVCB)DeviceObject->DeviceExtension,
						(PFCB)FileObject->FsContext,
						FileObject->CurrentByteOffset,
						Request,
						Buffer,
						Result );
}

//
//  Write ܺ
//
STATUS
FatWrite(
	IN PDEVICE_OBJECT DeviceObject,
	IN PFILE_OBJECT FileObject,
	IN PVOID Buffer,
	IN ULONG Request,
	OUT PULONG Result OPTIONAL
	)
{
	STATUS Status;

	Status = FatWriteFile( (PVCB)DeviceObject->DeviceExtension,
						   (PFCB)FileObject->FsContext,
						   FileObject->CurrentByteOffset,
						   Request,
						   Buffer,
						   Result );

	return Status;
}

//
//  Query ܺ
//
STATUS
FatQuery(
	IN PDEVICE_OBJECT DeviceObject,
	IN PFILE_OBJECT FileObject,
	OUT PFILE_INFO FileInfo
	)
{
	PFCB Fcb;

	Fcb = (PFCB)FileObject->FsContext;

	//
	// Ŀǰδʵʱʱļʱ䡣
	//
	FileInfo->FileAttributes = 0;

	if (Fcb->AttrDirectory) {
		FileInfo->FileAttributes |= FILE_ATTRIBUTE_DIRECTORY;
	} else {
		FileInfo->FileAttributes |= FILE_ATTRIBUTE_ARCHIVE;
	}

	if (Fcb->AttrHidden) {
		FileInfo->FileAttributes |= FILE_ATTRIBUTE_HIDDEN;
	}

	if (Fcb->AttrSystem) {
		FileInfo->FileAttributes |= FILE_ATTRIBUTE_SYSTEM;
	}

	if (Fcb->AttrReadOnly) {
		FileInfo->FileAttributes |= FILE_ATTRIBUTE_READONLY;
	}

	FileInfo->FileSize = Fcb->FileSize;

	return STATUS_SUCCESS;
}

//
//  Set ܺ
//
STATUS
FatSet(
	IN PDEVICE_OBJECT DeviceObject,
	IN PFILE_OBJECT FileObject,
	IN PSET_FILE_INFO FileInfo
	)
{
	//
	// Ŀǰв֧κ޸Ĳ
	//
	return STATUS_NOT_SUPPORTED;
}

USHORT
FatGetFatEntryValue(
	IN PVCB Vcb,
	IN USHORT Index
	)
/*++


	FATֵָȡصڴеFAT


	Vcb -- ƿָ롣
	Index -- ָ

ֵ
	FATֵ

--*/
{
	USHORT Value;

	ASSERT(2 <= Index && Index < 0xFF0);

	//
	// FATֽڶһ16λα
	//
	CopyUchar2(&Value, (PCHAR)Vcb->Fat + Index * 3 / 2)

	//
	// /żȡαĸ/12λֵ
	//
	return (Index & 0x1) != 0 ? Value >> 4 : Value & 0x0FFF;
}

STATUS
FatSetFatEntryValue(
	IN PVCB Vcb,
	IN USHORT Index,
	IN USHORT Value12
	)
/*++


	дFATֵָдFATͬʱд͸̡


	Vcb -- ƿָ롣
	Index -- ָ
	Value12 -- д12bitֵ

ֵ
	ɹ򷵻STATUS_SUCCESS

--*/
{
	STATUS Status;
	USHORT OldValue16;
	USHORT NewValue16;
	USHORT SectorNumber;
	USHORT BytesOffset;
	USHORT i;

	ASSERT(2 <= Index && Index < 0xFF0);
	ASSERT(Value12 != 1 && Value12 <= 0xFFF);

	//
	// FATֽڶһ16λαOriginalValue
	//
	CopyUchar2(&OldValue16, (PCHAR)Vcb->Fat + Index * 3 / 2);

	//
	// żԣ޸16λеĸ12λ12λֵ4λ䡣
	//
	NewValue16 = (Index & 0x01) != 0 ? Value12 << 4 | (OldValue16 & 0x000F) : (OldValue16 & 0xF000) | Value12;

	//
	// ޸ĺֵдFAT
	//
	CopyUchar2((PUCHAR)Vcb->Fat + Index * 3 / 2, &NewValue16);

	//
	// ޸ĺֵдеFATΪϿжFATҪѭд
	//
	for (i = 0; i < Vcb->Bpb.Fats; i++) {

		//
		// ڵԼڵֽƫơ
		//
		SectorNumber = Vcb->Bpb.ReservedSectors + i * Vcb->Bpb.SectorsPerFat + (Index * 3 / 2) / Vcb->Bpb.BytesPerSector;
		BytesOffset = (Index * 3 / 2) % Vcb->Bpb.BytesPerSector;
		
		//
		// ޸ĺ2ֽд̡ע⣺Ҫǵ2ֽڿܿ
		//
		if (BytesOffset < Vcb->Bpb.BytesPerSector - 1) {

			Status = IopReadWriteSector( Vcb->DiskDevice, 
										 SectorNumber,
										 BytesOffset,
										 &NewValue16,
										 2,
										 FALSE );
			if (!EOS_SUCCESS(Status)) {
				return Status;
			}

		} else {

			//
			// 2ֽÿˣдǰһ1ֽڣдһĵһ1ֽڡ
			//
			Status = IopReadWriteSector( Vcb->DiskDevice,
										 SectorNumber,
										 BytesOffset,
										 &NewValue16,
										 1,
										 FALSE );
			if (!EOS_SUCCESS(Status)) {
				return Status;
			}

			Status = IopReadWriteSector( Vcb->DiskDevice,
										 SectorNumber + 1,
										 0,
										 (char*)(&NewValue16) + 1,
										 1,
										 FALSE );
			if (!EOS_SUCCESS(Status)) {
				return Status;
			}
		}
	}

	return STATUS_SUCCESS;
}

BOOL
FatCheckPath(
	IN PCSTR PathName,
	IN BOOL IsDirectoryName
	)
/*++


	·ַǷЧ·еļ8.3򣬹£
	ļ1~8ַɣչ1~3ַɣչѡչ
	ļչ֮'.'ָ磺G9401.DBFG9401ļDBFչ
	ļչʹĸ(ִСдֺ͸ַţո < > / \ | : "
	* ?ַ⡣


	PathName -- ·
	IsDirectoryName -- ǷĿ¼·

ֵ
	·Ч򷵻TRUE

--*/
{
	PCSTR Dot;
	PCSTR Name = PathName;
	PCSTR End = PathName;
	ULONG CountOfFileName = 0;

	for (;;) {

		//
		// ·еķָбܻ߷бܣͬʱǷǷַ
		//
		while (*End != '\0' && *End != '\\' && *End != '/') {

			//
			// 8.3ļвַܰ
			//  ֵСڵ0x20ַ⣬ļĵһַ0x05
			//    滻ַ0xE5
			//  0x22, 0x2A, 0x2B, 0x2C, 0x2E, 0x2F, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E,
			//    0x3F, 0x5B, 0x5C, 0x5Dand 0x7C.
			// Ϊ˼򵥣ļ׸ַ0x05
			//
			if (*End <= 0x20 ||
				0x2A <= *End && *End <= 0x2C ||
				0x3A <= *End && *End <= 0x3F || 
				0x5B == *End || 0x5D == *End || 0x7c == *End) {
				return FALSE;
			}

			End++;
		}

		if (End > Name) {

			//
			// ļǵǰĿ¼"."ϼĿ¼".."8.3
			//
			if (!(End - Name == 1 && '.' == *Name) &&
				!(End - Name == 2 && '.' == *Name && '.' == *(Name+1))) {

				//
				// 8.3ļһַ'.'12ַļЧ
				//
				if ('.' == *Name || End - Name > 12) {
					return FALSE;
				}

				//
				// Ӻǰļչ֮ķָ'.'
				//
				for (Dot = End - 1; Dot > Name && *Dot != '.'; Dot--);

				if (Dot > Name) {

					//
					// ҵ'.'ļ8ַչ1~3ַЧ
					//
					if (Dot - Name > 8 || End - Dot == 1 || End - Dot > 4) {
						return FALSE;
					}

					//
					// ǰļв'.'Ч
					//
					for (Dot--; Dot > Name && *Dot != '.'; Dot--);
					
					if (Dot > Name) {
						return FALSE;
					}

				} else {

					//
					// '.'ûչļ8ַЧ
					//
					if (End - Name > 8) {
						return FALSE;
					}
				}

				CountOfFileName++;	// ͳ·Чļ
			}
		}

		if ('\0' == *End) {
			
			if (End-- == PathName) {
				return FALSE; // ·ַΪ0Ч
			}

			if (!IsDirectoryName) {

				//
				// ļ·Ҫһļһַ'\''/''.'
				//
				if (0 == CountOfFileName || '\\' == *End || '/' == *End || '.' == *End) {
					return FALSE;
				}
			}

			return TRUE;

		}

		//
		// ·һļ
		//
		Name = End + 1;
		End = Name;
	}
}

VOID
FatConvertDirNameToFileName(
	IN CHAR DirName[],
	OUT PSTR FileName
	)
/*++


	Ŀ¼е11ַļתΪ0βַַʽ*.*


	DirName -- Ŀ¼ļַ顣
	FileName -- 洢תַָ롣

ֵ
	ɹ򷵻TRUE

--*/
{
	INT i;
	PCHAR Dot;

	//
	// ˵ļĿո
	//
	for (i = 7; i >= 0 && ' ' == DirName[i]; i--); // ֺţ
	i++;

	//
	// ļ
	//
	strncpy(FileName, &DirName[0], i);

	Dot = FileName + i;

	//
	// ˵չĿո
	//
	for (i = 10; i > 7 && ' ' == DirName[i]; i--);

	//
	// չļ'.'չ
	//
	if (i > 7) {
		*Dot = '.';
		strncpy(Dot + 1, &DirName[8], i - 7);
	}
}

VOID
FatConvertFileNameToDirName(
	IN PSTR FileName,
	OUT CHAR DirName[]
	)
{
	PCHAR p = FileName;
	INT i = 0;

	//
	// ȸļ8ַÿո롣
	//
	for (i = 0, p = FileName; i < 8 && *p != '.' && *p != 0; i++, p++) {
		DirName[i] = *p;
	}

	for (; i < 8; i++) {
		DirName[i] = ' ';
	}

	//
	// չ3ַÿո롣
	//
	if ('.' == *p) {
		p++;
	}

	for (; i < 11 && *p != 0; i++, p++) {
		DirName[i] = *p;
	}

	for(; i < 11; i++) {
		DirName[i] = ' ';
	}
}

STATUS
FatAllocateOneCluster(
	IN PVCB Vcb,
	OUT PUSHORT ClusterNumber
	)
/*++


	һдء·Ĵ FAT жӦıԶΪ 0xFF8
	ԣ·ĴرΪļеһء


	Vcb -- ̾ƿָ롣
	ClusterNumber -- سɹĴغš

ֵ
	ɹ򷵻 STATUS_SUCCESS

--*/
{
	STATUS Status;
	USHORT n;

	//  FAT ҵһֵΪ 0  FAT ӦĴδõġ
	// עغŴ 2 ʼ
	for (n = 2; n < Vcb->NumberOfClusters + 2; n++) {
		if (0 == FatGetFatEntryValue(Vcb, n))
			break;
	}

	// δҵõĴ򷵻ش롣
	if (n == Vcb->NumberOfClusters + 2)
		return STATUS_NO_SPACE;

	// ޸ FAT ֵΪ 0xFF8Ǵ˴رļռãļһء
	Status = FatSetFatEntryValue(Vcb, n, 0xFF8);
	
	if (EOS_SUCCESS(Status))
		*ClusterNumber = n;

	return Status;
}

STATUS
FatReadFile(
	IN PVCB Vcb,
	IN PFCB File,
	IN ULONG Offset,
	IN ULONG BytesToRead,
	OUT PVOID Buffer,
	OUT PULONG BytesRead
	)
/*++


	ļָƫƴȡָֽڵݣʵʶȡֽܵļȵ
	Сֵ


	Vcb -- ƿָ롣
	File -- ļƿָ롣
	Offset -- ȡļʼƫƵַ
	BytesToRead -- ȡֽ
	Buffer -- ڴŶȡݵĻָ롣
	BytesRead -- ʵʶȡֽ

ֵ
	ɹ򷵻STATUS_SUCCESS

--*/
{
	STATUS Status;
	ULONG i;
	ULONG ReadCount = 0;
	USHORT Cluster;
	ULONG FirstSectorOfCluster;
	ULONG OffsetInSector;
	ULONG BytesToReadInSector;

	//
	// ȡļʼƫλóļСֱӷء
	//
	if (Offset >= File->FileSize) {
		*BytesRead = 0;
		return STATUS_SUCCESS;
	}

	//
	// ʵʿԶȡֽļȵơ
	//
	if (BytesToRead > File->FileSize - Offset) {
		BytesToRead = File->FileSize - Offset;
	}

	//
	// ˳ļңҵƫλڵĴء
	//
	Cluster = File->FirstCluster;
	for (i = Offset / FatBytesPerCluster(&Vcb->Bpb); i > 0; i--) {
		Cluster = FatGetFatEntryValue(Vcb, Cluster);
	}

	//
	// ƫλڵĴؿʼȡļĴأֱȡɡ
	//
	for (;;) {

		//
		// ɶɣصʼš
		//
		FirstSectorOfCluster = Vcb->FirstDataSector + (Cluster - 2) * Vcb->Bpb.SectorsPerCluster;

		//
		// ƫλڴڵĵڼȻʼȡڵ
		//
		for (i = ((Offset + ReadCount) / Vcb->Bpb.BytesPerSector) % Vcb->Bpb.SectorsPerCluster;
			i < Vcb->Bpb.SectorsPerCluster; i++ ) {

			//
			// ȡλڵֽƫơ
			//
			OffsetInSector = (Offset + ReadCount) % Vcb->Bpb.BytesPerSector;

			//
			// Ҫڶȡֽ
			//
			if (BytesToRead - ReadCount > Vcb->Bpb.BytesPerSector - OffsetInSector) {
				BytesToReadInSector = Vcb->Bpb.BytesPerSector - OffsetInSector;
			} else {
				BytesToReadInSector = BytesToRead - ReadCount;
			}

			//
			// ȡݡ
			//
			Status = IopReadWriteSector( Vcb->DiskDevice,
										 FirstSectorOfCluster + i,
										 OffsetInSector,
										 (PCHAR)Buffer + ReadCount,
										 BytesToReadInSector,
										 TRUE );

			if (!EOS_SUCCESS(Status)) {
				return Status;
			}

			//
			// ȡ򷵻ء
			//
			ReadCount += BytesToReadInSector;
			if (ReadCount == BytesToRead) {
				*BytesRead = ReadCount;
				return STATUS_SUCCESS;
			}
		}

		//
		// ļһء
		//
		Cluster = FatGetFatEntryValue(Vcb, Cluster);
	}
}

STATUS
FatWriteFile(
	IN PVCB Vcb,
	IN PFCB File,
	IN ULONG Offset,
	IN ULONG BytesToWrite,
	IN PVOID Buffer,
	OUT PULONG BytesWriten
	)
/*++


	ļָƫλÿʼдݣƫλСļС򸲸ԭݣ
	дΧļСԶļСļСӺ󳬹ļռõĴ̿
	СԶΪļµĴأļռõĴ̿ռ䡣
	עļСļռô̿ռ䡣Ϊļռô̿ռԴΪ
	λģļСĵλֽڣļС <= ļռô̿ռ䣬Եļ
	ʱһҪӴռÿռ䡣һļǰֻ1ֽڣôռ
	һصĴ̿ռ䡣ļСӵ10ֽʱռõĴ̿ռȻΪһء
	ĴСӵһصĴСʱôҪΪӴ̿ռˡ


	Vcb -- ƿָ롣
	File -- ļƿָ롣
	Offset -- ʼдƫλá
	BytesToWrite -- дֽ
	Buffer -- ָҪдݡ
	BytesWriten -- ָ룬ָڱʵдֽı

ֵ
	ɹ򷵻STATUS_SUCCESS

--*/
{
	return STATUS_NOT_SUPPORTED;
}

STATUS
FatOpenFileInDirectory(
	IN PVCB Vcb,
	IN PFCB Directory,
	IN PSTR FileName,
	OUT PFCB *OpenedFile
	)
/*++


	ָĿ¼дָƵļĿ¼ļĿ¼ÿһļĿ¼
	ļƿĴ򿪼1


	Vcb -- ƿָ롣
	Directory -- ļĿ¼ָ룬ΪNULLڸĿ¼д򿪡
	FileName -- ļַָ롣
	OpenedFile -- ָļָĻ

ֵ
	򿪳ɹ򷵻STATUS_SUCCESS

--*/
{
	STATUS Status;
	DIRENT DirEntry;
	CHAR DirName[11];
	PLIST_ENTRY FileListHead;
	PLIST_ENTRY FileListEntry;
	ULONG DirectoryFileSize;
	ULONG DirEntryOffset;
	ULONG BytesRead;
	USHORT Cluster;
	USHORT NumberOfClusters;
	PFCB File;

	//
	// ǸĿ¼ЧĿ¼ļ
	//
	ASSERT(NULL == Directory || Directory->AttrDirectory && Directory->Name[0] != (CHAR)0xE5);

	//
	// ȼļǷļ"."".."
	// "."ʾǰĿ¼".."ʾǰĿ¼ϼĿ¼
	//
	if (0 == strcmp(FileName, ".")) {

		//
		// 򿪵ǰĿ¼
		//
		if (NULL != Directory) {
			Directory->OpenCount++;
		}
		*OpenedFile = Directory;
		
		return STATUS_SUCCESS;

	} else if (0 == strcmp(FileName, "..")) {

		//
		// ǰĿ¼ǸĿ¼ȻظĿ¼(NULL)򿪵ǰĿ¼ϼĿ¼
		//
		if (NULL == Directory) {
			*OpenedFile = NULL;
		} else {
			if (NULL != Directory->ParentDirectory) {
				Directory->ParentDirectory->OpenCount++;
			}
			*OpenedFile = Directory->ParentDirectory;
		}

		return STATUS_SUCCESS;
	}

	//
	// ʹFileListHeadָĿ¼ѴļȻѯҪ򿪵ļ
	// ǷѾڱ򿪣Ѿ򿪼ɡ
	//
	if (NULL == Directory) {

		FileListHead = &Vcb->FileListHead;

	} else {

		//
		// Ѿռ򿪵Ŀ¼дļ
		//
		if (!Directory->SharedRead || !Directory->SharedWrite) {
			return STATUS_SHARING_VIOLATION;
		}

		FileListHead = &Directory->FileListHead;
	}

	for (FileListEntry = FileListHead->Next; 
		FileListEntry != FileListHead;
		FileListEntry = FileListEntry->Next) {

		File = CONTAINING_RECORD(FileListEntry, FCB, FileListEntry);
		
		//
		// ļĵһַΪ0xE5ļѾɾ
		//
		if (File->Name[0] != (CHAR)0xE5 && 0 == strcmp(File->Name, FileName)) {

			File->OpenCount++;
			*OpenedFile = File;

			return STATUS_SUCCESS;
		}
	}

	//
	// Ŀ¼еDIRENTṹ壬Ҫ̡
	//
	if (NULL == Directory) {
		DirectoryFileSize = Vcb->RootDirSize;
	} else {
		DirectoryFileSize = Directory->FileSize;
	}

	FatConvertFileNameToDirName(FileName, DirName);

	for (DirEntryOffset = 0; DirEntryOffset < DirectoryFileSize; DirEntryOffset += sizeof(DIRENT)) {

		if (NULL == Directory) {

			//
			// ڸĿ¼OffsetƫƴȡһĿ¼
			//
			Status = IopReadWriteSector( Vcb->DiskDevice,
										 Vcb->FirstRootDirSector + DirEntryOffset / Vcb->Bpb.BytesPerSector,
										 DirEntryOffset % Vcb->Bpb.BytesPerSector,
										 &DirEntry,
										 sizeof(DIRENT),
										 TRUE );
		} else {

			//
			// Ŀ¼ļOffsetƫƴȡһĿ¼
			//
			Status = FatReadFile( Vcb,
								  Directory,
								  DirEntryOffset,
								  sizeof(DIRENT),
								  &DirEntry,
								  &BytesRead );
		}

		//
		// ȡʧ̷ء
		//
		if (!EOS_SUCCESS(Status)) {
			return Status;
		}

		//
		// Ŀ¼(һַΪ0Ŀ¼־Ŀ¼ļ)
		//
		if (0 == DirEntry.Name[0]) {
			return STATUS_FILE_NOT_FOUND;
		}

		//
		// Ŀ¼Ч(һַΪ0xE5)ļһ£
		//
		if ((CHAR)0xE5 == DirEntry.Name[0] ||
			0 != strnicmp(DirEntry.Name, DirName, 11)) {
			continue;
		}

		//
		// ļĴͳƴĳȡ
		//
		NumberOfClusters = 0;

		if (DirEntry.FirstCluster != 0) {

			for (Cluster = DirEntry.FirstCluster;
				Cluster < 0xFF8;
				Cluster  = FatGetFatEntryValue(Vcb, Cluster)) {

				//
				// гЧĴغţС2غţ򷵻ش
				//
				if (Cluster < 2 || Cluster > Vcb->NumberOfClusters + 1) {
					return STATUS_FILE_CORRUPT_ERROR;
				}

				NumberOfClusters++; // ͳļռôص
			}
		}

		//
		// ļĿ¼¼еļСռôصһ£Ŀ¼ļ
		// Ŀ¼м¼ļС0ռһء
		//
		if ((DirEntry.Attributes & DIRENT_ATTR_ARCHIVE) != 0) {
			if ((DirEntry.FileSize + FatBytesPerCluster(&Vcb->Bpb) - 1) / FatBytesPerCluster(&Vcb->Bpb) != NumberOfClusters) {
				return STATUS_FILE_CORRUPT_ERROR;
			}
		} else if (DirEntry.FileSize != 0 || 0 == NumberOfClusters) {
			return STATUS_FILE_CORRUPT_ERROR;
		}
		

		//
		// ϵͳڴзһļƿ顣
		//
		File = (PFCB)MmAllocateSystemPool(sizeof(FCB));

		if (NULL == File) {
			return STATUS_NO_MEMORY;
		}

		//
		// ʼFCB֮Ŀ¼ļС
		//
		FatConvertDirNameToFileName(DirEntry.Name, File->Name);
		File->AttrReadOnly = (DirEntry.Attributes & DIRENT_ATTR_READ_ONLY) != 0;
		File->AttrHidden = (DirEntry.Attributes & DIRENT_ATTR_HIDDEN) != 0;
		File->AttrSystem = (DirEntry.Attributes & DIRENT_ATTR_SYSTEM) != 0;
		File->AttrDirectory = (DirEntry.Attributes & DIRENT_ATTR_DIRECTORY) != 0;
		File->SharedRead = TRUE;
		File->SharedWrite = TRUE;
		File->LastWriteTime = DirEntry.LastWriteTime;
		File->LastWriteDate = DirEntry.LastWriteDate;
		File->FirstCluster = DirEntry.FirstCluster;
		File->DirEntryOffset = DirEntryOffset;
		File->OpenCount = 1;
		File->ParentDirectory = Directory;
		ListInsertTail(FileListHead, &File->FileListEntry);
		ListInitializeHead(&File->FileListHead);

		//
		// ļֱӻļĴСĿ¼ļҪݴص㣬
		// ΪĿ¼ļĿ¼еFileSizeԶΪ0
		//
		if (!File->AttrDirectory) {
			File->FileSize = DirEntry.FileSize;
		} else {
			ASSERT(0 == DirEntry.FileSize);
			File->FileSize = NumberOfClusters * FatBytesPerCluster(&Vcb->Bpb);
		}

		// 
		// Ŀ¼ļĴ򿪼
		//
		if (NULL != Directory) {
			Directory->OpenCount++;
		}

		*OpenedFile = File;
		return STATUS_SUCCESS;
	}
}

STATUS
FatOpenFile(
	IN PVCB Vcb,
	IN PCSTR FullPathname,
	OUT PFCB *OpenedFile
	)
/*++


	򿪸·ļĿ¼ļ


	Vcb -- ƿָ롣
	FullPathname -- ļڴڵȫ·
	OpenedFile -- ָļָĻ

ֵ
	򿪳ɹ򷵻STATUS_SUCCESS

--*/
{
	STATUS Status;
	PCSTR PathnamePtr;
	CHAR FileName[13];	// ļ12ַ8ļ + 1'.' + 3չ
	PSTR FileNamePtr;
	PFCB ParentFcb;
	PFCB ChildFcb;

	ParentFcb = NULL;
	ChildFcb = NULL;
	PathnamePtr = FullPathname;

	for (;;) {

		//
		// ·еķָбܻ߷бܣָ֮ļ
		// ļFileName[13]С
		//
		FileNamePtr = FileName;
		while (*PathnamePtr != '\0' && *PathnamePtr != '\\' && *PathnamePtr != '/') {
			ASSERT(FileNamePtr - FileName < 12);
			*FileNamePtr++ = *PathnamePtr++;
		}

		if (FileNamePtr != FileName) {

			*FileNamePtr = '\0';

			Status = FatOpenFileInDirectory( Vcb,
											 ParentFcb,
											 FileName,
											 &ChildFcb );

			//
			// Ŀ¼ļָ벻ʹˣر
			//
			if (NULL != ParentFcb) {
				FatCloseFile(ParentFcb);
			}

			if (!EOS_SUCCESS(Status)) {

				//
				// δҵĿ¼ļʱSTATUS_PATH_NOT_FOUND
				//
				if (STATUS_FILE_NOT_FOUND == Status && *PathnamePtr != '\0') {
					return STATUS_PATH_NOT_FOUND;
				}

				return Status;
			}

			//
			// δҵĿ¼ļʱSTATUS_PATH_NOT_FOUND
			//
			if (*PathnamePtr != '\0' && NULL != ChildFcb && !ChildFcb->AttrDirectory) {
				FatCloseFile(ChildFcb);
				return STATUS_PATH_NOT_FOUND;
			}
		}

		//
		// ·ѭ
		//
		if ('\0' == *PathnamePtr) {
			break;
		}

		//
		// ָĿ¼ļ
		//
		PathnamePtr++;
		ParentFcb = ChildFcb;
	}

	//
	// δκļ˵·Ϊմ߲ЧļȫǷָ
	//
	if (NULL == ChildFcb) {	
		return STATUS_PATH_SYNTAX_BAD;
	}

	*OpenedFile = ChildFcb;
	return STATUS_SUCCESS;
}

STATUS
FatOpenExistingFile(
	IN PDEVICE_OBJECT DeviceObject,
	IN PCSTR FileName,
	IN OUT PFILE_OBJECT FileObject
	)
{
	STATUS Status;
	PFCB Fcb;

	//
	// ļ
	//
	Status = FatOpenFile( (PVCB)DeviceObject->DeviceExtension,
						  FileName,
						  &Fcb );

	if (!EOS_SUCCESS(Status)) {

		if (STATUS_FILE_NOT_FOUND == Status && FileObject->FlagsAndAttributes & FILE_ATTRIBUTE_DIRECTORY) {
			return STATUS_PATH_NOT_FOUND;
		}

		return Status;
	}

	//
	// 򿪵ļǷҪ
	//
	if (FileObject->FlagsAndAttributes & FILE_ATTRIBUTE_DIRECTORY) {

		if (!Fcb->AttrDirectory) {
			FatCloseFile(Fcb);
			return STATUS_PATH_NOT_FOUND; // Ŀ¼ļڡ
		}

	} else {

		if (Fcb->AttrDirectory) {
			FatCloseFile(Fcb);
			return STATUS_ACCESS_DENIED; // ܾݷʽĿ¼ļ
		}
	}

	if (Fcb->AttrReadOnly && FileObject->WriteAccess) {
		FatCloseFile(Fcb);
		return STATUS_ACCESS_DENIED; // ֻܾļд
	}

	//
	// ļǵһαùȨޣǷͻ
	//
	if (1 == Fcb->OpenCount) {

		Fcb->SharedRead = FileObject->SharedRead;
		Fcb->SharedWrite = FileObject->SharedWrite;

	} else {

		if (FileObject->ReadAccess && !Fcb->SharedRead ||
			FileObject->WriteAccess && !Fcb->SharedWrite ||
			FileObject->SharedRead != Fcb->SharedRead ||
			FileObject->SharedWrite != Fcb->SharedWrite) {
			FatCloseFile(Fcb);
			return STATUS_SHARING_VIOLATION;
		}
	}

	FileObject->FsContext = Fcb;
	return STATUS_SUCCESS;
}

STATUS
FatWriteDirEntry(
	IN PVCB Vcb,
	IN PFCB Fcb
	)
/*++


	дļӦDIRENTṹ嵽̣ļԡȡʱȱ޸ĺҪִд˺


	Vcb -- ̾ƿָ롣
	Fcb -- ļƿָ롣

ֵ
	ɹ򷵻STATUS_SUCCESS

--*/
{
	STATUS Status;
	DIRENT DirEntry = {0};
	ULONG BytesWriten;

	//
	// FCBṹʼһDIRENTṹ塣
	//
	FatConvertFileNameToDirName(Fcb->Name, DirEntry.Name);

	if (Fcb->AttrReadOnly) {
		DirEntry.Attributes |= DIRENT_ATTR_READ_ONLY;
	}
	if (Fcb->AttrHidden) {
		DirEntry.Attributes |= DIRENT_ATTR_HIDDEN;
	}
	if (Fcb->AttrSystem) {
		DirEntry.Attributes |= DIRENT_ATTR_SYSTEM;
	}
	if (Fcb->AttrDirectory) {
		DirEntry.Attributes |= DIRENT_ATTR_DIRECTORY;
	} else {
		DirEntry.Attributes |= DIRENT_ATTR_ARCHIVE;
	}

	DirEntry.LastWriteTime = Fcb->LastWriteTime;
	DirEntry.LastWriteDate = Fcb->LastWriteDate;

	DirEntry.FirstCluster = Fcb->FirstCluster;
	DirEntry.FileSize = Fcb->FileSize;

	//
	// ļλڸĿ¼дĿ¼дĿ¼ļ
	//
	if (Fcb->ParentDirectory != NULL) {
		Status = FatWriteFile( Vcb,
							   Fcb->ParentDirectory,
							   Fcb->DirEntryOffset,
							   sizeof(DIRENT),
							   &DirEntry,
							   &BytesWriten );
	} else {
		Status = IopReadWriteSector( Vcb->DiskDevice,
									 Vcb->FirstRootDirSector + Fcb->DirEntryOffset / Vcb->Bpb.BytesPerSector,
									 Fcb->DirEntryOffset % Vcb->Bpb.BytesPerSector,
									 &DirEntry,
									 sizeof(DIRENT),
									 FALSE );
	}

	return Status;
}

VOID
FatCloseFile(
	IN PFCB Fcb
	)
/*++


	رļƿ顣СļƿĴ򿪼Ϊ0رļƿ
	СļĿ¼ļƿĴ򿪼Դ˵ݹ顣


	File -- ļƿָ롣

ֵ
	ޡ

--*/
{
	PFCB Current;
	PFCB Parent;

	ASSERT(NULL != Fcb && Fcb->OpenCount > 0);

	for (Current = Fcb; Current != NULL; Current = Parent) {

		//
		// ǰļĴ򿪼1Դ0򷵻ء
		//
		if (--Current->OpenCount > 0) {
			break;
		}

		//
		// ¼ǰļĿ¼رյǰļҪݹرյǰļĿ¼
		//
		Parent = Current->ParentDirectory;

		//
		// ǰļĿ¼ļƳ
		//
		ListRemoveEntry(&Current->FileListEntry);

		//
		// ͷFCBռõڴ档
		//
		MmFreeSystemPool(Current);
	}
}
