/***

Copyright (c) 2008 ӢʱƼ޹˾Ȩ

ֻ EOS ԴЭ飨μ License.txtеʹЩ롣
ܣʹЩ롣

ļ: file.c

: ļʵ֣ļĴдѯá



*******************************************************************************/

#include "iop.h"

STATUS
IopCreateFileObject(
	IN PSTR FileName, 
	IN ULONG DesiredAccess, 
	IN ULONG ShareMode, 
	IN ULONG CreationDisposition, 
	IN ULONG FlagsAndAttributes, 
	OUT PFILE_OBJECT *FileObject
	)
/*++


	ļĿλڴļϵͳеļҲIO豸


	FileName -- 򿪵ļơ

	DesiredAccess -- õļȨޣGENERIC_READGENERIC_WRITE

	ShareMode -- ĹģʽFILE_SHARE_READFILE_SHARE_WRITE

	CreationDisposition -- ִжȡļǷѾڡȡֵ£
		CREATE_ALWAYSһСΪ0ļļѾ򸲸Ѵļ
		CREATE_NEWһСΪ0ļļѾ򷵻ʧܣ
		OPEN_ALWAYSһļļ򴴽һļ
		OPEN_EXISTINGһļļ򷵻ʧܣ
		TRUNCATE_EXISTINGһļض֮СΪ0ļ򷵻ʧܡ

	FlagsAndAttributes -- ļԺͱ־԰£
		FILE_ATTRIBUTE_READONLY ֻļ
		FILE_ATTRIBUTE_HIDDENļ
		FILE_ATTRIBUTE_SYSTEMϵͳļ
		FILE_ATTRIBUTE_DIRECTORYĿ¼ļFILE_ATTRIBUTE_ARCHIVE⣻
		FILE_ATTRIBUTE_ARCHIVEڴ洢ݵļFILE_ATTRIBUTE_DIRECTORY⣻

	FileObject -- ָ룬ָļָĻ

ֵ
	ɹ򷵻STATUS_SUCCESSSTATUS_FILE_ALLREADY_EXISTS

--*/
{
	STATUS Status;
	PCHAR SlashPtr;
	CHAR Slash;
	PSTR RelativName;
	PDEVICE_OBJECT DeviceObject = NULL;
	PFILE_OBJECT File = NULL;

	//
	// Ƿȷ
	//

	//
	// ΪDesiredAccessShareModeָ˲ʶĲ򷵻ʧܡ
	//
	if ((DesiredAccess & ~(GENERIC_READ | GENERIC_WRITE)) != 0) {
		return STATUS_INVALID_PARAMETER;
	}

	if ((ShareMode & ~(FILE_SHARE_READ | FILE_SHARE_WRITE)) != 0) {
		return STATUS_INVALID_PARAMETER;
	}

	//
	// ΪCreationDispositionָһЧֵ
	//
	if (CreationDisposition != CREATE_NEW &&
		CreationDisposition != CREATE_ALWAYS &&
		CreationDisposition != OPEN_EXISTING &&
		CreationDisposition != OPEN_ALWAYS &&
		CreationDisposition != TRUNCATE_EXISTING) {
		return STATUS_INVALID_PARAMETER;
	}

	//
	// ָTRUNCATE_EXISTINGдȨޡ
	//
	if (TRUNCATE_EXISTING == CreationDisposition && 0 == (DesiredAccess & GENERIC_WRITE)) {
		return STATUS_INVALID_PARAMETER;
	}

	//
	// вʶı־򷵻ʧܡ
	//
	if ((FlagsAndAttributes & ~(FILE_ATTRIBUTE_READONLY |
		FILE_ATTRIBUTE_HIDDEN | FILE_ATTRIBUTE_SYSTEM |
		FILE_ATTRIBUTE_DIRECTORY | FILE_ATTRIBUTE_ARCHIVE)) != 0) {
		return STATUS_INVALID_PARAMETER;
	}

	//
	// ָFILE_ATTRIBUTE_DIRECTORYFILE_ATTRIBUTE_ARCHIVE֮һ
	//
	if ((FlagsAndAttributes & (FILE_ATTRIBUTE_DIRECTORY | FILE_ATTRIBUTE_ARCHIVE)) == 0||
		(FlagsAndAttributes & (FILE_ATTRIBUTE_DIRECTORY | FILE_ATTRIBUTE_ARCHIVE)) == (FILE_ATTRIBUTE_DIRECTORY | FILE_ATTRIBUTE_ARCHIVE)) {
		return STATUS_INVALID_PARAMETER;
	}

	//
	// ĿĿ¼ǴеĻ򴴽µĿ¼Ŀ¼ܱд
	//
	if ((FlagsAndAttributes & FILE_ATTRIBUTE_DIRECTORY) != 0 &&
		(CreationDisposition != CREATE_NEW && CreationDisposition != OPEN_EXISTING || DesiredAccess != 0)) {
		return STATUS_INVALID_PARAMETER;
	}

	//
	// ļеĵһб'\''/'
	//
	for (SlashPtr = FileName; *SlashPtr != '\0' && *SlashPtr != '\\' && *SlashPtr != '/'; SlashPtr++);

	//
	// б֮ǰΪ豸бܴضַ豸豸Ȼָбֵܵ
	//
	Slash = *SlashPtr;	// бֵܵ
	*SlashPtr = '\0';	// ضַ
	Status = ObRefObjectByName(FileName, IopDeviceObjectType, (PVOID*)&DeviceObject);
	*SlashPtr = Slash;	// ָбֵܵ

	//
	// 豸ڻ豸ֱֱ֧Ӵ򿪣򷵻STATUS_PATH_NOT_FOUND
	//
	if (EOS_SUCCESS(Status)) {
		if (NULL == DeviceObject->DriverObject->Create) {
			ObDerefObject(DeviceObject);
			return STATUS_PATH_NOT_FOUND;
		}
	} else {
		ASSERT(STATUS_OBJECT_NAME_NOT_FOUND == Status);
		return STATUS_PATH_NOT_FOUND;
	} 

	//
	// ļ󲢳ʼ֮
	//
	Status = ObCreateObject( IopFileObjectType,
							 NULL,
							 sizeof(FILE_OBJECT),
							 0,
							 (PVOID*)&File );

	if (!EOS_SUCCESS(Status)) {
		ObDerefObject(DeviceObject);
		return Status;
	}

	File->DeviceObject = DeviceObject;
	File->FsContext = NULL;
	File->ReadAccess = (DesiredAccess & GENERIC_READ) != 0;
	File->WriteAccess = (DesiredAccess & GENERIC_WRITE) != 0;
	File->SharedRead = (ShareMode & FILE_SHARE_READ) != 0;
	File->SharedWrite = (ShareMode & FILE_SHARE_WRITE) != 0;
	File->FlagsAndAttributes = FlagsAndAttributes;
	File->CurrentByteOffset = 0;
	PsInitializeMutex(&File->Mutex, FALSE);

	//
	// ִCreateܺʹб֮豸·
	//
	for (RelativName = SlashPtr; '\\' == *RelativName || '/' == *RelativName; RelativName++);
	
	PsWaitForMutex(&DeviceObject->Mutex, INFINITE);
	
	Status = DeviceObject->DriverObject->Create(DeviceObject, RelativName, CreationDisposition, File);

	if (EOS_SUCCESS(Status)) {

		//
		// ɹִCreateFileObjectFsContextֵָ
		//
		ASSERT(File->FsContext != NULL);
		if (NULL == File->FsContext) {
			KeBugCheck("%s:%d:Checked a driver error!", __FILE__, __LINE__);
		}

		DeviceObject->OpenCount++;
		
		if (File->FsContext == DeviceObject) {

			//
			// ļֱӺ豸˹ǳδ豸մ
			// Ҫ豸ĹԣӦǷڹͻ
			//
			if (1 == DeviceObject->OpenCount) {

				DeviceObject->ShareRead = File->SharedRead;
				DeviceObject->ShareWrite = File->SharedWrite;

			} else if ( File->SharedRead != DeviceObject->ShareRead ||
						File->SharedWrite != DeviceObject->ShareWrite ||
						File->ReadAccess && !DeviceObject->ShareRead ||
						File->WriteAccess && !DeviceObject->ShareWrite ) {

				Status = STATUS_SHARING_VIOLATION;
			}
		}
	}

	PsReleaseMutex(&DeviceObject->Mutex);

	if (EOS_SUCCESS(Status)) {
		*FileObject =File;
	} else {
		ObDerefObject(File);
	}

	return Status;
}

VOID
IopCloseFileObject(
	IN PFILE_OBJECT FileObject
	)
/*++


	ļ


	FileObject -- ļָ롣

ֵ
	ޡ

--*/
{
	PDEVICE_OBJECT DeviceObject = FileObject->DeviceObject;

	if (DeviceObject != NULL) {

		//
		// FsContextΪNULL˵Ѿ豸Ҫر豸
		//
		if (FileObject->FsContext != NULL) {

			PsWaitForMutex(&DeviceObject->Mutex, INFINITE);

			DeviceObject->OpenCount--;
			if (DeviceObject->DriverObject->Close != NULL) {
				DeviceObject->DriverObject->Close(DeviceObject, FileObject);
			}

			PsReleaseMutex(&DeviceObject->Mutex);

			FileObject->FsContext = NULL;
		}

		//
		// رָFileObject->DeviceObject
		//
		FileObject->DeviceObject = NULL;
		ObDerefObject(DeviceObject);
	}
}

STATUS
IopReadFileObject(
	IN PFILE_OBJECT File,
	OUT PVOID Buffer,
	IN ULONG NumberOfBytesToRead,
	OUT PULONG NumberOfBytesRead
	)
/*++


	ȡļ


	File -- ļָ롣
	Buffer -- ָ룬ָȡĻ
	NumberOfBytesToRead -- ȡֽ
	NumberOfBytesRead -- ָ룬ָʵʶȡֽı

ֵ
	ɹ򷵻STATUS_SUCCESS

--*/
{
	STATUS Status;
	PDEVICE_OBJECT DeviceObject = File->DeviceObject;

	//
	// ļǷɶ
	//
	if (!File->ReadAccess) {
		return STATUS_ACCESS_DENIED;
	}

	//
	// 0̷ֽسɹ
	//
	if (0 == NumberOfBytesToRead) {
		*NumberOfBytesRead = 0;
		return STATUS_SUCCESS;
	}

	//
	// ضдͬһļ
	//
	PsWaitForMutex(&File->Mutex, INFINITE);

	//
	// ִReadܺ
	//
	PsWaitForMutex(&DeviceObject->Mutex, INFINITE);
	Status = DeviceObject->DriverObject->Read(DeviceObject, File, Buffer, NumberOfBytesToRead, NumberOfBytesRead);
	PsReleaseMutex(&DeviceObject->Mutex);

	if (EOS_SUCCESS(Status)) {
		File->CurrentByteOffset += *NumberOfBytesRead;
	}

	PsReleaseMutex(&File->Mutex);

	return Status;
}

STATUS
IopWriteFileObject(
	IN PFILE_OBJECT File,
	IN PVOID Buffer,
	IN ULONG NumberOfBytesToWrite,
	OUT PULONG NumberOfBytesWritten
	)
/*++


	дļ


	File -- ļָ롣
	Buffer -- ָ룬ָдݵĻ
	NumberOfBytesToWrite -- дֽ
	NumberOfBytesWritten -- ָ룬ָʵдֽı

ֵ
	ɹ򷵻STATUS_SUCCESS

--*/
{
	STATUS Status;
	PDEVICE_OBJECT DeviceObject = File->DeviceObject;

	//
	// Ƿдļ
	//
	if (!File->WriteAccess) {
		return STATUS_ACCESS_DENIED;
	}

	//
	// д0̷ֽسɹ
	//
	if (0 == NumberOfBytesToWrite) {
		*NumberOfBytesWritten = 0;
		return STATUS_SUCCESS;
	}

	//
	// дͬһļ
	//
	PsWaitForMutex(&File->Mutex, INFINITE);

	//
	// ִWriteܺ
	//
	PsWaitForMutex(&DeviceObject->Mutex, INFINITE);
	Status = DeviceObject->DriverObject->Write(DeviceObject, File, Buffer, NumberOfBytesToWrite, NumberOfBytesWritten);
	PsReleaseMutex(&DeviceObject->Mutex);

	if (EOS_SUCCESS(Status)) {
		File->CurrentByteOffset += *NumberOfBytesWritten;
	}

	PsReleaseMutex(&File->Mutex);

	return Status;
}

STATUS
IopQueryFileObjectInfo(
	IN PFILE_OBJECT FileObject,
	OUT PFILE_INFO FileInfo
	)
{
	STATUS Status;
	PDEVICE_OBJECT DeviceObject = FileObject->DeviceObject;

	if (NULL == DeviceObject->DriverObject->Query) {
		return STATUS_NOT_SUPPORTED;
	}

	//
	// ļ
	//
	PsWaitForMutex(&FileObject->Mutex, INFINITE);

	//
	// ִQueryܺ
	//
	PsWaitForMutex(&DeviceObject->Mutex, INFINITE);
	Status = DeviceObject->DriverObject->Query(DeviceObject, FileObject, FileInfo);
	PsReleaseMutex(&DeviceObject->Mutex);

	//
	// ͷļĻź
	//
	PsReleaseMutex(&FileObject->Mutex);

	return Status;
}

STATUS
IopSetFileObjectInfo(
	IN PFILE_OBJECT FileObject,
	IN PSET_FILE_INFO FileInfo
	)
{
	STATUS Status;
	PDEVICE_OBJECT DeviceObject = FileObject->DeviceObject;

	if (NULL == DeviceObject->DriverObject->Set) {
		return STATUS_NOT_SUPPORTED;
	}

	//
	// ļ
	//
	PsWaitForMutex(&FileObject->Mutex, INFINITE);

	//
	// ִSetܺ
	//
	PsWaitForMutex(&DeviceObject->Mutex, INFINITE);
	Status = DeviceObject->DriverObject->Set(DeviceObject, FileObject, FileInfo);
	PsReleaseMutex(&DeviceObject->Mutex);

	//
	// ͷļĻź
	//
	PsReleaseMutex(&FileObject->Mutex);

	return Status;
}
