/***

Copyright (c) 2008 ӢʱƼ޹˾Ȩ

ֻ EOS ԴЭ飨μ License.txtеʹЩ롣
ܣʹЩ롣

ļ: floppy.c

: EOS 
	  Ϊ˴׶֧һ 1.44M 



*******************************************************************************/

#include "iop.h"

//
// ̿Ĵ˿ڶ塣
//
#define DOR				0x03f2	// Ĵ
#define FDC_STATUS		0x03f4	// FDC״̬Ĵ
#define FDC_DATA		0x03f5	// FDCݼĴ
#define DIR				0x03f7	// Ĵ
#define DCR				0x03f7	// ̿ƼĴ

//
// Ĵλ塣
//
#define DOR_MOT_EN3		0x80	// D1-0-رա
#define DOR_MOT_EN2		0x40	// C1-0-رա
#define DOR_MOT_EN1		0x20	// B1-0-رա
#define DOR_MOT_EN0		0x10	// A1-0-رա
#define DOR_DMA_INT		0x08	// 1-DMAж0-ֹDMAж
#define DOR_RESET		0x04	// 1-̿FDC0-λFDC

//
// ״̬Ĵ塣
//
#define	MSR_RQM			0x80	// FDC_DATA
#define MSR_DIO			0x40	// ䷽1-FDC->CPU0-CPU->FDC
#define MSR_NDMA		0x20	// DMAʽ
#define MSR_CB			0x10	// æ
#define MSR_DDB			0x08	// Dæ
#define MSR_DCB			0x04	// Cæ
#define MSR_DBB			0x02	// Bæ
#define MSR_DAB			0x01	// Aæ

//
// ̿塣
//
#define FD_RECALIBRATE	0x07	// У
#define FD_SEEK			0x0F	// Ѱ
#define FD_READ			0xE6	// 
#define FD_WRITE		0xC5	// д
#define FD_SENSE		0x08	// ж״̬
#define FD_SPECIFY		0x03	// 趨
#define FD_CONFIGURE	0x13	// 

//
// ״̬
//
typedef enum _MOTOR_STATE {
	ON,		// 0
	DELAY,	// 1ʱأȻţ
	OFF		// 2ء
} MOTOR_STATE;

//
// ǰ״̬
//
PRIVATE UCHAR MotorState = OFF;

//
// ʱرļʱ
//
PRIVATE KTIMER DelayedOffTimer;

//
// ж¼
//
PRIVATE EVENT InterruptEvent;


PRIVATE VOID
FloppyIsr(
	VOID
	)
/*++


	жϷ򡣽ж¼ΪЧӶ֪ͨ߳жϵ


	ޡ

ֵ
	ޡ

--*/
{
	PsSetEvent(&InterruptEvent);
}

PRIVATE VOID
FloppyTurnOnMotor(
	VOID
	)
/*++


	


	ޡ

ֵ
	ޡ

--*/
{
	BOOL IntState;

	//
	// ʱرļʱ⣬Ҫرжϡ
	//
	IntState = KeEnableInterrupts(FALSE);

	if (DELAY == MotorState) {

		//
		// ڱʱرգתעӳٹرռʱɡ
		//
		KeUnregisterTimer(&DelayedOffTimer);

	} else if (OFF == MotorState) {

		//
		// ﴦڹر״̬A
		//
		WRITE_PORT_UCHAR((PUCHAR)DOR, DOR_MOT_EN0 | DOR_DMA_INT | DOR_RESET);

		//
		// 300-500msܴﵽȶת٣˯ߵȴ֮
		//
		PsSleep(500);
	}

	//
	// ޸״̬
	//
	MotorState = ON;

	//
	// ָж״̬
	//
	KeEnableInterrupts(IntState);
}

PRIVATE VOID
DelayOffTimerRoutine(
	IN ULONG_PTR Parameter
	)
/*++


	ӳٹرļʱر


	Parameter -- á

ֵ
	ޡ

--*/
{
	ASSERT(DELAY == MotorState);

	//
	// ر޸״̬עʱ
	//
	WRITE_PORT_UCHAR((PUCHAR)DOR, DOR_DMA_INT | DOR_RESET);
	
	MotorState = OFF;

	KeUnregisterTimer(&DelayedOffTimer);
}

PRIVATE VOID
FloppyTurnOffMotor(
	VOID
	)
/*++


	ر


	ޡ

ֵ
	ޡ

--*/
{
	BOOL IntState;

	//
	// ʱرļʱ⣬Ҫرжϡ
	//
	IntState = KeEnableInterrupts(FALSE);

	if (ON == MotorState) {

		//
		// Ϊ˱Ƶ̹ر3ڲʹ
		// ŽرաҪĽעһӳ3رļʱ
		//
		KeInitializeTimer( &DelayedOffTimer,
						   3000,
						   DelayOffTimerRoutine,
						   0 );

		KeRegisterTimer(&DelayedOffTimer);

		MotorState = DELAY;
	}

	KeEnableInterrupts(IntState);
}

PRIVATE BOOL
FloppyWriteFdc(
	IN PUCHAR Buffer,
	IN UCHAR BytesToWrite
	)
/*++


	дݵFDC_DATAĴ


	Buffer - ݻָ롣
	BytesToWrite - дֽ

ֵ
	ɹ򷵻TRUE򷵻FALSE

--*/
{
	UCHAR i;
	UCHAR ErrorCount;
	UCHAR Msr;

	for (i = 0; i < BytesToWrite; i++) {

		for (ErrorCount = 0;;) {

			//
			// ȡFDC_STATUS״̬Ĵ
			//
			Msr = READ_PORT_UCHAR((PUCHAR)FDC_STATUS);

			if ((Msr & MSR_RQM) != 0) {

				//
				// FDC_DATA䷽ΪCPU->FDCдFDC_DATAˣ
				// ʧܡ
				//
				if ((Msr & MSR_DIO) == 0) {
					WRITE_PORT_UCHAR((PUCHAR)FDC_DATA, Buffer[i]);
					break;
				} else {
					return FALSE;
				}

			} else {

				//
				// FDCδͬһֽԴﵽ3򷵻ʧܣȴԡ
				//
				if (3 == ++ErrorCount) {
					return FALSE;
				}

				//
				// ˯ߵȴһСzZZ^
				//
				PsSleep(10);
			}
		}
	}

	return TRUE;
}

PRIVATE BOOL
FloppyReadFdc(
	OUT PUCHAR Buffer,
	IN UCHAR BytesToRead
	)
/*++


	ȡFDCִĽֽС


	Buffer - ȡĻָ롣
	BytesToRead - ȡֽ

ֵ
	ɹTRUE򷵻FALSE

--*/
{
	UCHAR i;
	UCHAR ErrorCount; 
	UCHAR Msr;

	ASSERT(BytesToRead > 0);

	for (i = 0;;) {

		for (ErrorCount = 0;;) {

			//
			// ȡFDC_STATUS״̬Ĵ
			//
			Msr = READ_PORT_UCHAR((PUCHAR)FDC_STATUS);

			if ((Msr & MSR_RQM) != 0) {

				//
				// FDC_DATA䷽ΪFDC->CPUԶȡFDC_DATAˣ
				// ˵ݶȡϡ
				//
				if ((Msr & MSR_DIO) != 0) {

					//
					// ȡFDC_DATAݳȳȡĳ򷵻ʧܡ
					//
					if (i == BytesToRead) {
						return FALSE;
					}

					Buffer[i++] = READ_PORT_UCHAR((PUCHAR)FDC_DATA);

					//
					// ȡһֽڡ
					//
					break;

				} else {

					//
					// ݶȡϣȡȴﵽȡ򷵻TRUE
					//
					return (i == BytesToRead);
				}

			} else {

				//
				// FDCδͬһֽԴﵽ3򷵻ʧܣȴԡ
				//
				if (3 == ++ErrorCount) {
					return FALSE;
				}

				//
				// ˯ߵȴһСzZZ^
				//
				PsSleep(10);
			}
		}
	}
}

PRIVATE VOID
FloppyResetFDC(
	VOID
	)
/*++


	λ


	ޡ

ֵ
	ޡ

--*/
{
	UCHAR DataBuffer[4];

	for(;;) {

		//
		// ʹDORRESETλΪ0һСȻٻָΪ1ɸλ
		//
		WRITE_PORT_UCHAR((PUCHAR)DOR, DOR_MOT_EN0 | DOR_DMA_INT);

		PsSleep(10);

		WRITE_PORT_UCHAR((PUCHAR)DOR, DOR_MOT_EN0 | DOR_DMA_INT | DOR_RESET);

		//
		// λɺᴥһжϣȴλжϵĵ
		//
		PsWaitForEvent(&InterruptEvent, INFINITE);

		//
		// ж״̬ȷǸλжϡ
		//
		DataBuffer[0] = FD_SENSE;

		if (!FloppyWriteFdc(DataBuffer, 1) ||
			!FloppyReadFdc(DataBuffer, 2) ||
			0xC0 != DataBuffer[0] ) {
			continue;
		}

		//
		// 趨1.44MĲ
		//
		DataBuffer[0] = FD_SPECIFY;
		DataBuffer[1] = 0xDF;
		DataBuffer[2] = 8 << 1;

		if (!FloppyWriteFdc(DataBuffer, 3)) {
			continue;
		}

		//
		// Ѱ
		//
		DataBuffer[0] = FD_CONFIGURE;
		DataBuffer[1] = 0;
		DataBuffer[2] = 0x60;
		DataBuffer[3] = 0;

		if (!FloppyWriteFdc(DataBuffer, 4)) {
			continue;
		}

		//
		// ôʣ1.44MĴ500kb/s
		//
		WRITE_PORT_UCHAR((PUCHAR)DCR, 0);

		break;
	}
}

PRIVATE BOOL
FloppyRecalibrate(
	VOID
	)
/*++


	Уͷλãͷǿƹλ0ŵ


	ޡ

ֵ
	ɹ򷵻TRUE

--*/
{
	UCHAR DataBuffer[2];

	for (;;) {

		//
		// 0У
		//
		DataBuffer[0] = FD_RECALIBRATE;
		DataBuffer[1] = 0;

		if (FloppyWriteFdc(DataBuffer, 2)) {

			//
			// ɹУȴУжϡ
			//
			PsWaitForEvent(&InterruptEvent, INFINITE);

			//
			// ж״̬ȷУжϡ
			//
			DataBuffer[0] = FD_SENSE;

			if (FloppyWriteFdc(DataBuffer, 1) &&
				FloppyReadFdc(DataBuffer, 2) &&
				(DataBuffer[0] & 0x20) != 0) {

				break;
			}
		}

		//
		// FDC߼󣬸λȻУ
		//
		FloppyResetFDC();
	}

	//
	// ͷӦλ0ŵ
	//
	return (0 == (DataBuffer[0] >> 6) && 0 == DataBuffer[1]);
}

PRIVATE STATUS
FloppyRw(
	IN PVOID Buffer,
	IN USHORT StartingSector,
	IN USHORT SectorsToRW,
	IN BOOL IsRead
	)
/*++


	д


	Buffer -- ַ
	StartingSector -- дʼ
	SectorsToRW -- д
	IsRead -- TRUE:FALSE:д

ֵ
	ɹ򷵻STATUS_SUCESS

--*/
{
	STATUS Status;
	BOOL IntState;
	UCHAR Cylinder;
	UCHAR Head;
	UCHAR Sector;
	UCHAR ErrorCount;
	UCHAR DataBuffer[9];
	USHORT BytesToRW;
	PVOID BufferPhysicalAdress;

	Status = MmGetPhysicalAddress(Buffer, &BufferPhysicalAdress);

	//
	// DMAֻѰַ1Mڴ档
	//
	if (!EOS_SUCCESS(Status) || (ULONG_PTR)BufferPhysicalAdress >= 0x100000) {
		return STATUS_INVALID_ADDRESS;
	}

	//
	// IOʼCHSַֽ
	//
	Cylinder = (StartingSector / 18) / 2;
	Head = (StartingSector / 18) % 2;
	Sector = (StartingSector % 18) + 1;
	BytesToRW = SectorsToRW * 512;

	//
	// 
	//
	FloppyTurnOnMotor();

	//
	// ִIOIOУͷλúԣ6Ρ
	//
	Status = STATUS_FLOPPY_UNKNOWN_ERROR;

	for (ErrorCount = 0; ErrorCount < 6;) {

		//
		// ʼDMAͨ2رжϷֹš
		//
		IntState = KeEnableInterrupts(FALSE);

		//
		// ͨ2
		//
		WRITE_PORT_UCHAR((PUCHAR)0x0A, 0x06);

		//
		// /ʹ
		//
		WRITE_PORT_UCHAR((PUCHAR)0x0C, 0x06);

		//
		// дʽ֣ģʽΪֽڵ/дֹͣԶԤá
		//
		WRITE_PORT_UCHAR((PUCHAR)0x0B, IsRead ? 0x46 : 0x4A);

		//
		// ֱд8λ͸8λַĴ
		//
		WRITE_PORT_UCHAR((PUCHAR)0x04, (UCHAR)((ULONG_PTR)BufferPhysicalAdress));
		WRITE_PORT_UCHAR((PUCHAR)0x04, (UCHAR)((ULONG_PTR)BufferPhysicalAdress >> 8));

		//
		// дַ16-19λҳĴ
		//
		WRITE_PORT_UCHAR((PUCHAR)0x81, (UCHAR)((ULONG_PTR)Buffer >> 16));

		//
		// ֱд8λ͸8λֽĴ
		//
		WRITE_PORT_UCHAR((PUCHAR)0x05, (UCHAR)(BytesToRW - 1));
		WRITE_PORT_UCHAR((PUCHAR)0x05, (UCHAR)((BytesToRW - 1) >> 8));

		//
		// ͨ2
		//
		WRITE_PORT_UCHAR((PUCHAR)0x0A, 0x02);

		//
		// DMAʼɣָжϡ
		//
		KeEnableInterrupts(IntState);

		//
		// FDC/д
		//
		DataBuffer[0] = IsRead ? FD_READ : FD_WRITE;	// ֽ
		DataBuffer[1] = Head << 2;						// ͷ  
		DataBuffer[2] = Cylinder;						// 
		DataBuffer[3] = Head;							// ͷ
		DataBuffer[4] = Sector;							// 
		DataBuffer[5] = 2;								// С512Bytes)
		DataBuffer[6] = 18;								// ÿŵ
		DataBuffer[7] = 0x1B;							// ֮ļ
		DataBuffer[8] = 0xFF;							// 

		if (!FloppyWriteFdc(DataBuffer, 9)) {						

			//
			// ߼λ
			//
			FloppyResetFDC();
			continue;
		}

		//
		// ȴджϡ
		//
		PsWaitForEvent(&InterruptEvent, INFINITE);

		//
		// ȡ/дִн
		//
		if (!FloppyReadFdc(DataBuffer, 7)) {

			//
			// ߼λ
			//
			FloppyResetFDC();
			continue;
		}

		if ((DataBuffer[0] >> 6) != 0) {

			//
			// 쳣
			//
			ASSERT(0x01 == (DataBuffer[0] >> 6));

			if ((DataBuffer[1] & 0x02) != 0) {

				//
				// дֹд
				//
				Status = STATUS_ACCESS_DENIED;
				break;
			}

			//
			// ̶дӴУͷλúԡ
			//
			ErrorCount++;
			FloppyRecalibrate();
			continue;
		}

		Status = STATUS_SUCCESS;
		break;
	}

	//
	// ر
	//
	FloppyTurnOffMotor();

	return Status;
}

PRIVATE STATUS
FloppyRead(
	IN PDEVICE_OBJECT DeviceObject,
	IN PFILE_OBJECT FileObject,
	OUT PVOID Buffer,
	IN ULONG Request,
	OUT PULONG Result OPTIONAL
	)
/*++


	Ķǲ̣ȡָһָĻС


	ο iop.h ж Read ܺĽܡ

ֵ
	ɹ򷵻 STATUS_SUCCESS

--*/
{
	//
	// 1.44M ֻ 2880 
	//
	if (Request >= 2880) {
		return STATUS_INVALID_PARAMETER;
	}

	return FloppyRw(Buffer, Request, 1, TRUE);
}

PRIVATE STATUS
FloppyWrite(
	IN PDEVICE_OBJECT DeviceObject,
	IN PFILE_OBJECT FileObject,
	IN PVOID Buffer,
	IN ULONG Request,
	OUT PULONG Result OPTIONAL
	)
/*++


	дǲ̣деݵָһС


	ο iop.h ж Write ܺĽܡ

ֵ
	ɹ򷵻 STATUS_SUCCESS

--*/
{
	//
	// 1.44M ֻ 2880 
	//
	if (Request >= 2880) {
		return STATUS_INVALID_PARAMETER;
	}

	return FloppyRw(Buffer, Request, 1, FALSE);
}

PRIVATE STATUS
FlopyAddDevice(
	IN PDRIVER_OBJECT DriverObject,
	IN PDEVICE_OBJECT NextLayerDevice,
	IN USHORT DeviceNumber,
	OUT PDEVICE_OBJECT *DeviceObject
	)
{
	STATUS Status;

	//
	// û²豸Ŀǰ֧һ豸
	//
	ASSERT(NULL == NextLayerDevice);
	ASSERT(0 == DeviceNumber);

	Status = IopCreateDevice( DriverObject,
							  0,
							  "FLOPPY0",
							  DeviceNumber,
							  TRUE,
							  DeviceObject);

	if (EOS_SUCCESS(Status)) {

		//
		// ʼж¼
		//
		PsInitializeEvent(&InterruptEvent, FALSE, FALSE);

		//
		// ж
		//
		KeIsrFloppy = FloppyIsr;

		//
		// 豸жϡ
		//
		KeEnableDeviceInterrupt(INT_FLOPPY, TRUE);

		//
		// λ
		//
		FloppyResetFDC();
	}
	
	return Status;
}

VOID
FloppyInitializeDriver(
	PDRIVER_OBJECT DriverObject
	)
{
	DriverObject->AddDevice = FlopyAddDevice;

	//
	// ֱ̲֧ӱд֮ͨϵļϵͳʴ̣Դ
	// CreateCloseܺ
	//
	DriverObject->Read = FloppyRead;
	DriverObject->Write = FloppyWrite;
}
