/***

Copyright (c) 2008 ӢʱƼ޹˾Ȩ

ֻ EOS ԴЭ飨μ License.txtеʹЩ롣
ܣʹЩ롣

ļ: io.c

: IOģӿںʵ֡



*******************************************************************************/

#include "iop.h"

STATUS 
IoCreateFile(
	IN PSTR FileName, 
	IN ULONG DesiredAccess, 
	IN ULONG ShareMode, 
	IN ULONG CreationDisposition, 
	IN ULONG FlagsAndAttributes, 
	OUT PHANDLE FileHandle
	)
/*++


	ļĿλڴļϵͳеļҲIO豸


	FileName -- 򿪵ļơ

	DesiredAccess -- õļȨޣGENERIC_READGENERIC_WRITE

	ShareMode -- ĹģʽFILE_SHARE_READFILE_SHARE_WRITE

	CreationDisposition -- ִжȡļǷѾڡȡֵ£
		CREATE_ALWAYSһСΪ0ļļѾ򸲸Ѵļ
		CREATE_NEWһСΪ0ļļѾ򷵻ʧܣ
		OPEN_ALWAYSһļļ򴴽һļ
		OPEN_EXISTINGһļļ򷵻ʧܣ
		TRUNCATE_EXISTINGһļض֮СΪ0ļ򷵻ʧܡ

	FlagsAndAttributes -- ļԺͱ־԰£
		FILE_ATTRIBUTE_READONLY ֻļ
		FILE_ATTRIBUTE_HIDDENļ
		FILE_ATTRIBUTE_SYSTEMϵͳļ

	FileHandle -- ָ룬ָļָĻ

ֵ
	ɹ򷵻STATUS_SUCCESSSTATUS_FILE_ALLREADY_EXISTS

--*/
{
	STATUS Status;
	PFILE_OBJECT FileObject;

	//
	// ֻܴļܴĿ¼ļ
	//
	if ((FlagsAndAttributes & FILE_ATTRIBUTE_DIRECTORY) != 0) {
		return STATUS_INVALID_PARAMETER;
	}

	//
	// ֱӴĿ¼ļ
	//
	if ((FlagsAndAttributes & FILE_ATTRIBUTE_DIRECTORY) != 0) {
		return STATUS_INVALID_PARAMETER;
	}

	//
	// ԶFILE_ATTRIBUTE_ARCHIVEԡ
	//
	FlagsAndAttributes |= FILE_ATTRIBUTE_ARCHIVE;

	Status = IopCreateFileObject( FileName,
								  DesiredAccess,
								  ShareMode,
								  CreationDisposition,
								  FlagsAndAttributes,
								  &FileObject );

	if (!EOS_SUCCESS(Status)) {
		return Status;
	}

	Status = ObCreateHandle(FileObject, FileHandle);

	if (!EOS_SUCCESS(Status)) {
		ObDerefObject(FileObject);
	}

	return Status;
}

STATUS
IoCreateDirectory(
	IN PSTR PathName
	)
/*++


	һĿ¼


	PathName -- Ŀ¼·ַ

ֵ
	ɹ򷵻STATUS_SUCCESS

--*/
{
	STATUS Status;
	PFILE_OBJECT NewFile;

	Status = IopCreateFileObject( PathName,
								  0,
								  0,
								  CREATE_NEW,
								  FILE_ATTRIBUTE_DIRECTORY,
								  &NewFile );

	if (EOS_SUCCESS(Status)) {
		ObDerefObject(NewFile);
	}

	return Status;
}

STATUS
IoGetFileTime(
	IN HANDLE FileHandle,
	OUT PFILETIME CreationTime,
	OUT PFILETIME LastAccessTime,
	OUT PFILETIME LastWriteTime
	)
{
	STATUS Status;
	PFILE_OBJECT FileObject;
	FILE_INFO FileInfo;

	Status = ObRefObjectByHandle(FileHandle, IopFileObjectType, (PVOID*)&FileObject);

	if (EOS_SUCCESS(Status)) {

		Status = IopQueryFileObjectInfo(FileObject, &FileInfo);

		if (EOS_SUCCESS(Status)) {

			*CreationTime = FileInfo.CreationTime;
			*LastAccessTime = FileInfo.LastAccessTime;
			*LastWriteTime = FileInfo.LastWriteTime;
		}

		ObDerefObject(FileObject);
	}

	return Status;
}

STATUS 
IoGetFileSize(
	IN HANDLE FileHandle,
	OUT PULONG FileSize
	)
{
	STATUS Status;
	PFILE_OBJECT FileObject;
	FILE_INFO FileInfo;

	Status = ObRefObjectByHandle(FileHandle, IopFileObjectType, (PVOID*)&FileObject);

	if (EOS_SUCCESS(Status)) {

		Status = IopQueryFileObjectInfo(FileObject, &FileInfo);

		if (EOS_SUCCESS(Status)) {
			*FileSize = FileInfo.FileSize;
		}

		ObDerefObject(FileObject);
	}

	return Status;
}

//
// ļдλá
//
STATUS
IoSetFilePointer(
	IN HANDLE FileHandle,
	IN LONG DistanceToMove,
	IN ULONG MoveMethod,
	OUT PULONG NewFilePointer
	)
{
	STATUS Status;
	PFILE_OBJECT FileObject;
	FILE_INFO FileInfo;

	if (MoveMethod != FILE_BEGIN && MoveMethod != FILE_CURRENT && MoveMethod != FILE_END) {
		return STATUS_INVALID_PARAMETER;
	}

	Status = ObRefObjectByHandle(FileHandle, IopFileObjectType, (PVOID*)&FileObject);

	if (!EOS_SUCCESS(Status)) {
		return Status;
	}

	//
	// ļ
	//
	PsWaitForMutex(&FileObject->Mutex, INFINITE);

	Status = IopQueryFileObjectInfo(FileObject, &FileInfo);

	if (EOS_SUCCESS(Status)) {

		if (FILE_BEGIN == MoveMethod) {

			if (DistanceToMove <= 0) {
				FileObject->CurrentByteOffset = 0;
			} else if ((ULONG)DistanceToMove >= FileInfo.FileSize) {
				FileObject->CurrentByteOffset = FileInfo.FileSize;
			} else {
				FileObject->CurrentByteOffset = DistanceToMove;
			}

		} else if (FILE_CURRENT == MoveMethod) {

			if (DistanceToMove < 0 && (ULONG)(-DistanceToMove) > FileObject->CurrentByteOffset) {
				FileObject->CurrentByteOffset = 0;
			} else if (DistanceToMove > 0 && FileObject->CurrentByteOffset + DistanceToMove >= FileInfo.FileSize) {
				FileObject->CurrentByteOffset = FileInfo.FileSize;
			} else {
				FileObject->CurrentByteOffset += DistanceToMove;
			}

		} else {

			if (DistanceToMove >= 0) {
				FileObject->CurrentByteOffset = FileInfo.FileSize;
			} else if ((ULONG)(-DistanceToMove) >= FileInfo.FileSize) {
				FileObject->CurrentByteOffset = 0;
			} else {
				FileObject->CurrentByteOffset = FileInfo.FileSize + DistanceToMove;
			}
		}

		*NewFilePointer = FileObject->CurrentByteOffset;

		Status = STATUS_SUCCESS;
	}

	PsReleaseMutex(&FileObject->Mutex);

	return Status;
}

//
// õļֵ
//
STATUS
IoGetFileAttributes(
	IN PSTR FileName,
	OUT PULONG FileAttributes
	)
{
	STATUS Status;
	PFILE_OBJECT FileObject;
	FILE_INFO FileInfo;

	//
	// ļ
	//
	Status = IopCreateFileObject( FileName,
								  0,
								  FILE_SHARE_READ | FILE_SHARE_READ,
								  OPEN_EXISTING,
								  FILE_ATTRIBUTE_ARCHIVE,
								  &FileObject );

	if (!EOS_SUCCESS(Status)) {
		return Status;
	}

	Status = IopQueryFileObjectInfo( FileObject, &FileInfo);

	//
	// رļ
	//
	ObDerefObject(FileObject);

	if (EOS_SUCCESS(Status)) {
		*FileAttributes = FileInfo.FileAttributes;
	}

	return Status;
}

//
// ޸ļֵ
//
STATUS
IoSetFileAttributes(
	IN PSTR FileName,
	IN ULONG FileAttributes
	)
{
	STATUS Status;
	PFILE_OBJECT FileObject;
	SET_FILE_INFO FileInfo;

	if ((FileAttributes & ~(FILE_ATTRIBUTE_ARCHIVE | FILE_ATTRIBUTE_HIDDEN |
		FILE_ATTRIBUTE_READONLY | FILE_ATTRIBUTE_SYSTEM)) != 0) {
		return STATUS_INVALID_PARAMETER;
	}

	if ((FileAttributes & FILE_ATTRIBUTE_ARCHIVE) == 0) {
		FileAttributes |= FILE_ATTRIBUTE_ARCHIVE;
	}

	//
	// ռļ
	//
	Status = IopCreateFileObject( FileName,
								  0,
								  0,
								  OPEN_EXISTING,
								  FILE_ATTRIBUTE_ARCHIVE,
								  &FileObject );

	if (!EOS_SUCCESS(Status)) {
		return Status;
	}

	FileInfo.FileInfoClass = FileAttributesInfo;
	FileInfo.u.AttributesInfo.FileAttributes = FileAttributes;

	Status = IopSetFileObjectInfo(FileObject, &FileInfo);

	//
	// رļ
	//
	ObDerefObject(FileObject);

	return Status;
}

//
// ɾļ
//
STATUS
IoDeleteFile(
	IN PSTR FileName
	)
{
	STATUS Status;
	PFILE_OBJECT FileObject;
	SET_FILE_INFO FileInfo;

	//
	// ռļ
	//
	Status = IopCreateFileObject( FileName,
								  0,
								  0,
								  OPEN_EXISTING,
								  FILE_ATTRIBUTE_ARCHIVE,
								  &FileObject );

	if (!EOS_SUCCESS(Status)) {
		return Status;
	}

	FileInfo.FileInfoClass = FileAttributesInfo;
	FileInfo.u.DispositionInfo.DeleteFile = TRUE;

	Status = IopSetFileObjectInfo(FileObject, &FileInfo);

	//
	// رļ
	//
	ObDerefObject(FileObject);

	return Status;
}

//
// ɾһĿ¼
//
STATUS
IoRemoveDirectory(
	IN PSTR PathName
	)
{
	STATUS Status;
	PFILE_OBJECT FileObject;
	SET_FILE_INFO FileInfo;

	//
	// ռĿ¼ļ
	//
	Status = IopCreateFileObject( PathName,
								  0,
								  0,
								  OPEN_EXISTING,
								  FILE_ATTRIBUTE_DIRECTORY,
								  &FileObject );

	if (!EOS_SUCCESS(Status)) {
		return Status;
	}

	FileInfo.FileInfoClass = FileAttributesInfo;
	FileInfo.u.DispositionInfo.DeleteFile = TRUE;

	Status = IopSetFileObjectInfo(FileObject, &FileInfo);

	//
	// رļ
	//
	ObDerefObject(FileObject);

	return Status;
}
