/***

Copyright (c) 2008 ӢʱƼ޹˾Ȩ

ֻ EOS ԴЭ飨μ License.txtеʹЩ롣
ܣʹЩ롣

ļ: ktimer.c

: ں˶ʱʵ֡



*******************************************************************************/

#include "ki.h"

//
// ʱͷ
//
static LIST_ENTRY KiTimerListHead = {&KiTimerListHead, &KiTimerListHead};

//
// һҪļʱָ롣
//
static volatile PLIST_ENTRY KiNextTimerListEntry = NULL;

volatile long Tick = 0;

//
// ʱƬתȺԭ͡
//
VOID
PspRoundRobin(
	VOID
	);

VOID
KiIsrTimer(
	VOID
	)
/*++


	ʱPIT: Programmable Interval TimerжϷ


	ޡ

ֵ
	ޡ

--*/
{
	BOOL IntState;
	PKTIMER Timer;

	++Tick;
	//
	// ʱ
	//
	KiNextTimerListEntry = KiTimerListHead.Next;
	while (KiNextTimerListEntry != &KiTimerListHead) {

		Timer = CONTAINING_RECORD(KiNextTimerListEntry, KTIMER, TimerListEntry);

		//
		// ڵûصǰָƣΪصִʱܻע˼ʱ
		//
		KiNextTimerListEntry = KiNextTimerListEntry->Next;

		//
		// ӼʱѾʹõʱ
		//
		Timer->ElapsedTicks++;

		//
		// ʱ䵽¿ʼʱüʱص
		// ע⣺һҪ¿ʼʱȻٵüʱص
		// Ϊصִʱܻעʱ
		//
		if (Timer->IntervalTicks == Timer->ElapsedTicks) {

			Timer->ElapsedTicks = 0;
			Timer->TimerRoutine(Timer->Parameter);
		}
	}
	KiNextTimerListEntry = NULL;

	//
	// ʱƬתȡ
	//
	IntState = KeEnableInterrupts(FALSE);
	PspRoundRobin();
	KeEnableInterrupts(IntState);
}

VOID
KeInitializeTimer(
	IN PKTIMER Timer,
	IN ULONG Milliseconds,
	IN PKTIMER_ROUTINE TimerRoutine,
	IN ULONG_PTR Parameter
	)
/*++


	ʼں˼ʱṹ塣


	Timer -- ں˼ʱṹָ롣
	Milliseconds -- ʱʱλ롣ʱСKTIMER_MINIMUM
		KTIMER_MAXIMUM
	TimerRoutine -- ʱʱ䵽ҪõĻصصڼʱжбá
	Parameter -- ҪݸصĲ

ֵ
	ޡ

--*/
{
	ASSERT(NULL != Timer);
	ASSERT(NULL != TimerRoutine);
	ASSERT(Milliseconds >= KTIMER_MINIMUM && Milliseconds <= KTIMER_MAXIMUM);

	if (Milliseconds > KTIMER_MAXIMUM) {
		Milliseconds = KTIMER_MAXIMUM;
	} else if (Milliseconds < KTIMER_MINIMUM) {
		Milliseconds = KTIMER_MINIMUM;
	}

	//
	// λΪʱתΪϵͳڲʱ
	// ʼ PIT ʱʱ 10ms 5 Ϊ롣
	//
	Timer->IntervalTicks = (Milliseconds + 5) / 10;
	
	Timer->TimerRoutine = TimerRoutine;
	Timer->Parameter = Parameter;
}

VOID
KeRegisterTimer(
	IN PKTIMER Timer
	)
/*++


	עѳʼں˼ʱʱʱͷ


	Timer -- ں˼ʱṹָ롣

ֵ
	ޡ

--*/
{
	BOOL IntState;
#ifdef _DEBUG
	PLIST_ENTRY ListEntry;
#endif

	IntState = KeEnableInterrupts(FALSE);

#ifdef _DEBUG
	//
	// ȷظעͬһʱ
	//
	for (ListEntry = KiTimerListHead.Next; ListEntry != &KiTimerListHead; ListEntry = ListEntry->Next) {
		ASSERT(ListEntry != &Timer->TimerListEntry);
	}
#endif

	//
	// ʼͷ
	//
	Timer->ElapsedTicks = 0;
	ListInsertHead(&KiTimerListHead, &Timer->TimerListEntry);

	KeEnableInterrupts(IntState);
}

VOID
KeUnregisterTimer(
	IN PKTIMER Timer
	)
/*++


	עں˼ʱʱӼʱƳ


	Timer -- ں˼ʱṹָ롣

ֵ
	ޡ

--*/
{
	BOOL IntState;
#ifdef _DEBUG
	PLIST_ENTRY ListEntry;
#endif

	IntState = KeEnableInterrupts(FALSE);

#ifdef _DEBUG
	//
	// ȷעļʱ
	//
	for (ListEntry = KiTimerListHead.Next; ListEntry != &KiTimerListHead; ListEntry = ListEntry->Next) {
		if (ListEntry == &Timer->TimerListEntry) {
			break;
		}
	}

	ASSERT(ListEntry != &KiTimerListHead);
#endif

	//
	// һʱĻصִʱпܻעһҪļʱ
	// Ҫһȫֵ KiNextTimerListEntry ָһҪļʱ
	//
	if(KiNextTimerListEntry == &Timer->TimerListEntry) {
		KiNextTimerListEntry = KiNextTimerListEntry->Next;
	}
	
	ListRemoveEntry(&Timer->TimerListEntry);

	KeEnableInterrupts(IntState);
}
