/***

Copyright (c) 2008 ӢʱƼ޹˾Ȩ

ֻ EOS ԴЭ飨μ License.txtеʹЩ롣
ܣʹЩ롣

ļ: list.c

: ݽṹģ顣



*******************************************************************************/

#include "rtl.h"

PLIST_ENTRY
ListRemoveHead(
	PLIST_ENTRY ListHead
	)
/*++


	Ƴĵһ


	ListHead -- ͷָ롣

ֵ
	رƳָ룬Ϊգ NULL

--*/
{
	if (ListIsEmpty(ListHead)) {
		return NULL;
	}
	
	//
	// ĵһͷָһͷ
	//
	return ListRemoveEntry(ListHead->Next);
}

PLIST_ENTRY
ListRemoveTail(
	PLIST_ENTRY ListHead
	)
/*++


	Ƴһ


	ListHead -- ͷָ롣

ֵ
	رƳָ룬Ϊգ NULL

--*/
{
	if(ListIsEmpty(ListHead)) {
		return NULL;
	}

	//
	// һͷָǰһ
	//
	return ListRemoveEntry(ListHead->Prev);
}

ULONG
ListGetCount(
	PLIST_ENTRY ListHead
	)
/*++


	õĿע⣬ͷڡ


	ListHead -- ͷָ롣

ֵ
	Ŀ

--*/
{
	PLIST_ENTRY ListEntry;
	ULONG Count = 0;
	
	for (ListEntry = ListHead->Next;
		ListEntry != ListHead;
		ListEntry = ListEntry->Next) {
		
		Count++;
	}
	
	return Count;
}

PLIST_ENTRY
ListInitializeHead(
	PLIST_ENTRY ListHead
	)
/*++


	ʼͷҲǽʼΪա


	ListHead -- ͷָ롣

ֵ
	ʼϵͷָ롣

--*/
{
	//
	// һյ˫ѭͷǰһָ
	// ͺһָ붼ָͷԼ
	//
	ListHead->Next = ListHead->Prev = ListHead;

	return ListHead;
}

BOOL
ListIsEmpty(
	PLIST_ENTRY ListHead
	)
/*++


	ж˫ѭǷΪա


	ListHead -- ͷָ롣

ֵ
	˫ѭΪգ TRUE򷵻 FALSE

--*/
{
	//
	// ˫ѭͷĺһָָͷԼ˵Ϊա
	// жϵԭ򣬿Բοʼͷ ListInitializeHead
	//
	return ListHead->Next == ListHead;
}

PLIST_ENTRY
ListRemoveEntry(
	PLIST_ENTRY ListEntry
	)
/*++


	˫ѭƳָ


	ListEntry -- ָ롣

ֵ
	Ƴָ롣

ʾ
	˫ѭƾڣҪƳһʱ
	ֻҪָ뼴ɲ

--*/
{
	ListEntry->Next->Prev = ListEntry->Prev;
	ListEntry->Prev->Next = ListEntry->Next;
	
	ListEntry->Next = NULL;
	ListEntry->Prev = NULL;

	return ListEntry;
}

PLIST_ENTRY
ListInsertBefore(
	PLIST_ENTRY Pos,
	PLIST_ENTRY ListEntry
	)
/*++


	˫ѭָǰһ


	Pos -- ڴǰһ
	ListEntry -- ָ롣

ֵ
	ָ롣

--*/
{
	ListEntry->Next = Pos;
	ListEntry->Prev = Pos->Prev;
	Pos->Prev->Next = ListEntry;
	Pos->Prev = ListEntry;

	return ListEntry;
}

PLIST_ENTRY
ListInsertAfter(
	PLIST_ENTRY Pos,
	PLIST_ENTRY ListEntry
	)
/*++


	˫ѭָĺһ


	Pos -- ڴһ
	ListEntry -- ָ롣

ֵ
	ָ롣

--*/
{
	return ListInsertBefore(Pos->Next, ListEntry);
}

PLIST_ENTRY
ListInsertHead(
	PLIST_ENTRY ListHead,
	PLIST_ENTRY ListEntry
	)
/*++


	˫ѭĿʼһҲͷĺһ


	ListHead -- ͷָ롣
	ListEntry -- ָ롣

ֵ
	ָ롣

--*/
{
	return ListInsertAfter(ListHead, ListEntry);
}

PLIST_ENTRY
ListInsertTail(
	PLIST_ENTRY ListHead,
	PLIST_ENTRY ListEntry
	)
/*++


	˫ѭĩβһҲͷǰһ


	ListHead -- ͷָ롣
	ListEntry -- ָ롣

ֵ
	ָ롣

--*/
{
	return ListInsertBefore(ListHead, ListEntry);
}

//////////////////////////////////////////////////////////////////////////
//
// 
//

PSINGLE_LIST_ENTRY
SListInitializeHead(
	PSINGLE_LIST_ENTRY ListHead
	)
/*++


	ʼıͷҲǽʼΪա


	ListHead -- ͷָ롣

ֵ
	ʼϵͷָ롣

--*/
{
	ListHead->Next = NULL;

	return ListHead;
}

PSINGLE_LIST_ENTRY
SListPopEntry(
	PSINGLE_LIST_ENTRY ListHead
	)
/*++


	Ƴĵһ


	ListHead -- ͷָ롣

ֵ
	Ƴָ롣

--*/
{
	//
	// ĵһͷָһͷ
	//
    PSINGLE_LIST_ENTRY ListEntry = ListHead->Next;
    
	if (ListEntry != NULL) {
        ListHead->Next = ListEntry->Next;
		ListEntry->Next = NULL;
	}
	
	return ListEntry;
}

PSINGLE_LIST_ENTRY
SListPushEntry(
	PSINGLE_LIST_ENTRY ListHead,
	PSINGLE_LIST_ENTRY ListEntry
	)
/*++


	ڵĿʼһҲͷĺһ


	ListHead -- ͷָ롣
	ListEntry -- ָ롣

ֵ
	ָ롣

--*/
{
	ListEntry->Next = ListHead->Next;
	ListHead->Next = ListEntry;

	return ListEntry;
}
