/***

Copyright (c) 2008 ӢʱƼ޹˾Ȩ

ֻ EOS ԴЭ飨μ License.txtеʹЩ롣
ܣʹЩ롣

ļ: mempool.c

: ڴģʵ֡



*******************************************************************************/

#include "mi.h"

//
// еڴṹ塣
//
typedef struct _MEM_BLOCK {
	USHORT K;
	USHORT Tag;
	ULONG Number;
	LIST_ENTRY ListEntry;					
}MEM_BLOCK, *PMEM_BLOCK;

VOID
PoolInitialize(
	IN PMEM_POOL Pool
	)
/*++


	ʼڴؽṹ壬ʼڴǿյġ


	Pool -- Ŀڴؽṹָ롣

ֵ
	ޡ

--*/
{
	INT i;

	ASSERT(NULL != Pool);
	
	//
	// ʼ顣
	//
	for(i = 0; i < 32; i++) {
		ListInitializeHead(&Pool->FreeListHeads[i]);
	}
}

STATUS
PoolCommitMemory(
	IN PMEM_POOL Pool,
	IN PVOID Address,
	IN SIZE_T Size
	)
/*++


	ύڴڴйܷ䡣


	Pool -- ڴؽṹָ롣
	Address -- ύйܵڴĻַ
	Size -- ύйڴĴС

ֵ
	ύڴЧ򷵻STATUS_SUCCESSʧܡ

--*/
{
	ULONG k;
	PMEM_BLOCK Block;

	ASSERT(NULL != Pool);

	//
	// ύڴйܵڴ8ֽڶġ
	//
	ASSERT(NULL != Address && IS_ALIGNED_TO_SIZE(Address, sizeof(QUAD)));
	ASSERT(0 != Size && IS_ALIGNED_TO_SIZE(Size, sizeof(QUAD)));

	//
	// ύĴСҪһMEM_BLOCKҲ
	//
	if (Size < sizeof(MEM_BLOCK) || Address + Size - 1 < Address) {
		return STATUS_INVALID_PARAMETER;
	}

	//
	// ύڴ治һ2^kСݹ齫֮Ϊ2^kСĿ飬Ӧ
	// 14MBڴԻΪ8MB4MB1MB1MB4顣
	//
	Block = (PMEM_BLOCK)Address;
	while(Size >= sizeof(MEM_BLOCK)) {

		//
		// ָһСΪ2^kĿ鲢жkk㣺2^k <= Size < 2^(k+1)
		//
		BitScanReverse(&k, Size);
		Block->K = (USHORT)k;
		Block->Tag = 0;
		Block->Number = 1;
		ListInsertTail(&Pool->FreeListHeads[k], &Block->ListEntry);

		//
		// ʣµĲֵָ
		//
		Block = (PMEM_BLOCK)((ULONG_PTR)Block + (1 << k));
		Size = Size - (1 << k);
	}

	return STATUS_SUCCESS;
}

PVOID
PoolAllocateMemory(
	IN PMEM_POOL Pool,
	IN OUT PSIZE_T Size
	)
/*++


	ڴзһСΪSizeڴ档


	Pool -- ڴָ롣
	Size -- ĴСʱʵʷĴСʵʷ
			СڵСʵٷ8ֽڣֵΪ0

ֵ
	ʧ򷵻NULL򷵻ڴַ4ֽڵַ룩

--*/
{
	ULONG k, i;
	SIZE_T AllocSize;
	PLIST_ENTRY ListEntry;
	PMEM_BLOCK Block;
	PMEM_BLOCK BuddyBlock;

	ASSERT(NULL != Pool);
	ASSERT(NULL != Size);

	//
	// ӦĴССsizeof(LIST_ENTRY)
	//
	if (*Size <= sizeof(LIST_ENTRY)) {
		AllocSize = sizeof(MEM_BLOCK);
	} else {
		AllocSize =  sizeof(MEM_BLOCK) - sizeof(LIST_ENTRY) + *Size;
	}

	BitScanReverse(&k, AllocSize); // 㣺2^k <= AllocSize < 2^(k+1)kֵ

	if (!IS_POWER_OF_2(AllocSize)) {
		k++; // ʹ2^k >= AllocSize 
	}
	
	AllocSize = 1 << k; // BlockSize϶С2

	//
	// ҿġǿյġп򷵻NULL
	//
	for (i = k; i < 32; i++) {
		if (!ListIsEmpty(&Pool->FreeListHeads[i])) {

			//
			// ӿпײȡһп顣
			//
			ListEntry = ListRemoveHead(&Pool->FreeListHeads[i]);
			Block = CONTAINING_RECORD(ListEntry, MEM_BLOCK, ListEntry);

			//
			// Կпеֱ֣СպΪֹ
			// һ2^4飬ֻ2^6飬ԲΪ12^522^4飬
			// 2^512^4ӦĿһ2^4䡣
			//
			while (i-- > k) {

				Block->Number <<= 1; // ÿԷһαų2൱ڶĽڵID

				//
				// ߵַһΪ飬ӦĿпС
				//
				BuddyBlock = (PMEM_BLOCK)((ULONG_PTR)Block + (1 << i));
				BuddyBlock->Number = Block->Number + 1; // ֵܽڵIDֵܴ1
				BuddyBlock->K = (USHORT)i;
				BuddyBlock->Tag = 0;

				ListInsertTail(&Pool->FreeListHeads[i], &BuddyBlock->ListEntry);
			}

			//
			// ¼KTagTag0ʾռãΪkֵ
			//
			Block->K = (USHORT)k;
			Block->Tag = (USHORT)k;

			//
			// طڴĵַListEntryʼKTagNumberǶ⿪
			// ܱʹãͷŻڴʱҪʹЩ
			//
			*Size = AllocSize - (SIZE_T)&((PMEM_BLOCK)0)->ListEntry;
			return (PVOID)&Block->ListEntry;
		}
	}

	return NULL;
}

STATUS
PoolFreeMemory(
	IN PMEM_POOL Pool,
	IN PVOID Address
	)
/*++


	ͷŴڴзڴ顣


	Pool -- ڴؽṹָ롣
	Address -- ͷŵڴĵַ

ֵ
	ɹ򷵻STATUS_SUCCESS򷵻STATUS_MEMORY_NOT_ALLOCATED

--*/
{
	PLIST_ENTRY ListEntry;
	PMEM_BLOCK Block;
	PMEM_BLOCK BuddyBlock;
	PMEM_BLOCK MergedBlock;

	ASSERT(NULL != Pool);
	ASSERT(NULL != Address);

	//
	// ݵַMEM_BLOCKṹַTagȷһЧѷ顣
	//
	Block = CONTAINING_RECORD(Address, MEM_BLOCK, ListEntry);

	if (Block->Tag != Block->K || 0 == Block->K || Block->K > 31) {
		return STATUS_MEMORY_NOT_ALLOCATED;
	}

	//
	// ǿп顣
	//
	Block->Tag = 0;

	//
	// ıŴ1˵ܴڿл飬ϲ
	//
	while(Block->Number > 1) {

		//
		// Ϊлһ࣬һҲࡣ
		//
		if(Block->Number & 1) {
			BuddyBlock = (PMEM_BLOCK)((ULONG_PTR)Block - (1 << Block->K));
			MergedBlock = BuddyBlock;
		} else {
			BuddyBlock = (PMEM_BLOCK)((ULONG_PTR)Block + (1 << Block->K));
			MergedBlock = Block;
		}

		//
		// ֮ıӦ1ҴСͬ˵ڻ(鱻)
		//
		if ((Block->Number ^ BuddyBlock->Number) != 1 || Block->K != BuddyBlock->K ) {
			break;
		}

		//
		// ڵУͬܺϲ
		//
		if(0 != BuddyBlock->Tag) {
			break;
		}
		
		//
		// лӿпȡ
		//
		ListRemoveEntry(&BuddyBlock->ListEntry);
		
		//
		// úϲĴСͱš
		//
		MergedBlock->K += 1;
		MergedBlock->Number >>= 1;

		//
		// ϲĿпȻплڣеϲ
		//
		Block = MergedBlock;
	}

	//
	// пӦĿС
	//
	ListInsertTail(&Pool->FreeListHeads[Block->K], &Block->ListEntry);
	
	return STATUS_SUCCESS;
}
