/***

Copyright (c) 2008 ӢʱƼ޹˾Ȩ

ֻ EOS ԴЭ飨μ License.txtеʹЩ롣
ܣʹЩ롣

ļ: mutex.c

: ֮ͬźʵ֡



*******************************************************************************/

#include "psp.h"


VOID
PsInitializeMutex(
	IN PMUTEX Mutex,
	IN BOOL InitialOwner
	)
/*++


	ʼźṹ塣


	Mutex -- źṹָ롣
	InitialOwner -- źĳʼӵ̵ָ߳롣

ֵ
	ޡ

--*/
{
	ASSERT(KeGetIntNesting() == 0);

	if (InitialOwner) {
		Mutex->OwnerThread = PspCurrentThread;
		Mutex->RecursionCount = 1;
	} else {
		Mutex->OwnerThread = NULL;
		Mutex->RecursionCount = 0;
	}

	ListInitializeHead(&Mutex->WaitListHead);
}

STATUS
PsWaitForMutex(
	IN PMUTEX Mutex,
	IN ULONG Milliseconds
	)
/*++


	ȴźP


	Mutex -- źṹָ롣
	Milliseconds -- ȴʱޣλ롣ȴʱ򷵻 STATUS_TIMEOUT
		Ϊ INFINIT õȴֱɹ

ֵ
	STATUS_SUCCESS -- ȴɹ
	STATUS_TIMEOUT -- ȴʱ

--*/
{
	STATUS Status;
	BOOL IntState = KeEnableInterrupts(FALSE);

	ASSERT(KeGetIntNesting() == 0);

	//
	//  MUTEX ǿеģӵΪǰ̲߳ݹΪ 1
	// ǰ̱߳ MUTEX ӵߣ MUTEX ĵݹ
	//  MUTEX ߳ռУ򽫵ǰ̼߳뵽 MUTEX ĵȴС
	//
	if (NULL == Mutex->OwnerThread) {

		Mutex->OwnerThread = PspCurrentThread;
		Mutex->RecursionCount = 1;
		Status = STATUS_SUCCESS;

	} else if (PspCurrentThread == Mutex->OwnerThread) {

		Mutex->RecursionCount++;
		Status = STATUS_SUCCESS;

	} else {

		Status = PspWait(&Mutex->WaitListHead, Milliseconds);
	}

	KeEnableInterrupts(IntState);

	return Status;
}

STATUS
PsReleaseMutex(
	IN PMUTEX Mutex
	)
/*++


	ͷŻźע⣺ͷŻẕ́߳ǻźӵ̡߳


	Mutex -- źṹָ롣

ֵ
	STATUS_SUCCESS -- Releaseɹ
	STATUS_MUTEX_NOT_OWNED -- ǰ̷߳ǻźӵߡ

--*/
{
	STATUS Status;
	BOOL IntState = KeEnableInterrupts(FALSE);

	ASSERT(KeGetIntNesting() == 0);

	if (PspCurrentThread == Mutex->OwnerThread) {

		//
		// СݹΪ0ͷŻź
		//
		if (0 == --Mutex->RecursionCount) {

			//
			// һȴûẓ֮́߳Ϊźӵ̡߳
			//
			Mutex->OwnerThread = PspWakeThread(&Mutex->WaitListHead, STATUS_SUCCESS);

			if(NULL != Mutex->OwnerThread) {

				Mutex->RecursionCount = 1;

				//
				// ̱߳ѣ̵ִ߳ȡ
				//
				PspThreadSchedule();
			}
		}

		Status = STATUS_SUCCESS;

	} else {

		Status = STATUS_MUTEX_NOT_OWNED;
	}

	KeEnableInterrupts(IntState);

	return Status;
}

//////////////////////////////////////////////////////////////////////////
//
// ǺͻźصĴ롣
//

//
// źָ롣
//
POBJECT_TYPE PspMutexType = NULL;

VOID
PspCreateMutexObjectType(
	VOID
	)
/*++


	ź͡


	ޡ

ֵ
	ޡ

--*/
{
	STATUS Status;
	OBJECT_TYPE_INITIALIZER Initializer;

	Initializer.Create = (OB_CREATE_METHOD)PsInitializeMutex;
	Initializer.Delete = NULL;
	Initializer.Wait = (OB_WAIT_METHOD)PsWaitForMutex;
	Initializer.Read = NULL;
	Initializer.Write = NULL;

	Status = ObCreateObjectType("MUTEX", &Initializer, &PspMutexType);

	if (!EOS_SUCCESS(Status)) {
		KeBugCheck("Failed to create mutex object type!");
	}
}

STATUS
PsCreateMutexObject(
	IN BOOL InitialOwner,
	IN PCSTR MutexName,
	OUT PHANDLE MutexHandle
	)
/*++


	ź


	InitialOwner -- ΪTRUEʼǰ߳Ϊ´źӵߡ
	MutexName -- ַָ룬ΪNULL򴴽һ󣬷ԴѴڵ
		󲻴򴴽һµ
	MutexHandle -- ´򿪵Ļź

ֵ
	ɹ򷵻STATUS_SUCCESS

--*/
{
	STATUS Status;
	PVOID MutexObject;

	//
	// MUTEX
	//
	Status = ObCreateObject( PspMutexType,
							 MutexName,
							 sizeof(MUTEX),
							 InitialOwner,
							 &MutexObject );

	if (!EOS_SUCCESS(Status)) {
		return Status;
	}

	Status = ObCreateHandle(MutexObject, MutexHandle);

	if (!EOS_SUCCESS(Status)) {
		ObDerefObject(MutexObject);
	}
		
	return Status;
}

STATUS
PsReleaseMutexObject(
	IN HANDLE Handle
	)
/*++


	ͷŻź


	Handle -- źľ

ֵ
	STATUS_SUCCESS -- Releaseɹ
	STATUS_INVALID_HANDLE -- һЧĻź
	STATUS_MUTEX_NOT_OWNED -- ǰ̷߳ǻźӵߡ

--*/
{
	STATUS Status;
	PMUTEX Mutex;

	//
	// ¼õָ롣
	//
	Status = ObRefObjectByHandle(Handle, PspMutexType, (PVOID*)&Mutex);

	if (EOS_SUCCESS(Status)) {

		PsReleaseMutex(Mutex);

		//
		// رնָ롣
		//
		ObDerefObject(Mutex);
	}

	return Status;
}
