/***

Copyright (c) 2008 ӢʱƼ޹˾Ȩ

ֻ EOS ԴЭ飨μ License.txtеʹЩ롣
ܣʹЩ롣

ļ: ob.h

: ӿͷļ



*******************************************************************************/

#ifndef _OB_
#define _OB_

#include "eosdef.h"

#define OB_WAIT_ACCESS		0x00000001
#define OB_READ_ACCESS		0x00000002
#define OB_WRITE_ACCESS		0x00000004

//
// ָ
//
typedef struct _OBJECT_TYPE *POBJECT_TYPE;

//
// ָ
//
typedef struct _HANDLE_TABLE *PHANDLE_TABLE;

//
// ͵鷽Ľӿڶ塣
//
typedef
VOID
(*OB_CREATE_METHOD)(
	IN PVOID Object,
	IN ULONG_PTR Param
	);

typedef
VOID
(*OB_DELETE_METHOD)(
	IN PVOID Object
	);

typedef
STATUS
(*OB_WAIT_METHOD)(
	IN PVOID Object,
	IN ULONG Milliseconds
	);

typedef 
STATUS
(*OB_READ_METHOD)(
	IN PVOID Object,
	OUT PVOID Buffer,
	IN ULONG NumberOfBytesToRead,
	OUT PULONG NumberOfBytesRead
	);

typedef
STATUS
(*OB_WRITE_METHOD)(
	IN PVOID Object,
	IN PVOID Buffer,
	IN ULONG NumberOfBytesToWrite,
	OUT PULONG NumberOfBytesWritten
	);

//
// ͳʼĲṹ塣
//
typedef struct _OBJECT_TYPE_INITIALIZER {
	OB_CREATE_METHOD Create;
	OB_DELETE_METHOD Delete;
	OB_WAIT_METHOD Wait;
	OB_READ_METHOD Read;
	OB_WRITE_METHOD Write;
}OBJECT_TYPE_INITIALIZER, *POBJECT_TYPE_INITIALIZER;

//
// ʼģһ
//
VOID
ObInitializeSystem1(
	VOID
	);

//
// ʼģڶ
//
VOID
ObInitializeSystem2(
	VOID
	);

//
// һ͡
//
STATUS
ObCreateObjectType(
	IN PCSTR TypeName,
	IN POBJECT_TYPE_INITIALIZER Initializer,
	OUT POBJECT_TYPE *ObjectType
	);

//
// һָ͵Ķ
//
STATUS
ObCreateObject(
	IN POBJECT_TYPE ObjectType,
	IN PCSTR ObjectName,
	IN SIZE_T ObjectBodySize,
	IN ULONG_PTR CreateParam,
	OUT PVOID *Object
	);

//
// õID
//
ULONG
ObGetObjectId(
	IN PVOID Object
	);

//
// һݶá
//
VOID
ObRefObject(
	IN PVOID Object
	);

//
// ɶƺ͵õһá
//
STATUS
ObRefObjectByName(
	IN PCSTR ObjectName,
	IN POBJECT_TYPE ObjectType,
	OUT PVOID *Object
	);

//
// ɶIdõһá
//
STATUS
ObRefObjectById(
	IN ULONG Id,
	IN POBJECT_TYPE ObjectType OPTIONAL,
	OUT PVOID *Object
	);

//
// ͷŶһá
//
VOID
ObDerefObject(
	IN PVOID Object
	);

//
// õЧ롣
//
ULONG
ObGetAccessMask(
	IN PVOID Object
	);

//
// һ
//
PHANDLE_TABLE
ObAllocateHandleTable(
	VOID
	);

//
// ͷž
//
VOID
ObFreeHandleTable(
	IN PHANDLE_TABLE ObjectTable
	);

//
// ھзһվ
//
STATUS
ObAllocateHandleEx(
	IN PHANDLE_TABLE ObjectTable,
	OUT PHANDLE Handle
	);

//
// ͷſվ
//
STATUS
ObFreeHandleEx(
	IN PHANDLE_TABLE ObjectTable,
	IN HANDLE Handle
	);

//
// ÿվֵ
//
STATUS
ObSetHandleValueEx(
	IN PHANDLE_TABLE ObjectTable,
	IN HANDLE Handle,
	IN PVOID Object
	);

//
// ڵǰ̵ľΪ󴴽һ
//
STATUS
ObCreateHandle(
	IN PVOID Object,
	OUT PHANDLE Handle
	);

//
// ָΪ󴴽һ
//
STATUS
ObCreateHandleEx(
	IN PHANDLE_TABLE ObjectTable,
	IN PVOID Object,
	OUT PHANDLE Handle
	);

//
// õڵǰ̾һá
//
STATUS
ObRefObjectByHandle(
	IN HANDLE Handle,
	IN POBJECT_TYPE ObjectType OPTIONAL,
	OUT PVOID *Object
	);

//
// õָһá
//
STATUS
ObRefObjectByHandleEx(
	IN PHANDLE_TABLE ObjectTable,
	IN HANDLE Handle,
	IN POBJECT_TYPE ObjectType OPTIONAL,
	OUT PVOID *Object
	);

//
// رյǰ̾еĶ
//
STATUS
ObCloseHandle(
	IN HANDLE Handle
	);

//
// رָеĶ
//
STATUS
ObCloseHandleEx(
	IN PHANDLE_TABLE ObjectTable,
	IN HANDLE Handle
	);

//
// öWait麯
//
STATUS
ObWaitForObject(
	IN HANDLE Handle,
	IN ULONG Milliseconds
	);

//
// öRead麯
//
STATUS
ObRead(
	IN HANDLE Handle,
	IN PVOID Buffer,
	IN ULONG NumberOfBytesToRead,
	OUT PULONG NumberOfBytesRead
	);

//
// öWrite麯
//
STATUS
ObWrite(
	IN HANDLE Handle,
	IN PVOID Buffer,
	IN ULONG NumberOfBytesToWrite,
	OUT PULONG NumberOfBytesWritten
	);

#endif // _OB_
