/***

Copyright (c) 2008 ӢʱƼ޹˾Ȩ

ֻ EOS ԴЭ飨μ License.txtеʹЩ롣
ܣʹЩ롣

ļ: pas.c

: ̵ַռĴɾл



*******************************************************************************/

#include "mi.h"

//
// ϵͳ̵ַռ䡣
//
MMPAS MiSystemPas;

//
// ǰ̵ַռ 
//
volatile PMMPAS MiCurrentPas = &MiSystemPas;

VOID
MiInitializeSystemPas(
	VOID
	)
/*++


	ʼϵͳ̵ַռ䡣
	ϵͳ̵ַռУMI_SYSTEM_VM_BASEʼɽڴ䣬С
	Ϊڴ1/4󲻳512MB4MBȡλн̵ַ
	䶼ϵͳַռУΪʹҳĿ¼ӳ乲ϵͳַռ
	ҳĿ¼һ£ȫװҳڷ䡢ڴʱҳ
	Ķ̬װжء


	ޡ

ֵ
	ޡ

--*/
{
	ULONG_PTR n;
	ULONG_PTR pfn;
	ULONG_PTR vpn;

	//
	// ϵͳַռҳ
	//
	n = (MiTotalPageFrameCount + 4095) / 4096;

	if (n > 128) {
		n = 128;
	}

	//
	// ʼɷڴַռ
	//
	MiInitializeVadList( &MiSystemPas.VadList,
						 MI_SYSTEM_VM_BASE,
						 MI_SYSTEM_VM_BASE + (n << PDI_SHIFT) - 1);

	//
	// Ϊɷڴȫװҳ
	//
	vpn = MI_VA_TO_VPN(MI_SYSTEM_VM_BASE);

	for (; n > 0; n--) {

		MiAllocateZeroedPages(1, &pfn);
		MiMapPageTable(vpn, pfn);

		//
		// һҳĿ¼ (1 << PDI_BITS) ҳĿ¼
		//
		vpn += 1 << PDI_BITS;
	}

	MiSystemPas.PfnOfPageDirectory = MiGetPdeAddressByVa(PTE_BASE)->u.Hard.PageFrameNumber;
	MiSystemPas.PfnOfPteCounter = 0;
}

PMMPAS
MmGetSystemProcessAddressSpace(
	VOID
	)
/*++


	õϵͳ̵ַռ䡣


	ޡ

ֵ
	ϵͳ̵ַռָ롣

--*/
{
	return &MiSystemPas;
}

PMMPAS
MmCreateProcessAddressSpace(
	VOID
	)
/*++


	һ̵ַռ䡣


	ޡ

ֵ
	ɹ򷵻´Ľ̵ַռṹָ룬򷵻NULL

--*/
{
	PMMPAS Pas;
	PMMPTE PageDirectory;
	ULONG_PTR PfnArray[2];
	ULONG_PTR i;

	//
	// ϵͳڴзMMPASṹ塣
	//
	Pas = (PMMPAS)MmAllocateSystemPool(sizeof(MMPAS));

	if (NULL == Pas) {
		return NULL;
	}

	//
	// ҳ򣬷ֱҳĿ¼PTEݿ⡣
	//
	if (!EOS_SUCCESS(MiAllocateZeroedPages(2, PfnArray))) {

		MmFreeSystemPool(Pas);

		return NULL;
	}

	//
	// ʼɷڴַռ
	//
	MiInitializeVadList( &Pas->VadList,
						 MM_LOWEST_USER_ADDRESS,
						 MM_HIGHEST_USER_ADDRESS );

	Pas->PfnOfPageDirectory = PfnArray[0];
	Pas->PfnOfPteCounter = PfnArray[1];

	//
	// ҳĿ¼ӳ䵽ϵͳPTEԶ֮гʼ
	//
	PageDirectory = (PMMPTE)MiMapPageToSystemPte(Pas->PfnOfPageDirectory);

	//
	// ʹ̹ϵͳַռ䣬ӳϵͳַռҳĿ¼
	//
	for (i = ((ULONG_PTR)MM_SYSTEM_RANGE_START >> PDI_SHIFT); i <= (MAXULONG_PTR >> PDI_SHIFT); i++) {
		PageDirectory[i] = PDE_BASE[i];
	}
	
	//
	// ҳĿ¼Ҳһҳӳ̵ҳPTE_BASE
	//
	PageDirectory[(ULONG_PTR)PTE_BASE >> PDI_SHIFT].u.Long = 0;
	PageDirectory[(ULONG_PTR)PTE_BASE >> PDI_SHIFT].u.Hard.PageFrameNumber = Pas->PfnOfPageDirectory;
	PageDirectory[(ULONG_PTR)PTE_BASE >> PDI_SHIFT].u.Hard.Writable = 1;
	PageDirectory[(ULONG_PTR)PTE_BASE >> PDI_SHIFT].u.Hard.Valid = 1;

	//
	// ҳĿ¼ʼϣͷϵͳPTE
	//
	MiFreeSystemPte(PageDirectory);

	return Pas;
}

VOID
MmDeleteProcessAddressSpace(
	IN PMMPAS Pas
	)
/*++


	ɾ̵ַռ䡣


	Pas -- ̵ַռṹָ롣

ֵ
	ޡ

ע⣺
	ǰ̵ַռϵͳַռ䲻ԱɾҪɾһ̵ַռ
	ǰַռ䣬Ƚ֮ɾ֮

--*/
{
	BOOL IntState;

	IntState = KeEnableInterrupts(FALSE);

	//
	// ɾǰ̵ַռϵͳַռ䡣
	//
	ASSERT(Pas != MiCurrentPas && Pas != &MiSystemPas);

	//
	// ̵ַռӦñ
	//
	ASSERT(ListIsEmpty(&Pas->VadList.VadListHead));

	//
	// ͷҳĿ¼MMPASṹ塣
	//
	MiFreePages(1, &Pas->PfnOfPageDirectory);
	MiFreePages(1, &Pas->PfnOfPteCounter);

	MmFreeSystemPool(Pas);

	KeEnableInterrupts(IntState);
}

PMMPAS
MmSwapProcessAddressSpace(
	IN PMMPAS NewPas
	)
/*++


	̵ַռ䣬̵ַռѾ򲻽κβһʱ̣
	ֻһ̵ַռ䴦ڻ״ֻ̬н̵ַռ䴦ڻ״̬ʱܶԽ
	ûַռждʡ


	NewPas -- Ľ̵ַռṹָ롣

ֵ
	ޡ

ע⣺
	ֻжϻ±ãΪڽ̻£ǰ̵ĵַռǲ
	ġ

--*/
{
	BOOL IntState;
	PMMPAS OldPas;

	IntState = KeEnableInterrupts(FALSE);

	OldPas = MiCurrentPas;

	if (NewPas != MiCurrentPas) {

		MiSetPageDirectory(NewPas->PfnOfPageDirectory);

		//
		// PTEҳӳPTE_COUNTER_DATABASE
		// ע⣺ϵͳ̵ַռ䲻ʹPTEΪϵͳ̵ַռпɷ
		// ڴҳǹ̶ģж̬İװжء
		//
		if (NewPas != &MiSystemPas) {
			MiMapPage(MI_VA_TO_VPN(PTE_COUNTER_DATABASE), NewPas->PfnOfPteCounter);
		} else {
			MiUnmapPage(MI_VA_TO_VPN(PTE_COUNTER_DATABASE));
		}

		MiCurrentPas = NewPas;
	}

	KeEnableInterrupts(IntState);

	return OldPas;
}
