/***

Copyright (c) 2008 ӢʱƼ޹˾Ȩ

ֻ EOS ԴЭ飨μ License.txtеʹЩ롣
ܣʹЩ롣

ļ: pfnlist.c

: ڴҳķ䡢Լҳ̡߳



*******************************************************************************/

#include "mi.h"

//
// ҳ
//
ULONG_PTR MiTotalPageFrameCount;

//
// ҳͷԼҳ
//
ULONG_PTR MiZeroedPageListHead;
ULONG_PTR MiZeroedPageCount;

//
// ҳͷԼҳ
//
ULONG_PTR MiFreePageListHead;
ULONG_PTR MiFreePageCount;

VOID
MiInitializePfnDatabase(
	PLOADER_PARAMETER_BLOCK LoaderBlock
	)
/*++


	ʼҳݿ⡣
	ҳݿһMMPFNṹ飬Ԫҳһ£±Ϊ
	nMMPFNṹӦҳΪnҳMMPFNṹеPageState˶
	Ӧҳ״̬Ŀǰ״̬ZEROED_PAGEFREE_PAGEBUSY_PAGEṹ
	еNextΪһͬ״̬ҳҳţ͹ͬ״̬ҳ


	LoaderBlock -- زṹָ롣

ֵ
	ޡ

--*/
{
	ULONG_PTR i;

	MiTotalPageFrameCount = LoaderBlock->PhysicalMemorySize / PAGE_SIZE;

	//
	// ʼҳݿ⡣
	// ҳݿһMMPFNṹ飬鳤Ⱥҳһ£±Ϊ
	// nMMPFNṹӦҳΪnҳMMPFNṹеPageState˶
	// Ӧҳ״̬Ŀǰ״̬ZEROED_PAGEFREE_PAGEBUSY_PAGEṹ
	// еNextΪһͬ״̬ҳҳţ͹ͬ״̬ҳ
	//

	//
	// ʼʹҳӦݿ
	//
	for (i = 0; i < LoaderBlock->FirstFreePageFrame; i++) {
		MiGetPfnDatabaseEntry(i)->PageState = BUSY_PAGE;
	}

	//
	// ʼҳӦݿ֮
	//
	MiFreePageListHead = LoaderBlock->FirstFreePageFrame;
	MiFreePageCount = MiTotalPageFrameCount - MiFreePageListHead;

	for (i = MiFreePageListHead; i < MiTotalPageFrameCount; i++) {
		MiGetPfnDatabaseEntry(i)->PageState = FREE_PAGE;
		MiGetPfnDatabaseEntry(i)->Next = i + 1;
	}

	MiGetPfnDatabaseEntry(i - 1)->Next = -1;

	//
	// ҳΪա
	//
	MiZeroedPageListHead = -1;
	MiZeroedPageCount = 0;
}


ULONG_PTR
MiGetAnyPageCount(
	VOID
	)
/*++


	õõĿҳ


	ޡ

ֵ
	ĿǰõĿҳ

--*/
{
	return MiFreePageCount + MiZeroedPageCount;
}

STATUS
MiAllocateAnyPages(
	IN ULONG_PTR NumberOfPages,
	OUT PULONG_PTR PfnArray
	)
/*++


	ҳȴӿҳз䣬ҳٴҳ䡣


	NumberOfPages -- ҳ
	PfnArray -- ָ룬ָҳŵĻ

ֵ
	ɹ򷵻STATUS_SUCCESS򷵻STATUS_NO_MEMORY

--*/
{
	BOOL IntState;
	ULONG_PTR Pfn;
	ULONG_PTR i;

	IntState = KeEnableInterrupts(FALSE);

	if (NumberOfPages <= MiZeroedPageCount + MiFreePageCount) {

		//
		// ȴӿз䡣
		//
		for (i = 0; i < NumberOfPages && MiFreePageCount > 0; i++) {

			Pfn = MiFreePageListHead;
			MiFreePageListHead = MiGetPfnDatabaseEntry(Pfn)->Next;
			MiFreePageCount--;

			MiGetPfnDatabaseEntry(Pfn)->PageState = BUSY_PAGE;

			PfnArray[i] = Pfn;
		}

		//
		// ҳ䡣
		//
		for (; i < NumberOfPages; i++) {

			Pfn = MiZeroedPageListHead;
			MiZeroedPageListHead = MiGetPfnDatabaseEntry(Pfn)->Next;
			MiZeroedPageCount--;

			MiGetPfnDatabaseEntry(Pfn)->PageState = BUSY_PAGE;

			PfnArray[i] = Pfn;
		}
	}

	KeEnableInterrupts(IntState);

	return STATUS_SUCCESS;
}

STATUS
MiAllocateZeroedPages(
	IN ULONG_PTR NumberOfPages,
	OUT PULONG_PTR PfnArray
	)
/*++


	ȴҳз䣬ҳٴӿҳ
	䣨㣩


	NumberOfPages -- ҳ
	PfnArray -- ָ룬ָҳŵĻ

ֵ
	ɹ򷵻STATUS_SUCCESS򷵻STATUS_NO_MEMORY

--*/
{
	BOOL IntState;
	ULONG_PTR Pfn;
	PVOID ZeroBuffer;
	ULONG_PTR i;

	IntState = KeEnableInterrupts(FALSE);

	if (NumberOfPages <= MiZeroedPageCount + MiFreePageCount) {

		//
		// ȴҳ䡣
		//
		for (i = 0; i < NumberOfPages && MiZeroedPageCount > 0; i++) {

			Pfn = MiZeroedPageListHead;
			MiZeroedPageListHead = MiGetPfnDatabaseEntry(Pfn)->Next;
			MiZeroedPageCount--;

			MiGetPfnDatabaseEntry(Pfn)->PageState = BUSY_PAGE;

			PfnArray[i] = Pfn;
		}

		//
		// ҳ㣬ӿҳ䡣
		//
		for (; i < NumberOfPages; i++) {

			Pfn = MiFreePageListHead;
			MiFreePageListHead = MiGetPfnDatabaseEntry(Pfn)->Next;
			MiFreePageCount--;

			MiGetPfnDatabaseEntry(Pfn)->PageState = BUSY_PAGE;

			//
			// ҳӳ䵽ϵͳPTE㡣
			//
			ZeroBuffer = MiMapPageToSystemPte(Pfn);
			memset(ZeroBuffer, 0, PAGE_SIZE);
			MiFreeSystemPte(ZeroBuffer);

			PfnArray[i] = Pfn;
		}
	}

	KeEnableInterrupts(IntState);

	return STATUS_SUCCESS;
}

STATUS
MiFreePages(
	IN ULONG_PTR NumberOfPages,
	IN PULONG_PTR PfnArray
	)
/*++


	ͷҳ档


	NumberOfPages -- ͷŵҳ
	PfnArray -- ָҳŻָ롣

ֵ
	ɹ򷵻STATUS_SUCCESS

--*/
{
	ULONG_PTR Pfn;
	ULONG_PTR i;

	//
	// дյҳȷΪЧʹҳ
	//
	for (i = 0; i < NumberOfPages; i++) {

		Pfn = PfnArray[i];

		if (Pfn >= MiTotalPageFrameCount || MiGetPfnDatabaseEntry(Pfn)->PageState != BUSY_PAGE) {
			ASSERT(FALSE);
			return STATUS_MEMORY_NOT_ALLOCATED;
		}
	}

	//
	// ޸Щҳ״̬ΪУǲҳͷ
	//
	for (i = 0; i < NumberOfPages; i++) {

		Pfn = PfnArray[i];

		MiGetPfnDatabaseEntry(Pfn)->PageState = FREE_PAGE;
		MiGetPfnDatabaseEntry(Pfn)->Next = MiFreePageListHead;
		MiFreePageListHead = Pfn;
	}

	MiFreePageCount += NumberOfPages;
	
	return STATUS_SUCCESS;
}
