/***

Copyright (c) 2008 ӢʱƼ޹˾Ȩ

ֻ EOS ԴЭ飨μ License.txtеʹЩ롣
ܣʹЩ롣

ļ: psp.h

: ̹ģڲͷļ



*******************************************************************************/

#ifndef _PSP_
#define _PSP_

#include "ke.h"
#include "mm.h"
#include "ob.h"
#include "ps.h"
#include "rtl.h"

//
// ̶̶ָ߳롣
//
typedef struct _PROCESS *PPROCESS;
typedef struct _THREAD *PTHREAD;

#ifdef _DEBUG

extern void record_task_state(long pid, long new_state, long Tick, const char* fun_name, int line_num);
#define RECORD_TASK_STATE(pid, state, jiffies) record_task_state(pid, state, Tick, __FUNCTION__, __LINE__);

extern volatile INT ThreadSeq;
extern INT MaxTid;

#endif

//
// ̶ṹ (PCB)
//
typedef struct _PROCESS {
	BOOLEAN System;						// Ƿϵͳ
	UCHAR Priority;						// ̵ȼ
	PMMPAS Pas;							// ̵ַռ 
	PHANDLE_TABLE ObjectTable;			// ̵ں˶
	LIST_ENTRY ThreadListHead;			// ߳ͷ
	PTHREAD PrimaryThread;				// ָ߳
	LIST_ENTRY WaitListHead;			// ȴУеȴ̶̽߳ڴ˶еȴ

	PSTR ImageName;						// ӳļ
	PSTR CmdLine;						// в
	PVOID ImageBase;					// ִӳļػַ
	PPROCESS_START_ROUTINE ImageEntry;	// ִӳڵַ

	HANDLE StdInput;
	HANDLE StdOutput;
	HANDLE StdError;

	ULONG ExitCode;						// ˳
} PROCESS;

//
// ̶߳ṹ (TCB)
//
typedef	struct _THREAD {
	PPROCESS Process;					// ָ߳
	LIST_ENTRY ThreadListEntry;			// ̵߳
	UCHAR Priority;						// ߳ȼ
	UCHAR State;						// ̵߳ǰ״̬
	ULONG RemainderTicks;				// ʣʱƬʱƬת
	STATUS WaitStatus;					// ȴĽ״̬
	KTIMER WaitTimer;					// ޵ȴѵļʱ
	LIST_ENTRY StateListEntry;			// ״̬е
	LIST_ENTRY WaitListHead;			// ȴУеȴ̶߳̽߳ڴ˶еȴ

	//
	// Ϊ˽ṹ򵥣EOSûжں˽и뱣̶߳ں״̬Ŀ
	// ǰ߳ûûռջ
	//
	PVOID KernelStack;					// ߳λں˿ռջ
	CONTEXT KernelContext;				// ִ߳ں״̬Ļ״̬

	//
	// ̵̱߳ĵַռִû룬κν̵ĵַռִ
	// ں˴룬Ϊں˴λн̵ַռ乲ϵͳַռС
	//
	PMMPAS AttachedPas;					// ִ߳ں˴ʱ󶨽̵ַռ䡣

	PTHREAD_START_ROUTINE StartAddr;	// ̵߳ںַ
	PVOID Parameter;					// ݸںĲ

	ULONG LastError;					// ߳һεĴ
	ULONG ExitCode;						// ̵߳˳
} THREAD;

//
// ̵߳״̬ (Ready) (Running)ȴ (Waiting) ͽ (Terminated)
// ע⣺Zero ̵߳Ч״̬һ״̬߳״̬תм̬
//
typedef enum _THREAD_STATE {
	Zero,		// 0
	Ready,		// 1
	Running,	// 2
	Waiting,	// 3
	Terminated	// 4
} THREAD_STATE;

#define TS_CREATE 	0	// 
#define TS_READY	1	// ̬
#define TS_RUNNING	2	// ̬
#define TS_WAIT		3	// ̬
#define TS_STOPPED	4	// 

//
// ʱƬתȵʱƬСʱƬʱӵδ
//
#define TICKS_OF_TIME_SLICE		6

//
// ߳ںջС--2 ҳ档
//
#define KERNEL_STACK_SIZE	(PAGE_SIZE * 2)

//
// ̶̡߳͡ 
//
extern POBJECT_TYPE PspProcessType;
extern POBJECT_TYPE PspThreadType;
extern POBJECT_TYPE PspSemaphoreType;
extern POBJECT_TYPE PspMutexType;

extern LIST_ENTRY PspReadyListHeads[32];

//
// ϵͳָ롣
//
extern PPROCESS PspSystemProcess;

//
// ǰָ߳롣
//
extern volatile PTHREAD PspCurrentThread;

//
// ǰ̵ָ
//
#define PspCurrentProcess (PspCurrentThread->Process)


//
// ʹ Zero  Running ߳ת Ready ״̬
//
VOID
PspReadyThread(
	IN PTHREAD Thread
	);

//
// ʹ Ready ߳ת Zero ״̬
//
VOID
PspUnreadyThread(
	IN PTHREAD Thread
	);

//
// ǰ̰߳ FCFS ȴָĵȴУȴʱ䳬 Milliseconds 
// δѣ߳̽ԶѲ STATUS_TIMEOUT
//
STATUS
PspWait(
   IN PLIST_ENTRY WaitListHead,
   IN ULONG Milliseconds
   );

//
// ʹ Waiting ߳ת Zero ״̬
//
VOID
PspUnwaitThread(
	IN PTHREAD Thread
	);

//
//  FCFS ԭָȴеһ̣߳߳̽״̬׼С
// WaitStatus Ϊ߳ڵ PspWait() ʱķֵ
//
PTHREAD
PspWakeThread(
	IN PLIST_ENTRY WaitListHead,
	IN STATUS WaitStatus
	);

//
// ̵ִ߳ȡ
//
VOID
PspThreadSchedule(
	VOID
	);

//
// ǰ̸߳ŵ̵ָĵַռִС
//
VOID
PspThreadAttachProcess(
	IN PPROCESS Process
	);

//
// ӦóĿִӳ
//
STATUS
PspLoadProcessImage(
	IN PPROCESS Process,
	IN PSTR ImageName,
	OUT PVOID *ImageBase,
	OUT PVOID *ImageEntry
	);

//
// û̵
//
ULONG
PspProcessStartup(
	PVOID Parameter
	);

//
// ̻
//
STATUS
PspCreateProcessEnvironment(
	IN UCHAR Priority,
	IN PCSTR ImageName,
	IN PCSTR CmdLine,
	OUT PPROCESS *Process
	);

//
// ɾ̻
//
VOID
PspDeleteProcessEnvironment(
	IN PPROCESS Process
	);

//
// ָĽڴһ̡߳
//
STATUS
PspCreateThread(
	IN PPROCESS Process,
	IN SIZE_T StackSize,
	IN PTHREAD_START_ROUTINE StartAddr,
	IN PVOID ThreadParam,
	IN ULONG CreateFlags,
	OUT PTHREAD *Thread
	);

//
// ʼ̵߳Ļ
//
VOID
PspInitializeThreadContext(
	IN PTHREAD Thread
	);

//
// ̵ָС
//
VOID
PspTerminateProcess(
	IN PPROCESS Process,
	IN ULONG ExitCode
	);

//
// ̵ָ߳С
//
VOID
PspTerminateThread(
	IN PTHREAD Thread,
	IN ULONG ExitCode,
	IN BOOL IsTerminatingProcess
	);

#endif // _PSP_
