/***

Copyright (c) 2008 ӢʱƼ޹˾Ȩ

ֻ EOS ԴЭ飨μ License.txtеʹЩ롣
ܣʹЩ롣

ļ: rbuf.c

: λʵ֡
	  ע⣺ʵδṩκͬƣԻλдʱҪע̼߳Լ߳
	  ϴ֮Ļ⡣



*******************************************************************************/

#include "iop.h"

PRING_BUFFER 
IopCreateRingBuffer(
	ULONG BufferSize
	)
/*++


	λ


	BufferSize - λĴС

ֵ
	ɹ򷵻ػλĽṹָ룬򷵻NULL

--*/
{
	PRING_BUFFER RingBuffer;

	if (BufferSize < 4) {
		BufferSize = 4;
	}

	RingBuffer = (PRING_BUFFER)MmAllocateSystemPool(sizeof(RING_BUFFER) - 4 + BufferSize);

	if (NULL != RingBuffer) {
		RingBuffer->Size = BufferSize;
		RingBuffer->Start = 0;
		RingBuffer->FillCount = 0;
	}

	return RingBuffer;
}

VOID
IopDeleteRingBuffer(
	PRING_BUFFER RingBuffer
	)
/*++


	ɾλ


	RingBuffer - ҪɾĻλĽṹָ롣

ֵ
	ޡ

--*/
{
	MmFreeSystemPool(RingBuffer);
}

ULONG
IopWriteRingBuffer(
	IN PRING_BUFFER RingBuffer,
	IN PVOID Data,
	IN ULONG NumberOfBytesToWrite
	)
/*++


	򻺳дݡ


	RingBuffer - λĽṹָ룻
	Data -- ָ룬ָҪдڴݣ
	NumberOfBytesToWrite -- дݵֽ

ֵ
	ʵд뻺ݵֵֽNumberOfBytesToWriteдǰ
	ռСƣдǰ򷵻0

--*/
{
	ULONG Count;

	for (Count = 0;
		 Count < NumberOfBytesToWrite && RingBuffer->FillCount < RingBuffer->Size;
		 Count++, RingBuffer->FillCount++)
	{
		RingBuffer->Buffer[(RingBuffer->Start + RingBuffer->FillCount) % RingBuffer->Size] = ((PCHAR)Data)[Count];
	}

	return Count;
}

ULONG
IopReadRingBuffer(
	IN PRING_BUFFER RingBuffer,
	OUT PVOID Data,
	IN ULONG NumberOfBytesToRead
	)
/*++


	еݡ


	RingBuffer - λĽṹָ룻
	Data -- ָ룬ָҪŶȡݵڴ棻
	NumberOfBytesToRead -- ݵֽ

ֵ
	ʵʶݵֵֽNumberOfBytesToReadܶǰֽ
	ƣǰ򷵻0

--*/
{
	ULONG Count;

	for (Count = 0;
		 Count < NumberOfBytesToRead && RingBuffer->FillCount > 0;
		 Count++, RingBuffer->FillCount--)
	{
		((PCHAR)Data)[Count] = RingBuffer->Buffer[RingBuffer->Start];
		RingBuffer->Start = (RingBuffer->Start + 1) % RingBuffer->Size;
	}

	return Count;
}
