/***

Copyright (c) 2008 ӢʱƼ޹˾Ȩ

ֻ EOS ԴЭ飨μ License.txtеʹЩ롣
ܣʹЩ롣

ļ: sched.c

: ̵߳ȵʵ֡߳״̬ת



*******************************************************************************/

#include "psp.h"

//
// 32ͷɵ飬ֱӦ0~3132ȼľС
// ±ΪnӦȼΪnľС
//
LIST_ENTRY PspReadyListHeads[32];

//
// 32λλͼ
// λͼĵnλΪ1ȼΪnľзǿա
//
volatile ULONG PspReadyBitmap = 0;

//
// ˯ߵȴ̶߳С
// ̵߳Sleepнеȴ
//
LIST_ENTRY PspSleepingListHead;

//
// ѽ̶߳С
//
LIST_ENTRY PspTerminatedListHead;

//
// ǰ̡߳
//
volatile PTHREAD PspCurrentThread = NULL;


VOID
PspInitSchedulingQueue(
	VOID
	)
/*++


	ʼ̵߳ҪʹõĸֶС


	ޡ

ֵ
	ޡ

--*/
{
	INT i;

	//
	// ʼ32ȼӦ32С
	//
	for(i = 0; i < 32; i++)
		ListInitializeHead(&PspReadyListHeads[i]);

	//
	// ʼ˯ߵȴС
	//
	ListInitializeHead(&PspSleepingListHead);

	//
	// ʼѽ̶߳С
	//
	ListInitializeHead(&PspTerminatedListHead);
}

//
// õǰ̶ָ߳롣
//
PVOID
PsGetCurrentThreadObject(
	VOID
	)
{
	return PspCurrentThread;
}

//
// õǰ̶ָ롣
//
PVOID
PsGetCurrentProcessObject(
	VOID
	)
{
	return PspCurrentProcess;
}

VOID
PspReadyThread(
	PTHREAD Thread
	)
/*++


	ʹ Zero ״̬״̬߳ת״̬


	Thread -- ָ߳롣

ֵ
	ޡ

--*/
{
	ASSERT(NULL != Thread);
	ASSERT(Zero == Thread->State || Running == Thread->State);

	//
	// ̲߳ȼӦľеĶβþλͼжӦλ
	// ̵߳״̬޸Ϊ״̬
	//
	ListInsertTail(&PspReadyListHeads[Thread->Priority], &Thread->StateListEntry);
	BIT_SET(PspReadyBitmap, Thread->Priority);
	Thread->State = Ready;

#ifdef _DEBUG
	RECORD_TASK_STATE(ObGetObjectId(Thread) , TS_READY, Tick);
#endif
}

VOID
PspUnreadyThread(
	PTHREAD Thread
	)
/*++


	ȡ̵߳ľ״̬ʹ߳ת Zero ״̬


	Thread - ǰھ״̵ָ̬߳롣

ֵ
	ޡ

--*/
{
	ASSERT(NULL != Thread && Ready == Thread->State);

	//
	// ̴߳ڵľȡ߳ȼӦľбΪգ
	// λͼжӦλ
	//
	ListRemoveEntry(&Thread->StateListEntry);

	if(ListIsEmpty(&PspReadyListHeads[Thread->Priority])) {
		BIT_CLEAR(PspReadyBitmap, Thread->Priority);
	}

	Thread->State = Zero;
}

PRIVATE
VOID
PspOnWaitTimeout(
	IN ULONG_PTR Param
	)
/*++


	ȴʱʱصѵȴʱ̡߳


	Param -- ȴʱ̵ָ߳루Ҫǿת

ֵ
	

--*/
{
	PspUnwaitThread((PTHREAD)Param);
	PspReadyThread((PTHREAD)Param);
}

STATUS
PspWait(
	IN PLIST_ENTRY WaitListHead,
	IN ULONG Milliseconds
	)
/*++


	ǰ̰߳FCFSԭָĵȴеĶβ߳ȴֱȴʱ
	PspWakeThreadá


	WaitListHead -- ĵȴеָ롣
	Milliseconds -- ޵ȴʱ(λms)ȴʱ䳬ϵͳԶѲ
		STATUS_TIMEOUTΪ0STATUS_TIMEOUTΪINFINIT
		õȴֱPspWakeThreadá

ֵ
	̵߳ȴʱ򷵻STATUS_TIMEOUT򷵻PspWakeThreadĵڶ
	WaitStatus

--*/
{
	ASSERT(0 == KeGetIntNesting());
	ASSERT(Running == PspCurrentThread->State);
	ASSERT(0 != PspReadyBitmap);

	if(0 == Milliseconds) {
		return STATUS_TIMEOUT;
	}

	//
	// ǰ̲߳ȴеĶβ޸߳״̬ΪWaiting
	//
	ListInsertTail(WaitListHead, &PspCurrentThread->StateListEntry);
	PspCurrentThread->State = Waiting;
	
#ifdef _DEBUG
	RECORD_TASK_STATE(ObGetObjectId(PspCurrentThread) , TS_WAIT, Tick);
#endif

	//
	// õȴעһڳʱ̵߳ĵȴʱ
	//
	if (INFINITE != Milliseconds) {

		KeInitializeTimer( &PspCurrentThread->WaitTimer,
						   Milliseconds,
						   PspOnWaitTimeout,
						   (ULONG_PTR)PspCurrentThread );

		KeRegisterTimer(&PspCurrentThread->WaitTimer);

		PspCurrentThread->WaitStatus = STATUS_TIMEOUT;

	} else {

		PspCurrentThread->WaitStatus = STATUS_SUCCESS;
	}

	//
	// ǰ߳̽ȴ״̬ҪóȨȴ̵ִ߳ȡ
	//
	PspThreadSchedule();

	//
	// zzZ...
	//

	//
	// ̱߳ѼִУصȴ״̬롣
	//
	return PspCurrentThread->WaitStatus;
}

VOID
PspUnwaitThread(
	IN PTHREAD Thread
	)
/*++


	ʹڵȴ״̬߳ȴвת Zero ״̬


	Thread -- Ŀ̶ָ߳롣

ֵ
	ޡ

--*/
{
	ASSERT(Waiting == Thread->State);

	//
	// ̴߳ڵȴƳ޸״̬ΪZero
	//
	ListRemoveEntry(&Thread->StateListEntry);
	Thread->State = Zero;

	//
	// ߳ע˵ȴʱעȴʱ
	//
	if (STATUS_TIMEOUT == Thread->WaitStatus) {
		KeUnregisterTimer(&Thread->WaitTimer);
	}
}

PTHREAD
PspWakeThread(
	IN PLIST_ENTRY WaitListHead,
	IN STATUS WaitStatus
	)
/*++


	ָȴеĶ̡߳


	WaitListHead -- ȴָ롣
	WaitStatus -- ̴߳PspWaitصķֵ

ֵ
	ȴΪ򷵻NULL򷵻ر̵ָ߳롣

--*/
{
	PTHREAD Thread;

	if (!ListIsEmpty(WaitListHead)) {

		//
		// ѵȴеĶ̡߳
		//
		Thread = CONTAINING_RECORD(WaitListHead->Next, THREAD, StateListEntry);
		PspUnwaitThread(Thread);
		PspReadyThread(Thread);

		//
		// ̴߳PspWaitصķֵ
		//
		Thread->WaitStatus = WaitStatus;

	} else {

		Thread = NULL;
	}

	return Thread;
}

VOID
PspRoundRobin(
	VOID
	)
/*++


	ʱƬתȺʱжϷ KiIsrTimer á


	ޡ

ֵ
	ޡ

--*/
{
	//
	// ڴӴ룬ʵʱƬת㷨
	//
	
	return;
}

PCONTEXT
PspSelectNextThread(
	VOID
	)
/*++


	̵߳ȺжϷִɺ󣬲̷رже
	̣ǵѡһʵ̼߳Ужϵܼ߳̿У


	ޡ

ֵ
	Ӧ̵ִ߳CPUָ롣

--*/
{
	ULONG HighestPriority;
	SIZE_T StackSize;

	//
	// ɨλͼõǰȼע⣺λͼΪա
	//
	BitScanReverse(&HighestPriority, PspReadyBitmap);

	if (NULL != PspCurrentThread && Running == PspCurrentThread->State) {

		if (0 != PspReadyBitmap && HighestPriority > PspCurrentThread->Priority) {

			//
			// ڱȵǰ߳ȼߵḷ̌߳ǰ߳Ӧȡ
			// Ϊǰ߳Դ״̬Աȼ߳ȺӦ
			// ȼӦľеĶסע⣬ܵ PspReadyThread
			//
			ListInsertHead( &PspReadyListHeads[PspCurrentThread->Priority],
							&PspCurrentThread->StateListEntry );
			BIT_SET(PspReadyBitmap, PspCurrentThread->Priority);
			PspCurrentThread->State = Ready;

#ifdef _DEBUG
			RECORD_TASK_STATE(ObGetObjectId(PspCurrentThread) , TS_READY, Tick);
#endif

		} else {

			//
			// ǰ̼߳С
			// ע⣺жϳִʱܻ˵ǰ̰߳еĵַռ䡣
			//
			MmSwapProcessAddressSpace(PspCurrentThread->AttachedPas);
			return &PspCurrentThread->KernelContext;
		}

	} else if(0 == PspReadyBitmap) {

		//
		// ж̴߳ڷ״̬һеľ̡߳
		//
		ASSERT(FALSE);
		KeBugCheck("No ready thread to run!");
	}

	if (NULL != PspCurrentThread) {

		//
		// ǰ߳̽Լͷ̵߳ںջΪִ߳ʱ
		// ͷԼռõջ
		//
		if (Terminated == PspCurrentThread->State) {

			StackSize = 0;

			MmFreeVirtualMemory( &PspCurrentThread->KernelStack,
								 &StackSize,
								 MEM_RELEASE,
								 TRUE );
		}

		//
		// ȡָ PspCurrentThread ̶߳á
		//
		ObDerefObject(PspCurrentThread);
	}

	//
	// ѡȼߵķǿվеĶ߳Ϊǰ̡߳
	//
	PspCurrentThread = CONTAINING_RECORD(PspReadyListHeads[HighestPriority].Next, THREAD, StateListEntry);
	ObRefObject(PspCurrentThread);

	PspUnreadyThread(PspCurrentThread);
	PspCurrentThread->State = Running;
	
#ifdef _DEBUG
	RECORD_TASK_STATE(ObGetObjectId(PspCurrentThread) , TS_RUNNING, Tick);
#endif

	//
	// ̰߳еĵַռ䡣
	//
	MmSwapProcessAddressSpace(PspCurrentThread->AttachedPas);

	//
	// ̵߳Ļ飬ָ߳С
	//
	return &PspCurrentThread->KernelContext;
}

VOID
PspThreadSchedule(
	VOID
	)
/*++


	̵ִ߳ȡ


	ޡ

ֵ
	ޡ

--*/
{
	ULONG HighestPriority;

	//
	// ע⣬ǰڴжϣжǶȲΪ 0ʲôҲ
	// ΪжϷʱϵͳԶ̵ִ߳ȡ
	//
	if (KeGetIntNesting() == 0) {

		if (Running != PspCurrentThread->State) {

			//
			// ǰ߳Ѿڷ״̵ִ̬߳ȡ
			//
			KeThreadSchedule();

		} else if (0 != PspReadyBitmap) {

			//
			// ɨλͼڱȵǰ߳ȼߵľ̵ִ߳߳ȡ
			//
			BitScanReverse(&HighestPriority, PspReadyBitmap);
			if (HighestPriority > PspCurrentThread->Priority)
				KeThreadSchedule();
		}
	}
}

VOID
PsSleep(
	IN ULONG Milliseconds
	)
/*++


	ǰָֹ߳ͣʱ


	Milliseconds -- ֹͣеʱλ롣
					ע⣬ֵΪ INFINITEǰ߳̽ԶֹͣС

ֵ
	ޡ

--*/
{
	BOOL IntState;

	ASSERT(KeGetIntNesting() == 0);

	IntState = KeEnableInterrupts(FALSE);

	if (0 == Milliseconds) {

		//
		// ͬȼḷ̌߳ǰ߳̽״̵ִ̬߳ȡ
		//
		if (BIT_TEST(PspReadyBitmap, PspCurrentThread->Priority)) {
			PspReadyThread(PspCurrentThread);
			PspThreadSchedule();
		}

	} else {

		//
		// ǰ߳˯߶еȴʱ
		//
		PspWait(&PspSleepingListHead, Milliseconds);
	}

	KeEnableInterrupts(IntState);
}

STATUS
PsSetThreadPriority(
	IN HANDLE Handle,
	IN UCHAR Priority
	)
/*++


	ָ߳ȼע⣺Ŀ߳ȼıܻᴥ̵߳ȡ


	Handle -- Ŀ߳̾
	Priority -- õȼ

ֵ
	ɹ򷵻STATUS_SUCCESS˵Ч

--*/
{
	STATUS Status;
	BOOL IntState;
	PTHREAD Thread;

	ASSERT(Priority <= 31);

	if (Priority > 31) {
		return STATUS_INVALID_PARAMETER;
	}

	Status = ObRefObjectByHandle(Handle, PspThreadType, (PVOID*)&Thread);

	if (!EOS_SUCCESS(Status)) {
		return Status;
	}
	
	IntState = KeEnableInterrupts(FALSE);

	if (Thread->Priority != Priority) {

		//
		// ߳ڸıȼʱڲͬȼӦľ֮Ǩơ
		//
		if (Ready == Thread->State) {

			//
			// ߳뵱ǰȼӦľС
			//
			PspUnreadyThread(Thread);

			Thread->Priority = Priority;

			//
			// ̲߳ȼӦľеĶβ
			//
			PspReadyThread(Thread);

		} else {

			Thread->Priority = Priority;
		}

		//
		// ȼıҪ̵ִ߳ȡ
		//
		PspThreadSchedule();
	}

	KeEnableInterrupts(IntState);

	ObDerefObject(Thread);

	return STATUS_SUCCESS;
}

STATUS
PsGetThreadPriority(
	IN HANDLE Handle,
	OUT PUCHAR Priority
	)
/*++


	ȡ̵ָ߳ȼ


	Handle -- Ŀ߳̾
	Priority -- ̵߳ȼ

ֵ
	ɹ򷵻 STATUS_SUCCESS

--*/
{
	STATUS Status;
	BOOL IntState;
	PTHREAD Thread;

	ASSERT(Priority != NULL);

	Status = ObRefObjectByHandle(Handle, PspThreadType, (PVOID*)&Thread);

	if (!EOS_SUCCESS(Status)) {
		return Status;
	}
	
	IntState = KeEnableInterrupts(FALSE);
	
	//
	// ȡ̵߳ȼ
	//
	*Priority = Thread->Priority;

	KeEnableInterrupts(IntState);

	ObDerefObject(Thread);

	return STATUS_SUCCESS;
}

VOID
PspThreadAttachProcess(
	IN PPROCESS Process
	)
/*++


	ǰ̸̵ָ߳ĵַռִС


	Process -- ̶ָ롣

ֵ
	ޡ

--*/
{
	BOOL IntState;

	IntState = KeEnableInterrupts(FALSE);

	if (PspCurrentThread->AttachedPas != Process->Pas) {

		MmSwapProcessAddressSpace(Process->Pas);

		PspCurrentThread->AttachedPas = Process->Pas;
	}

	KeEnableInterrupts(IntState);
}

#ifdef _DEBUG

/*
һԱڼ¼״̬תĹ켣
*/															
struct task_state_entry
{
	long pid;
	long new_state;
	long Tick;
	char fun_name[64];
	int line_num;
};

#define MAX_TASK_TRANS 1000		// ֱӽֵ޸ĵĸһЩͿԼ¼״̬任Ĺ켣Ҫ趨̫󣬷ᵼ»ƹ켣ڴ治㡣
struct task_state_entry task_trans_table[MAX_TASK_TRANS]; 
long task_trans_count = 0;

void record_task_state(long pid, long new_state, long Tick, const char* fun_name, int line_num)
{
	if(task_trans_count >= MAX_TASK_TRANS)
		return;
		
	task_trans_table[task_trans_count].pid = pid;
	task_trans_table[task_trans_count].new_state = new_state;
	task_trans_table[task_trans_count].Tick = Tick;
	strcpy(task_trans_table[task_trans_count].fun_name, fun_name);
	task_trans_table[task_trans_count].line_num = line_num;
	
	task_trans_count++;
}

#endif
