/***

Copyright (c) 2008 ӢʱƼ޹˾Ȩ

ֻ EOS ԴЭ飨μ License.txtеʹЩ롣
ܣʹЩ롣

ļ: semaphore.c

: ֮ͬ¼źʵ֡



*******************************************************************************/

#include "psp.h"

VOID
PsInitializeSemaphore(
	IN PSEMAPHORE Semaphore,
	IN LONG InitialCount,
	IN LONG MaximumCount
	)
/*++


	ʼźṹ塣


	Semaphore -- Ҫʼźṹָ롣
	InitialCount -- źĳʼֵС 0 Ҳܴ MaximumCount
	MaximumCount -- źֵ 0

ֵ
	ޡ

--*/
{
	ASSERT(InitialCount >= 0 && InitialCount <= MaximumCount && MaximumCount > 0);

	Semaphore->Count = InitialCount;
	Semaphore->MaximumCount = MaximumCount;
	ListInitializeHead(&Semaphore->WaitListHead);
}

STATUS
PsWaitForSemaphore(
	IN PSEMAPHORE Semaphore,
	IN ULONG Milliseconds
	)
/*++


	ź Wait P 


	Semaphore -- Wait ź
	Milliseconds -- ȴʱޣλ롣

ֵ
	STATUS_SUCCESS
	޸źʹֳ֧֮ʱѹܺȴʱӦ÷ STATUS_TIMEOUT

--*/
{
	BOOL IntState;

	ASSERT(KeGetIntNesting() == 0); // жϻ²ܵô˺

	IntState = KeEnableInterrupts(FALSE); // ʼԭӲֹжϡ

	//
	// Ŀǰʵ˱׼¼źֳ֧ʱѹܣ PspWait 
	// ĵڶֵֻ INFINITE
	//
	Semaphore->Count--;
	if (Semaphore->Count < 0) {
		PspWait(&Semaphore->WaitListHead, INFINITE);
	}

	KeEnableInterrupts(IntState); // ԭӲɣָжϡ

	return STATUS_SUCCESS;
}

STATUS
PsReleaseSemaphore(
	IN PSEMAPHORE Semaphore,
	IN LONG ReleaseCount,
	OUT PLONG PreviousCount
	)
/*++


	ź Signal V 


	Semaphore -- Wait ź
	ReleaseCount -- źӵǰֻΪ 1޸źʹ֧֮
					ʱѹܺ󣬴˲ֵܹڵ 1
	PreviousCount -- ź֮ǰֵ

ֵ
	ɹͷź STATUS_SUCCESS

--*/
{
	STATUS Status;
	BOOL IntState;

	IntState = KeEnableInterrupts(FALSE); // ʼԭӲֹжϡ

	if (Semaphore->Count + ReleaseCount > Semaphore->MaximumCount) {

		Status = STATUS_SEMAPHORE_LIMIT_EXCEEDED;

	} else {

		//
		// ¼ǰźֵ
		//
		if (NULL != PreviousCount) {
			*PreviousCount = Semaphore->Count;
		}

		//
		// Ŀǰʵ˱׼¼źÿִһźͷŲ
		// ֻʹźֵ 1
		//
		Semaphore->Count++;
		if (Semaphore->Count <= 0) {
			PspWakeThread(&Semaphore->WaitListHead, STATUS_SUCCESS);
		}

		//
		// ̱߳ѣ̵ִ߳ȡ
		//
		PspThreadSchedule();

		Status = STATUS_SUCCESS;
	}

	KeEnableInterrupts(IntState); // ԭӲɣָжϡ

	return Status;
}

//////////////////////////////////////////////////////////////////////////
//
// ǺźصĴ롣
//

//
// źָ롣
//
POBJECT_TYPE PspSemaphoreType = NULL;

//
// ڳʼ semaphore ṹĲṹ塣
//
typedef struct _SEM_CREATE_PARAM{
	LONG InitialCount;
	LONG MaximumCount;
}SEM_CREATE_PARAM, *PSEM_CREATE_PARAM;

//
// semaphore Ĺ캯ڴ semaphore ʱá
//
VOID
PspOnCreateSemaphoreObject(
	IN PVOID SemaphoreObject,
	IN ULONG_PTR CreateParam
	)
{
	PsInitializeSemaphore( (PSEMAPHORE)SemaphoreObject, 
						   ((PSEM_CREATE_PARAM)CreateParam)->InitialCount,
						   ((PSEM_CREATE_PARAM)CreateParam)->MaximumCount );
}

//
// semaphore ͵ĳʼ
//
VOID
PspCreateSemaphoreObjectType(
	VOID
	)
{
	STATUS Status;
	OBJECT_TYPE_INITIALIZER Initializer;

	Initializer.Create = PspOnCreateSemaphoreObject;
	Initializer.Delete = NULL;
	Initializer.Wait = (OB_WAIT_METHOD)PsWaitForSemaphore;
	Initializer.Read = NULL;
	Initializer.Write = NULL;
	
	Status = ObCreateObjectType("SEMAPHORE", &Initializer, &PspSemaphoreType);

	if (!EOS_SUCCESS(Status)) {
		KeBugCheck("Failed to create semaphore object type!");
	}
}
 
//
// semaphore Ĺ캯
//
STATUS
PsCreateSemaphoreObject(
	IN LONG InitialCount,
	IN LONG MaximumCount,
	IN PSTR Name,
	OUT PHANDLE SemaphoreHandle
	)
{
	STATUS Status;
	PVOID SemaphoreObject;
	SEM_CREATE_PARAM CreateParam;

	if(InitialCount < 0 || MaximumCount <= 0 || InitialCount > MaximumCount){
		return STATUS_INVALID_PARAMETER;
	}

	//
	// ź
	//
	CreateParam.InitialCount = InitialCount;
	CreateParam.MaximumCount = MaximumCount;

	Status = ObCreateObject( PspSemaphoreType,
							 Name,
							 sizeof(SEMAPHORE),
							 (ULONG_PTR)&CreateParam,
							 &SemaphoreObject);

	if (!EOS_SUCCESS(Status)) {
		return Status;
	}

	Status = ObCreateHandle(SemaphoreObject, SemaphoreHandle);

	if (!EOS_SUCCESS(Status)) {
		ObDerefObject(SemaphoreObject);
	}

	return Status;
}

//
// semaphore  signal 
//
STATUS
PsReleaseSemaphoreObject(
	IN HANDLE Handle,
	IN LONG ReleaseCount,
	IN PLONG PreviousCount
	)
{
	STATUS Status;
	PSEMAPHORE Semaphore;

	if (ReleaseCount < 1) {
		return STATUS_INVALID_PARAMETER;
	}

	//  semaphore õ semaphore ָ롣
	Status = ObRefObjectByHandle(Handle, PspSemaphoreType, (PVOID*)&Semaphore);

	if (EOS_SUCCESS(Status)) {
		Status = PsReleaseSemaphore(Semaphore, ReleaseCount, PreviousCount);
		ObDerefObject(Semaphore);
	}

	return Status;
}

