/***

Copyright (c) 2008 ӢʱƼ޹˾Ȩ

ֻ EOS ԴЭ飨μ License.txtеʹЩ롣
ܣʹЩ롣

ļ: serial.c

: ʵ֡
	  ʵ˻ĴͨţṩúͨŴΪʾ
	  ̡



*******************************************************************************/

#include "iop.h"

//
// 豸չ顣
//
typedef struct _SERIAL_DEVICE_EXTENSION {
	PRING_BUFFER SendBuffer;		// ڷݵĻλ
	EVENT CompletionEvent;			// ͻ¼ͻΪʱsignaled״̬

	PRING_BUFFER RecvBuffer;		// ݻ
	EVENT RecvBufferNotEmpty;		// ջǿʱsignaled״̬
	

}SERIAL_DEVICE_EXTENSION, *PSERIAL_DEVICE_EXTENSION;

//
// COM1COM2Ӧ豸ָ룬жϷʹá
//
PDEVICE_OBJECT SrlDevice[2] = {NULL, NULL};

//
// COM1COM2ļĴ˿ڵַĻַ
//
const PUCHAR SrlRegPortBase[2] = {(PUCHAR)0x03F8, (PUCHAR)0x02F8};

//
// 8250ļĴ˿ڵַ(0x3F80x2F8ƫ)
//
#define RBR			0
#define THR			0
#define IER			1
#define IIR			2
#define LCR			3
#define MCR			4
#define LSR			5
#define MSR			6
#define DIVRL		0
#define DIVRH		1

//
// ȡ豸ӦCOM˿ڵļĴַd-豸ָ룬r-RBRTHRȡ
//
#define REG_PORT(d, r) (SrlRegPortBase[(d)->DeviceNumber] + (r))

STATUS
SrlAddDevice(
	IN PDRIVER_OBJECT DriverObject,
	IN PDEVICE_OBJECT NextLayerDevice,
	IN USHORT DeviceNumber,
	OUT PDEVICE_OBJECT *DeviceObject
	);

STATUS
SrlCreate(
	IN PDEVICE_OBJECT DeviceObject,
	IN PCSTR FileName,
	IN ULONG CreationDisposition,
	IN OUT PFILE_OBJECT FileObject
	);

VOID
SrlClose(
	IN PDEVICE_OBJECT DeviceObject,
	IN OUT PFILE_OBJECT FileObject
	);

STATUS
SrlRead(
	IN PDEVICE_OBJECT DeviceObject,
	IN PFILE_OBJECT FileObject,
	OUT PVOID Buffer,
	IN ULONG Request,
	OUT PULONG Result OPTIONAL
	);

STATUS
SrlWrite(
	IN PDEVICE_OBJECT DeviceObject,
	IN PFILE_OBJECT FileObject,
	IN PVOID Buffer,
	IN ULONG Request,
	OUT PULONG Result OPTIONAL
	);

VOID
SrlIsr(
   PDEVICE_OBJECT Device
   );

//
// COM1COM2жϷ
//
VOID
SrlIsrCom1(
	VOID
	)
{
	SrlIsr(SrlDevice[0]);
}

VOID
SrlIsrCom2(
	VOID
	)
{
	SrlIsr(SrlDevice[1]);
}

//
// ʼ
//
VOID
SrlInitializeDriver(
	PDRIVER_OBJECT DriverObject
	)
{
	DriverObject->AddDevice = SrlAddDevice;
	DriverObject->Create = SrlCreate;
	DriverObject->Close = SrlClose;
	DriverObject->Read = SrlRead;
	DriverObject->Write = SrlWrite;
}

//
// AddDeviceܺͷֵοiop.hԴļ
//
STATUS
SrlAddDevice(
	IN PDRIVER_OBJECT DriverObject,
	IN PDEVICE_OBJECT NextLayerDevice,
	IN USHORT DeviceNumber,
	OUT PDEVICE_OBJECT *DeviceObject
	)
{
	STATUS Status;
	CHAR DeviceName[] = "COM1";
	PDEVICE_OBJECT SerialDevice;
	PSERIAL_DEVICE_EXTENSION Ext;

	ASSERT(NULL == NextLayerDevice); // û²豸
	ASSERT(0 == DeviceNumber || 1 == DeviceNumber); // Ŀǰ֧COM1COM2豸
	ASSERT(NULL == SrlDevice[DeviceNumber]);

	//
	// COM1COM2豸ŷֱΪ01豸ֱǡCOM1COM2
	//
	DeviceName[3] += DeviceNumber;

	//
	// ڶӦ豸
	//
	Status = IopCreateDevice( DriverObject,				// ָ
							  sizeof(SERIAL_DEVICE_EXTENSION),	// 豸չĴС
							  DeviceName,				// 豸COM1ΪCOM1COM2ΪCOM2
							  DeviceNumber,				// 豸ţCOM1Ϊ0COM2Ϊ1
							  FALSE,					// ǿ豸
							  &SerialDevice );

	if (EOS_SUCCESS(Status)) {

		SrlDevice[DeviceNumber] = SerialDevice;

		//
		// ʼ豸չ顣
		//
		Ext = (PSERIAL_DEVICE_EXTENSION)SerialDevice->DeviceExtension;
		Ext->SendBuffer = IopCreateRingBuffer(256);				// лʼΪ 256 ֽڡ
		PsInitializeEvent(&Ext->CompletionEvent, FALSE, FALSE);	// ͻ¼ʼΪЧԶ¼

		
		Ext->RecvBuffer = IopCreateRingBuffer(256);				// лʼΪ 256 ֽڡ
		PsInitializeEvent(&Ext->RecvBufferNotEmpty, TRUE, FALSE);	// ջǿ¼ʼΪЧֶ¼


		//
		// ĬͨŲ576008λһֹͣλżУ顣
		//
		WRITE_PORT_UCHAR(REG_PORT(SerialDevice, LCR), 0x80);	// дLCRʹDLAB = 1ȻдĴ
		WRITE_PORT_UCHAR(REG_PORT(SerialDevice, DIVRL), 0x02);	// дĴ8λ
		WRITE_PORT_UCHAR(REG_PORT(SerialDevice, DIVRH), 0);		// дĴ8λĴֵΪ1843200 / (57600 * 16) = 2
		WRITE_PORT_UCHAR(REG_PORT(SerialDevice, LCR), 0x03);	// LCR = 00000011B8λ1ֹͣλżУ顣
		WRITE_PORT_UCHAR(REG_PORT(SerialDevice, MCR), 0x0B);	// OUT2͵ƽжźŷ~DTR~RTSΪͣ
		WRITE_PORT_UCHAR(REG_PORT(SerialDevice, IER), 0x03);	// ͺͽжϡ

		//
		// жϷڵַȡ8259ɱжϿCOMжϵΡ
		//
		if (0 ==DeviceNumber) {
			KeIsrCom1 = SrlIsrCom1;
			KeEnableDeviceInterrupt(INT_COM1, TRUE);
		} else {
			KeIsrCom2 = SrlIsrCom2;
			KeEnableDeviceInterrupt(INT_COM2, TRUE);
		}

		*DeviceObject = SerialDevice;
	}

	return Status;
}

//
// Createͷֵοiop.hԴļ
//
STATUS
SrlCreate(
	IN PDEVICE_OBJECT DeviceObject,
	IN PCSTR FileName,
	IN ULONG CreationDisposition,
	IN OUT PFILE_OBJECT FileObject
	)
{
	BOOL IntState;
	PSERIAL_DEVICE_EXTENSION Ext = (PSERIAL_DEVICE_EXTENSION)DeviceObject->DeviceExtension;
	
	//
	// 豸豸·Ӧǿַ
	//
	if (*FileName != '\0') {
		return STATUS_FILE_NOT_FOUND;
	}

	//
	// ֻʹOPEN_EXISTING־
	//
	if (OPEN_EXISTING != CreationDisposition) {
		return STATUS_INVALID_PARAMETER;
	}

	if (0 == DeviceObject->OpenCount) {

		//
		// 豸ɹر״̬򿪣ɸҪڴӴӦĴ
		//

	}

	//
	// 豸ɹʹļCOM豸
	//
	FileObject->FsContext = DeviceObject;
	return STATUS_SUCCESS;
}

//
// CloseFileͷֵοiop.hԴļ
//
VOID
SrlClose(
	IN PDEVICE_OBJECT DeviceObject,
	IN OUT PFILE_OBJECT FileObject
	)
{
	if (0 == DeviceObject->OpenCount) {

		//
		// 豸ɴ״̬رգɸҪڴӴӦĴ
		//

	}
}

//
// Readܺͷֵοiop.hԴļ
//
STATUS
SrlRead(
	IN PDEVICE_OBJECT DeviceObject,
	IN PFILE_OBJECT FileObject,
	OUT PVOID Buffer,
	IN ULONG Request,
	OUT PULONG Result OPTIONAL
	)
{
	//
	// ڴӶȡ豸Ĵ롣
	//
	return STATUS_NOT_SUPPORTED;
}

//
// Writeܺͷֵοiop.hԴļ
//
STATUS
SrlWrite(
	IN PDEVICE_OBJECT DeviceObject,
	IN PFILE_OBJECT FileObject,
	IN PVOID Buffer,
	IN ULONG Request,
	OUT PULONG Result OPTIONAL
	)
{
	CHAR Data;
	ULONG Count = 0;
	PSERIAL_DEVICE_EXTENSION Ext = (PSERIAL_DEVICE_EXTENSION)DeviceObject->DeviceExtension;

	PsResetEvent(&Ext->CompletionEvent); // λ¼ΪЧ״̬

	while (Count < Request) {

		//
		// ¼Ҫ͵ĵһֽڣҪ͵д뷢ͻ
		// ע⣬ĴСܲһαҪ͵ݣIopWriteRingBuffer
		// ʵд뻺ֽ
		//
		Data = ((PCHAR)Buffer)[Count++];
		Count += IopWriteRingBuffer(Ext->SendBuffer, Buffer + Count, Request - Count);

		//
		// ͹̡
		// ͹̽轫һֽдTHRTHRеݱͳᴥһ
		// THRжϣжϴ̳򽫼ͻеݡݱ
		// жϴCompletionEvent¼ΪЧ
		//
		WRITE_PORT_UCHAR(REG_PORT(DeviceObject, THR), Data);

		//
		// ȴֱݷϡע⣬ȴغ󣬸¼ԶΪЧ״̬
		//
		PsWaitForEvent(&Ext->CompletionEvent, INFINITE);
	}

	*Result = Count;
	return STATUS_SUCCESS;
}

//
// ڵжϷ
//
VOID
SrlIsr(
   PDEVICE_OBJECT Device
   )
{
	CHAR Data;
	PSERIAL_DEVICE_EXTENSION Ext = (PSERIAL_DEVICE_EXTENSION)Device->DeviceExtension;

	//
	// жʶĴȷжԴӦĴ
	//
	if (2 == READ_PORT_UCHAR(REG_PORT(Device, IIR))) {

		//
		// THRգTHRдһҪ͵ֽݡ
		// ͻΪ˵͹̽Ӧ÷¼ΪЧ״̬
		// 򣬴ӷͻжȡһֽݲдTHRз͡
		//
		if (IopIsRingBufferEmpty(Ext->SendBuffer)) {
			PsSetEvent(&Ext->CompletionEvent);
		} else {
			IopReadRingBuffer(Ext->SendBuffer, &Data, 1);
			WRITE_PORT_UCHAR(REG_PORT(Device, THR), Data);
		}

	} else  {

		//
		// RBRȡRBRõյݡ
		//
		Data = READ_PORT_UCHAR(REG_PORT(Device, RBR));

		//
		// ڴӴ룬һжϡ
		//

	}
}

#define MAXSERIALEVENTWAITCOUNT 10
typedef struct _SERIALEVENT
{
	INT WaitObj[MAXSERIALEVENTWAITCOUNT];
	INT Count;	
}SERIALEVENT;

SERIALEVENT COM1SendEvent;
SERIALEVENT COM1RecvEvent;

#ifdef _DEBUG

PRIVATE VOID GetCOM1( )
/*++


	ȡ1Ϣ


	

ֵ
	ޡ

--*/
{
	BOOL IntState;
	PTHREAD pThread;	
	PLIST_ENTRY pWListEntry;
	INT WaitThreadNum = 0;
	INT Size = 0, FillCount = 0;
	
	const char* ThreadState = NULL;
	
	StopKeyboard = 1;	
	IntState = KeEnableInterrupts(FALSE);	// ж
	
	if(SrlDevice[0] != 0)
	{
		if((*(PSERIAL_DEVICE_EXTENSION)(SrlDevice[0]-> DeviceExtension)).SendBuffer != 0 && (*(PSERIAL_DEVICE_EXTENSION)(SrlDevice[0]-> DeviceExtension)).RecvBuffer != 0)
		{
			for(WaitThreadNum = 0,
			pWListEntry = (*(PSERIAL_DEVICE_EXTENSION)(SrlDevice[0]-> DeviceExtension)).CompletionEvent.WaitListHead.Next;
			pWListEntry != NULL
			&& pWListEntry != &((*(PSERIAL_DEVICE_EXTENSION)(SrlDevice[0]-> DeviceExtension)).CompletionEvent.WaitListHead) 
			&& WaitThreadNum < MAXSERIALEVENTWAITCOUNT;
			pWListEntry = pWListEntry->Next, WaitThreadNum++)
			{
				//
				// ̶ָ߳
				//
				pThread = CONTAINING_RECORD(pWListEntry, THREAD, StateListEntry);
				
				COM1SendEvent.WaitObj[WaitThreadNum] = ObGetObjectId(pThread);
			}
			COM1SendEvent.Count = WaitThreadNum;
		
			for(WaitThreadNum = 0,
			pWListEntry = (*(PSERIAL_DEVICE_EXTENSION)(SrlDevice[0]-> DeviceExtension)).RecvBufferNotEmpty.WaitListHead.Next;
			pWListEntry != NULL 
			&& pWListEntry != &((*(PSERIAL_DEVICE_EXTENSION)(SrlDevice[0]-> DeviceExtension)).RecvBufferNotEmpty.WaitListHead) 
			&& WaitThreadNum < MAXSERIALEVENTWAITCOUNT;
			pWListEntry = pWListEntry->Next, WaitThreadNum++)
			{
				//
				// ̶ָ߳
				//
				pThread = CONTAINING_RECORD(pWListEntry, THREAD, StateListEntry);
				
				COM1SendEvent.WaitObj[WaitThreadNum] = ObGetObjectId(pThread);
			}
			COM1RecvEvent.Count = WaitThreadNum;
		}
		
	}
	
			
	KeEnableInterrupts(IntState);	// ж
	StopKeyboard = 0;	
}

#endif
