/***

Copyright (c) 2008 ӢʱƼ޹˾Ȩ

ֻ EOS ԴЭ飨μ License.txtеʹЩ롣
ܣʹЩ롣

ļ: vadlist.c

: ַģ顣



*******************************************************************************/

#include "mi.h"

VOID
MiInitializeVadList(
	IN PMMVAD_LIST VadList, 
	IN PVOID StartingAddress, 
	IN PVOID EndAddress
	)
/*++


	ʼַMMVAD_LIST


	VadList -- ַָ롣
	StartingAddress -- ʼַ
	EndAddress -- ַ

ֵ
	ޡ

--*/
{
	//
	// ȷַΧЧҳ롣
	//
	ASSERT(StartingAddress != NULL && StartingAddress < EndAddress);
	ASSERT(IS_PAGE_ALIGNED(StartingAddress) && IS_PAGE_ALIGNED(EndAddress + 1));

	VadList->StartingVpn = MI_VA_TO_VPN(StartingAddress);
	VadList->EndVpn = MI_VA_TO_VPN(EndAddress);
	ListInitializeHead(&VadList->VadListHead);
}

STATUS
MiReserveAddressRegion(
	IN PMMVAD_LIST VadList,
	IN PVOID BaseAddress,
	IN SIZE_T RegionSize,
	OUT PMMVAD *Vad
	)
/*++


	һַ


	VadList -- ַָ롣
	BaseAddress --ĵַʼַ
	RegionSize -- ĵַĴС
	Vad -- ָ룬ַָָĻ

ֵ
	ɹ򷵻STATUS_SUCCESSʧܡ

--*/
{
	PLIST_ENTRY ListEntry;
	PMMVAD PointerVad;
	ULONG_PTR StartingVpn;
	ULONG_PTR EndVpn;
	ULONG_PTR Size;

	ASSERT(RegionSize != 0 && BaseAddress + RegionSize - 1 >= BaseAddress);

	if (NULL != BaseAddress) {

		StartingVpn = MI_VA_TO_VPN(BaseAddress);
		EndVpn = MI_VA_TO_VPN(BaseAddress + RegionSize - 1);

		if (StartingVpn < VadList->StartingVpn || EndVpn > VadList->EndVpn) {
			return STATUS_INVALID_ADDRESS;
		}

		//
		// ҵĿǰѱP
		//
		for (ListEntry = VadList->VadListHead.Prev;
			ListEntry != &VadList->VadListHead;
			ListEntry = ListEntry->Prev) {

			PointerVad = CONTAINING_RECORD(ListEntry, MMVAD, VadListEntry);
			
			if(PointerVad->EndVpn < StartingVpn) {
				break;
			}
		}

		//
		// P֮ѱĿص򷵻ʧܡ
		//
		ListEntry = ListEntry->Next;

		if(ListEntry != &VadList->VadListHead) {

			PointerVad = CONTAINING_RECORD(ListEntry, MMVAD, VadListEntry);
			
			if (PointerVad->StartingVpn <= EndVpn) {
				return STATUS_INVALID_ADDRESS;
			}
		}

	} else {

		//
		// ӵַռʼҵһСδ
		//
		Size = (RegionSize + PAGE_SIZE - 1) >> PAGE_SHIFT;

		StartingVpn = VadList->StartingVpn;
		EndVpn = StartingVpn + Size - 1;

		if (EndVpn > VadList->EndVpn) {
			return STATUS_NO_MEMORY;
		}

		for (ListEntry = VadList->VadListHead.Next;
			ListEntry != &VadList->VadListHead;
			ListEntry = ListEntry->Next) {

			PointerVad = CONTAINING_RECORD(ListEntry, MMVAD, VadListEntry);

			if (EndVpn < PointerVad->StartingVpn) {
				break;
			}

			//
			// ѱƶ
			//
			StartingVpn = PointerVad->EndVpn + 1;
			EndVpn = StartingVpn + Size - 1;

			//
			// ַΧ߳ռ䷶Χʧܣ
			//
			if (EndVpn > VadList->EndVpn) {
				return STATUS_NO_MEMORY;
			}
		}
	}

	//
	// ϵͳڴзһַṹ塣
	//
	PointerVad = MmAllocateSystemPool(sizeof(MMVAD));

	if (NULL == PointerVad) {
		return STATUS_NO_MEMORY;
	}

	//
	// ַѱС
	//
	PointerVad->StartingVpn = StartingVpn;
	PointerVad->EndVpn = EndVpn;
	ListInsertBefore(ListEntry, &PointerVad->VadListEntry);

	*Vad = PointerVad;
	
	return STATUS_SUCCESS;
}

STATUS
MiFindReservedAddressRegion(
	IN PMMVAD_LIST VadList,
	IN PVOID BaseAddress,
	IN SIZE_T RegionSize,
	OUT PMMVAD *Vad
	)
/*++


	ַָǷѾ


	VadList -- ַָ롣
	BaseAddress -- Ŀʼַ
	RegionSize -- ĿĴСΪ0ʱοBaseAddress
	Vad -- ָ룬ַָָĻ

ֵ
	ɹ򷵻STATUS_SUCCESSʧܡ

--*/
{
	PLIST_ENTRY ListEntry;
	PMMVAD PointerVad;
	ULONG_PTR StartingVpn;
	ULONG_PTR EndVpn;

	ASSERT(0 == RegionSize || BaseAddress + RegionSize - 1 >= BaseAddress);

	StartingVpn = MI_VA_TO_VPN(BaseAddress);

	if (0 == RegionSize) {
		EndVpn = StartingVpn;
	} else {
		EndVpn = MI_VA_TO_VPN(BaseAddress + RegionSize - 1);
	}

	if (VadList->StartingVpn <= StartingVpn && EndVpn <= VadList->EndVpn) {

		for (ListEntry = VadList->VadListHead.Next;
			ListEntry != &VadList->VadListHead;
			ListEntry = ListEntry->Next) {

			PointerVad = CONTAINING_RECORD(ListEntry, MMVAD, VadListEntry);

			if (PointerVad->EndVpn >= EndVpn) {

				if (PointerVad->StartingVpn <= StartingVpn) {

					*Vad = PointerVad;

					return STATUS_SUCCESS;

				} else {

					return STATUS_MEMORY_NOT_ALLOCATED;
				}
			}
		}
	}

	return STATUS_INVALID_ADDRESS;
}

VOID
MiFreeAddressRegion(
	IN PMMVAD_LIST VadList,
	IN PMMVAD Vad
	)
/*++


	ͷűַ


	VadList -- ַָ롣
	Vad -- ַָ롣

ֵ
	ޡ

--*/
{
	ASSERT(NULL != VadList && NULL != Vad);

	ListRemoveEntry(&Vad->VadListEntry);

	MmFreeSystemPool(Vad);
}

VOID
MiCleanAddressRegion(
	IN PMMVAD_LIST VadList
	)
/*++


	VADеѱ򣬽ٵַռʱʹá


	VadList -- VADָ롣

ֵ
	

--*/
{
	PLIST_ENTRY CurrentEntry;
	PLIST_ENTRY NextEntry;

	NextEntry = VadList->VadListHead.Next;

	while (NextEntry != &VadList->VadListHead) {

		CurrentEntry = NextEntry;
		NextEntry = NextEntry->Next;

		ListRemoveEntry(CurrentEntry);
		MmFreeSystemPool(CONTAINING_RECORD(CurrentEntry, MMVAD, VadListEntry));
	}
}
