/***

Copyright (c) 2008 ӢʱƼ޹˾Ȩ

ֻ EOS ԴЭ飨μ License.txtеʹЩ롣
ܣʹЩ롣

ļ: virtual.c

: ڴڴķ䡢յȡ



*******************************************************************************/

#include "mi.h"

PRIVATE STATUS
MiCommitPages(
	IN ULONG_PTR StartingVpn,
	IN ULONG_PTR EndVpn
	);

PRIVATE STATUS
MiDecommitPages(
	IN ULONG_PTR StartingVpn,
	IN ULONG_PTR EndVpn
	);

STATUS
MmAllocateVirtualMemory(
	IN OUT PVOID *BaseAddress,
	IN OUT PSIZE_T RegionSize,
	IN ULONG AllocationType,
	IN BOOL SystemVirtual
	)
/*++


	ڵǰ̵ַռϵͳַռзڴ档


	BaseAddress -- ΪʱύĵַʼַΪ
		ʱʵʱύĵַʼַNULLֵ
		Ϊֵ¶뵽ҳ߽磬ϵͳλãȻ뵽ҳ߽磩
	RegionSize -- ΪʱύڴĴСΪʱ
		ʵʱύڴĴСΪҳС
	AllocationType -- ͣȡֵ
		MEM_RESERVEڽ̵ַռбһַԱʹã
		MEM_COMMITΪѱύڴ棨Ϊַӳڴ棩
		ֵͬʱָMEM_RESERVE | MEM_COMMITڱַͬʱ
		Ϊύڴ档
	SystemVirtual -- Ƿϵͳַռڴ档

ֵ
	ɹ򷵻STATUS_SUCCESSʾʧܡ

--*/
{
	STATUS Status;
	BOOL IntState;
	PMMPAS Pas;
	PMMVAD Vad;
	ULONG_PTR StartingVpn;
	ULONG_PTR EndVpn;

	ASSERT(BaseAddress != NULL && RegionSize != NULL);

	//
	// ȷЧַΧû
	//
	if (0 == *RegionSize || *BaseAddress + *RegionSize - 1 < *BaseAddress) {
		return STATUS_INVALID_PARAMETER;
	}

	//
	// ֻMEM_RESERVEMEM_COMMITѡѡһѡ
	//
	if ((AllocationType & (MEM_RESERVE | MEM_COMMIT)) == 0 ||
		(AllocationType & ~(MEM_RESERVE | MEM_COMMIT)) != 0) {
		return STATUS_INVALID_PARAMETER;
	}

	IntState = KeEnableInterrupts(FALSE);

	if (SystemVirtual) {
		Pas = &MiSystemPas;
	} else {
		Pas = MiCurrentPas;
	}

	do {

		if ((AllocationType & MEM_RESERVE) != 0) {

			//
			// ڵַռбһεַ򣬱ĵλΪҳ
			//
			Status = MiReserveAddressRegion( &Pas->VadList,
											 *BaseAddress,
											 *RegionSize,
											 &Vad );

			if (!EOS_SUCCESS(Status)) {
				break;
			}

			//
			// ¼ʵʱʼҳš
			//
			StartingVpn = Vad->StartingVpn;
			EndVpn = Vad->EndVpn;

		} else {

			//
			// ѯMEM_COMMITַǷΪѱַ粻򷵻ʧܡ
			//
			Status = MiFindReservedAddressRegion( &Pas->VadList,
												  *BaseAddress,
												  *RegionSize,
												  &Vad );

			if (!EOS_SUCCESS(Status)) {
				break;
			}

			//
			// MEM_COMMITĵλΪҳ
			//
			StartingVpn = MI_VA_TO_VPN(*BaseAddress);
			EndVpn = MI_VA_TO_VPN(*BaseAddress + *RegionSize - 1);
		}

		if ((AllocationType & MEM_COMMIT) != 0) {

			//
			// ִMEM_COMMIT
			//
			Status = MiCommitPages(StartingVpn, EndVpn);

			if (!EOS_SUCCESS(Status)) {

				ASSERT(STATUS_NO_MEMORY == Status);

				//
				// ǰִMEM_RESERVEعMEM_RESERVE
				//
				if ((AllocationType & MEM_RESERVE) != 0) {
					MiFreeAddressRegion(&Pas->VadList, Vad);
				}

				break;
			}
		}

		//
		// ÷ֵ
		//
		*BaseAddress = MI_VPN_TO_VA(StartingVpn);
		*RegionSize = (EndVpn - StartingVpn + 1) << PAGE_SHIFT;

		Status = STATUS_SUCCESS;

	} while (0);

	KeEnableInterrupts(IntState);

	return Status;
}

STATUS
MmFreeVirtualMemory(
	IN OUT PVOID *BaseAddress,
	IN OUT PSIZE_T RegionSize,
	IN ULONG FreeType,
	IN BOOL SystemVirtual
	)
/*++


	ڵǰ̵ַռϵͳַռͷڴ档


	BaseAddress -- ʱͷŵʼַFreeTypeֵ
		ΪMEM_RELEASEBaseAddressֵ MmAllocateVirtualMemory 
		ʱķֵʱʵͷŵĵַʼֵַ¶
		뵽ҳ߽õ
	RegionSize -- ʱFreeTypeֵΪMEM_RELEASEΪ0
		MEM_DECOMMITڴСʱʵͷŵС
	FreeType -- ͷŲֵֻ֮ͣһ
		MEM_RELEASEͷѱύڴͬʱͷţ
		MEM_DECOMMITԱڲύзύ
	SystemVirtual -- Ƿϵͳַռͷڴ档

ֵ
	ɹ򷵻STATUS_SUCCESS

--*/
{
	STATUS Status;
	BOOL IntState;
	PMMPAS Pas;
	PMMVAD Vad;
	ULONG_PTR StartingVpn;
	ULONG_PTR EndVpn;

	//
	// *BaseAddressЧַ
	//
	if (NULL == *BaseAddress) {
		return STATUS_INVALID_ADDRESS;
	}

	//
	// ַ֤Χû*RegionSizeΪ0
	//
	if (*RegionSize > 0 && *BaseAddress + *RegionSize - 1 < *BaseAddress) {
		return STATUS_INVALID_PARAMETER;
	}

	//
	// ֻMEM_DECOMMITMEM_RELEASEѡ֮һ
	//
	if ((FreeType & ~(MEM_DECOMMIT | MEM_RELEASE)) != 0 ||
		((FreeType & (MEM_DECOMMIT | MEM_RELEASE)) == 0) ||
		((FreeType & (MEM_DECOMMIT | MEM_RELEASE)) == (MEM_DECOMMIT | MEM_RELEASE))) {
		return STATUS_INVALID_PARAMETER;
	}

	//
	// ָMEM_RELEASE*RegionSizeΪ0
	//
	if ((FreeType & MEM_RELEASE) != 0 && *RegionSize != 0) {
		return STATUS_INVALID_PARAMETER;		
	}

	IntState = KeEnableInterrupts(FALSE);

	if (SystemVirtual) {
		Pas = &MiSystemPas;
	} else {
		Pas = MiCurrentPas;
	}

	do {

		//
		// ѱַĿѱ򷵻ʧܡ
		//
		Status = MiFindReservedAddressRegion( &Pas->VadList,
											  *BaseAddress,
											  *RegionSize,
											  &Vad );
		
		if (!EOS_SUCCESS(Status)) {
			break;
		}

		//
		// ¼ѱֹҳš
		//
		StartingVpn = Vad->StartingVpn;
		EndVpn = Vad->EndVpn;

		if ((FreeType & MEM_RELEASE) != 0) {

			//
			// ִMEM_RELEASEʱ*BaseAddressѱĻַ
			//
			if (*BaseAddress != MI_VPN_TO_VA(StartingVpn)) {

				Status = STATUS_FREE_VM_NOT_AT_BASE;

				break;
			}

			//
			// ͷѱַ
			//
			MiFreeAddressRegion(&Pas->VadList, Vad);

		} else {

			//
			// *BaseAddressڱʼַ*RegionSizeΪ0ʱɶ
			// DECOMMIT*RegionSizeΪ0
			//
			if(0 == *RegionSize) {

				if(*BaseAddress != MI_VPN_TO_VA(StartingVpn)) {

					Status = STATUS_FREE_VM_NOT_AT_BASE;

					break;
				}

			} else {
				
				//
				// MEM_DECOMMITĵλΪҳ
				//
				StartingVpn = MI_VA_TO_VPN(*BaseAddress);
				EndVpn = MI_VA_TO_VPN(*BaseAddress + *RegionSize - 1);
			}
		}

		//
		// ִMEM_DECOMMIT
		//
		Status = MiDecommitPages(StartingVpn, EndVpn);
		ASSERT(EOS_SUCCESS(Status));

		//
		// ÷ֵ
		//
		*BaseAddress = MI_VPN_TO_VA(StartingVpn);
		*RegionSize = (EndVpn - StartingVpn + 1) << PAGE_SHIFT;

		Status = STATUS_SUCCESS;

	} while (0);

	KeEnableInterrupts(IntState);

	return Status;
}

VOID
MmCleanVirtualMemory(
	VOID
	)
{
	ASSERT(MiCurrentPas != &MiSystemPas);

	MiCleanAddressRegion(&MiCurrentPas->VadList);
	MiDecommitPages(MiCurrentPas->VadList.StartingVpn, MiCurrentPas->VadList.EndVpn);
}

STATUS
MiCommitPages(
	IN ULONG_PTR StartingVpn,
	IN ULONG_PTR EndVpn
	)
/*++


	Ϊҳӳҳ


	StartingVpn -- ʼҳš
	EndVpn -- ҳš

ֵ
	ɹ򷵻STATUS_SUCCESS

--*/
{
	STATUS Status;
	ULONG_PTR Vpn;
	ULONG_PTR Pfn;
	ULONG_PTR DemandPages;

	//
	// ͳΪַύڴҳ
	//
	DemandPages = 0;
	
	//
	// ϵͳڴͳַȱҳΪϵͳַռȫ
	// װҳûַռûС
	//
	if (StartingVpn < MI_VA_TO_VPN(MM_SYSTEM_RANGE_START)) {

		for (Vpn = StartingVpn & ~((1 << PTI_BITS) -1); Vpn <= EndVpn; Vpn += (1 << PTI_BITS))  {

			if (0 == MiGetPdeAddress(Vpn)->u.Hard.Valid) {
				DemandPages++;
			}
		}
	}
	

	//
	// ͳַҳն
	//
	for (Vpn = StartingVpn; Vpn <= EndVpn; Vpn++) {

		if (0 == MiGetPdeAddress(Vpn)->u.Hard.Valid ||
			0 == MiGetPteAddress(Vpn)->u.Hard.Valid) {
			DemandPages++;
		}
	}

	//
	// û㹻Ŀҳ򷵻ʧܡ
	//
	if (DemandPages > MiGetAnyPageCount()) {
		return STATUS_NO_MEMORY;
	}

	for (Vpn = StartingVpn; Vpn <= EndVpn; Vpn++) {

		//
		// ҳĿ¼ҳЧ˵ǰַûӳڴ档
		//
		if (0 == MiGetPdeAddress(Vpn)->u.Hard.Valid ||
			0 == MiGetPteAddress(Vpn)->u.Hard.Valid) {

			//
			// ҳĿ¼ЧһҳΪҳҳĿ¼
			//
			if (0 == MiGetPdeAddress(Vpn)->u.Hard.Valid) {

				ASSERT(Vpn < MI_VA_TO_VPN(MM_SYSTEM_RANGE_START));
				
				Status = MiAllocateZeroedPages(1, &Pfn);
				ASSERT(EOS_SUCCESS(Status));
				
				MiMapPageTable(Vpn, Pfn);
			}

			//
			// һҳ֮ӳ䵽ҳ
			//
			Status = MiAllocateZeroedPages(1, &Pfn);
			ASSERT(EOS_SUCCESS(Status));

			MiMapPage(Vpn, Pfn);

			//
			// ҳӦЧPTE
			// ע⣺ϵͳַռӲʹPTEҳӲжػװ
			//
			if (Vpn < MI_VA_TO_VPN(MM_SYSTEM_RANGE_START)) {
				MiIncPteCounter(Vpn);
			}
		}
	}

	return STATUS_SUCCESS;
}

STATUS
MiDecommitPages(
	IN ULONG_PTR StartingVpn,
	IN ULONG_PTR EndVpn
	)
/*++


	ͷӳҳϵҳ


	StartingVpn -- ʼҳš
	EndVpn -- ҳš

ֵ
	ɹ򷵻STATUS_SCCESSʾʧܡ

--*/
{
	ULONG_PTR Vpn;
	ULONG_PTR Pfn;

	//
	// ÿҳҳӳҳȡӳ䲢ͷҳ
	//
	for (Vpn = StartingVpn; Vpn <= EndVpn; Vpn++) {

		if (1 == MiGetPdeAddress(Vpn)->u.Hard.Valid &&
			1 == MiGetPteAddress(Vpn)->u.Hard.Valid) {

			Pfn = MiGetPteAddress(Vpn)->u.Hard.PageFrameNumber;
			MiUnmapPage(Vpn);
	
			MiFreePages(1, &Pfn);

			//
			// СPTEΪ0жزҳ
			// ע⣺ϵͳַռҳӲжء
			//
			if (Vpn < MI_VA_TO_VPN(MM_SYSTEM_RANGE_START) && 1 == MiDecPteCounter(Vpn)) {

				Pfn = MiGetPdeAddress(Vpn)->u.Hard.PageFrameNumber;

				MiUnmapPageTable(Vpn);

				MiFreePages(1, &Pfn);
			}
		}
	}

	return STATUS_SUCCESS;
}

BOOL
MmIsAddressValid(
	IN PVOID VirtualAddress
	)
/*++


	ַָǷΥ쳣ҲǼַǷӳ
	ڴ档


	VirtualAddress -- ַ

ֵ
	дʵַ쳣򷵻TRUE

--*/
{
	BOOL Result;
	BOOL IntState;
	ULONG_PTR Vpn;

	Vpn = MI_VA_TO_VPN(VirtualAddress);

	IntState = KeEnableInterrupts(FALSE);

	Result = MiGetPdeAddress(Vpn)->u.Hard.Valid && MiGetPteAddress(Vpn)->u.Hard.Valid;

	KeEnableInterrupts(IntState);

	return Result;
}

STATUS
MmGetPhysicalAddress(
	IN PVOID VirtualAddress,
	OUT PVOID* PhysicalAddress
	)
/*++


	õַӦַ.


	VirtualAddress -- ַ
	PhysicalAddress -- ָ룬ַָĻ

ֵ
	ɹ򷵻STATUS_SUCESS

--*/
{
	STATUS Status;
	BOOL IntState;
	ULONG_PTR Vpn;
	ULONG_PTR Pfn;

	IntState = KeEnableInterrupts(FALSE);

	Vpn = MI_VA_TO_VPN(VirtualAddress);

	if (1 == MiGetPdeAddress(Vpn)->u.Hard.Valid &&
		1 == MiGetPteAddress(Vpn)->u.Hard.Valid) {

		Pfn = MiGetPteAddress(Vpn)->u.Hard.PageFrameNumber;

		*PhysicalAddress = (PVOID)((Pfn << PAGE_SHIFT) + BYTE_OFFSET(VirtualAddress));

		Status = STATUS_SUCCESS;

	} else {

		Status = STATUS_INVALID_ADDRESS;
	}

	KeEnableInterrupts(IntState);

	return Status;
}
