# 测试python访问数据库
import pymssql

# 查询时需要用到
import pandas as pd

# 将sql文件的内容转换成字符串
def parse_sql(filename):
    # 读取 sql 文件文本内容，sqltxt 为 list 类型
    sql = open(filename, 'r', encoding = 'utf8')
    sqltxt = sql.readlines()
 
    # 读取之后关闭文件
    sql.close()

    # list 转 str
    sql = "".join(sqltxt)

    return sql

# 主函数
if __name__ == '__main__':

    #建立连接并获取cursor
    conn = pymssql.connect(host='localhost', user='SA', password='<MyStrong@Passw0rd>')
    cursor = conn.cursor()

    # 创建测试数据库
    conn.autocommit(True)
    cursor.execute("CREATE DATABASE wxq2")
    conn.autocommit(False)

    # 创建数据库表
    createdb_sql = parse_sql('createdb.sql')
    pd.read_sql(createdb_sql, conn)

    # 填充数据
    seed_sql = parse_sql('seed.sql')
    df = pd.read_sql(seed_sql, conn)
    print(df)

    # 运行学生代码
    query_sql = parse_sql('query.sql')
    df = pd.read_sql(query_sql, conn)

    # 输出查询结果
    print(df)

    # 连接用完后记得关闭以释放资源
    conn.close()
