# 概述
CodeCode.net 是专门为高校师生提供的一个理想的代码托管和实验实训交互协作平台。

# 特点
1. 为教师和学生提供类似 GitHub 的 `Git 库托管服务`。教师可以将实验文档、源代码文件托管到此平台，学生也可以将编写的源代码、实验报告、毕业论文在此平台进行托管。
2. 教师可`在线管理实验课程`，首先通过此平台在线布置实验任务，然后使用浏览器查看学生提交的作业，并通过提交历史、版本比较等功能掌握学生的实验过程，教师还可以使用问题跟踪、在线讨论等功能与学生进行充分的互动。
3. 提供`Web IDE`功能，学生可通过浏览器在线编写源代码，在线完成项目的构建、验证和部署工作。
4. 提供`团队协作`功能，在进行课程设计和毕业设计时，学生团队可以利用该平台的团队协作功能扮演不同的角色，分派不同的任务，通过在线协作的方式共同完成一个设计目标。教师可以通过此平台随时掌握学生团队的工作进展。
5. 支持`开放式实验`，用户可以使用 CodCode.net 账号登录我公司的任何一款实验软件。这样，只要学生能够连接互联网，就可以随时随地进行实验，彻底解决了传统实验方式在时间和空间上的限制。
6. 此平台配套的实验软件大量使用`虚拟仿真技术`和`可视化技术`，可提高实验效率，获得更好的实验效果。
7. 提供`EOJ题库`，包含三百多个C语言和C++语言编程题目，覆盖一百多个知识点，可用于编程能力在线评测。
8. 提供`源代码分析`功能，可以为C、C++、Java、Python、C#、SQL等十几门编程语言提供代码分析，报告潜在的Bug和不规范的编码方式，让学生编写高质量的代码。
9. 提供在线助手`小助同学`，学生如果有编程上的问题，除了问老师之外，还可以随时在线联系小助同学寻求帮助了。

# 观看演示录像
[CodeCode 平台演示录像](https://v.qq.com/x/page/g0871mhfrxt.html) 

# 免费申请账号
CodeCode.net和配套实验软件已提供给全国高校教师免费使用，现在就加入下面的 QQ 群向管理员申请账号吧！
```
非高校教师用户申请账号，请加 QQ 群 759027275。
```

![QQ Group](http://www.engintime.com/sites/default/files/codecode.net-qq-group.png)

# 配套实验软件
| 序号 | 软件名称 | 支持课程 |
| :------: | :---------- | ---------- |
| 1 | [Dream Logic 2019](https://www.codecode.net/engintime/Dream-Logic/Dream-Logic) | 计算机组成原理(DM1000)<br>计算机体系结构(MIPS)<br>微机原理与接口技术(8086)<br>数字电路<br>模拟电路 |
| 2 | [Linux Lab](https://www.codecode.net/engintime/linux-lab/Linux-Lab) | 操作系统原理<br>Linux 操作系统 |
| 3 | [OS Lab](https://www.codecode.net/engintime/os-lab/os-lab) | 操作系统原理 |
| 4 | [CS Lab](https://www.codecode.net/engintime/cs-lab/cs-lab) | 计算机系统基础 |
| 5 | [ASM Lab](https://www.codecode.net/engintime/asm-lab/asm-lab) | 汇编语言程序设计<br>微机原理与接口技术 |
| 6 | [CP Lab](https://www.codecode.net/engintime/cp-lab/cp-lab) | 编译原理 |
| 7 | [DS Lab](https://www.codecode.net/engintime/ds-lab/ds-lab) | 数据结构(C和C++)<br>算法分析 |
| 8 | [Engintime Eclipse](https://www.codecode.net/engintime/Eclipse-Group/eclipse) | Java程序设计<br>Java数据结构<br>Java Web编程<br>Python程序设计 |
| 9 | [C&C++ Lab](https://www.codecode.net/engintime/cpp-lab/cpp-lab) | C语言程序设计<br>C++语言程序设计<br>编程能力在线评测(EOJ 题库) |
| 10 | [CG Lab](http://www.engintime.com/node/55) | 计算机图形学 |
| 11 | [DI Lab](http://www.engintime.com/node/69) | 数字图像处理 |

# 提交问题或建议
[提交问题或建议](https://www.codecode.net/engintime/codecode/codecode/issues)