# CodeCode.net平台概述
CodeCode.net 平台是专门为高校计算机专业提供的一个理想的教学与科研平台。可用于高校计算机专业的`新工科建设`、`虚拟仿真实验中心建设`，以及`工程教育专业认证`和`大规模在线开放课程MOOC`的开展。

# CodeCode.net平台特点
**`Git 库托管服务`**  
为教师和学生提供类似 GitHub 的 Git 库托管服务。教师可以将实验文档、源代码文件托管到此平台，学生也可以将编写的源代码、实验报告、毕业论文在此平台进行托管。  
为托管的 Git 库提供了强大的、细粒度的成员权限管理功能，方便师生使用。

**`课程管理和任务管理`**  
教师可在线管理实验课程和实验任务。首先，教师可以通过此平台在线新建实验课程，在线布置实验任务，然后使用浏览器查看学生提交的作业，并通过提交历史、版本比较等功能掌握学生的实验过程。  
教师还可以使用问题跟踪、在线讨论等功能与学生进行充分的互动。

**`支持在线编程`**  
提供 Web IDE，学生无需安装任何客户端软件，可以直接使用浏览器在线编写源代码，在线完成项目的构建、验证和部署工作。

**`支持团队协作`**  
提供团队协作功能，在进行课程设计和毕业设计时，学生团队可以利用该平台的团队协作功能扮演不同的角色，分派不同的任务，通过在线协作的方式共同完成一个设计目标。  
教师可以通过此平台随时掌握学生团队的工作进展。

**`支持开放式实验`**  
支持开放式实验，用户可以使用 CodCode.net 账号登录我公司的任何一款实验软件。这样，只要学生能够连接互联网，就可以随时随地进行实验，彻底解决了传统实验方式在时间和空间上的限制。

**`大量采用虚拟仿真和可视化技术`**  
此平台配套的实验软件大量使用虚拟仿真技术和可视化技术，可以用于虚拟仿真实验中心建设，大大提高实验效率，可以获得更好的实验效果。

**`提供代码质量分析`**  
提供代码质量分析功能，可以为C、C++、Java、Python、C#、SQL等十几门编程语言提供代码分析，报告潜在的Bug和不规范的编码方式，让学生编写高质量的代码。

**`提供在线助手`**  
提供在线助手"小助同学"，学生如果有编程上的问题，除了问老师之外，还可以随时在线联系小助同学寻求帮助。

**`支持自动化评分`**  
对于提供了自动化评分脚本的任务，教师完全可以做到布置任务后不管，待任务结束后，本平台会根据学生程序的运行分数、代码质量分数、完成作业用时等多种因素自动给学生一个合理的分数。

**`提供代码查重功能`**  
教师可一键对所有学生提交的代码启动代码查重功能，自动生成查重报告，方便教师发现有抄袭行为的学生。

**`轻松定制新的任务模板`**  
教师可以在已有的实验模板上派生出新的实验模板，或者重新制作实验模板，我公司可以提供技术支持服务。

**`提供课程迁移服务`**  
如果有课程需要迁移到本平台，我公司可以提供课程迁移服务，包括定制课程内容，定制任务模板等。

**`支持大规模在线开放课程MOOC`**  
本平台支持学院级别、学校级别和互联网级别的在线开放课程，教师可以灵活选择。

**`同时提供互联网平台和校内私有平台`**  
教师可以安排学生使用互联网平台 CodeCode.net，我公司也可以在校园网为高校部署私有平台，方便师生使用。

**`强大的多维统计`**  
提供从任务、课程、学生到班级、学院、学校等多个维度的统计报告，满足各种类型用户的需要。

**`界面采用响应式设计`**  
用户无论是使用大屏幕的电脑，还是使用小屏幕的手机或者平板，都可以使用浏览器访问此平台，获得相似的体验。

**`提供EOJ题库`**  
包含三百多个C语言和C++语言编程题目，覆盖一百多个知识点，可用于编程能力在线评测。

# 观看演示录像
[CodeCode 平台演示录像](https://v.qq.com/x/page/g0871mhfrxt.html) 

# 免费申请账号
CodeCode.net和配套实验软件已提供给全国高校教师免费使用，现在就加入下面的 QQ 群向管理员申请账号吧！
```
非高校教师用户申请账号，请加 QQ 群 759027275。
```

![QQ Group](http://www.engintime.com/sites/default/files/codecode.net-qq-group.png)

# 配套实验软件
| 序号 | 软件名称 | 支持课程 |
| :------: | :---------- | ---------- |
| 1 | [Dream Logic 2019](https://www.codecode.net/engintime/Dream-Logic/Dream-Logic) | 计算机组成原理(DM1000)<br>计算机体系结构(MIPS)<br>微机原理与接口技术(8086)<br>数字电路<br>模拟电路 |
| 2 | [Linux Lab](https://www.codecode.net/engintime/linux-lab/Linux-Lab) | 操作系统原理<br>Linux 操作系统 |
| 3 | [OS Lab](https://www.codecode.net/engintime/os-lab/os-lab) | 操作系统原理 |
| 4 | [CS Lab](https://www.codecode.net/engintime/cs-lab/cs-lab) | 计算机系统基础 |
| 5 | [ASM Lab](https://www.codecode.net/engintime/asm-lab/asm-lab) | 汇编语言程序设计<br>微机原理与接口技术 |
| 6 | [CP Lab](https://www.codecode.net/engintime/cp-lab/cp-lab) | 编译原理 |
| 7 | [DS Lab](https://www.codecode.net/engintime/ds-lab/ds-lab) | 数据结构(C和C++)<br>算法分析 |
| 8 | [Engintime Eclipse](https://www.codecode.net/engintime/Eclipse-Group/eclipse) | Java程序设计<br>Java数据结构<br>Java Web编程<br>Python程序设计 |
| 9 | [C&C++ Lab](https://www.codecode.net/engintime/cpp-lab/cpp-lab) | C语言程序设计<br>C++语言程序设计<br>编程能力在线评测(EOJ 题库) |
| 10 | [CG Lab](http://www.engintime.com/node/55) | 计算机图形学 |
| 11 | [DI Lab](http://www.engintime.com/node/69) | 数字图像处理 |

# 提交问题或建议
[提交问题或建议](https://www.codecode.net/engintime/codecode/codecode/issues)