# 概述
CodeCode.net 平台是专门为高校计算机专业提供的一个理想的教学与科研平台。可用于高校计算机专业的`新工科建设`、`本科一流课程（“金课”）建设`、`双万计划`、`虚拟仿真实验中心建设`，以及`工程教育专业认证`、`本科教学评估`和`大规模在线开放课程MOOC`的开展。

# 解决方案白皮书
:arrow_double_down:[下载计算机专业新工科建设平台解决方案白皮书](http://www.engintime.com/forum/viewtopic.php?f=2&t=3088&sid=54e9991dc870bdf28df5fa4838ac02b3)

# 观看演示录像
:cinema:[CodeCode 平台演示录像](https://v.qq.com/x/page/g0871mhfrxt.html) 

# 数据披露报告
:arrow_double_down:[下载2019年秋季学期数据披露报告](https://www.codecode.net/engintime/codecode/datareveal/2019autumn/raw/master/2019%E7%A7%8B%E5%AD%A3%E5%AD%A6%E6%9C%9FCodeCode.net%E5%B9%B3%E5%8F%B0%E6%95%B0%E6%8D%AE%E6%8A%AB%E9%9C%B2.pdf)

# CodeCode.net平台特点
**`Git 库托管服务`**  
为教师和学生提供类似 GitHub 的 Git 库托管服务。教师可以将实验文档、源代码文件托管到此平台，学生也可以将编写的源代码、实验报告、毕业论文在此平台进行托管。  
为托管的 Git 库提供了强大的、细粒度的成员权限管理功能，方便师生使用。

**`机构管理和用户管理`**  
机构管理提供学校、学院、班级管理功能。用户管理提供教师、学生管理功能。

**`课程管理和任务管理`**  
教师可在线管理实验课程和实验任务。首先，教师可以通过此平台在线新建实验课程，在线布置实验任务，然后使用浏览器查看学生提交的作业，并通过提交历史、版本比较等功能掌握学生的实验过程。  
教师还可以使用问题跟踪、在线讨论等功能与学生进行充分的互动。

**`支持在线编程`**  
提供 Web IDE，学生无需安装任何客户端软件，可以直接使用浏览器在线编写源代码，在线完成项目的构建、验证和部署工作。

**`支持团队协作`**  
提供团队协作功能，在进行课程设计和毕业设计时，学生团队可以利用该平台的团队协作功能扮演不同的角色，分派不同的任务，通过在线协作的方式共同完成一个设计目标。  
教师可以通过此平台随时掌握学生团队的工作进展。

**`支持开放式实验和自主学习`**  
支持开放式实验和自主学习，用户可以使用 CodCode.net 账号登录我公司的任何一款实验软件。这样，只要学生能够连接互联网，就可以随时随地进行实验，彻底解决了传统实验方式在时间和空间上的限制。
同时，本平台提供的学习资料都是免费公开的，任何人都可以自由获取，方便学生进行自主学习。

**`大量采用虚拟仿真和可视化技术`**  
此平台配套的实验软件大量使用虚拟仿真技术和可视化技术，可以用于虚拟仿真实验中心建设，大大提高实验效率，可以获得更好的实验效果。

**`提供代码质量分析`**  
提供代码质量分析功能，可以为C、C++、Java、Python、C#、SQL等十几门编程语言提供代码分析，报告潜在的Bug和不规范的编码方式，让学生编写高质量的代码。

**`提供在线助手`**  
提供在线助手"小助同学"，学生如果有编程上的问题，除了问老师之外，还可以随时@小助同学寻求帮助。

**`支持自动化评分`**  
对于提供了自动化评分脚本的任务，教师完全可以做到布置任务后不管，待任务结束后，本平台会根据学生程序的运行分数、代码质量分数、完成作业用时等多种因素自动给学生一个合理的分数。

**`提供代码查重等功能防作弊`**  
教师可一键对所有学生提交的代码启动代码查重功能，自动生成查重报告，方便教师发现有抄袭行为的学生。同时，还停供了隐藏的附加测试算例功能，以及算例文件一致性校验功能，可有效防止学生篡改验证过程。

**`轻松定制新的任务模板`**  
教师可以在已有的实验模板上派生出新的实验模板，或者重新制作实验模板，我公司可以提供技术支持服务。

**`提供课程迁移服务`**  
如果有课程需要迁移到本平台，我公司可以提供课程迁移服务，包括定制课程内容，定制任务模板等。

**`方便与第三方系统集成`**  
本平台提供的Git是国际通用的开放协议，同时本平台还提供了大量的 API ，方便与第三方系统集成。

**`支持大规模在线开放课程MOOC`**  
本平台支持学院级别、学校级别和互联网级别的在线开放课程，教师可以灵活选择。

**`同时提供互联网平台和校内私有平台`**  
教师可以安排学生使用互联网平台 CodeCode.net，我公司也可以在校园网为高校部署私有平台，方便师生使用。

**`强大的多维统计`**  
提供从任务、课程、学生到班级、学院、学校等多个维度的统计报告，满足各种类型用户的需要。

**`界面采用响应式设计`**  
用户无论是使用大屏幕的电脑，还是使用小屏幕的手机或者平板，都可以使用浏览器访问此平台，获得相似的体验。

**`提供EOJ题库`**  
包含三百多个C语言和C++语言编程题目，覆盖一百多个知识点，可用于编程能力在线评测。

# 免费申请账号
CodeCode.net和配套实验软件已提供给全国高校教师免费使用，现在就加入下面的 QQ 群向管理员申请账号吧！
>
非高校教师用户申请账号，请加 QQ 群 759027275。
>

![QQ Group](img/codecode.net-qq-group.png)

# 已发布的课程
>
这些课程是由北京英真时代科技有限公司在 CodeCode 平台上设计的，这些课程实验方案成熟，配套资料齐全，高校教师可直接使用这些课程内容为学生在线授课。
>

| 序号 | 课程名称 | 自动评分 | 教学视频 |
| :------: | :---------- | :----------: | :----------: 
| 1 | 计算机组成原理 |   | :heavy_check_mark: |
| 2 | 计算机体系结构 |   |   |
| 3 | 微机原理与接口技术  |   | :heavy_check_mark: |
| 4 | 数字电路与数字逻辑 |   |   |
| 5 | 操作系统原理 |   | :heavy_check_mark: |
| 6 | Linux 操作系统 |   | :heavy_check_mark: |
| 7 | 计算机系统基础  |   |   |
| 8 | 汇编语言程序设计 |   |   |
| 9 | 编译原理 | :heavy_check_mark: | :heavy_check_mark: |
| 10 | 数据结构 | :heavy_check_mark: |   |
| 11 | 算法设计与分析 | :heavy_check_mark: |   |
| 12 | Java 程序设计 | :heavy_check_mark: |   |
| 13 | Java Web 应用开发 | :heavy_check_mark: |   |
| 14 | Python 程序设计  | :heavy_check_mark: |   |
| 15 | Python 数据分析  | :heavy_check_mark: |   |
| 16 | C 语言程序设计 | :heavy_check_mark: |   |
| 17 | C++ 语言程序设计 | :heavy_check_mark: |   |
| 18 | 计算机图形学 |   |   |
| 19 | 数字图像处理 |   |   |
| 20 | 面向对象程序设计 | :heavy_check_mark: |   |
| 21 | 网站开发与网页制作 | :heavy_check_mark:  |   |
| 22 | Web前端开发技术 | :heavy_check_mark:  |   |
| 23 | Web应用技术 | :heavy_check_mark:  |   |
|  | 更多课程正在开发中… | |   |

# 可定制的课程

>
可定制的课程是指北京英真时代科技有限公司可以与高校教师合作，在 CodeCode 平台上设计课程相关的实验内容，从而允许教师开设在线课程。
>

| 序号 | 课程名称 |
| :------: | :---------- |
| 1 | 数字电路与数字逻辑 |
| 2 | 数据结构(C/C++/Java) |
| 3 | 算法设计与分析(C/Java)  |
| 4 | 面向对象程序设计(C++/Java/C#) |
| 5 | Web前端开发技术(HTML5/CSS/JS) |
| 6 | 程序设计(C/C++/Java/Python/C#) |
| 7 | Android 移动应用开发 |
| 8 | Unity 3D 程序设计 |
| 9 | 微信小程序开发 |
| 10 | 数据分析与软件 |
| 11 | 大数据基础 |
| 12 | 人工智能基础 |
| 13 | 数据库原理与应用 |
| 14 | 软件工程 |
| 15 | 嵌入式操作系统 |
| 16 | 网络编程 |
| 17 | Unix/Linux 系统编程 |
| 18 | Windows 系统编程 |
| 19 | Cocos2d 游戏开发 |
| 20 | 计算机网络（Socket 编程） |
|  | 更多课程正在开发中… |

# 配套实验软件
>
这些配套实验软件是由北京英真时代科技有限公司专门为相关实验课程开发的，具有很多强大的教学功能，并与CodeCode平台深度集成。
>

| 序号 | 软件名称 | 支持课程 |
| :------: | :---------- | ---------- |
| 1 | [Dream Logic 2019](https://www.codecode.net/engintime/Dream-Logic/Dream-Logic) | 计算机组成原理(DM1000)<br>计算机体系结构(MIPS)<br>微机原理与接口技术(8086)<br>数字电路<br>模拟电路 |
| 2 | [Linux Lab](https://www.codecode.net/engintime/linux-lab/Linux-Lab) | 操作系统原理<br>Linux 操作系统 |
| 3 | [OS Lab](https://www.codecode.net/engintime/os-lab/os-lab) | 操作系统原理 |
| 4 | [CS Lab](https://www.codecode.net/engintime/cs-lab/cs-lab) | 计算机系统基础 |
| 5 | [ASM Lab](https://www.codecode.net/engintime/asm-lab/asm-lab) | 汇编语言程序设计<br>微机原理与接口技术 |
| 6 | [CP Lab](https://www.codecode.net/engintime/cp-lab/cp-lab) | 编译原理 |
| 7 | [DS Lab](https://www.codecode.net/engintime/ds-lab/ds-lab) | 数据结构(C和C++)<br>算法分析 |
| 8 | [Engintime Eclipse](https://www.codecode.net/engintime/Eclipse-Group/eclipse) | Java 程序设计<br>Java 数据结构<br>Java Web 应用开发<br>Python 程序设计 |
| 9 | [C&C++ Lab](https://www.codecode.net/engintime/cpp-lab/cpp-lab) | C 语言程序设计<br>C++ 语言程序设计<br>编程能力在线评测(EOJ 题库) |
| 10 | [CG Lab](http://www.engintime.com/node/55) | 计算机图形学 |
| 11 | [DI Lab](http://www.engintime.com/node/69) | 数字图像处理 |

# 提交问题或建议
:question:[提交问题或建议](https://www.codecode.net/engintime/codecode/codecode/issues)

# 北京英真时代科技有限公司
地址：北京市房山区拱辰大街 98 号 7 层 0825  
邮编：102488  
电话：010-60357081  
手机：18500560938 18501161622  
传真：010-60357081  
QQ ：964515564  
邮箱：sales@tevation.com  