/*******************************************************************************

Copyright (c) 2008 - 2018 ӢʱƼ޹˾Ȩ

*******************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

typedef unsigned char BYTE;
typedef long BOOL;

#define FALSE	0
#define TRUE	1


#define MAX_LINE_LENGTH		256		// һджٸַ
#define MAX_LINE_COUNT		1024	// Դļж
#define MAX_MACHINE_CODE_BYTE_COUNT		256	// Դжٸֽڻ

#define MAX_SYMBOL_LENGTH	64		// һ԰ٸַ
#define MAX_SYMBOL_COUNT	256		// Դļ԰ٸ

#ifndef MAX_PATH
#define MAX_PATH 256				// ļ·԰ٸַ
#endif


// ݿ⡣¼ԴļдеϢעСУ
struct LINE_RECORD
{
	char line_string[MAX_LINE_LENGTH];	// е
	unsigned long line_num;				// к
	unsigned long address;				// дתĻӳļеĵַƫƣ
	int machine_code_count;				// дתĻֽ
	unsigned long flag;					// б־λ32λ
};
struct LINE_RECORD line_database[MAX_LINE_COUNT] = { 0 };
int line_count = 0;
int machine_code_line_count = 0;	// ¼˻Ĵе

									// ڴ˶еĴб־λע⣬б־λǰλĹϵ
#define LF_INSTRUCTION	0x00000001		// б־λλ1ʾһָʾ


									// ضλָʹ˱šȷţڵһɨʱ޷ȷǵĵַҪ
									// ڵڶɨʱضλ
struct REALLOCATE
{
	unsigned long address;					// һɨʱ¼ҪضλĻĵַƫƣ
											// ڶɨʱݷŵĵַضλ
	char symbol_name[MAX_SYMBOL_LENGTH];	// Ҫضλķơ
	int line_num;							// кš
};
struct REALLOCATE reallocate_table[MAX_LINE_COUNT] = { 0 };
int reallocate_count = 0;


// űŰԴеıš
struct SYMBOL
{
	char name[MAX_SYMBOL_LENGTH];			// 
	unsigned long address;					// űʾĵַضλʱҪõ
	int machine_code_count;							// ɵĻֽΪλ
	int line_num;							// к
	int ref_count;							// ü
};
struct SYMBOL symbol_table[MAX_SYMBOL_COUNT] = { 0 };
int symbol_count = 0;


// ̵״̬
enum
{
	AS_BEGIN		// ʼ״̬ǰڴ״̬
	, AS_INT_TABLE	// ڴжббƺǰڴ״̬
	, AS_TEXT		// ڴΡƺݵǰڴ״̬
	, AS_DATA		// ڴݶΡݶƺ󣬴ڴ״̬
};
unsigned long assembler_state = AS_BEGIN;

//
// 涨еĹؼ
//

// 
const char* int_table_section_keyword = ".int_table";		// жб־
const char* code_section_keyword = ".text";		// α־
char const* data_section_keyword = ".data";		// ݶα־

												// ָ
const char* mov_instruction_keyword = "mov";
const char* add_instruction_keyword = "add";
const char* adc_instruction_keyword = "adc";
const char* sub_instruction_keyword = "sub";
const char* sbb_instruction_keyword = "sbb";
const char* and_instruction_keyword = "and";
const char* or_instruction_keyword = "or";
const char* xor_instruction_keyword = "xor";

const char* shr_instruction_keyword = "shr";
const char* shl_instruction_keyword = "shl";
const char* rcr_instruction_keyword = "rcr";
const char* rcl_instruction_keyword = "rcl";
const char* sal_instruction_keyword = "sal";
const char* sar_instruction_keyword = "sar";
const char* rol_instruction_keyword = "rol";
const char* ror_instruction_keyword = "ror";
const char* not_instruction_keyword = "not";

const char* push_instruction_keyword = "push";
const char* pop_instruction_keyword = "pop";

const char* in_instruction_keyword = "in";
const char* out_instruction_keyword = "out";

const char* call_instruction_keyword = "call";
const char* ret_instruction_keyword = "ret";

const char* int_instruction_keyword = "int";
const char* iret_instruction_keyword = "iret";


const char* inc_instruction_keyword = "inc";
const char* dec_instruction_keyword = "dec";
const char* lea_instruction_keyword = "lea";
const char* cmp_instruction_keyword = "cmp";

const char* nop_instruction_keyword = "nop";
const char* cli_instruction_keyword = "cli";
const char* sti_instruction_keyword = "sti";

const char* jmp_instruction_keyword = "jmp";
const char* jc_instruction_keyword = "jc";
const char* jz_instruction_keyword = "jz";
const char* je_instruction_keyword = "je";
const char* jne_instruction_keyword = "jne";
const char* jnz_instruction_keyword = "jnz";

// ͨüĴ
const char* al_register_keyword = "al";
const char* bl_register_keyword = "bl";
const char* cl_register_keyword = "cl";
const char* dl_register_keyword = "dl";
const char* sp_register_keyword = "sp";
const char* bp_register_keyword = "bp";
const char* si_register_keyword = "si";
const char* di_register_keyword = "di";

const char* cs_register_keyword = "cs";
const char* ds_register_keyword = "ds";
const char* ss_register_keyword = "ss";
const char* es_register_keyword = "es";

const char* al_register_indirect_keyword = "[al]";
const char* bl_register_indirect_keyword = "[bl]";
const char* cl_register_indirect_keyword = "[cl]";
const char* dl_register_indirect_keyword = "[dl]";
const char* sp_register_indirect_keyword = "[sp]";
const char* bp_register_indirect_keyword = "[bp]";
const char* si_register_indirect_keyword = "[si]";
const char* di_register_indirect_keyword = "[di]";

const char* cs_register_indirect_keyword = "[cs]";
const char* ds_register_indirect_keyword = "[ds]";
const char* ss_register_indirect_keyword = "[ss]";
const char* es_register_indirect_keyword = "[es]";


const char* delimit_char = "\n\t\r ";			// ҪԵĿհַ
const char* delimit_char_comma = "\n\t\r, ";	// ҪԵĿհַӢĶ

												// Ļ
#define MAX_MACHINE_CODE 1024
BYTE machine_code[MAX_MACHINE_CODE];
unsigned long machine_code_address = 0;
unsigned long machine_code_old_address = 0;


const char* assembly_file_name = NULL;			// ļ·
const char* target_file_name = NULL;			// Ŀļ·
const char* list_file_name = NULL;				// бļ·
const char* dbg_file_name = NULL;				// Ϣļ·

const unsigned long dbg_file_magic = 58;
const unsigned long dbg_file_version = 1;


// зֵ﷨Ϣ
void error_msg(const char* error_msg, int line_num)
{
	if (line_num >= 1)
	{
		printf("%s:%d: error: %s\n", assembly_file_name, line_num, error_msg);
	}
	else
	{
		printf("%s: error: %s\n", assembly_file_name, error_msg);
	}

	exit(1);
}

char formated_msg[1024];	// ʽĴϢڴַС
void error_msg_miss_op(const char* instruction_name, int line_num)
{
	sprintf(formated_msg, "%s ָȱٲ", instruction_name);
	error_msg(formated_msg, line_num);
}

void error_msg_wrong_op(const char* instruction_name, int line_num)
{
	sprintf(formated_msg, "%s ָ֧Ĳ", instruction_name);
	error_msg(formated_msg, line_num);
}

void error_msg_same_symbol(const char* symbol, int line_num, int ref_line_num)
{
	sprintf(formated_msg, " %s ظ塣μ %d С", symbol, ref_line_num);
	error_msg(formated_msg, line_num);
}

void error_msg_keyword_symbol(const char* symbol, int line_num)
{
	sprintf(formated_msg, "ʹñĹؼ %s Ϊơ", symbol);
	error_msg(formated_msg, line_num);
}

void error_msg_keyword_int_vector(const char* vector, int line_num)
{
	sprintf(formated_msg, "ʹñĹؼ %s Ϊжơ", vector);
	error_msg(formated_msg, line_num);
}

void error_msg_wrong_data(const char* data, int line_num)
{
	sprintf(formated_msg, "%s Чݡ", data);
	error_msg(formated_msg, line_num);
}

// зֵľϢ
void warning_msg(const char* warning_msg, int line_num)
{
	if (line_num >= 1)
	{
		printf("%s:%d: warning: %s\n", assembly_file_name, line_num, warning_msg);
	}
	else
	{
		printf("%s: warning: %s\n", assembly_file_name, warning_msg);
	}
}

void warning_msg_invalid_line(int line_num)
{
	warning_msg("ЧĴС", line_num);
}

void warning_msg_unref_symbol(const char* symbol, int line_num)
{
	sprintf(formated_msg, " %s δá", symbol);
	warning_msg(formated_msg, line_num);
}

// жǷֿͷǸſͷģΪ
int is_immediate(const char* token)
{
	return (isdigit(token[0]) || '-' == token[0]) ? 1 : 0;
}

// жǷַ磬[4]
int is_immediate_address(const char* token)
{
	// һַ"]"
	if (token[strlen(token) - 1] != ']')
	{
		return 0;
	}

	// һַ"["
	if (token[0] != '[')
	{
		return 0;
	}

	// ַֿͷ
	return (isdigit(token[1]) || ' ' == token[1]) ? 1 : 0;

}

// жǷ
int is_main_memory(const char* token)
{
	return (isdigit(token[0]) || '@' == token[0]) ? 1 : 0;
}

// ָ
enum
{
	OT_REGISTER_AL					// al
	, OT_REGISTER_BL				// bl
	, OT_REGISTER_CL				// cl
	, OT_REGISTER_DL				// dl
	, OT_REGISTER_SP				// sp
	, OT_REGISTER_BP				// bp
	, OT_REGISTER_SI				// si
	, OT_REGISTER_DI				// di

	, OT_REGISTER_CS				// cs
	, OT_REGISTER_DS				// ds
	, OT_REGISTER_SS				// ss
	, OT_REGISTER_ES				// es

	, OT_REGISTER_AL_INDIRECT		// [al]
	, OT_REGISTER_BL_INDIRECT		// [bl]
	, OT_REGISTER_CL_INDIRECT		// [cl]
	, OT_REGISTER_DL_INDIRECT		// [dl]
	, OT_REGISTER_SP_INDIRECT		// [sp]
	, OT_REGISTER_BP_INDIRECT		// [bp]
	, OT_REGISTER_SI_INDIRECT		// [si]
	, OT_REGISTER_DI_INDIRECT		// [di]

	, OT_REGISTER_CS_INDIRECT		// [cs]
	, OT_REGISTER_DS_INDIRECT		// [ds]
	, OT_REGISTER_SS_INDIRECT		// [ss]
	, OT_REGISTER_ES_INDIRECT		// [es]
	, OT_IMMEDIATE					// 
	, OT_SYMBOL						// 
};

// õָ
unsigned long get_operand_type(const char* op)
{
	unsigned long op_type;

	if (stricmp(op, al_register_keyword) == 0)
	{
		op_type = OT_REGISTER_AL;
	}
	else if (stricmp(op, bl_register_keyword) == 0)
	{
		op_type = OT_REGISTER_BL;
	}
	else if (stricmp(op, cl_register_keyword) == 0)
	{
		op_type = OT_REGISTER_CL;
	}
	else if (stricmp(op, dl_register_keyword) == 0)
	{
		op_type = OT_REGISTER_DL;
	}
	else if (stricmp(op, sp_register_keyword) == 0)
	{
		op_type = OT_REGISTER_SP;
	}
	else if (stricmp(op, bp_register_keyword) == 0)
	{
		op_type = OT_REGISTER_BP;
	}
	else if (stricmp(op, si_register_keyword) == 0)
	{
		op_type = OT_REGISTER_SI;
	}
	else if (stricmp(op, di_register_keyword) == 0)
	{
		op_type = OT_REGISTER_DI;
	}

	else if (stricmp(op, cs_register_keyword) == 0)
	{
		op_type = OT_REGISTER_CS;
	}
	else if (stricmp(op, ds_register_keyword) == 0)
	{
		op_type = OT_REGISTER_DS;
	}
	else if (stricmp(op, ss_register_keyword) == 0)
	{
		op_type = OT_REGISTER_SS;
	}
	else if (stricmp(op, es_register_keyword) == 0)
	{
		op_type = OT_REGISTER_ES;
	}


	else if (stricmp(op, al_register_indirect_keyword) == 0)
	{
		op_type = OT_REGISTER_AL_INDIRECT;
	}
	else if (stricmp(op, bl_register_indirect_keyword) == 0)
	{
		op_type = OT_REGISTER_BL_INDIRECT;
	}
	else if (stricmp(op, cl_register_indirect_keyword) == 0)
	{
		op_type = OT_REGISTER_CL_INDIRECT;
	}
	else if (stricmp(op, dl_register_indirect_keyword) == 0)
	{
		op_type = OT_REGISTER_DL_INDIRECT;
	}
	else if (stricmp(op, sp_register_indirect_keyword) == 0)
	{
		op_type = OT_REGISTER_SP_INDIRECT;
	}
	else if (stricmp(op, bp_register_indirect_keyword) == 0)
	{
		op_type = OT_REGISTER_BP_INDIRECT;
	}
	else if (stricmp(op, si_register_indirect_keyword) == 0)
	{
		op_type = OT_REGISTER_SI_INDIRECT;
	}
	else if (stricmp(op, di_register_indirect_keyword) == 0)
	{
		op_type = OT_REGISTER_DI_INDIRECT;
	}

	else if (stricmp(op, cs_register_indirect_keyword) == 0)
	{
		op_type = OT_REGISTER_CS_INDIRECT;
	}
	else if (stricmp(op, ds_register_indirect_keyword) == 0)
	{
		op_type = OT_REGISTER_DS_INDIRECT;
	}
	else if (stricmp(op, ss_register_indirect_keyword) == 0)
	{
		op_type = OT_REGISTER_SS_INDIRECT;
	}
	else if (stricmp(op, es_register_indirect_keyword) == 0)
	{
		op_type = OT_REGISTER_ES_INDIRECT;
	}
	else if (is_immediate(op))
	{
		op_type = OT_IMMEDIATE;
	}
	else
	{
		op_type = OT_SYMBOL;
	}

	return op_type;
}

// ݼĴõһ
char get_machine_code_from_r(unsigned long op_type)
{
	return (char)(op_type - OT_REGISTER_AL);
}

// ͨüĴͻĻֵõһ
char get_machine_code_from_r_indirect(unsigned long op_type)
{
	return (char)(op_type - OT_REGISTER_AL_INDIRECT);
}

// õһ롣ע⣬ʹøԷֵǴŵ 8 λ char
char get_machine_code_from_immediate(const char* immediate)
{
	char* end;
	int start_index = (immediate[0] == '-' ? 1 : 0);

	int base = (immediate[start_index] == '0' && (immediate[start_index + 1] == 'x' || immediate[start_index + 1] == 'X')) ? 16 : 10;
	return (char)strtol(immediate, &end, base);
}

// ַõһ롣ȥţٽתΪŵ8λַ
char get_machine_code_from_immediate_address(const char* immediate)
{
	char d[7];
	int i = 0;
	int t = strlen(immediate);
	for (; i < t - 2; i++)
	{
		d[i] = immediate[i + 1];
	}

	char* temp;
	int base = (immediate[1] == '0' && (immediate[2] == 'x' || immediate[2] == 'X')) ? 16 : 10;
	return (char)strtol(d, &temp, base);
}


// ضλһضλϢ
void add_reallocate(const char* symbol, int line_num)
{
	reallocate_table[reallocate_count].address = machine_code_address;
	strcpy(reallocate_table[reallocate_count].symbol_name, symbol);
	reallocate_table[reallocate_count].line_num = line_num;
	reallocate_count++;
}

//////////////////////////////////////////////////////////////////////////////////////
// ָ뺯
// mov op1, op2
//
void parse_mov(int line_num)
{
	char *op1, *op2;
	char rs, rd;
	unsigned long op1_type, op2_type;

	if (assembler_state != AS_TEXT)
	{
		warning_msg_invalid_line(line_num);
		return;
	}

	op1 = strtok(NULL, delimit_char_comma);
	op2 = strtok(NULL, delimit_char);

	if (NULL == op1 || NULL == op2)
	{
		error_msg_miss_op(mov_instruction_keyword, line_num);
	}

	op1_type = get_operand_type(op1);
	op2_type = get_operand_type(op2);

	if ((op1_type >= OT_REGISTER_AL && op1_type <= OT_REGISTER_ES)
		&& OT_IMMEDIATE == op2_type)
	{
		// mov reg, immediate
		// 
		machine_code[machine_code_address] = 0x01;
		machine_code_address++;

		// regΪĿļĴ
		machine_code[machine_code_address] = get_machine_code_from_r(op1_type);
		machine_code_address++;

		// 
		machine_code[machine_code_address] = get_machine_code_from_immediate(op2);
		machine_code_address++;
	}
	else if ((op1_type >= OT_REGISTER_AL && op1_type <= OT_REGISTER_ES)
		&& (op2_type >= OT_REGISTER_AL && op2_type <= OT_REGISTER_ES))
	{
		// mov reg, reg
		// 
		machine_code[machine_code_address] = 0x02;
		machine_code_address++;

		// ԴĴrs
		rs = get_machine_code_from_r(op2_type);
		rs = rs << 4;

		// ĿĲ
		rd = get_machine_code_from_r(op1_type);

		// 
		machine_code[machine_code_address] = rs | rd;
		machine_code_address++;

	}
	else if ((op1_type >= OT_REGISTER_AL && op1_type <= OT_REGISTER_ES) && OT_SYMBOL == op2_type)
	{
		// mov reg, symbol
		// 
		machine_code[machine_code_address] = 0x03;
		machine_code_address++;

		// ĿĲ
		machine_code[machine_code_address] = get_machine_code_from_r(op1_type);
		machine_code_address++;

		// ضλ
		add_reallocate(op2, line_num);
		machine_code_address++;
	}
	else if ((op1_type >= OT_REGISTER_AL && op1_type <= OT_REGISTER_ES)
		&& (op2_type >= OT_REGISTER_AL_INDIRECT && op2_type <= OT_REGISTER_ES_INDIRECT))
	{
		// mov reg, [reg]
		// 
		machine_code[machine_code_address] = 0x04;
		machine_code_address++;

		// ԴĴrs
		rs = get_machine_code_from_r_indirect(op2_type);
		rs = rs << 4;

		// ĿĲ
		rd = get_machine_code_from_r(op1_type);

		// 
		machine_code[machine_code_address] = rs | rd;
		machine_code_address++;
	}
	else if ((op1_type >= OT_REGISTER_AL_INDIRECT && op1_type <= OT_REGISTER_ES_INDIRECT)
		&& (op2_type >= OT_REGISTER_AL && op2_type <= OT_REGISTER_ES))
	{
		// mov [reg], reg
		// 
		machine_code[machine_code_address] = 0x05;
		machine_code_address++;

		// ԴĴrs
		rs = get_machine_code_from_r(op2_type);
		rs = rs << 4;

		// ĿĲ
		rd = get_machine_code_from_r_indirect(op1_type);

		// 
		machine_code[machine_code_address] = rs | rd;
		machine_code_address++;
	}

	else if ((op1_type >= OT_REGISTER_AL_INDIRECT && op1_type <= OT_REGISTER_ES_INDIRECT) && OT_IMMEDIATE == op2_type)
	{
		// mov [reg], immediate
		// 
		machine_code[machine_code_address] = 0x06;
		machine_code_address++;

		// ĿĲ
		machine_code[machine_code_address] = get_machine_code_from_r_indirect(op1_type);
		machine_code_address++;

		// 
		machine_code[machine_code_address] = get_machine_code_from_immediate(op2);
		machine_code_address++;
	}
	else if (OT_SYMBOL == op1_type && (op2_type >= OT_REGISTER_AL && op2_type <= OT_REGISTER_ES))
	{
		// mov symbol, reg
		machine_code[machine_code_address] = 0x07;
		machine_code_address++;

		rs = get_machine_code_from_r(op2_type);
		rs = rs << 4;
		machine_code[machine_code_address] = rs;
		machine_code_address++;

		// ضλ
		add_reallocate(op1, line_num);
		machine_code_address++;
	}
	else
	{
		error_msg_wrong_op(mov_instruction_keyword, line_num);
	}

	//
	// ڴݿУǴһָ
	//
	line_database[line_count].flag |= LF_INSTRUCTION;
}

//////////////////////////////////////////////////////////////////////////
// ӷָ
// add op1, op2
void parse_add(int line_num)
{
	char *op1, *op2;
	char rs, rd;
	unsigned long op1_type, op2_type;

	if (assembler_state != AS_TEXT)
	{
		warning_msg_invalid_line(line_num);
		return;
	}

	op1 = strtok(NULL, delimit_char_comma);
	op2 = strtok(NULL, delimit_char);

	if (NULL == op1 || NULL == op2)
	{
		error_msg_miss_op(add_instruction_keyword, line_num);
	}

	op1_type = get_operand_type(op1);
	op2_type = get_operand_type(op2);

	if ((op1_type >= OT_REGISTER_AL && op1_type <= OT_REGISTER_DI)
		&& (op2_type >= OT_REGISTER_AL && op2_type <= OT_REGISTER_DI))
	{
		// add reg, reg
		// 
		machine_code[machine_code_address] = 0x08;
		machine_code_address++;

		// ԴĴrs
		rs = get_machine_code_from_r(op2_type);
		rs = rs << 4;

		// ĿĲ
		rd = get_machine_code_from_r(op1_type);

		// 
		machine_code[machine_code_address] = rs | rd;
		machine_code_address++;
	}
	else if ((op1_type >= OT_REGISTER_AL && op1_type <= OT_REGISTER_DI)
		&& (op2_type >= OT_REGISTER_AL_INDIRECT && op2_type <= OT_REGISTER_DI_INDIRECT))
	{
		// add reg, [reg]
		// 
		machine_code[machine_code_address] = 0x0a;
		machine_code_address++;

		// ԴĴrs
		rs = get_machine_code_from_r_indirect(op2_type);
		rs = rs << 4;

		// ĿĲ
		rd = get_machine_code_from_r(op1_type);

		// 
		machine_code[machine_code_address] = rs | rd;
		machine_code_address++;
	}
	else if ((op1_type >= OT_REGISTER_AL && op1_type <= OT_REGISTER_DI) && OT_SYMBOL == op2_type)
	{
		// add reg, symbol
		// 
		machine_code[machine_code_address] = 0x0c;
		machine_code_address++;

		// 
		machine_code[machine_code_address] = get_machine_code_from_r(op1_type);
		machine_code_address++;

		// ضλ
		add_reallocate(op2, line_num);
		machine_code_address++;
	}
	else if ((op1_type >= OT_REGISTER_AL && op1_type <= OT_REGISTER_DI) && OT_IMMEDIATE == op2_type)
	{
		// add reg, immediate
		machine_code[machine_code_address] = 0x0e;
		machine_code_address++;

		// 
		machine_code[machine_code_address] = get_machine_code_from_r(op1_type);
		machine_code_address++;

		// 
		machine_code[machine_code_address] = get_machine_code_from_immediate(op2);
		machine_code_address++;
	}
	else
	{
		error_msg_wrong_op(add_instruction_keyword, line_num);
	}

	//
	// ڴݿУǴһָ
	//
	line_database[line_count].flag |= LF_INSTRUCTION;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////
// λļӷָ
// adc op1, op2
void parse_adc(int line_num)
{
	char *op1, *op2;
	char rs, rd;
	unsigned long op1_type, op2_type;

	if (assembler_state != AS_TEXT)
	{
		warning_msg_invalid_line(line_num);
		return;
	}

	op1 = strtok(NULL, delimit_char_comma);
	op2 = strtok(NULL, delimit_char);

	if (NULL == op1 || NULL == op2)
	{
		error_msg_miss_op(adc_instruction_keyword, line_num);
	}

	op1_type = get_operand_type(op1);
	op2_type = get_operand_type(op2);

	if ((op1_type >= OT_REGISTER_AL && op1_type <= OT_REGISTER_DI)
		&& (op2_type >= OT_REGISTER_AL && op2_type <= OT_REGISTER_DI))
	{
		// adc reg, reg
		// 
		machine_code[machine_code_address] = 0x10;
		machine_code_address++;

		// ԴĴrs
		rs = get_machine_code_from_r(op2_type);
		rs = rs << 4;

		// ĿĲ
		rd = get_machine_code_from_r(op1_type);

		// 
		machine_code[machine_code_address] = rs | rd;
		machine_code_address++;
	}
	else if ((op1_type >= OT_REGISTER_AL && op1_type <= OT_REGISTER_DI)
		&& (op2_type >= OT_REGISTER_AL_INDIRECT && op2_type <= OT_REGISTER_DI_INDIRECT))
	{
		// adc reg, [reg]
		// 
		machine_code[machine_code_address] = 0x12;
		machine_code_address++;

		// ԴĴrs
		rs = get_machine_code_from_r_indirect(op2_type);
		rs = rs << 4;

		// ĿĲ
		rd = get_machine_code_from_r(op1_type);

		// 
		machine_code[machine_code_address] = rs | rd;
		machine_code_address++;
	}
	else if ((op1_type >= OT_REGISTER_AL && op1_type <= OT_REGISTER_DI) && OT_SYMBOL == op2_type)
	{
		// adc reg, symbol
		// 
		machine_code[machine_code_address] = 0x14;
		machine_code_address++;

		// 
		machine_code[machine_code_address] = get_machine_code_from_r(op1_type);
		machine_code_address++;

		// ضλ
		add_reallocate(op2, line_num);
		machine_code_address++;
	}
	else if ((op1_type >= OT_REGISTER_AL && op1_type <= OT_REGISTER_DI) && OT_IMMEDIATE == op2_type)
	{
		// adc reg, immediate
		machine_code[machine_code_address] = 0x16;
		machine_code_address++;

		// 
		machine_code[machine_code_address] = get_machine_code_from_r(op1_type);
		machine_code_address++;

		// 
		machine_code[machine_code_address] = get_machine_code_from_immediate(op2);
		machine_code_address++;
	}
	else
	{
		error_msg_wrong_op(adc_instruction_keyword, line_num);
	}

	//
	// ڴݿУǴһָ
	//
	line_database[line_count].flag |= LF_INSTRUCTION;
}

////////////////////////////////////////////////////////////////////////////////////////////
// ָ
// sub op1, op2
void parse_sub(int line_num)
{
	char *op1, *op2;
	char rs, rd;
	unsigned long op1_type, op2_type;

	if (assembler_state != AS_TEXT)
	{
		warning_msg_invalid_line(line_num);
		return;
	}

	op1 = strtok(NULL, delimit_char_comma);
	op2 = strtok(NULL, delimit_char);

	if (NULL == op1 || NULL == op2)
	{
		error_msg_miss_op(sub_instruction_keyword, line_num);
	}

	op1_type = get_operand_type(op1);
	op2_type = get_operand_type(op2);

	if ((op1_type >= OT_REGISTER_AL && op1_type <= OT_REGISTER_DI)
		&& (op2_type >= OT_REGISTER_AL && op2_type <= OT_REGISTER_DI))
	{
		// sub reg, reg
		// 
		machine_code[machine_code_address] = 0x18;
		machine_code_address++;

		// ԴĴrs
		rs = get_machine_code_from_r(op2_type);
		rs = rs << 4;

		// ĿĲ
		rd = get_machine_code_from_r(op1_type);

		// 
		machine_code[machine_code_address] = rs | rd;
		machine_code_address++;
	}
	else if ((op1_type >= OT_REGISTER_AL && op1_type <= OT_REGISTER_DI)
		&& (op2_type >= OT_REGISTER_AL_INDIRECT && op2_type <= OT_REGISTER_DI_INDIRECT))
	{
		// sub reg, [reg]
		// 
		machine_code[machine_code_address] = 0x1a;
		machine_code_address++;

		// ԴĴrs
		rs = get_machine_code_from_r_indirect(op2_type);
		rs = rs << 4;

		// ĿĲ
		rd = get_machine_code_from_r(op1_type);

		// 
		machine_code[machine_code_address] = rs | rd;
		machine_code_address++;
	}
	else if ((op1_type >= OT_REGISTER_AL && op1_type <= OT_REGISTER_DI) && OT_SYMBOL == op2_type)
	{
		// sub reg, symbol
		// 
		machine_code[machine_code_address] = 0x1c;
		machine_code_address++;

		// 
		machine_code[machine_code_address] = get_machine_code_from_r(op1_type);
		machine_code_address++;

		// ضλ
		add_reallocate(op2, line_num);
		machine_code_address++;
	}
	else if ((op1_type >= OT_REGISTER_AL && op1_type <= OT_REGISTER_DI) && OT_IMMEDIATE == op2_type)
	{
		// sub reg, immediate
		machine_code[machine_code_address] = 0x1e;
		machine_code_address++;

		// 
		machine_code[machine_code_address] = get_machine_code_from_r(op1_type);
		machine_code_address++;

		// 
		machine_code[machine_code_address] = get_machine_code_from_immediate(op2);
		machine_code_address++;
	}
	else
	{
		error_msg_wrong_op(sub_instruction_keyword, line_num);
	}

	//
	// ڴݿУǴһָ
	//
	line_database[line_count].flag |= LF_INSTRUCTION;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////
// λָ
// sbb op1, op2
void parse_sbb(int line_num)
{
	char *op1, *op2;
	char rs, rd;
	unsigned long op1_type, op2_type;

	if (assembler_state != AS_TEXT)
	{
		warning_msg_invalid_line(line_num);
		return;
	}

	op1 = strtok(NULL, delimit_char_comma);
	op2 = strtok(NULL, delimit_char);

	if (NULL == op1 || NULL == op2)
	{
		error_msg_miss_op(sbb_instruction_keyword, line_num);
	}

	op1_type = get_operand_type(op1);
	op2_type = get_operand_type(op2);

	if ((op1_type >= OT_REGISTER_AL && op1_type <= OT_REGISTER_DI)
		&& (op2_type >= OT_REGISTER_AL && op2_type <= OT_REGISTER_DI))
	{
		// sbb reg, reg
		// 
		machine_code[machine_code_address] = 0x20;
		machine_code_address++;

		// ԴĴrs
		rs = get_machine_code_from_r(op2_type);
		rs = rs << 4;

		// ĿĲ
		rd = get_machine_code_from_r(op1_type);

		// 
		machine_code[machine_code_address] = rs | rd;
		machine_code_address++;
	}
	else if ((op1_type >= OT_REGISTER_AL && op1_type <= OT_REGISTER_DI)
		&& (op2_type >= OT_REGISTER_AL_INDIRECT && op2_type <= OT_REGISTER_DI_INDIRECT))
	{
		// sbb reg, [reg]
		// 
		machine_code[machine_code_address] = 0x22;
		machine_code_address++;

		// ԴĴrs
		rs = get_machine_code_from_r_indirect(op2_type);
		rs = rs << 4;

		// ĿĲ
		rd = get_machine_code_from_r(op1_type);

		// 
		machine_code[machine_code_address] = rs | rd;
		machine_code_address++;
	}
	else if ((op1_type >= OT_REGISTER_AL && op1_type <= OT_REGISTER_DI) && OT_SYMBOL == op2_type)
	{
		// sbb reg, symbol
		// 
		machine_code[machine_code_address] = 0x24;
		machine_code_address++;

		// 
		machine_code[machine_code_address] = get_machine_code_from_r(op1_type);
		machine_code_address++;

		// ضλ
		add_reallocate(op2, line_num);
		machine_code_address++;
	}
	else if ((op1_type >= OT_REGISTER_AL && op1_type <= OT_REGISTER_DI) && OT_IMMEDIATE == op2_type)
	{
		// sbb reg, immediate
		machine_code[machine_code_address] = 0x26;
		machine_code_address++;

		// 
		machine_code[machine_code_address] = get_machine_code_from_r(op1_type);
		machine_code_address++;

		// 
		machine_code[machine_code_address] = get_machine_code_from_immediate(op2);
		machine_code_address++;
	}
	else
	{
		error_msg_wrong_op(sbb_instruction_keyword, line_num);
	}

	//
	// ڴݿУǴһָ
	//
	line_database[line_count].flag |= LF_INSTRUCTION;
}

/////////////////////////////////////////////////////////////////////////////////////////
// 1ָ
// inc reg
void parse_inc(int line_num)
{
	char *op;
	unsigned long op_type;

	if (assembler_state != AS_TEXT)
	{
		warning_msg_invalid_line(line_num);
		return;
	}

	op = strtok(NULL, delimit_char);

	if (NULL == op)
	{
		error_msg_miss_op(inc_instruction_keyword, line_num);
	}

	op_type = get_operand_type(op);

	if (op_type >= OT_REGISTER_AL && op_type <= OT_REGISTER_DI)
	{
		// 
		machine_code[machine_code_address] = 0x78;
		machine_code_address++;

		// 
		machine_code[machine_code_address] = get_machine_code_from_r(op_type);
		machine_code_address++;
	}
	else
	{
		error_msg_wrong_op(inc_instruction_keyword, line_num);
	}

	//
	// ڴݿУǴһָ
	//
	line_database[line_count].flag |= LF_INSTRUCTION;
}

// dec reg
void parse_dec(int line_num)
{
	char *op;
	unsigned long op_type;

	if (assembler_state != AS_TEXT)
	{
		warning_msg_invalid_line(line_num);
		return;
	}

	op = strtok(NULL, delimit_char);

	if (NULL == op)
	{
		error_msg_miss_op(dec_instruction_keyword, line_num);
	}

	op_type = get_operand_type(op);

	if (op_type >= OT_REGISTER_AL && op_type <= OT_REGISTER_DI)
	{
		// 
		machine_code[machine_code_address] = 0x79;
		machine_code_address++;

		// 
		machine_code[machine_code_address] = get_machine_code_from_r(op_type);
		machine_code_address++;
	}
	else
	{
		error_msg_wrong_op(dec_instruction_keyword, line_num);
	}

	//
	// ڴݿУǴһָ
	//
	line_database[line_count].flag |= LF_INSTRUCTION;
}

//////////////////////////////////////////////////////////////////////////////////////////////
// λָ
// and op1, op2
void parse_and(int line_num)
{
	char *op1, *op2;
	char rs, rd;
	unsigned long op1_type, op2_type;

	if (assembler_state != AS_TEXT)
	{
		warning_msg_invalid_line(line_num);
		return;
	}

	op1 = strtok(NULL, delimit_char_comma);
	op2 = strtok(NULL, delimit_char);

	if (NULL == op1 || NULL == op2)
	{
		error_msg_miss_op(and_instruction_keyword, line_num);
	}

	op1_type = get_operand_type(op1);
	op2_type = get_operand_type(op2);

	if ((op1_type >= OT_REGISTER_AL && op1_type <= OT_REGISTER_DI)
		&& (op2_type >= OT_REGISTER_AL && op2_type <= OT_REGISTER_DI))
	{
		// and reg, reg
		// 
		machine_code[machine_code_address] = 0x2a;
		machine_code_address++;

		// ԴĴrs
		rs = get_machine_code_from_r(op2_type);
		rs = rs << 4;

		// ĿĲ
		rd = get_machine_code_from_r(op1_type);

		// 
		machine_code[machine_code_address] = rs | rd;
		machine_code_address++;
	}
	else if ((op1_type >= OT_REGISTER_AL && op1_type <= OT_REGISTER_DI)
		&& (op2_type >= OT_REGISTER_AL_INDIRECT && op2_type <= OT_REGISTER_DI_INDIRECT))
	{
		// and reg, [reg]
		// 
		machine_code[machine_code_address] = 0x2c;
		machine_code_address++;

		// ԴĴrs
		rs = get_machine_code_from_r_indirect(op2_type);
		rs = rs << 4;

		// ĿĲ
		rd = get_machine_code_from_r(op1_type);

		// 
		machine_code[machine_code_address] = rs | rd;
		machine_code_address++;
	}
	else if ((op1_type >= OT_REGISTER_AL && op1_type <= OT_REGISTER_DI) && OT_SYMBOL == op2_type)
	{
		// and reg, symbol
		// 
		machine_code[machine_code_address] = 0x2e;
		machine_code_address++;

		// 
		machine_code[machine_code_address] = get_machine_code_from_r(op1_type);
		machine_code_address++;

		// ضλ
		add_reallocate(op2, line_num);
		machine_code_address++;
	}
	else if ((op1_type >= OT_REGISTER_AL && op1_type <= OT_REGISTER_DI) && OT_IMMEDIATE == op2_type)
	{
		// and reg, immediate
		machine_code[machine_code_address] = 0x30;
		machine_code_address++;

		// 
		machine_code[machine_code_address] = get_machine_code_from_r(op1_type);
		machine_code_address++;

		// 
		machine_code[machine_code_address] = get_machine_code_from_immediate(op2);
		machine_code_address++;
	}
	else
	{
		error_msg_wrong_op(and_instruction_keyword, line_num);
	}

	//
	// ڴݿУǴһָ
	//
	line_database[line_count].flag |= LF_INSTRUCTION;
}

/////////////////////////////////////////////////////////////////////////////////////
// λָ
// or op1, op2
void parse_or(int line_num)
{
	char *op1, *op2;
	char rs, rd;
	unsigned long op1_type, op2_type;

	if (assembler_state != AS_TEXT)
	{
		warning_msg_invalid_line(line_num);
		return;
	}

	op1 = strtok(NULL, delimit_char_comma);
	op2 = strtok(NULL, delimit_char);

	if (NULL == op1 || NULL == op2)
	{
		error_msg_miss_op(or_instruction_keyword, line_num);
	}

	op1_type = get_operand_type(op1);
	op2_type = get_operand_type(op2);

	if ((op1_type >= OT_REGISTER_AL && op1_type <= OT_REGISTER_DI)
		&& (op2_type >= OT_REGISTER_AL && op2_type <= OT_REGISTER_DI))
	{
		// or reg, reg
		// 
		machine_code[machine_code_address] = 0x32;
		machine_code_address++;

		// ԴĴrs
		rs = get_machine_code_from_r(op2_type);
		rs = rs << 4;

		// ĿĲ
		rd = get_machine_code_from_r(op1_type);

		// 
		machine_code[machine_code_address] = rs | rd;
		machine_code_address++;
	}
	else if ((op1_type >= OT_REGISTER_AL && op1_type <= OT_REGISTER_DI)
		&& (op2_type >= OT_REGISTER_AL_INDIRECT && op2_type <= OT_REGISTER_DI_INDIRECT))
	{
		// or reg, [reg]
		// 
		machine_code[machine_code_address] = 0x34;
		machine_code_address++;

		// ԴĴrs
		rs = get_machine_code_from_r_indirect(op2_type);
		rs = rs << 4;

		// ĿĲ
		rd = get_machine_code_from_r(op1_type);

		// 
		machine_code[machine_code_address] = rs | rd;
		machine_code_address++;
	}
	else if ((op1_type >= OT_REGISTER_AL && op1_type <= OT_REGISTER_DI) && OT_SYMBOL == op2_type)
	{
		// or reg, symbol
		// 
		machine_code[machine_code_address] = 0x36;
		machine_code_address++;

		// 
		machine_code[machine_code_address] = get_machine_code_from_r(op1_type);
		machine_code_address++;

		// ضλ
		add_reallocate(op2, line_num);
		machine_code_address++;
	}
	else if ((op1_type >= OT_REGISTER_AL && op1_type <= OT_REGISTER_DI) && OT_IMMEDIATE == op2_type)
	{
		// or reg, immediate
		machine_code[machine_code_address] = 0x38;
		machine_code_address++;

		// 
		machine_code[machine_code_address] = get_machine_code_from_r(op1_type);
		machine_code_address++;

		// 
		machine_code[machine_code_address] = get_machine_code_from_immediate(op2);
		machine_code_address++;
	}
	else
	{
		error_msg_wrong_op(or_instruction_keyword, line_num);
	}

	//
	// ڴݿУǴһָ
	//
	line_database[line_count].flag |= LF_INSTRUCTION;
}

/////////////////////////////////////////////////////////////////////////////////////
// λָ
// xor op1, op2
void parse_xor(int line_num)
{
	char *op1, *op2;
	char rs, rd;
	unsigned long op1_type, op2_type;

	if (assembler_state != AS_TEXT)
	{
		warning_msg_invalid_line(line_num);
		return;
	}

	op1 = strtok(NULL, delimit_char_comma);
	op2 = strtok(NULL, delimit_char);

	if (NULL == op1 || NULL == op2)
	{
		error_msg_miss_op(xor_instruction_keyword, line_num);
	}

	op1_type = get_operand_type(op1);
	op2_type = get_operand_type(op2);

	if ((op1_type >= OT_REGISTER_AL && op1_type <= OT_REGISTER_DI)
		&& (op2_type >= OT_REGISTER_AL && op2_type <= OT_REGISTER_DI))
	{
		// xor reg, reg
		// 
		machine_code[machine_code_address] = 0x3a;
		machine_code_address++;

		// ԴĴrs
		rs = get_machine_code_from_r(op2_type);
		rs = rs << 4;

		// ĿĲ
		rd = get_machine_code_from_r(op1_type);

		// 
		machine_code[machine_code_address] = rs | rd;
		machine_code_address++;
	}
	else if ((op1_type >= OT_REGISTER_AL && op1_type <= OT_REGISTER_DI)
		&& (op2_type >= OT_REGISTER_AL_INDIRECT && op2_type <= OT_REGISTER_DI_INDIRECT))
	{
		// xor reg, [reg]
		// 
		machine_code[machine_code_address] = 0x3c;
		machine_code_address++;

		// ԴĴrs
		rs = get_machine_code_from_r_indirect(op2_type);
		rs = rs << 4;

		// ĿĲ
		rd = get_machine_code_from_r(op1_type);

		// 
		machine_code[machine_code_address] = rs | rd;
		machine_code_address++;
	}
	else if ((op1_type >= OT_REGISTER_AL && op1_type <= OT_REGISTER_DI) && OT_SYMBOL == op2_type)
	{
		// xor reg, symbol
		// 
		machine_code[machine_code_address] = 0x3e;
		machine_code_address++;

		// 
		machine_code[machine_code_address] = get_machine_code_from_r(op1_type);
		machine_code_address++;

		// ضλ
		add_reallocate(op2, line_num);
		machine_code_address++;
	}
	else if ((op1_type >= OT_REGISTER_AL && op1_type <= OT_REGISTER_DI) && OT_IMMEDIATE == op2_type)
	{
		// xor reg, immediate
		machine_code[machine_code_address] = 0x40;
		machine_code_address++;

		// 
		machine_code[machine_code_address] = get_machine_code_from_r(op1_type);
		machine_code_address++;

		// 
		machine_code[machine_code_address] = get_machine_code_from_immediate(op2);
		machine_code_address++;
	}
	else
	{
		error_msg_wrong_op(xor_instruction_keyword, line_num);
	}

	//
	// ڴݿУǴһָ
	//
	line_database[line_count].flag |= LF_INSTRUCTION;
}

////////////////////////////////////////////////////
//
// push reg
void parse_push(int line_num)
{
	char *op;
	unsigned long op_type;

	if (assembler_state != AS_TEXT)
	{
		warning_msg_invalid_line(line_num);
		return;
	}

	op = strtok(NULL, delimit_char_comma);
	if (NULL == op)
	{
		error_msg_miss_op(push_instruction_keyword, line_num);
	}

	op_type = get_operand_type(op);
	if (op_type >= OT_REGISTER_AL && op_type <= OT_REGISTER_ES)
	{
		machine_code[machine_code_address] = 0x42;
		machine_code_address++;

		//
		machine_code[machine_code_address] = get_machine_code_from_r(op_type);
		machine_code_address++;
	}
	else
	{
		error_msg_wrong_op(push_instruction_keyword, line_num);
	}

	//
	// ڴݿУǴһָ
	//
	line_database[line_count].flag |= LF_INSTRUCTION;
}

/////////////////////////////////////////////////////////////////
//
// pop reg
void parse_pop(int line_num)
{
	char *op;
	unsigned long op_type;

	if (assembler_state != AS_TEXT)
	{
		warning_msg_invalid_line(line_num);
		return;
	}

	op = strtok(NULL, delimit_char_comma);
	if (NULL == op)
	{
		error_msg_miss_op(pop_instruction_keyword, line_num);
	}

	op_type = get_operand_type(op);
	if (op_type >= OT_REGISTER_AL && op_type <= OT_REGISTER_ES)
	{
		machine_code[machine_code_address] = 0x43;
		machine_code_address++;

		//
		machine_code[machine_code_address] = get_machine_code_from_r(op_type);
		machine_code_address++;
	}
	else
	{
		error_msg_wrong_op(pop_instruction_keyword, line_num);
	}

	//
	// ڴݿУǴһָ
	//
	line_database[line_count].flag |= LF_INSTRUCTION;
}

//////////////////////////////////////////////////////////////////////////
//
// not reg
void parse_not(int line_num)
{
	char *op;
	unsigned long op_type;

	if (assembler_state != AS_TEXT)
	{
		warning_msg_invalid_line(line_num);
		return;
	}

	op = strtok(NULL, delimit_char);

	if (NULL == op)
	{
		error_msg_miss_op(not_instruction_keyword, line_num);
	}

	op_type = get_operand_type(op);

	// ĿֻͨüĴ
	if (op_type >= OT_REGISTER_AL && op_type <= OT_REGISTER_DI)
	{
		machine_code[machine_code_address] = 0x44;
		machine_code_address++;

		// 
		machine_code[machine_code_address] = get_machine_code_from_r(op_type);
		machine_code_address++;
	}
	else
	{
		error_msg_wrong_op(not_instruction_keyword, line_num);
	}

	//
	// ڴݿУǴһָ
	//
	line_database[line_count].flag |= LF_INSTRUCTION;
}

//////////////////////////////////////////////////////////////////////
//
// cmp op1, op2
void parse_cmp(int line_num)
{
	char *op1, *op2;
	char rs, rd;
	unsigned long op1_type, op2_type;

	if (assembler_state != AS_TEXT)
	{
		warning_msg_invalid_line(line_num);
		return;
	}

	op1 = strtok(NULL, delimit_char_comma);
	op2 = strtok(NULL, delimit_char);

	if (NULL == op1 || NULL == op2)
	{
		error_msg_miss_op(cmp_instruction_keyword, line_num);
	}

	op1_type = get_operand_type(op1);
	op2_type = get_operand_type(op2);

	if ((op1_type >= OT_REGISTER_AL && op1_type <= OT_REGISTER_DI) && OT_IMMEDIATE == op2_type)
	{
		// cmp reg, immediate
		machine_code[machine_code_address] = 0x47;
		machine_code_address++;

		// 
		machine_code[machine_code_address] = get_machine_code_from_r(op1_type);
		machine_code_address++;

		// 
		machine_code[machine_code_address] = get_machine_code_from_immediate(op2);
		machine_code_address++;

	}
	else if ((op1_type >= OT_REGISTER_AL && op1_type <= OT_REGISTER_DI)
		&& (op2_type >= OT_REGISTER_AL && op2_type <= OT_REGISTER_DI))
	{
		// cmp reg, reg
		// 
		machine_code[machine_code_address] = 0x49;
		machine_code_address++;

		// ԴĴrs
		rs = get_machine_code_from_r(op2_type);
		rs = rs << 4;

		// ĿĲ
		rd = get_machine_code_from_r(op1_type);

		// 
		machine_code[machine_code_address] = rs | rd;
		machine_code_address++;
	}
	else
	{
		error_msg_wrong_op(xor_instruction_keyword, line_num);
	}

	//
	// ڴݿУǴһָ
	//
	line_database[line_count].flag |= LF_INSTRUCTION;
}


//////////////////////////////////////////////////////////////
//
// ӿڷָ
// in op1, op2
void parse_in(int line_num)
{
	char *op1, *op2;
	char rs, rd;
	unsigned long op1_type, op2_type;

	if (assembler_state != AS_TEXT)
	{
		warning_msg_invalid_line(line_num);
		return;
	}

	op1 = strtok(NULL, delimit_char_comma);
	op2 = strtok(NULL, delimit_char);

	if (NULL == op1 || NULL == op2)
	{
		error_msg_miss_op(in_instruction_keyword, line_num);
	}

	op1_type = get_operand_type(op1);
	op2_type = get_operand_type(op2);

	if (OT_REGISTER_AL == op1_type && OT_IMMEDIATE == op2_type)
	{
		// in al, imm
		machine_code[machine_code_address] = 0x4b;
		machine_code_address++;

		//
		machine_code[machine_code_address] = get_machine_code_from_r(op1_type);
		machine_code_address++;

		machine_code[machine_code_address] = get_machine_code_from_immediate(op2);
		machine_code_address++;

	}
	else if (OT_REGISTER_AL == op1_type && OT_REGISTER_DL == op2_type)
	{
		// in al, dl
		machine_code[machine_code_address] = 0x4c;
		machine_code_address++;

		//
		rs = get_machine_code_from_r(op2_type);
		rs = rs << 4;

		rd = get_machine_code_from_r(op1_type);
		machine_code[machine_code_address] = rs | rd;
		machine_code_address++;

	}
	else
	{
		error_msg_wrong_op(in_instruction_keyword, line_num);
	}

	//
	// ڴݿУǴһָ
	//
	line_database[line_count].flag |= LF_INSTRUCTION;
}

// out op1, op2
void parse_out(int line_num)
{
	char *op1, *op2;
	char rs, rd;
	unsigned long op1_type, op2_type;

	if (assembler_state != AS_TEXT)
	{
		warning_msg_invalid_line(line_num);
		return;
	}

	op1 = strtok(NULL, delimit_char_comma);
	op2 = strtok(NULL, delimit_char);

	if (NULL == op1 || NULL == op2)
	{
		error_msg_miss_op(out_instruction_keyword, line_num);
	}

	op1_type = get_operand_type(op1);
	op2_type = get_operand_type(op2);

	if (OT_REGISTER_DL == op1_type && OT_REGISTER_AL == op2_type)
	{
		// out dl, al
		machine_code[machine_code_address] = 0x4d;
		machine_code_address++;

		//
		rs = get_machine_code_from_r(op2_type);
		rs = rs << 4;

		rd = get_machine_code_from_r(op1_type);
		machine_code[machine_code_address] = rs | rd;
		machine_code_address++;
	}
	else if (OT_IMMEDIATE == op1_type && OT_REGISTER_AL == op2_type)
	{
		// out imm, al
		machine_code[machine_code_address] = 0x4e;
		machine_code_address++;

		//
		machine_code[machine_code_address] = get_machine_code_from_r(op2_type);
		machine_code_address++;

		machine_code[machine_code_address] = get_machine_code_from_immediate(op1);
		machine_code_address++;
	}
	else
	{
		error_msg_wrong_op(out_instruction_keyword, line_num);
	}

	//
	// ڴݿУǴһָ
	//
	line_database[line_count].flag |= LF_INSTRUCTION;
}

///////////////////////////////////////////////////////
//
// lea reg, symbol
void parse_lea(int line_num)
{
	char *op1, *op2;
	unsigned long op1_type, op2_type;

	if (assembler_state != AS_TEXT)
	{
		warning_msg_invalid_line(line_num);
		return;
	}

	op1 = strtok(NULL, delimit_char_comma);
	op2 = strtok(NULL, delimit_char);

	if (NULL == op1 || NULL == op2)
	{
		error_msg_miss_op(lea_instruction_keyword, line_num);
	}

	op1_type = get_operand_type(op1);
	op2_type = get_operand_type(op2);

	if ((op1_type >= OT_REGISTER_AL && op1_type <= OT_REGISTER_DI) && OT_SYMBOL == op2_type)
	{
		// lea reg, symbol
		machine_code[machine_code_address] = 0x4f;
		machine_code_address++;

		machine_code[machine_code_address] = get_machine_code_from_r(op1_type);
		machine_code_address++;

		// ضλ
		add_reallocate(op2, line_num);
		machine_code_address++;
	}
	else
	{
		error_msg_wrong_op(lea_instruction_keyword, line_num);
	}

	//
	// ڴݿУǴһָ
	//
	line_database[line_count].flag |= LF_INSTRUCTION;
}

//////////////////////////////////////////////////////
//
// jz/je symbol
void parse_jz(int line_num)
{
	char *op;
	unsigned long op_type;

	if (assembler_state != AS_TEXT)
	{
		warning_msg_invalid_line(line_num);
		return;
	}

	op = strtok(NULL, delimit_char);

	if (NULL == op)
	{
		error_msg_miss_op(jz_instruction_keyword, line_num);
	}

	op_type = get_operand_type(op);

	if (OT_SYMBOL == op_type)
	{
		// jz symbol
		machine_code[machine_code_address] = 0x54;
		machine_code_address++;

		// ضλ
		add_reallocate(op, line_num);
		machine_code_address++;
	}
	else
	{
		error_msg_wrong_op(jz_instruction_keyword, line_num);
	}

	//
	// ڴݿУǴһָ
	//
	line_database[line_count].flag |= LF_INSTRUCTION;
}

//////////////////////////////////////////////////////
//
// jnz/jne symbol
void parse_jnz(int line_num)
{
	char *op;
	unsigned long op_type;

	if (assembler_state != AS_TEXT)
	{
		warning_msg_invalid_line(line_num);
		return;
	}

	op = strtok(NULL, delimit_char);

	if (NULL == op)
	{
		error_msg_miss_op(jnz_instruction_keyword, line_num);
	}

	op_type = get_operand_type(op);

	if (OT_SYMBOL == op_type)
	{
		machine_code[machine_code_address] = 0x55;
		machine_code_address++;

		// ضλ
		add_reallocate(op, line_num);
		machine_code_address++;
	}
	else
	{
		error_msg_wrong_op(jnz_instruction_keyword, line_num);
	}

	//
	// ڴݿУǴһָ
	//
	line_database[line_count].flag |= LF_INSTRUCTION;
}

//////////////////////////////////////////////////////
//
// jc symbol
void parse_jc(int line_num)
{
	char *op;
	unsigned long op_type;

	if (assembler_state != AS_TEXT)
	{
		warning_msg_invalid_line(line_num);
		return;
	}

	op = strtok(NULL, delimit_char);

	if (NULL == op)
	{
		error_msg_miss_op(jc_instruction_keyword, line_num);
	}

	op_type = get_operand_type(op);

	if (OT_SYMBOL == op_type)
	{
		machine_code[machine_code_address] = 0x56;
		machine_code_address++;

		// ضλ
		add_reallocate(op, line_num);
		machine_code_address++;
	}
	else
	{
		error_msg_wrong_op(jc_instruction_keyword, line_num);
	}

	//
	// ڴݿУǴһָ
	//
	line_database[line_count].flag |= LF_INSTRUCTION;
}

//////////////////////////////////////////////////////////
// jmp symbol
void parse_jmp(int line_num)
{
	char *op;
	unsigned long op_type;

	if (assembler_state != AS_TEXT)
	{
		warning_msg_invalid_line(line_num);
		return;
	}

	op = strtok(NULL, delimit_char);

	if (NULL == op)
	{
		error_msg_miss_op(jmp_instruction_keyword, line_num);
	}

	op_type = get_operand_type(op);

	if (OT_SYMBOL == op_type)
	{
		// jmp symbol
		machine_code[machine_code_address] = 0x57;
		machine_code_address++;

		// ضλ
		add_reallocate(op, line_num);
		machine_code_address++;
	}
	else
	{
		error_msg_wrong_op(jmp_instruction_keyword, line_num);
	}

	//
	// ڴݿУǴһָ
	//
	line_database[line_count].flag |= LF_INSTRUCTION;
}


////////////////////////////////////////////////////////////////////////////////////
//
// int immediate
void parse_int(int line_num)
{
	char *op;
	unsigned long op_type;

	if (assembler_state != AS_TEXT)
	{
		warning_msg_invalid_line(line_num);
		return;
	}

	op = strtok(NULL, delimit_char);

	if (NULL == op)
	{
		error_msg_miss_op(int_instruction_keyword, line_num);
	}

	op_type = get_operand_type(op);

	if (OT_IMMEDIATE == op_type)
	{
		// int immediate
		machine_code[machine_code_address] = 0x5a;
		machine_code_address++;

		//
		machine_code[machine_code_address] = 0xB4;
		machine_code_address++;

		machine_code[machine_code_address] = get_machine_code_from_immediate(op);
		machine_code_address++;
	}
	else
	{
		error_msg_wrong_op(int_instruction_keyword, line_num);
	}

	//
	// ڴݿУǴһָ
	//
	line_database[line_count].flag |= LF_INSTRUCTION;
}

// iret 
void parse_iret(int line_num)
{
	machine_code[machine_code_address] = 0x5d;
	machine_code_address++;

	//
	machine_code[machine_code_address] = 0x44;
	machine_code_address++;

	//
	// ڴݿУǴһָ
	//
	line_database[line_count].flag |= LF_INSTRUCTION;
}

/////////////////////////////////////////////////////////////////
//
// λָ

// sal op1, op2
void parse_sal(int line_num)
{
	char *op1, *op2;
	char rs, rd;
	unsigned long op1_type, op2_type;

	if (assembler_state != AS_TEXT)
	{
		warning_msg_invalid_line(line_num);
		return;
	}

	op1 = strtok(NULL, delimit_char_comma);
	op2 = strtok(NULL, delimit_char);

	if (NULL == op1 || NULL == op2)
	{
		error_msg_miss_op(sal_instruction_keyword, line_num);
	}

	op1_type = get_operand_type(op1);
	op2_type = get_operand_type(op2);

	if ((op1_type >= OT_REGISTER_AL && op1_type <= OT_REGISTER_DI)
		&& (op2_type >= OT_REGISTER_AL && op2_type <= OT_REGISTER_DI))
	{
		// 
		machine_code[machine_code_address] = 0x5f;
		machine_code_address++;

		// ԴĴrs
		rs = get_machine_code_from_r(op2_type);
		rs = rs << 4;

		// ĿĲ
		rd = get_machine_code_from_r(op1_type);

		// 
		machine_code[machine_code_address] = rs | rd;
		machine_code_address++;
	}
	else
	{
		error_msg_wrong_op(sal_instruction_keyword, line_num);
	}

	//
	// ڴݿУǴһָ
	//
	line_database[line_count].flag |= LF_INSTRUCTION;
}

// sar op1, op2
void parse_sar(int line_num)
{
	char *op1, *op2;
	char rs, rd;
	unsigned long op1_type, op2_type;

	if (assembler_state != AS_TEXT)
	{
		warning_msg_invalid_line(line_num);
		return;
	}

	op1 = strtok(NULL, delimit_char_comma);
	op2 = strtok(NULL, delimit_char);

	if (NULL == op1 || NULL == op2)
	{
		error_msg_miss_op(sar_instruction_keyword, line_num);
	}

	op1_type = get_operand_type(op1);
	op2_type = get_operand_type(op2);

	if ((op1_type >= OT_REGISTER_AL && op1_type <= OT_REGISTER_DI)
		&& (op2_type >= OT_REGISTER_AL && op2_type <= OT_REGISTER_DI))
	{
		// 
		machine_code[machine_code_address] = 0x61;
		machine_code_address++;

		// ԴĴrs
		rs = get_machine_code_from_r(op2_type);
		rs = rs << 4;

		// ĿĲ
		rd = get_machine_code_from_r(op1_type);

		// 
		machine_code[machine_code_address] = rs | rd;
		machine_code_address++;
	}
	else
	{
		error_msg_wrong_op(sar_instruction_keyword, line_num);
	}

	//
	// ڴݿУǴһָ
	//
	line_database[line_count].flag |= LF_INSTRUCTION;
}

// shl op1, op2
void parse_shl(int line_num)
{
	char *op1, *op2;
	char rs, rd;
	unsigned long op1_type, op2_type;

	if (assembler_state != AS_TEXT)
	{
		warning_msg_invalid_line(line_num);
		return;
	}

	op1 = strtok(NULL, delimit_char_comma);
	op2 = strtok(NULL, delimit_char);

	if (NULL == op1 || NULL == op2)
	{
		error_msg_miss_op(shl_instruction_keyword, line_num);
	}

	op1_type = get_operand_type(op1);
	op2_type = get_operand_type(op2);

	if ((op1_type >= OT_REGISTER_AL && op1_type <= OT_REGISTER_DI)
		&& (op2_type >= OT_REGISTER_AL && op2_type <= OT_REGISTER_DI))
	{
		// 
		machine_code[machine_code_address] = 0x63;
		machine_code_address++;

		// ԴĴrs
		rs = get_machine_code_from_r(op2_type);
		rs = rs << 4;

		// ĿĲ
		rd = get_machine_code_from_r(op1_type);

		// 
		machine_code[machine_code_address] = rs | rd;
		machine_code_address++;
	}
	else
	{
		error_msg_wrong_op(shl_instruction_keyword, line_num);
	}

	//
	// ڴݿУǴһָ
	//
	line_database[line_count].flag |= LF_INSTRUCTION;
}

// shr op1, op2
void parse_shr(int line_num)
{
	char *op1, *op2;
	char rs, rd;
	unsigned long op1_type, op2_type;

	if (assembler_state != AS_TEXT)
	{
		warning_msg_invalid_line(line_num);
		return;
	}

	op1 = strtok(NULL, delimit_char_comma);
	op2 = strtok(NULL, delimit_char);

	if (NULL == op1 || NULL == op2)
	{
		error_msg_miss_op(shr_instruction_keyword, line_num);
	}

	op1_type = get_operand_type(op1);
	op2_type = get_operand_type(op2);

	if ((op1_type >= OT_REGISTER_AL && op1_type <= OT_REGISTER_DI)
		&& (op2_type >= OT_REGISTER_AL && op2_type <= OT_REGISTER_DI))
	{
		// 
		machine_code[machine_code_address] = 0x65;
		machine_code_address++;

		// ԴĴrs
		rs = get_machine_code_from_r(op2_type);
		rs = rs << 4;

		// ĿĲ
		rd = get_machine_code_from_r(op1_type);

		// 
		machine_code[machine_code_address] = rs | rd;
		machine_code_address++;
	}
	else
	{
		error_msg_wrong_op(shr_instruction_keyword, line_num);
	}

	//
	// ڴݿУǴһָ
	//
	line_database[line_count].flag |= LF_INSTRUCTION;
}

// rol op1, op2
void parse_rol(int line_num)
{
	char *op1, *op2;
	char rs, rd;
	unsigned long op1_type, op2_type;

	if (assembler_state != AS_TEXT)
	{
		warning_msg_invalid_line(line_num);
		return;
	}

	op1 = strtok(NULL, delimit_char_comma);
	op2 = strtok(NULL, delimit_char);

	if (NULL == op1 || NULL == op2)
	{
		error_msg_miss_op(rol_instruction_keyword, line_num);
	}

	op1_type = get_operand_type(op1);
	op2_type = get_operand_type(op2);

	if ((op1_type >= OT_REGISTER_AL && op1_type <= OT_REGISTER_DI)
		&& (op2_type >= OT_REGISTER_AL && op2_type <= OT_REGISTER_DI))
	{
		// 
		machine_code[machine_code_address] = 0x67;
		machine_code_address++;

		// ԴĴrs
		rs = get_machine_code_from_r(op2_type);
		rs = rs << 4;

		// ĿĲ
		rd = get_machine_code_from_r(op1_type);

		// 
		machine_code[machine_code_address] = rs | rd;
		machine_code_address++;
	}
	else
	{
		error_msg_wrong_op(rol_instruction_keyword, line_num);
	}

	//
	// ڴݿУǴһָ
	//
	line_database[line_count].flag |= LF_INSTRUCTION;
}

// ror op1, op2
void parse_ror(int line_num)
{
	char *op1, *op2;
	char rs, rd;
	unsigned long op1_type, op2_type;

	if (assembler_state != AS_TEXT)
	{
		warning_msg_invalid_line(line_num);
		return;
	}

	op1 = strtok(NULL, delimit_char_comma);
	op2 = strtok(NULL, delimit_char);

	if (NULL == op1 || NULL == op2)
	{
		error_msg_miss_op(ror_instruction_keyword, line_num);
	}

	op1_type = get_operand_type(op1);
	op2_type = get_operand_type(op2);

	if ((op1_type >= OT_REGISTER_AL && op1_type <= OT_REGISTER_DI)
		&& (op2_type >= OT_REGISTER_AL && op2_type <= OT_REGISTER_DI))
	{
		// 
		machine_code[machine_code_address] = 0x69;
		machine_code_address++;

		// ԴĴrs
		rs = get_machine_code_from_r(op2_type);
		rs = rs << 4;

		// ĿĲ
		rd = get_machine_code_from_r(op1_type);

		// 
		machine_code[machine_code_address] = rs | rd;
		machine_code_address++;
	}
	else
	{
		error_msg_wrong_op(ror_instruction_keyword, line_num);
	}

	//
	// ڴݿУǴһָ
	//
	line_database[line_count].flag |= LF_INSTRUCTION;
}

// rcl op1, op2
void parse_rcl(int line_num)
{
	char *op1, *op2;
	char rs, rd;
	unsigned long op1_type, op2_type;

	if (assembler_state != AS_TEXT)
	{
		warning_msg_invalid_line(line_num);
		return;
	}

	op1 = strtok(NULL, delimit_char_comma);
	op2 = strtok(NULL, delimit_char);

	if (NULL == op1 || NULL == op2)
	{
		error_msg_miss_op(rcl_instruction_keyword, line_num);
	}

	op1_type = get_operand_type(op1);
	op2_type = get_operand_type(op2);

	if ((op1_type >= OT_REGISTER_AL && op1_type <= OT_REGISTER_DI)
		&& (op2_type >= OT_REGISTER_AL && op2_type <= OT_REGISTER_DI))
	{
		// 
		machine_code[machine_code_address] = 0x6b;
		machine_code_address++;

		// ԴĴrs
		rs = get_machine_code_from_r(op2_type);
		rs = rs << 4;

		// ĿĲ
		rd = get_machine_code_from_r(op1_type);

		// 
		machine_code[machine_code_address] = rs | rd;
		machine_code_address++;
	}
	else
	{
		error_msg_wrong_op(rcl_instruction_keyword, line_num);
	}

	//
	// ڴݿУǴһָ
	//
	line_database[line_count].flag |= LF_INSTRUCTION;
}

// rcr op1, op2
void parse_rcr(int line_num)
{
	char *op1, *op2;
	char rs, rd;
	unsigned long op1_type, op2_type;

	if (assembler_state != AS_TEXT)
	{
		warning_msg_invalid_line(line_num);
		return;
	}

	op1 = strtok(NULL, delimit_char_comma);
	op2 = strtok(NULL, delimit_char);

	if (NULL == op1 || NULL == op2)
	{
		error_msg_miss_op(rcr_instruction_keyword, line_num);
	}

	op1_type = get_operand_type(op1);
	op2_type = get_operand_type(op2);

	if ((op1_type >= OT_REGISTER_AL && op1_type <= OT_REGISTER_DI)
		&& (op2_type >= OT_REGISTER_AL && op2_type <= OT_REGISTER_DI))
	{
		// 
		machine_code[machine_code_address] = 0x6d;
		machine_code_address++;

		// ԴĴrs
		rs = get_machine_code_from_r(op2_type);
		rs = rs << 4;

		// ĿĲ
		rd = get_machine_code_from_r(op1_type);

		// 
		machine_code[machine_code_address] = rs | rd;
		machine_code_address++;
	}
	else
	{
		error_msg_wrong_op(rcr_instruction_keyword, line_num);
	}

	//
	// ڴݿУǴһָ
	//
	line_database[line_count].flag |= LF_INSTRUCTION;
}

//////////////////////////////////////////////////////////////////////////
//
// nop
void parse_nop(int line_num)
{
	machine_code[machine_code_address] = 0x6f;
	machine_code_address++;

	//
	// ڴݿУǴһָ
	//
	line_database[line_count].flag |= LF_INSTRUCTION;
}

//////////////////////////////////////////////////////////////////////////
//
// call symbol
void parse_call(int line_num)
{
	char *op;
	unsigned long op_type;

	if (assembler_state != AS_TEXT)
	{
		warning_msg_invalid_line(line_num);
		return;
	}

	op = strtok(NULL, delimit_char);

	if (NULL == op)
	{
		error_msg_miss_op(call_instruction_keyword, line_num);
	}

	op_type = get_operand_type(op);

	if (OT_SYMBOL == op_type)
	{
		// call symbol
		machine_code[machine_code_address] = 0x71;
		machine_code_address++;

		// ضλ
		add_reallocate(op, line_num);
		machine_code_address++;
	}
	else
	{
		error_msg_wrong_op(call_instruction_keyword, line_num);
	}

	//
	// ڴݿУǴһָ
	//
	line_database[line_count].flag |= LF_INSTRUCTION;
}

/////////////////////////////////////////////////////////////////////////////
//
// ret 
void parse_ret(int line_num)
{
	machine_code[machine_code_address] = 0x73;
	machine_code_address++;

	//
	// ڴݿУǴһָ
	//
	line_database[line_count].flag |= LF_INSTRUCTION;
}

/////////////////////////////////////////////////////////////////////////////
//
// cli 
void parse_cli(int line_num)
{
	machine_code[machine_code_address] = 0x74;
	machine_code_address++;

	//
	// ڴݿУǴһָ
	//
	line_database[line_count].flag |= LF_INSTRUCTION;
}

/////////////////////////////////////////////////////////////////////////////
//
// sti 
void parse_sti(int line_num)
{
	machine_code[machine_code_address] = 0x75;
	machine_code_address++;

	//
	// ڴݿУǴһָ
	//
	line_database[line_count].flag |= LF_INSTRUCTION;
}


// űһ
void add_symbol(const char* symbol, int line_num)
{
	int i;

	// Ʋظ
	for (i = 0; i < symbol_count; i++)
	{
		if (stricmp(symbol, symbol_table[i].name) == 0)
		{
			error_msg_same_symbol(symbol, line_num, symbol_table[i].line_num);
		}
	}

	// 
	if (symbol_count == MAX_SYMBOL_COUNT)
	{
		sprintf(formated_msg, "̫ķšԶ %d š", MAX_SYMBOL_COUNT);
		error_msg(formated_msg, line_num);
	}

	// ӷ
	strcpy(symbol_table[symbol_count].name, symbol);
	symbol_table[symbol_count].address = machine_code_address;
	symbol_table[symbol_count].line_num = line_num;
	symbol_count++;
}

// 
void parse_symbol(const char* symbol_with_colon, int line_num)
{
	char symbol[MAX_SYMBOL_LENGTH];
	char* token;

	// ɾĩβð
	strcpy(symbol, symbol_with_colon);
	symbol[strlen(symbol) - 1] = 0;


	if (AS_TEXT == assembler_state)
	{
		// еıΪš¼űУ롣
		add_symbol(symbol, line_num);

		// ű뵥ռһУ򱨴
		if (strtok(NULL, delimit_char) != NULL)
		{
			error_msg("ű뵥ռһС", line_num);
		}
	}
	else if (AS_DATA == assembler_state)
	{
		// ݶеıΪšһ԰ֽݡ¼űУ롣
		add_symbol(symbol, line_num);

		while ((token = strtok(NULL, delimit_char)) != NULL)
		{
			if (!is_immediate(token))
			{
				error_msg_wrong_data(token, line_num);
			}

			machine_code[machine_code_address] = get_machine_code_from_immediate(token);
			machine_code_address++;
			symbol_table[symbol_count - 1].machine_code_count++;
		}
	}
	else
	{
		warning_msg_invalid_line(line_num);
	}
}

// ж
void parse_int_vector(const char* symbol_with_colon, int line_num)
{
	char symbol[MAX_SYMBOL_LENGTH];
	char* token;

	if (AS_INT_TABLE == assembler_state)
	{
		// ضλ
		add_reallocate(symbol_with_colon, line_num);
		machine_code_address++;

		// ж뵥ռһУ򱨴
		if (strtok(NULL, delimit_char) != NULL)
		{
			error_msg("ж뵥ռһС", line_num);
		}
	}
}

// жʼ־
void parse_int_table_section_keyword(int line_num)
{
	// ж־
	if (AS_TEXT == assembler_state)
	{
		error_msg("жܶڴεĺ档", line_num);
	}
	else if (AS_INT_TABLE == assembler_state)
	{
		error_msg("ظжб", line_num);
	}

	assembler_state = AS_INT_TABLE;
}

// οʼ־
void parse_code_section_keyword(int line_num)
{
	// α־
	if (AS_DATA == assembler_state)
	{
		error_msg("βܶݶεĺ档", line_num);
	}
	else if (AS_TEXT == assembler_state)
	{
		error_msg("ظĴΡ", line_num);
	}

	//ǰַС0x10򲹳
	for (; machine_code_address < 0x10;)
	{
		line_database[line_count].line_num = line_num;
		line_database[line_count].address = machine_code_address;
		machine_code_address++;
		machine_code_old_address++;
	}

	// εʼַΪ0x10
	assembler_state = AS_TEXT;
}

// ݶοʼ־
void parse_data_section_keyword(int line_num)
{
	// ݶα־
	if (AS_DATA == assembler_state)
	{
		error_msg("ظݶΡ", line_num);
	}
	else if (AS_BEGIN == assembler_state)
	{
		error_msg("ݶβܶڴεǰ档", line_num);
	}

	assembler_state = AS_DATA;
}

// ؼֺͽĶӦϵ
typedef void(*PARSE_FUNCTION)(int line_num);
struct KEYWORD_FUNCTION_ENTRY
{
	const char** keyword;
	PARSE_FUNCTION parse_function;
};

//
// 뽫ؼּıСӶʹáıģʽ
//
struct KEYWORD_FUNCTION_ENTRY keyword_function_table[] =
{
	{ NULL,								NULL }	// δ

	,{ &int_table_section_keyword,			parse_int_table_section_keyword }
	,{ &code_section_keyword,				parse_code_section_keyword }
	,{ &data_section_keyword,				parse_data_section_keyword }

	,{ &mov_instruction_keyword,			parse_mov }
	,{ &jmp_instruction_keyword,			parse_jmp }
	,{ &add_instruction_keyword,			parse_add }
	,{ &adc_instruction_keyword,			parse_adc }
	,{ &sub_instruction_keyword,			parse_sub }
	,{ &sbb_instruction_keyword,			parse_sbb }
	,{ &and_instruction_keyword,			parse_and }
	,{ &or_instruction_keyword,				parse_or }
	,{ &jc_instruction_keyword,				parse_jc }
	,{ &jz_instruction_keyword,				parse_jz }
	,{ &je_instruction_keyword,				parse_jz }
	,{ &jnz_instruction_keyword,			parse_jnz }
	,{ &jne_instruction_keyword,			parse_jnz }
	,{ &call_instruction_keyword,			parse_call }

	,{ &push_instruction_keyword,			parse_push }
	,{ &pop_instruction_keyword,			parse_pop }

	,{ &in_instruction_keyword,				parse_in }
	,{ &out_instruction_keyword,			parse_out }
	,{ &ret_instruction_keyword,			parse_ret }
	,{ &shr_instruction_keyword,			parse_shr }
	,{ &shl_instruction_keyword,			parse_shl }
	,{ &rcr_instruction_keyword,			parse_rcr }
	,{ &rcl_instruction_keyword,			parse_rcl }

	,{ &sal_instruction_keyword,			parse_sal }
	,{ &sar_instruction_keyword,			parse_sar }
	,{ &rol_instruction_keyword,			parse_rol }
	,{ &ror_instruction_keyword,			parse_ror }
	,{ &not_instruction_keyword,			parse_not }
	,{ &iret_instruction_keyword,			parse_iret }
	,{ &nop_instruction_keyword,			parse_nop }
	,{ &int_instruction_keyword,			parse_int }
	,{ &lea_instruction_keyword,			parse_lea }
	,{ &inc_instruction_keyword,			parse_inc }
	,{ &dec_instruction_keyword,			parse_dec }
	,{ &cmp_instruction_keyword,			parse_cmp }

	,{ &cli_instruction_keyword,			parse_cli }
	,{ &sti_instruction_keyword,			parse_sti }

	,{ &al_register_keyword,				NULL }
	,{ &bl_register_keyword,				NULL }
	,{ &cl_register_keyword,				NULL }
	,{ &dl_register_keyword,				NULL }

	,{ &sp_register_keyword,				NULL }
	,{ &bp_register_keyword,				NULL }
	,{ &si_register_keyword,				NULL }
	,{ &di_register_keyword,				NULL }

	,{ &cs_register_keyword,				NULL }
	,{ &ds_register_keyword,				NULL }
	,{ &ss_register_keyword,				NULL }
	,{ &es_register_keyword,				NULL }

	,{ &al_register_indirect_keyword,		NULL }
	,{ &bl_register_indirect_keyword,		NULL }
	,{ &cl_register_indirect_keyword,		NULL }
	,{ &dl_register_indirect_keyword,		NULL }

	,{ &sp_register_indirect_keyword,		NULL }
	,{ &bp_register_indirect_keyword,		NULL }
	,{ &si_register_indirect_keyword,		NULL }
	,{ &di_register_indirect_keyword,		NULL }

	,{ &cs_register_indirect_keyword,		NULL }
	,{ &ds_register_indirect_keyword,		NULL }
	,{ &ss_register_indirect_keyword,		NULL }
	,{ &es_register_indirect_keyword,		NULL }

};

// жǷһؼ֡0ǹؼ֣ط0ǹؼ֣ҷֵǹؼڱе±ꡣ
int match_keyword(const char* token)
{
	int i;

	for (i = 1; i < sizeof(keyword_function_table) / sizeof(keyword_function_table[0]); i++)
	{
		if (stricmp(token, *keyword_function_table[i].keyword) == 0)
		{
			return i;
		}
	}

	return 0;
}

// жǷһ
int is_symbol(const char* token, int line_num)
{
	int i;
	char symbol_name[MAX_SYMBOL_LENGTH];

	// һַð
	if (token[strlen(token) - 1] != ':')
	{
		return 0;
	}

	// һַĸ»
	if (token[0] != '_' && !isalpha(token[0]))
	{
		return 0;
	}

	// ַĸ֡»
	for (i = 0; i < (int)strlen(token) - 2; i++)
	{
		if (token[i] != '_' && !isalpha(token[i]) && !isdigit(token[i]))
		{
			return 0;
		}
	}

	// ؼͬ
	strcpy(symbol_name, token);
	symbol_name[strlen(symbol_name) - 1] = 0;
	if (match_keyword(symbol_name) != 0)
	{
		error_msg_keyword_symbol(symbol_name, line_num);
	}

	return 1;
}

// жǷһж
int is_int_vector(const char* token, int line_num)
{
	int i;
	char vector_name[MAX_SYMBOL_LENGTH];

	// һַĸ»
	if (token[0] != '_' && !isalpha(token[0]))
	{
		return 0;
	}

	// ַĸ֡»
	for (i = 0; i < (int)strlen(token) - 2; i++)
	{
		if (token[i] != '_' && !isalpha(token[i]) && !isdigit(token[i]))
		{
			return 0;
		}
	}

	// ؼͬ
	strcpy(vector_name, token);
	if (match_keyword(vector_name) != 0)
	{
		error_msg_keyword_int_vector(vector_name, line_num);
	}

	return 1;
}


// 汾Ϣ
void version_msg()
{
	printf(
		"Engintime 8086 [汾 2.0]\n"
		"Ȩ (c) 2008-2018 ӢʱƼ޹˾Ȩ\n"
	);
}

// Ϣ
void help_msg()
{
	printf(
		"Engintime 8086\n\n"
		"÷:\n\n"
		"  dmasm.exe assembly_file_name [options]\n\n"
		"ѡ:\n\n"
		"  -g debug_file_name\tָɵĵϢļ·\n"
		"  -h\t\t\tӡ˰Ϣ\n"
		"  -l list_file_name\tָɵбļ·\n"
		"  -o target_file_name\tָɵĿļ·δָĬ a.obj ļ\n"
		"  -v\t\t\tӡ汾Ϣ\n"
	);

	printf("\n");

	version_msg();

	exit(1);
}

void argument_error_msg()
{
	printf("в\n\n");
	help_msg();
}

// ûв
void process_argument(int argc, char* argv[])
{
	int i;

	// argv[0]  "easm.exe"ԿԺԡ
	for (i = 1; i < argc; i++)
	{
		if (strcmp(argv[i], "-v") == 0)
		{
			version_msg();
			exit(1);
		}
		else if (strcmp(argv[i], "-h") == 0)
		{
			help_msg();
		}
		else if (strcmp(argv[i], "-o") == 0)
		{
			if (i + 1 < argc)
			{
				i++;
				target_file_name = argv[i];
			}
			else
			{
				argument_error_msg();
			}
		}
		else if (strcmp(argv[i], "-l") == 0)
		{
			if (i + 1 < argc)
			{
				i++;
				list_file_name = argv[i];
			}
			else
			{
				argument_error_msg();
			}
		}
		else if (strcmp(argv[i], "-g") == 0)
		{
			if (i + 1 < argc)
			{
				i++;
				dbg_file_name = argv[i];
			}
			else
			{
				argument_error_msg();
			}
		}
		else if (NULL == assembly_file_name && argv[i][0] != '-')
		{
			// ĻԴļ·
			assembly_file_name = argv[i];
		}
		else
		{
			argument_error_msg();
		}
	}

	//
	// вûָĻļʹӡϢ˳
	//
	if (NULL == assembly_file_name)
	{
		printf("вûָԴļ·\n");
		help_msg();
	}
}

// һַдļСȽַдļȻַе
// ÿַдļַĩβ 0.
void write_string_to_binary_file(const char* str, FILE* fp)
{
	int str_length;

	if (str != NULL)
	{
		str_length = strlen(str);
		fwrite(&str_length, 1, sizeof(str_length), fp);
		fwrite(str, 1, str_length, fp);
	}
	else
	{
		str_length = 0;
		fwrite(&str_length, 1, sizeof(str_length), fp);
	}
}


int main(int argc, char* argv[])
{
	FILE* fp;
	char* token;
	char line[MAX_LINE_LENGTH];
	int i, j;
	int line_num = 1;	// кŴӵһпʼ
	int keyword_index;

	//
	// в
	//
	process_argument(argc, argv);

	//
	// 򿪻Դļ
	//
	fp = fopen(assembly_file_name, "r");
	if (NULL == fp)
	{
		printf("޷Դļ %s\n", assembly_file_name);
		return 1;
	}

	//////////////////////////////////////////////////////////////////////////
	// һɨ

	version_msg();
	printf("\nڻ %s...\n", assembly_file_name);

	//
	// һζȡһıͬʱ¼еĴϢ
	//
	while (fgets(line, sizeof(line), fp) != NULL)
	{
		//
		// һдϢ¼ݿ
		//
		strcpy(line_database[line_count].line_string, line);
		line_database[line_count].line_num = line_num;
		line_database[line_count].address = machine_code_address;

		//
		// еעͰ
		//
		line[strcspn(line, ";")] = 0;

		//
		// ʼ
		//
		token = strtok(line, delimit_char);
		if (NULL == token)
		{
			// ǿУκδ
		}
		else if ((keyword_index = match_keyword(token)) != 0
			&& keyword_function_table[keyword_index].parse_function != NULL)
		{
			// ݹؼֽӦĴ
			keyword_function_table[keyword_index].parse_function(line_num);
		}
		else if (is_int_vector(token, line_num))
		{
			// жǷжȻжǷǱšΪжϱŵʱɾһ־ַжƺûðŵ
			// ж
			parse_int_vector(token, line_num);

			// жϷ
			if (is_symbol(token, line_num))
			{
				// 
				parse_symbol(token, line_num);
			}

		}
		else
		{
			error_msg("޷ʶĴС", line_num);
		}

		//
		// ݿϢ
		//
		line_database[line_count].machine_code_count = machine_code_address - machine_code_old_address;
		machine_code_old_address = machine_code_address;

		//
		// ַǷ񳬹ַ򱨴(һַԪ洢һֽڻ)
		//
		// 
		if (MAX_MACHINE_CODE_BYTE_COUNT == machine_code_address)
		{
			sprintf(formated_msg, "Ļֻ࣬ %d ֽڻ롣", MAX_MACHINE_CODE_BYTE_COUNT);
			error_msg(formated_msg, -1);
		}

		//
		// ¼˻Ĵ
		//
		if (line_database[line_count].machine_code_count != 0)
		{
			machine_code_line_count++;
		}

		//
		// к
		//
		line_count++;
		line_num++;

		if (line_count == MAX_LINE_COUNT)
		{
			sprintf(formated_msg, "ļеĴйֻ࣬ %d д롣", MAX_LINE_COUNT);
			error_msg(formated_msg, -1);
		}
	}

	fclose(fp);

	//////////////////////////////////////////////////////////////////////////
	// ڶɨ

	//
	// ݷűضλ
	//
	for (i = 0; i < reallocate_count; i++)
	{
		for (j = 0; j < symbol_count; j++)
		{
			if (stricmp(symbol_table[j].name, reallocate_table[i].symbol_name) == 0)
			{
				machine_code[reallocate_table[i].address] = (BYTE)symbol_table[j].address;
				symbol_table[j].ref_count++;

				break;
			}
		}

		if (j == symbol_count)
		{
			// ضλʹõķڷűδ壬
			sprintf(formated_msg, "ʹδķ %s", reallocate_table[i].symbol_name);
			error_msg(formated_msg, reallocate_table[i].line_num);
		}
	}

	//
	// δõķţϢ
	//
	for (i = 0; i < symbol_count; i++)
	{
		if (0 == symbol_table[i].ref_count)
		{
			warning_msg_unref_symbol(symbol_table[i].name, symbol_table[i].line_num);
		}
	}

	//////////////////////////////////////////////////////////////////////////
	// ļ

	//
	// дļ
	//
	if (NULL == target_file_name)
	{
		target_file_name = "a.obj";
	}

	fp = fopen(target_file_name, "wb");
	if (NULL == fp)
	{
		printf("޷ļ %s\n", target_file_name);
		return 1;
	}

	fwrite(machine_code, 1, machine_code_address, fp);

	fclose(fp);

	printf("\nĿļ %s\n", target_file_name);

	//
	// ݿеϢдбļ
	//
	if (list_file_name != NULL)
	{
		fp = fopen(list_file_name, "w");
		if (NULL == fp)
		{
			printf("޷бļ %s\n", list_file_name);
			return 1;
		}

		for (i = 0; i < line_count; i++)
		{
			// к
			fprintf(fp, "%04d    ", line_database[i].line_num);

			// ַͻ
			if (line_database[i].machine_code_count > 0)
			{
				fprintf(fp, "%02X    ", line_database[i].address);

				for (j = 0; j < line_database[i].machine_code_count; j++)
				{
					// ȷÿдֽڵĻ
					if (j != 0 && j % 3 == 0)
					{
						if (3 == j)
						{
							fprintf(fp, "              ");
						}
						else
						{
							fprintf(fp, "\n        ");
						}
					}

					fprintf(fp, "%02X ", machine_code[line_database[i].address + j]);


					if (2 == j)
					{
						fprintf(fp, "  ");
						fprintf(fp, line_database[i].line_string);
					}
				}

				if (1 == j)
				{
					// ָֽ
					fprintf(fp, "        ");
					fprintf(fp, line_database[i].line_string);
				}
				else if (2 == j)
				{
					fprintf(fp, "     ");
					fprintf(fp, line_database[i].line_string);
				}
				else if (j > 3)
				{
					fprintf(fp, "\n");
				}
			}
			else
			{
				fprintf(fp, "                 ");

				// Դ
				fprintf(fp, line_database[i].line_string);
			}
		}

		fclose(fp);

		printf("бļ %s\n", list_file_name);
	}

	//
	// ݿеϢдƵĵϢļ
	//
	// ϢĻʽΪ
	// ħ4ֽڣ̶ɸı
	// 汾ţ4ֽڣ̶ɸı
	// Դļ·ַȣ4ֽڣ
	// Դļ·ַַβ0
	// бļ·ַȣ4ֽڣ
	// бļ·ַַβ0
	//
	// ݿԪص4ֽڣ
	// ݿеԪ
	//
	// űԪص4ֽڣ
	// űеԪ
	//

	if (dbg_file_name != NULL)
	{
		fp = fopen(dbg_file_name, "wb");
		if (NULL == fp)
		{
			printf("޷򿪵Ϣļ %s\n", dbg_file_name);
			return 1;
		}

		// ħ
		fwrite(&dbg_file_magic, 1, sizeof(dbg_file_magic), fp);

		// 汾
		fwrite(&dbg_file_version, 1, sizeof(dbg_file_version), fp);

		// Դļ·
		write_string_to_binary_file(assembly_file_name, fp);

		// бļ·
		write_string_to_binary_file(list_file_name, fp);

		// ݿеԪ
		fwrite(&machine_code_line_count, 1, sizeof(machine_code_line_count), fp);
		for (i = 0; i < line_count; i++)
		{
			// ûвĴ
			if (0 == line_database[i].machine_code_count)
			{
				continue;
			}

			fwrite(&line_database[i].line_num, 1, sizeof(unsigned long), fp);
			fwrite(&line_database[i].address, 1, sizeof(unsigned long), fp);
			fwrite(&line_database[i].machine_code_count, 1, sizeof(unsigned long), fp);
			fwrite(&line_database[i].flag, 1, sizeof(unsigned long), fp);
		}

		// űеԪ
		fwrite(&symbol_count, 1, sizeof(symbol_count), fp);
		for (i = 0; i < symbol_count; i++)
		{
			write_string_to_binary_file(symbol_table[i].name, fp);
			fwrite(&symbol_table[i].address, 1, sizeof(unsigned long), fp);
			fwrite(&symbol_table[i].machine_code_count, 1, sizeof(int), fp);
			fwrite(&symbol_table[i].line_num, 1, sizeof(int), fp);
		}

		fclose(fp);

		printf("ɵϢļ %s\n", dbg_file_name);
	}

	return 0;
}


