#include "RegexpToNFA.h"
#include "RegexpToPost.h"
#include "NFAFragmentStack.h"
#include "OutputResult.h"
#include <stdlib.h>

NFAFragmentStack FragmentStack;	// ջڴ NFA Ƭ

char* regexp = "ab";		//  1
// char* regexp = "a|b";	//  2
// char* regexp = "a*";		//  3
// char* regexp = "a?";		//  4
// char* regexp = "a+";		//  5
// char* regexp = "a(a|1)*";//  6
// char* regexp = "(aa|b)*a(a|bb)*";//  7
// char* regexp = "(a|b)*a(a|b)?"; 	//  8

char regexp_ci[256];

int main(int argc, char **argv)
{
	char *post;
	NFAState *start;
	

	//  CP Labִгʱʹ궨Ĵ룬ύҵˮʱŻʹú궨Ĵ롣
	// 궨Ĵˮʱinput.txtļжȡʽ֤
	// Уinput1.txt  input8.txtļаʽ1  8ʽǶӦġ
#ifdef CODECODE_CI	
	scanf("%255s", regexp_ci);  
	regexp = regexp_ci;  
#endif
			
	//
	// ʼջ
	//
	InitNFAFragmentStack(&FragmentStack);
	
	//
	//  re2post ʽַתɽĺ
	//
	post = re2post(regexp);
	
	//
	//  post2nfa ĺתΪ NFA ؿʼ״̬
	//
	start = post2nfa(post);
	
	//
	//  NFA ӡ
	//
	OutputResult(start);
				
	return 0;
}

/*
ܣ
	ʼһ״̬
	  
ֵ
	״ָ̬롣
*/
int nstate = 1;  // ״̬
NFAState* CreateNFAState()
{
	NFAState *s = (NFAState*)malloc(sizeof(NFAState));

	s->Name = nstate++;
	s->Transform = '\0';
	s->Next1 = NULL;
	s->Next2 = NULL;
	s->AcceptFlag = 0;
	
	return s;
}

/*
ܣ
	ʼ״̬ͽ״̬һ Fragment
	

	StartState -- ʼ״̬
	AcceptState -- ״̬	
	  
ֵ
	 Fragment ṹָ롣
*/
NFAFragment MakeNFAFragment(NFAState *StartState, NFAState *AcceptState)
{
	NFAFragment n = {StartState, AcceptState};
	return n;
}

/*
ܣ
	ĺתΪ NFA


	postfix -- ĺָ롣
	  
ֵ
	NFA Ŀʼ״ָ̬롣
*/
const char VoidTrans = '$'; // ʾת
NFAState* post2nfa(char *postfix)
{
	char *p;							   		// α
	NFAFragment fragment1, fragment2, fm;     	// NFA Ƭνṹ
	NFAFragment fragment = {0, 0};			   	// ʼڷص NFA Ƭ
	NFAState *NewStartState, *NewAcceptState; 	// ʼ״̬ͽ״ָ̬
	
	for(p=postfix; *p != '\0'; p++)
	{
		switch(*p)
		{
			default:	// 쵥ַ NFA Ƭ
				//  CreateNFAState µ״̬
				NewStartState = CreateNFAState();
				NewAcceptState = CreateNFAState();
				// ʼ״ַ̬ͨת״̬
				NewStartState->Transform = *p;
				NewStartState->Next1 = NewAcceptState;
				NewAcceptState->AcceptFlag = 1;
				//  MakeNFAFragment һµ NFA Ƭ, ջ
				fm = MakeNFAFragment(NewStartState, NewAcceptState);
				PushNFAFragment(&FragmentStack, fm);
				break;
			case '.':	//  NFA Ƭ
				// ջƬγջµ NFA Ƭ
				fragment2 = PopNFAFragment(&FragmentStack);
				fragment1 = PopNFAFragment(&FragmentStack);
				// Ƭ 1 ͨתƬ 2 
				fragment1.AcceptState->AcceptFlag = 0;
				fragment1.AcceptState->Next1 = fragment2.StartState;
				fragment1.AcceptState->Transform = VoidTrans;
				//  MakeNFAFragment һµ NFA Ƭ, ջ
				fm = MakeNFAFragment(fragment1.StartState, fragment2.AcceptState);
				PushNFAFragment(&FragmentStack, fm);
				break;
			case '|':	// ѡ NFA Ƭ
				
				//
				// TODO: ڴӴ
				//
								
				break;
			case '*':	// Ǻ NFA Ƭ
				
				//
				// TODO: ڴӴ
				//
								
				break;
			case '?':	// ʺ NFA Ƭ
				
				//
				// TODO: ڴӴ
				//
								
				break;
			case '+':	// Ӻ NFA Ƭ
				
				//
				// TODO: ڴӴ
				//
				
				break;

		}
	}
	
	//
	//  NFA սջ浽 fragment 
	//
	fragment = PopNFAFragment(&FragmentStack);

	return fragment.StartState;
}

