#include "NFAToDFA.h"
#include "RegexpToPost.h"
#include "PostToNFA.h"
#include "NFAStateStack.h"
#include "NFAFragmentStack.h"
#include "OutputResult.h"
#include <stdlib.h>

NFAFragmentStack FragmentStack; // ջڴ NFA Ƭ
NFAStateStack StateStack;		// ջڴ NFA ״̬

const char VoidTrans = '$'; // ʾת


char* regexp = "a(a|1)*";			 //  1
// char* regexp = "(aa|b)*a(a|bb)*"; //  2
// char* regexp = "(a|b)*a(a|b)?"; 	 //  3

char regexp_ci[256];

int main(int argc, char **argv)
{
	char *post;
	DFA* dfa = (DFA*)malloc(sizeof(DFA));
	dfa->length = 0;
	
	//
	// ʼջ
	//
	InitNFAFragmentStack(&FragmentStack);
	
	//  CP Labִгʱʹ궨Ĵ룬ύҵˮʱ궨ⲿִ롣
	// 궨ˮʱinput.txtļжȡʽ֤
	// Уinput1.txt  input3.txtļаʽ1  3ʽǶӦġ	
#ifdef CODECODE_CI
	scanf("%255s", regexp_ci);
	regexp = regexp_ci;  	 
#endif	
	
	//
	//  re2post ʽַתɽĺ
	//
	post = re2post(regexp);
	
	//
	//  post2dfa ĺתΪ DFA 
	//
	dfa = post2dfa(dfa, post);
	
	//
	//  DFA ӡ
	//
	OutputResult(dfa);
				
	return 0;
}

/*
ܣ
	һ DFA ״̬ת
	

	TransformChar -- תš
	NFAStateArray -- NFA ״ָ̬顣
	Count -- Ԫظ	
	  
ֵ
	 Transform ṹָ롣
*/
Transform* CreateDFATransform(char TransformChar, NFAState** NFAStateArray, int Count)
{
	int i;
	Transform* pTransform = (Transform*)malloc(sizeof(Transform));
	
	for (i=0; i<Count; i++)
	{
		pTransform->NFAlist[i] = NFAStateArray[i];
	}
	
	pTransform->NFAStateCount = Count;	
	pTransform->TransformChar = TransformChar;
	pTransform->DFAStateIndex = -1;
	pTransform->NextTrans = NULL;
	
	return pTransform;
}

/*
ܣ
	һ DFA ״̬
	

	pTransform -- DFA ״̬תָ롣	
	  
ֵ
	 DFAState ṹָ롣
*/
DFAState* CreateDFAState(Transform* pTransform)
{
	int i;
	DFAState* pDFAState = (DFAState*)malloc(sizeof(DFAState));
	
	for (i=0; i<pTransform->NFAStateCount; i++)
	{
		pDFAState->NFAlist[i] = pTransform->NFAlist[i];
	}

	pDFAState->NFAStateCount = pTransform->NFAStateCount;
	pDFAState->firstTran = NULL;

	return pDFAState;
}

/*
ܣ
	жһתе NFA ״̬ǷΪĳһ DFA ״̬ NFA ״̬ϵӼ
	

	pDFA -- DFA ָ롣
	pTransform -- DFA ״̬תָ롣	
	  
ֵ
	 ڷ DFA ״̬±꣬ڷ -1
*/
int NFAStateIsSubset(DFA* pDFA, Transform* pTransform)
{
	//
	// TODO: ڴӴ
	//		
}

/*
ܣ
	жĳ DFA ״̬תǷѾһַת
	

	pDFAState -- DFAState ָ롣
	TransformChar -- תʶ
	  
ֵ
	 Transform ṹָ롣
*/
Transform* IsTransformExist(DFAState* pDFAState, char TransformChar)
{
	//
	// TODO: ڴӴ
	//
}

/*
ܣ
	һ NFA Ϻϲһ DFA תе NFA С
	ע⣬ϲ NFA вӦظ NFA ״̬
	

	NFAStateArray -- NFA ״ָ̬飬 NFA ϡ
	Count --  NFA Ԫظ
	pTransform -- תָ롣
*/
void AddNFAStateArrayToTransform(NFAState** NFAStateArray, int Count, Transform* pTransform)
{
	//
	// TODO: ڴӴ
	//
}

/*
ܣ
	ʹö㷨һ NFA ״̬Ħ-հ
	

	State -- NFA ״ָ̬롣Ӵ NFA ״̬ʼ-հ
	StateArray -- NFA ״ָ̬顣ڷئ-հ
	Count -- Ԫظ	ڷئ-հ NFA ״̬ĸ
*/
void Closure(NFAState* State, NFAState** StateArray, int* Count)
{
	InitNFAStateStack(&StateStack); //  InitNFAStateStack ʼջ
	
	//
	// TODO: ڴӴ
	//
}

/*
ܣ
	ĺתΪ DFA


	pDFA -- DFA ָ롣
	postfix -- ʽĽС
	  
ֵ
	DFA ָ롣
*/
NFAState* Start = NULL;
DFA* post2dfa(DFA* pDFA, char *postfix)
{
	int i, j;								// α
	Transform* pTFCursor;  					// תָ
	NFAState* NFAStateArray[MAX_STATE_NUM]; // NFA ״ָ̬顣ڱ-հ
	int Count = 0;							// -հԪظ
	
	//
	//  post2nfa ĺתΪ NFA ؿʼ״̬
	//
	Start = post2nfa(postfix);
	
	//
	//  Closure 쿪ʼ״̬Ħ-հ
	//
	Closure(Start, NFAStateArray, &Count);

	//  CreateDFATransform һת(תַ)
	// Ȼ󣬵 CreateDFAState øոմת½һ DFA ״̬
	Transform* pTransform = CreateDFATransform('\0', NFAStateArray, Count);
	DFAState* pDFAState = CreateDFAState(pTransform);

	//  DFA ״̬뵽 DFA ״̬Ա
	pDFA->DFAlist[pDFA->length++] = pDFAState;

	// Ա DFA ״̬
	for(i=0; i<pDFA->length; i++)
	{
		//  i  DFA ״̬е NFA ״̬
		for(j=0; j<pDFA->DFAlist[i]->NFAStateCount; j++)
		{
			NFAState* NFAStateTemp = pDFA->DFAlist[i]->NFAlist[j];

			//  NFA ״̬ǽ״̬תǿת NFA ״̬
			if(NFAStateTemp->Transform == VoidTrans || NFAStateTemp->AcceptFlag == 1)
				continue;

			//  Closure  NFA ״̬Ħ-հ
			Closure(NFAStateTemp->Next1, NFAStateArray, &Count);

			//  IsTransfromExist жϵǰ DFA ״̬תǷѾڸ NFA ״̬ת
			pTransform = IsTransformExist(pDFA->DFAlist[i], NFAStateTemp->Transform);
			if(pTransform == NULL)
			{
				// ڣ CreateDFATransform һתת뵽תĿʼλ
				
				//
				// TODO: ڴӴ
				//
				
			}
			else
			{
				//ڣ AddNFAStateArrayToTransform Ѧ-հϲѴڵת
				
				//
				// TODO: ڴӴ
				//
				
			}
		}

		//  DFA ״̬תÿתӦ DFA ״̬
		for(pTFCursor = pDFA->DFAlist[i]->firstTran; pTFCursor != NULL; pTFCursor = pTFCursor->NextTrans)
		{
			//  NFAStateIsSubset жתе NFA ״̬ǷΪĳһ DFA ״̬ NFA ״̬ϵӼ
			int Index = NFAStateIsSubset(pDFA, pTFCursor);
			if(Index == -1)
			{
				// Ӽ CreateDFAState һµ DFA ״̬ DFA Ա
				// ת DFAStateIndex ֵΪ¼ DFA ״̬±
				
				//
				// TODO: ڴӴ
				//
				
			}
			else
			{
				// Ӽת DFAStateIndex ֵΪ Index
				
				//
				// TODO: ڴӴ
				//
				
			}
		}
	}

	return pDFA;
}
