#include "RemoveLeftRecursion.h"
#include <string.h>
#include <stdlib.h>

const char* VoidSymbol = "$"; // ""
const char* Postfix = "'";

char rule_table_ci[20][256];
char ruleNameArr[20][64];

int main(int argc, char* argv[])
{
	//
	//  InitRules ʼķ
	//
	
#ifdef CODECODE_CI
	Rule* pHead = InitRules_CI();  	// дˮ
#else
	Rule* pHead = InitRules();		// д CP Lab 
#endif

	//
	// ݹ֮ǰķ
	//
	printf("Before Remove Left Recursion:\n");
	PrintRule(pHead);

	//
	//  RemoveLeftRecursion ķеݹ
	//
	RemoveLeftRecursion(pHead);
	
	//
	// ݹ֮ķ
	//
	printf("\nAfter Remove Left Recursion:\n");
	PrintRule(pHead);
	
	return 0;
}

/*
ܣ
	жϵǰ Rule еһ Symbol ǷҪ滻
	 Symbol һս Symbol Ӧ
	Rule ڵǰ Rule ֮ǰҪ滻


	pCurRule -- ǰ Rule ָ롣
	pSymbol -- Symbol ָ롣
	  
ֵ
	Ҫ滻 1
	Ҫ滻 0
*/
int SymbolNeedReplace(const Rule* pCurRule, const RuleSymbol* pSymbol)
{

	//
	// TODO: ڴӴ
	//
	
}

/*
ܣ
	һ Symbol


	pSymbolTemplate -- Ҫ Symbol ָ롣
	  
ֵ
	õ Symbol ָ롣
*/
RuleSymbol* CopySymbol(const RuleSymbol* pSymbolTemplate)
{

	//
	// TODO: ڴӴ
	//

}

/*
ܣ
	һ Select


	pSelectTemplate -- Ҫ Select ָ롣
	  
ֵ
	õ Select ָ롣
*/
RuleSymbol* CopySelect(const RuleSymbol* pSelectTemplate)
{

	//
	// TODO: ڴӴ
	//

}

/*
ܣ
	滻һ Select ĵһ Symbol


	pSelectTemplate -- Ҫ滻 Select ָ롣
	  
ֵ
	滻õ Select ָ롣
	ע⣬滻ܻһµ Select
	Ҳܻж Select һ
*/
RuleSymbol* ReplaceSelect(const RuleSymbol* pSelectTemplate)
{

	//
	// TODO: ڴӴ
	//

}

/*
ܣ
	ͷһ Select ڴ档


	pSelect -- Ҫͷŵ Select ָ롣
*/
void FreeSelect(RuleSymbol* pSelect)
{

	//
	// TODO: ڴӴ
	//

}

/*
ܣ
	жһ Rule Ƿݹ顣


	prRule -- Rule ָ롣
	  
ֵ
	ڷ 1
	ڷ 0
*/
int RuleHasLeftRecursion(Rule* pRule)
{

	//
	// TODO: ڴӴ
	//

}

/*
ܣ
	һ Symbol ӵ Select ĩβ


	pSelect -- Select ָ롣
	pNewSymbol -- Symbol ָ롣
*/
void AddSymbolToSelect(RuleSymbol* pSelect, RuleSymbol* pNewSymbol)
{

	//
	// TODO: ڴӴ
	//

}

/*
ܣ
	һ Select 뵽ķĩβ Select Ϊ NULL ʱͽһս뵽ķĩβ


	pRule -- ķָ롣
	pNewSelect -- Select ָ롣
*/
void AddSelectToRule(Rule* pRule, RuleSymbol* pNewSelect)
{

	//
	// TODO: ڴӴ
	//

}

/*
ܣ
	ݹ顣


	pHead -- ķͷָ롣
*/
void RemoveLeftRecursion(Rule* pHead)
{
	Rule* pRule;				// Rule α
	RuleSymbol* pSelect; 		// Select α
	Rule* pNewRule;			  	// Rule ָ
	int isChange;				// Rule Ƿ滻ı
	RuleSymbol **pSelectPrePtr; // Symbol ָָ
	
	for(pRule = pHead; pRule != NULL; pRule = pRule->pNextRule)
	{
		//
		// 滻
		//
		do
		{
			isChange = 0;

			//  Rule  Select вǷҪ滻
			for(pSelect = pRule->pFirstSymbol, pSelectPrePtr = &pRule->pFirstSymbol;
				pSelect != NULL;
				pSelectPrePtr = &pSelect->pOther, pSelect = pSelect->pOther)
			{
				if(SymbolNeedReplace(pRule, pSelect)) // ж Select ĵһ Symbol ǷҪ滻
				{
					isChange = 1;

					//  ReplaceSelect 滻 Select ĵһ Symbol õµ Selects
					RuleSymbol* pNewSelects = ReplaceSelect(pSelect);

					// ʹµ Selects 滻ԭе Select FreeSelect ͷԭе Select ڴ
					
					//
					// TODO: ڴӴ
					//					

					break;
				}

				if(isChange)
					break;
			}
		}while(isChange);

		// ûݹ Rule;
		if(!RuleHasLeftRecursion(pRule))
			continue;

		//
		// ݹ
		//
		pNewRule = CreateRule(pRule->RuleName); //  Rule
		strcat(pNewRule->RuleName, Postfix);

		pSelect = pRule->pFirstSymbol; // ʼ Select α
		pSelectPrePtr = &pRule->pFirstSymbol;
		while(pSelect != NULL) // ѭе Select
		{
			if(0 == pSelect->isToken && pSelect->pRule == pRule) // Select ݹ
			{
				// Ƴݹ SelectתΪҵݹӵ Rule ĩβƶα
				
				//
				// TODO: ڴӴ
				//
				
			}
			else // Select ݹ
			{
				// ûݹ Select ĩβָ Rule ķսƶα
				
				//
				// TODO: ڴӴ
				//
			}
		}

		//  Rule ( '$' )
		//  Rule ķ
		
		//
		// TODO: ڴӴ
		//

		pRule = pNewRule;
	}
}

/*
ܣ
	ʹøݳʼķ

ֵ
	Rule ָ
*/
typedef struct _SYMBOL
{
	int isToken;
	char Name[MAX_STR_LENGTH];
}SYMBOL;

typedef struct _RULE_ENTRY
{
	char RuleName[MAX_STR_LENGTH];
	SYMBOL Selects[64][64];
}RULE_ENTRY;

static const RULE_ENTRY rule_table[] =
{
	/* A -> Ba | Aa | c */
	{ "A", 
			{
				{ { 0, "B" }, { 1, "a"} },
				{ { 0, "A" }, { 1, "a"} },
				{ { 1, "c" } }
			}	
	},

	/* B -> Bb | Ab | d */
	{ "B", 
			{
				{ { 0, "B" }, { 1, "b"} },
				{ { 0, "A" }, { 1, "b"} },
				{ { 1, "d" } }
			}	
	}
};

/*
ܣ
	ʼķ
	
ֵ
	ķͷָ롣
*/
Rule* InitRules()
{
	Rule *pHead, *pRule;
	RuleSymbol **pSymbolPtr1, **pSymbolPtr2;
	int nRuleCount = sizeof(rule_table) / sizeof(rule_table[0]);
	int i, j, k;

	Rule** pRulePtr = &pHead;
	for (i=0; i<nRuleCount; i++)
	{
		*pRulePtr = CreateRule(rule_table[i].RuleName);
		pRulePtr = &(*pRulePtr)->pNextRule;
	}

	pRule = pHead;
	for (i=0; i<nRuleCount; i++)
	{
		pSymbolPtr1 = &pRule->pFirstSymbol;
		for (j=0; rule_table[i].Selects[j][0].Name[0] != '\0'; j++)
		{
			pSymbolPtr2 = pSymbolPtr1;
			for (k=0; rule_table[i].Selects[j][k].Name[0] != '\0'; k++)
			{
				const SYMBOL* pSymbol = &rule_table[i].Selects[j][k];

				*pSymbolPtr2 = CreateSymbol();
				(*pSymbolPtr2)->isToken = pSymbol->isToken;
				if (1 == pSymbol->isToken)
				{
					strcpy((*pSymbolPtr2)->TokenName, pSymbol->Name);
				}
				else
				{
					(*pSymbolPtr2)->pRule = FindRule(pHead, pSymbol->Name);
					if (NULL == (*pSymbolPtr2)->pRule)
					{
						printf("Init rules error, miss rule \"%s\"\n", pSymbol->Name);
						exit(1);
					}
				}
				
				pSymbolPtr2 = &(*pSymbolPtr2)->pNextSymbol;
			}
			
			pSymbolPtr1 = &(*pSymbolPtr1)->pOther;
		}

		pRule = pRule->pNextRule;
	}

	return pHead;
}

/*
ܣ
	ʼķ(ִˮʱ)
	
ֵ
	ķͷָ롣
*/
Rule* InitRules_CI()
{
	int nRuleCount = 0;
	for (int i = 0; i < 20; i++)
	{
		gets(rule_table_ci[i]);	
		int length = strlen(rule_table_ci[i]);
		if (length == 0)
		{
			break;
		}
		
		for (int j = 0; j < length; j++)
		{
			if (rule_table_ci[i][j] == ' ')
			{
				ruleNameArr[i][j] = '\0';
				break;
			}
			ruleNameArr[i][j]= rule_table_ci[i][j];
		}	  
		
		nRuleCount++;
	}
			
	Rule *pHead, *pRule;
	RuleSymbol **pSymbolPtr1, **pSymbolPtr2;
		
	int i, j, k;

	Rule** pRulePtr = &pHead;
	for (i=0; i<nRuleCount; i++)
	{
		*pRulePtr = CreateRule(ruleNameArr[i]);
		pRulePtr = &(*pRulePtr)->pNextRule;
	}

	pRule = pHead;
	for (i=0; i<nRuleCount; i++)
	{
		pSymbolPtr1 = &pRule->pFirstSymbol;
		
		int start = 0;
		for (int j=0; rule_table_ci[i][j] != '\0'; j++)
		{
			if (rule_table_ci[i][j] == ' '
			 && rule_table_ci[i][j + 1] == '-'
			&& rule_table_ci[i][j + 2] == '>' 
			&& rule_table_ci[i][j + 3] == ' ')
			{
				start = j + 4;
				break;
			}
		}
			
		for (k = start; rule_table_ci[i][k] != '\0'; k++)
		{
			if (rule_table_ci[i][k] == '|')
			{
				pSymbolPtr1 = &(*pSymbolPtr1)->pOther;
				pSymbolPtr2 = pSymbolPtr1;
				continue;
			}
			if (rule_table_ci[i][k] == ' ')
			{
				continue;
			}
			if (k == start)
			{
				pSymbolPtr2 = pSymbolPtr1;
			}

			*pSymbolPtr2 = CreateSymbol();
			
			char tokenName[MAX_STR_LENGTH] = {};
			tokenName[0] = rule_table_ci[i][k];
			tokenName[1] = '\0';
			(*pSymbolPtr2)->isToken = 1;
			for (int m = 0; m < nRuleCount; m++)
			{
				if (strcmp(tokenName, ruleNameArr[m]) == 0)
				{
					(*pSymbolPtr2)->isToken = 0;
					(*pSymbolPtr2)->pRule = FindRule(pHead, tokenName);
					if (NULL == (*pSymbolPtr2)->pRule)
					{
						printf("Init rules error, miss rule \"%s\"\n", tokenName);
						exit(1);
					}
				}
			}
			if ((*pSymbolPtr2)->isToken == 1)
			{
				strcpy((*pSymbolPtr2)->TokenName, tokenName);
			}
			
			pSymbolPtr2 = &(*pSymbolPtr2)->pNextSymbol;
			
		}
			
		pRule = pRule->pNextRule;
	}

	return pHead;
}

/*
ܣ
	һµ Rule


	pRuleName -- ķ֡
	
ֵ
	Rule ָ
*/
Rule* CreateRule(const char* pRuleName)
{
	Rule* pRule = (Rule*)malloc(sizeof(Rule));

	strcpy(pRule->RuleName, pRuleName);
	pRule->pFirstSymbol = NULL;
	pRule->pNextRule = NULL;

	return pRule;
}

/*
ܣ
	һµ Symbol
	
ֵ
	RuleSymbol ָ	
*/
RuleSymbol* CreateSymbol()
{
	RuleSymbol* pSymbol = (RuleSymbol*)malloc(sizeof(RuleSymbol));

	pSymbol->pNextSymbol = NULL;
	pSymbol->pOther = NULL;
	pSymbol->isToken = -1;
	pSymbol->TokenName[0] = '\0';
	pSymbol->pRule = NULL;

	return pSymbol;
}

/*
ܣ
	 RuleName ķвͬķ


	pHead -- ķͷָ롣
	RuleName -- ķ֡
	
ֵ
	Rule ָ	
*/
Rule* FindRule(Rule* pHead, const char* RuleName)
{
	Rule* pRule;
	for (pRule = pHead; pRule != NULL; pRule = pRule->pNextRule)
	{
		if (0 == strcmp(pRule->RuleName, RuleName))
		{
			break;
		}
	}
	
	return pRule;
}	

/*
ܣ
	ķ


	pHead -- ķͷָ롣
*/
void PrintRule(Rule* pHead)
{

	//
	// TODO: ڴӴ
	//
		
}
