#include "Follow.h"
#include <string.h>
#include <stdlib.h>

const char* VoidSymbol = "#"; // ""
const char* DollarSymbol = "$";

char rule_table_ci[20][256];
char ruleNameArr[20][64];

int main(int argc, char* argv[])
{
	//
	//  InitRules ʼķ
	//
#ifdef CODECODE_CI
	Rule* pHead = InitRules_CI();  	// дˮ
#else
	Rule* pHead = InitRules();		// д CP Lab 
#endif

	//
	// ʼ First ϡFollow 
	//
	SetList FirstSetList, FollowSetList;
	FirstSetList.nSetCount = 0;
	FollowSetList.nSetCount = 0;

	//
	//  Follow ķ First ϡFollow 
	//
	Follow(pHead, &FollowSetList, &FirstSetList);

	//
	// ķ
	//
	PrintRule(pHead);
	
	//
	// Follow
	// 
	PrintFollowSet(&FollowSetList);
	
	return 0;
}

/*
ܣ
	һ Set  SetList


	pSetList -- SetList ָ롣
	pName -- ַָ롣 
*/
void AddOneSet(SetList* pSetList, const char* pName)
{

	//
	// TODO: ڴӴ
	//
	
}

/*
ܣ
	 SetList вҡ


	pSetList -- SetList ָ롣
	pName -- ַָ롣
	  
ֵ
	ҵ Set ָ룬򷵻 NULL
*/
Set* GetSet(SetList* pSetList, const char* pName)
{

	//
	// TODO: ڴӴ
	//
	
}

/*
ܣ
	һս Set


	pSet -- Set ָ롣
	pTerminal -- սָ롣
	  
ֵ
	ӳɹ 1򷵻 0
*/
int AddTerminalToSet(Set* pSet, const char* pTerminal)
{

	//
	// TODO: ڴӴ
	//
	
}

/*
ܣ
	Դ Set ӵĿ Set УԦš


	pDesSet -- Ŀ Set ָ롣
	pSrcSet -- Դ Set ָ롣
	  
ֵ
	ӳɹ 1򷵻 0
*/
int AddSetToSet(Set* pDesSet, const Set* pSrcSet)
{

	//
	// TODO: ڴӴ
	//
	
}

/*
ܣ
	ж Set ǷЦš


	pSet -- Set ָ롣
	  
ֵ
	ڷ 1
	ڷ 0
*/
int SetHasVoid(const Set* pSet)
{

	//
	// TODO: ڴӴ
	//
			
}

/*
ܣ
	ķ First ϡ


	pHead -- ķͷָ롣
	pFirstSetList -- First ָ롣
*/
void First(const Rule* pHead, SetList* pFirstSetList)
{
	const Rule* pRule;  // Rule ָ
	int isChange;	    // Ƿ޸ĵı־
	RuleSymbol* pSymbol;// Symbol α
	
	
	//
	// TODO: ڴӴ
	//
	
}

/*
ܣ
	ķ Follow ϡ


	pHead -- ķͷָ롣
	pFollowSetList -- Follow ָ롣
	pFirstSetList -- First ָ롣
*/
void Follow(const Rule* pHead, SetList* pFollowSetList, SetList* pFirstSetList)
{
	const Rule* pRule;  // Rule ָ
	int isChange;	    // Ƿ޸ĵı־
	RuleSymbol* pSymbol;// Symbol α

	//  First ķ First 
	First(pHead, pFirstSetList);

	// ʹķʼ Follow 
	for(pRule = pHead; pRule != NULL; pRule = pRule->pNextRule)
	{
		AddOneSet(pFollowSetList, pRule->RuleName);
	}

	// ڿʼŵ Follow мս $
	AddTerminalToSet(&pFollowSetList->Sets[0], DollarSymbol);

	do
	{
		isChange = 0; // ü޸ı־

		for(pRule = pHead; pRule != NULL; pRule = pRule->pNextRule)
		{
			for(pSymbol = pRule->pFirstSymbol; pSymbol != NULL; pSymbol = pSymbol->pNextSymbol)
			{
				// ս
				if(pSymbol->isToken)
					continue;

				// ʼһ First  TempFirstSetΪʱ
				Set TempFirstSet;
				TempFirstSet.nTerminalCount = 0;

				if(NULL != pSymbol->pNextSymbol)
				{
					if(pSymbol->pNextSymbol->isToken) // ս
					{
						//  AddTerminalToSet ս뵽 TempFirstSet
						AddTerminalToSet(&TempFirstSet, pSymbol->pNextSymbol->SymbolName);
					}
					else // ս
					{
						//  GetSet  pFirstSetList в Set
						Set* pFirstSetXn = GetSet(pFirstSetList, pSymbol->pNextSymbol->SymbolName);

						// ҵ Set  TempFirstSet 
						AddSetToSet(&TempFirstSet, pFirstSetXn);
					}
				}
				else
				{
					//  AddTerminalToSet  VoidSymbol 뵽 TempFirstSet 
					AddTerminalToSet(&TempFirstSet, VoidSymbol);
				}

				//  GetSet  pFollowSetList в Set
				Set* pFollowSetXi = GetSet(pFollowSetList, pSymbol->SymbolName);

				//  TempFirstSet  pFollowSetXi
				if(AddSetToSet(pFollowSetXi, &TempFirstSet))
					isChange = 1; // ü޸ı־

				if(SetHasVoid(&TempFirstSet)) // жϼ TempFirstSet ǷЦ
				{
					//  GetSet õǰķƶӦ Follow 
					Set* pFollowSetA = GetSet(pFollowSetList, pRule->RuleName);

					//  pFollowSetA  pFollowSetXi
					if(AddSetToSet(pFollowSetXi, pFollowSetA))
						isChange = 1; // ü޸ı־
				}
			}
		}

	} while(isChange);
	
}

typedef struct _SYMBOL
{
	int isToken;
	char SymbolName[MAX_STR_LENGTH];
}SYMBOL;

typedef struct _RULE_ENTRY
{
	char RuleName[MAX_STR_LENGTH];
	SYMBOL Symbols[64];
}RULE_ENTRY;

static const RULE_ENTRY rule_table[] =
{
	/* exp -> exp addop term| term */
	{ "exp", { { 0, "exp" }, { 0, "addop"}, { 0, "term"} } },
	{ "exp", { { 0, "term" } } },

	/* addop -> + | - */
	{ "addop", { { 1, "+" } } },
	{ "addop", { { 1, "-" } } },

	/* term -> term mulop factor | factor */
	{ "term", { { 0, "term" }, { 0, "mulop"}, { 0, "factor"} } },
	{ "term", { { 0, "factor" } } },

	/* mulop -> * */
	{ "mulop", { { 1, "*" } } },

	/* factor -> (exp) | number */
	{ "factor", { { 1, "(" }, { 0, "exp"}, { 1, ")"} } },
	{ "factor", { { 1, "number" } } },
};

/*
ܣ
	ʼķ
	
ֵ
	ķͷָ롣
*/
Rule* InitRules()
{
	Rule *pHead, *pRule;
	RuleSymbol **pSymbolPtr, *pNewSymbol;
	int nRuleCount = sizeof(rule_table) / sizeof(rule_table[0]);
	int i, j;

	Rule** pRulePtr = &pHead;
	for (i=0; i<nRuleCount; i++)
	{
		*pRulePtr = CreateRule(rule_table[i].RuleName);
		pRulePtr = &(*pRulePtr)->pNextRule;
	}

	pRule = pHead;
	for (i=0; i<nRuleCount; i++)
	{
		pSymbolPtr = &pRule->pFirstSymbol;
		for (j=0; rule_table[i].Symbols[j].SymbolName[0] != '\0'; j++)
		{
			const SYMBOL* pSymbol = &rule_table[i].Symbols[j];

			pNewSymbol = CreateSymbol();
			pNewSymbol->isToken = pSymbol->isToken;
			strcpy(pNewSymbol->SymbolName, pSymbol->SymbolName);
			*pSymbolPtr = pNewSymbol;

			pSymbolPtr = &pNewSymbol->pNextSymbol;
		}

		pRule = pRule->pNextRule;
	}

	return pHead;
}

Rule* InitRules_CI()
{
	int nRuleCount = 0;
	// Ҫȡı
	for (int i = 0; i < 20; i++)
	{
		gets(rule_table_ci[i]);	
		int length = strlen(rule_table_ci[i]);
		if (length == 0)
		{
			break;
		}
		
		for (int j = 0; j < length; j++)
		{
			if (rule_table_ci[i][j] == ' ')
			{
				ruleNameArr[i][j] = '\0';
				break;
			}
			ruleNameArr[i][j]= rule_table_ci[i][j];
		}	  
		nRuleCount++;
	}
	
	Rule *pHead, *pRule;
	RuleSymbol **pSymbolPtr, *pNewSymbol;

	Rule** pRulePtr = &pHead;
	for (int i=0; i<nRuleCount; i++)
	{
		*pRulePtr = CreateRule(ruleNameArr[i]);
		pRulePtr = &(*pRulePtr)->pNextRule;
	}

	pRule = pHead;
	for (int i=0; i<nRuleCount; i++)
	{
		pSymbolPtr = &pRule->pFirstSymbol;
		
		int start = 0;
		for (int j=0; rule_table_ci[i][j] != '\0'; j++)
		{
			if (rule_table_ci[i][j] == ' '
			 && rule_table_ci[i][j + 1] == '-'
			&& rule_table_ci[i][j + 2] == '>' 
			&& rule_table_ci[i][j + 3] == ' ')
			{
				start = j + 4;
				break;
			}
		}
			
		for (int k=start; rule_table_ci[i][k] != '\0'; k++)
		{
			if (rule_table_ci[i][k] == ' ')
			{
				continue;
			}
				
			pNewSymbol = CreateSymbol();
			char tokenName[MAX_STR_LENGTH] = {};
			
			for (int m = 0; ;m++)
			{
				if (rule_table_ci[i][k] ==  ' ' || rule_table_ci[i][k] == '\0' || rule_table_ci[i][k] == '\n')
				{
					tokenName[m] = '\0';
					break;
				}
				tokenName[m] = rule_table_ci[i][k++];
				
			}
			
			
			strcpy(pNewSymbol->SymbolName, tokenName);
			
			pNewSymbol->isToken = 1;
			for (int n = 0; n < nRuleCount; n++)
			{
				if (strcmp(pNewSymbol->SymbolName, ruleNameArr[n]) == 0)
				{
					pNewSymbol->isToken = 0;
					break;
				}
			}		
			
			*pSymbolPtr = pNewSymbol;

			pSymbolPtr = &pNewSymbol->pNextSymbol;
			
		}
			
		pRule = pRule->pNextRule;
	}

	return pHead;
}

/*
ܣ
	һµķ
	

	pRuleName -- ķ֡	
	
ֵ
	ķָ롣
*/
Rule* CreateRule(const char* pRuleName)
{
	Rule* pRule = (Rule*)malloc(sizeof(Rule));

	strcpy(pRule->RuleName, pRuleName);
	pRule->pFirstSymbol = NULL;
	pRule->pNextRule = NULL;

	return pRule;
}

/*
ܣ
	һµķš
	
ֵ
	ŵָ롣
*/
RuleSymbol* CreateSymbol()
{
	RuleSymbol* pSymbol = (RuleSymbol*)malloc(sizeof(RuleSymbol));

	pSymbol->pNextSymbol = NULL;
	pSymbol->isToken = -1;
	pSymbol->SymbolName[0] = '\0';

	return pSymbol;
}

/*
ܣ
	ķ
	

	pHead -- ķͷָ롣
*/
void PrintRule(const Rule* pHead)
{
	const Rule* pRule;
	for (pRule = pHead; pRule != NULL; pRule = pRule->pNextRule)
	{
		printf("%s ->", pRule->RuleName);

		RuleSymbol* pRuleSymbol;
		for (pRuleSymbol = pRule->pFirstSymbol; pRuleSymbol != NULL; 
			pRuleSymbol = pRuleSymbol->pNextSymbol)
		{	
			printf(" %s", pRuleSymbol->SymbolName);
		}
		printf("\n");
	}
}

/*
ܣ
	 First ϡ


	pFirstSetList -- First ָ롣
*/
void PrintFollowSet(SetList* pFollowSetList)
{
	printf("\nThe Follow Set:\n");
	for (int i = 0; i < pFollowSetList->nSetCount; i++)
	{
		printf("Follow(%s) = { ", pFollowSetList->Sets[i].Name);
		for (int j = 0; j < pFollowSetList->Sets[i].nTerminalCount; j++)
		{
			if (j == pFollowSetList->Sets[i].nTerminalCount - 1)
			{
				printf("%s ", pFollowSetList->Sets[i].Terminal[j]);
			}
			else
			{
				printf("%s, ", pFollowSetList->Sets[i].Terminal[j]);
			}
			
		}
		printf("}\n");
	}
}
