#include "T2P.h"
#include <stdlib.h>
#include <string.h>

char TCodeArray[MAX_CODE_COUNT][256];
int main()
{
	TCode TCodeList[MAX_CODE_COUNT]; // ַб
	PCode PCodeList[MAX_CODE_COUNT]; // P-б

	// ַбP-б
	memset(TCodeList, 0, sizeof(TCodeList));
	memset(PCodeList, 0, sizeof(PCodeList));

	//
	// ʼַб
	//
#ifdef CODECODE_CI
	InitTCodeList_CI(TCodeList);  	// дˮ
#else
	InitTCodeList(TCodeList);		// д CP Lab 
#endif

	//
	// ַתΪP-
	//
	T2P(TCodeList, PCodeList);
	
	//
	// P-
	//
	OutputResult(PCodeList);

	return 0;
}

/*
ܣ
	ַתΪ P-롣
	

	TCodeList -- ַбָ롣
	PCodeList -- P-бָ롣
*/
void T2P(TCode* TCodeList, PCode* PCodeList)
{
	int TIndex = 0;	// ַбα
	int PIndex = 0;	// P-бα
	
	for( ; TCodeList[TIndex].Kind != 0; TIndex++)
	{
		switch(TCodeList[TIndex].Kind)
		{
		case t_rd:

			// һ lda ָ
			PCodeList[PIndex].Kind = p_lda;
			PCodeList[PIndex].Addr.Kind = string;
			strcpy(PCodeList[PIndex].Addr.Name, TCodeList[TIndex].Addr1.Name);
			PIndex++;

			// һ rdi ָ
			PCodeList[PIndex].Kind = p_rdi;
			PIndex++;

			break;

		case t_gt:

			//  gt ָת P-
			
			//
			// TODO: ڴӴ
			//

			break;

		case t_if_f:

			if(TCodeList[TIndex].Addr1.Kind == intconst)
			{
				// һ ldc ָ
				PCodeList[PIndex].Kind = p_ldc;
				PCodeList[PIndex].Addr.Kind = intconst;
				PCodeList[PIndex].Addr.Value = TCodeList[TIndex].Addr1.Value;
			}
			else
			{
				// һ lod ָ
				PCodeList[PIndex].Kind = p_lod;
				PCodeList[PIndex].Addr.Kind = string;
				strcpy(PCodeList[PIndex].Addr.Name, TCodeList[TIndex].Addr1.Name);
			}
			PIndex++;

			// һ fjp ָ
			PCodeList[PIndex].Kind = p_fjp;
			PCodeList[PIndex].Addr.Kind = string;
			strcpy(PCodeList[PIndex].Addr.Name, TCodeList[TIndex].Addr2.Name);
			PIndex++;

			break;

		case t_asn:

			// һ lda ָ
			PCodeList[PIndex].Kind = p_lda;
			PCodeList[PIndex].Addr.Kind = string;
			strcpy(PCodeList[PIndex].Addr.Name, TCodeList[TIndex].Addr2.Name);
			PIndex++;

			if(TCodeList[TIndex].Addr1.Kind == intconst)
			{
				// һ ldc ָ
				PCodeList[PIndex].Kind = p_ldc;
				PCodeList[PIndex].Addr.Kind = intconst;
				PCodeList[PIndex].Addr.Value = TCodeList[TIndex].Addr1.Value;
			}
			else
			{
				// һ lod ָ
				PCodeList[PIndex].Kind = p_lod;
				PCodeList[PIndex].Addr.Kind = string;
				strcpy(PCodeList[PIndex].Addr.Name, TCodeList[TIndex].Addr1.Name);
			}
			PIndex++;

			// һ sto ָ
			PCodeList[PIndex].Kind = p_sto;
			PIndex++;

			break;

		case t_lab:

			//  lab ָת P-
			
			//
			// TODO: ڴӴ
			//

			break;

		case t_mul:

			// һ lda ָ
			PCodeList[PIndex].Kind = p_lda;
			PCodeList[PIndex].Addr.Kind = string;
			strcpy(PCodeList[PIndex].Addr.Name, TCodeList[TIndex].Addr3.Name);
			PIndex++;

			if(TCodeList[TIndex].Addr1.Kind == intconst)
			{
				// һ ldc ָ
				PCodeList[PIndex].Kind = p_ldc;
				PCodeList[PIndex].Addr.Kind = intconst;
				PCodeList[PIndex].Addr.Value = TCodeList[TIndex].Addr1.Value;
			}
			else
			{
				// һ lod ָ
				PCodeList[PIndex].Kind = p_lod;
				PCodeList[PIndex].Addr.Kind = string;
				strcpy(PCodeList[PIndex].Addr.Name, TCodeList[TIndex].Addr1.Name);
			}
			PIndex++;

			if(TCodeList[TIndex].Addr2.Kind == intconst)
			{
				// һ ldc ָ
				PCodeList[PIndex].Kind = p_ldc;
				PCodeList[PIndex].Addr.Kind = intconst;
				PCodeList[PIndex].Addr.Value = TCodeList[TIndex].Addr2.Value;
			}
			else
			{
				// һ lod ָ
				PCodeList[PIndex].Kind = p_lod;
				PCodeList[PIndex].Addr.Kind = string;
				strcpy(PCodeList[PIndex].Addr.Name, TCodeList[TIndex].Addr2.Name);
			}
			PIndex++;

			// һ mpi ָ
			PCodeList[PIndex].Kind = p_mpi;
			PIndex++;

			// һ sto ָ
			PCodeList[PIndex].Kind = p_sto;
			PIndex++;

			break;

		case t_sub:

			//  sub ָת P-
			
			//
			// TODO: ڴӴ
			//

			break;

		case t_eq:

			//  eq ָת P-
			
			//
			// TODO: ڴӴ
			//

			break;

		case t_wri:

			//  wri ָת P-
			
			//
			// TODO: ڴӴ
			//

			break;

		case t_halt:

			//  halt ָת P-
			
			//
			// TODO: ڴӴ
			//

			break;
		}
	}

}

typedef struct _AddressEntry
{
	AddrKind Kind;
	const char* Content;
}AddressEntry;

typedef struct _TCodeEntry
{
	TOpKind Kind;
	AddressEntry Addr1, Addr2, Addr3;
}TCodeEntry;

static const TCodeEntry TCodeTable[] =
{
	{ t_rd,   { string, "x" } },
	{ t_mul,  { string, "x" }, { intconst, "2" }, { string, "t1"} },
	{ t_asn,  { string, "t1" }, { string, "x" } },
	{ t_if_f, { string, "x" }, { string, "L1" } },
	{ t_wri,  { string, "x" } },
	{ t_lab,  { string, "L1" } },
	{ t_halt }
};

/*
ܣ
	ʼַ
	

	pEntry -- ڳʼַĽṹ塣
	pAddr -- ַָ롣
*/
void InitAddress(const AddressEntry* pEntry, Address* pAddr)
{
	pAddr->Kind = pEntry->Kind;
	switch (pAddr->Kind)
	{
	case empty:
		break;
	case intconst:
		pAddr->Value = atoi(pEntry->Content);
		break;
	case string:
		strcpy(pAddr->Name, pEntry->Content);
		break;
	}
}

/*
ܣ
	ʼַб
	

	pTCodeList -- ַбָ롣
*/
void InitTCodeList(TCode* pTCodeList)
{
	int i;
	int EntryCount = sizeof(TCodeTable) / sizeof(TCodeTable[0]);
	
	for (i = 0; i < EntryCount; i++)
	{
		pTCodeList[i].Kind = TCodeTable[i].Kind;

		InitAddress(&TCodeTable[i].Addr1, &pTCodeList[i].Addr1);
		InitAddress(&TCodeTable[i].Addr2, &pTCodeList[i].Addr2);
		InitAddress(&TCodeTable[i].Addr3, &pTCodeList[i].Addr3);
	}
}

/*
ܣ
	ʼַбִˮʱã
	

	pTCodeList -- ַбָ롣
*/
void InitTCodeList_CI(TCode* pTCodeList)
{
	for (int i = 0; i < MAX_CODE_COUNT; i++)
	{
		gets(TCodeArray[i]);
		int length = strlen(TCodeArray[i]);
		if (length == 0)
		{
			break;
		}
		char unitArr[7][64] = {};
		int k = 0, w = 0;
		for (int j = 0; j < 256; j++)
		{
			if (TCodeArray[i][j] == '\0')
			{
				break;
			}
			if (TCodeArray[i][j] == 32)
			{
				k++; 
				w = 0;
				continue;
			}
			unitArr[k][w++] = TCodeArray[i][j];
		}
		
		char kind[64] = {0};
		strcpy(kind, unitArr[0]);
		if (strcmp(kind, "t_rd") == 0)
		{
			pTCodeList[i].Kind = t_rd;
		}
		else if (strcmp(kind, "t_gt") == 0)
		{
			pTCodeList[i].Kind = t_gt;
		}
		else if (strcmp(kind, "t_if_f") == 0)
		{
			pTCodeList[i].Kind = t_if_f;
		}
		else if (strcmp(kind, "t_asn") == 0)
		{
			pTCodeList[i].Kind = t_asn;
		}
		else if (strcmp(kind, "t_lab") == 0)
		{
			pTCodeList[i].Kind = t_lab;
		}
		else if (strcmp(kind, "t_mul") == 0)
		{
			pTCodeList[i].Kind = t_mul;
		}
		else if (strcmp(kind, "t_sub") == 0)
		{
			pTCodeList[i].Kind = t_sub;
		}
		else if (strcmp(kind, "t_eq") == 0)
		{
			pTCodeList[i].Kind = t_eq;
		}
		else if (strcmp(kind, "t_wri") == 0)
		{
			pTCodeList[i].Kind = t_wri;
		}
		else if (strcmp(kind, "t_halt") == 0)
		{
			pTCodeList[i].Kind = t_halt;
		}
		
		for (int j = 1; j < k; j += 2)
		{
			if (strcmp(unitArr[j], "string") == 0)
			{
				if (j == 1)
				{
					pTCodeList[i].Addr1.Kind = string;
					strcpy(pTCodeList[i].Addr1.Name, unitArr[j + 1]);
				}
				else if (j == 3)
				{
					pTCodeList[i].Addr2.Kind = string;
					strcpy(pTCodeList[i].Addr2.Name, unitArr[j + 1]);
				}
				else if (j == 5)
				{
					pTCodeList[i].Addr3.Kind = string;
					strcpy(pTCodeList[i].Addr3.Name, unitArr[j + 1]);
				}
				
			}
			else if (strcmp(unitArr[j], "intconst") == 0)
			{
				if (j == 1)
				{
					pTCodeList[i].Addr1.Kind = intconst;
					pTCodeList[i].Addr1.Value = atoi(unitArr[j + 1]);
				}
				else if (j == 3)
				{
					pTCodeList[i].Addr2.Kind = intconst;
					pTCodeList[i].Addr2.Value = atoi(unitArr[j + 1]);
				}
				else if (j == 5)
				{
					pTCodeList[i].Addr3.Kind = intconst;
					pTCodeList[i].Addr3.Value = atoi(unitArr[j + 1]);
				}
			  
			}
		}
	}
}

/*
ܣ
	ַб
	

	pCodeList -- P-бָ롣
*/
void OutputResult(PCode* PCodeList)
{

	for (int PIndex = 0; PCodeList[PIndex].Kind != 0; PIndex++)
	{
		switch (PCodeList[PIndex].Kind)
		{
		case p_lda:
			printf("lda%c%c%s\n", 32, 32, PCodeList[PIndex].Addr.Name);
		break;
		case p_rdi:
			printf("rdi\n");
		break;
		case p_lod:
			printf("lod%c%c%s\n", 32, 32, PCodeList[PIndex].Addr.Name);
		break;
		case p_ldc:
			printf("ldc%c%c%d\n", 32, 32, PCodeList[PIndex].Addr.Value);
		break;
		case p_grt:
			printf("grt\n");
		break;
		case p_fjp:
			printf("fjp%c%c%s\n", 32, 32, PCodeList[PIndex].Addr.Name);
		break;
		case p_sto:
			printf("sto\n");
		break;
		case p_lab:
			printf("lab%c%c%s\n", 32, 32, PCodeList[PIndex].Addr.Name);
		break;
		case p_mpi:
			printf("mpi\n");
		break;
		case p_sbi:
			printf("sbi\n");
		break;
		case p_equ:
			printf("equ\n");
		break;
		case p_wri:
			printf("wri%c%c%s\n", 32, 32, PCodeList[PIndex].Addr.Name);
		break;
		case p_stp:
			printf("stp\n");
		break;
		}
	}
}

