# 目录
[下载安装](#下载安装)  
[启动](#启动)  
[登录](#登录)  
[主窗口布局](#主窗口布局)  
[从 CodeCode 平台新建一个项目](#从-codecode-平台新建一个项目)    
[将新项目克隆到本地](#将新项目克隆到本地)  
[项目中的文件](#项目中的文件)  
[生成项目](#生成项目)  
[运行项目](#运行项目)  
[修改语法错误](#修改语法错误)  
[调试项目](#调试项目)  
[验证项目](#验证项目)  
[推送项目](#推送项目)  
[查看预处理命令](#查看预处理命令)  
[线上查看任务的完成结果](#线上查看任务的完成结果)   
[查看当前项目的代码质量分析的结果](#查看当前项目的代码质量分析的结果)   
[新建问题](#新建问题)   
[添加评论](#添加评论)   
[总结](#总结)  
[获得帮助](#获得帮助)  
[可能遇到的问题和使用技巧](#可能遇到的问题和使用技巧)  

# C&C++ Lab 使用手册（C语言）
[C&C++ Lab](https://www.codecode.net/engintime/cpp-lab/cpp-lab) 是一款成熟的编程软件，提供了源代码编辑、编译、调试等功能，并且与 CodeCode.net 平台深度集成，可用于 C 语言程序设计、C++ 语言程序设计、数据结构、算法分析等课程的实验。

# 下载安装
[下载安装 C&C++ Lab](https://www.codecode.net/engintime/cpp-lab/cpp-lab#%E4%B8%8B%E8%BD%BD%E5%AE%89%E8%A3%85%E5%8C%85)

# 启动
可以使用两种不同的方法启动该软件：
- 方法一：在桌面上双击 Engintime C&C++ Lab 图标。
- 方法二：点击“开始”菜单，在“程序”中的“Engintime C&C++ Lab”中选择“Engintime C&C++ Lab”。

# 登录
软件启动后，首先弹出的是用户登录对话框。有两种不同的登录方式：
- 如果读者注册了 CodeCode 账号，可以填写 CodeCode 用户名和密码完成登录（必须连接互联网）。
- 如果读者使用加密锁，则直接点击按钮“从加密锁获取授权”即可完成登录（不必连接互联网）。

# 主窗口布局
主窗口布局由下面的若干元素组成：
- 顶部的菜单栏、工具栏。
- 停靠在左侧和底部的各种工具窗口。
- 余下的区域用来放置“起始页”和“源代码编辑器”窗口。  

>
**`提示`** 菜单栏、工具栏和各种工具窗口的位置可以随意拖动。如果想恢复窗口的默认布局，选择“窗口”菜单中的“重置窗口布局”即可。
>

# 从 CodeCode 平台新建一个项目

从CodeCode平台新建项目主要包含两种方式：
- 方法一，从课程中领取任务。
- 方法二，从实验模板 fork 一个新项目。

## 从课程中领取任务
1. 读者登录 CodeCode 平台之后，在课程列表页面，点击某一个课程的链接，可以打开该课程的详细页面。
2. 在课程的详细信息页面中，切换到任务列表页面，找到需要完成的任务，就可以[领取任务](https://www.codecode.net/engintime/codecode/studentsmanual#%E9%A2%86%E5%8F%96%E4%BB%BB%E5%8A%A1)。

>
**`提示`** 读者从 CodeCode.net 平台领取任务时，也是使用任务中设定的实验模板 fork 了一个新项目。
>

## 从实验模板 fork 一个新项目
为了方便读者完成程序设计实验，CodeCode.net 平台提供了大量 [实验模板](https://www.codecode.net/engintime/cpp-lab/Project-Template) 供读者使用。通常，这些实验模板只授予读者查看的权限，而没有修改的权限。所以，读者需要从实验模板 fork 出一个新项目，然后在这个新项目中编写源代码。  
可以按照下面的步骤 fork 项目：
1. 使用浏览器打开一个实验模板。例如在浏览器地址栏中输入 https://www.codecode.net/engintime/cpp-lab/Project-Template/c-language/Lab001 。注意，只有登录 CodeCode.net 平台后才能使用浏览器访问此实验模板。
2. 当浏览器打开实验模板后，点击如下图所示的 fork 按钮。
![Image text](./img/fork.png)
3. 接下来读者还需要选择一个拥有新建项目权限的群组，就会在此群组中创建一个新项目。浏览器会自动跳转到新项目的页面。

# 将新项目克隆到本地
读者从实验模板 fork 项目成功后，通常需要将新项目克隆到本地磁盘，然后使用 C&C++ Lab 编写源代码。步骤如下：
1. 使用浏览器打开 fork 得到的新项目，在项目页面中将 fork 按钮右侧的 https 项目路径复制。
2. 在 C&C++ Lab 的“文件”菜单中选择“新建”，然后点击“从 Git 远程库新建项目”，打开“从 Git 远程库新建项目”对话框。此时会自动将剪切板中的 URL 路径复制到“Git 远程库 URL”编辑框中。
3. 在“项目文件夹名称”中输入新项目使用的文件夹名称“lab1”。
4. 在“项目位置”中输入项目保存在本地磁盘上的位置“C:\C&C++ Lab”。
5. 点击“确定”按钮后，会弹出一个 Windows 控制台窗口，在其中显示 Git 远程库克隆到本地的进度和结果。
6. 克隆成功后，关闭 Windows 控制台窗口，选择对话框中的“打开项目”按钮，会打开在本地新建的项目。

在左侧的“项目管理器”窗口中，根节点是项目节点，各个子节点是项目包含的文件夹或者文件。读者也可以使用“Windows资源管理器”打开磁盘上的“C:\C&C++ Lab\lab1”文件夹，查看项目中包含的源代码文件。

![Image text](./img/projecttree.png)

>
**`提示`** 右键点击“项目管理器”窗口中的项目节点，选择快捷菜单中的“打开所在的文件夹”，即可使用“Windows资源管理器”打开项目所在的文件夹。
>

# 项目中的文件
| 文件名 | 说明 |
| :------: | :---------- |
| main.c | 在此文件中编写源代码。也可以根据编程需要添加新的源代码文件。  |
| makefile | 在 CodeCode.net 平台中（Linux）使用此文件将源代码文件编译为可执行文件，用于在线验证。如果添加了新的源代码文件，就需要在此文件中做对应的修改。  |
| input1.txt | 在自动化验证时，会将此文件中的内容重定向到标准输入。当有多个算例时，会有多个类似文件。 |
| output1.txt | 在自动化验证时，程序的标准输出会重定向到user_output1.txt文件中，然后与该文件比较，如果两个文件的内容相同，就说明验证成功，否则，验证失败。当有多个算例时，会有多个类似文件。 |
| readme.md | Markdown 格式的文本文件。通常包含编程要求等内容。 |

# 生成项目
使用“生成项目”功能可以将程序的源代码文件编译为可执行的二进制文件，操作如下：
1.	在“生成”菜单中选择“生成项目”（快捷键是F7）。

在项目生成过程中，“输出”窗口会实时显示生成的进度和结果。如果源代码中不包含语法错误，会在生成的最后阶段提示生成成功。  
在生成项目的过程中，首先运行代码分析，检查源代码中是否含有语法错误，接下来将项目所包含的每个C源代码文件（.c文件）生成一个预处理文件（.i文件），然后生成一个汇编文件（.s文件），最后生成一个对象文件（.o文件），编译完成后将一个或多个对象文件链接为一个目标文件（.exe文件）。以本实验为例，成功生成项目后，默认会在“C:\C&C++\lab1\Debug" 目录下生成  “main.i” “main.s” “main.o”文件和“lab1.exe”文件。

>
**`提示`** 读者可以通过修改项目名称的方法来修改生成的.exe文件的名称。方法是在“项目管理器”窗口中右键点击项目节点，选择快捷菜单中的“重命名”。待项目名称修改后，需要再次生成项目才能得到新的.exe文件。
>

# 运行项目
生成成功后，就可以运行目标文件（.exe文件）了。步骤如下：
1. 在“调试”菜单中选择“开始执行（不调试）”（快捷键是Ctrl+F5），会弹出一个 Windows 控制台窗口运行目标文件。
2. 由于当前源代码中还没有任何输出语句，所以控制台窗口中没有输出内容。按任意键可以关闭控制台窗口。 

# 修改语法错误
在编写源代码的过程中可能由于拼写错误或者其他原因，造成编译无法通过从而无法生成目标文件。接下来使用下面的源代码替换main.c文件中的源代码。


```c
#include <stdio.h>
int main()
{
    int a, b;
    a = 123;
    b = 456;
    int sum;
    sum = a + b;
    printf("sum is %d\n", sum)
    return 0;
}
```

>
**`C99`** 变量的声明可以不在所有语句之前。例如，main函数中可以先有一个变量声明，下面跟一些语句，然后再有变量声明。  
>

如果源代码中存在语法错误，“输出”窗口会显示错误信息,包括错误所在文件的路径，错误在文件中的位置，以及错误原因和改正建议，并在最后提示生成失败。此时，在“输出”窗口中双击错误信息所在的行，C&C++ Lab会使用源代码编辑器自动打开错误所在的文件，并定位到错误所在的代码行。
可以按照下面的步骤进行练习：
1.	在源代码文件中故意输入一些错误的代码。例如删除语句printf("sum is %d\n", sum)末尾的分号。
2.	按F7生成项目，“输出”窗口中会显示“代码分析”过程中检测到的错误，并自动统计“错误”和“警告”的数量。注意，“警告”并不影响目标文件的生成。
3.	在“输出”窗口中双击错误信息来定位存在错误的代码行，并将代码修改正确。
4.	重复步骤2、3，直到项目生成成功。

#  调试项目
C&C++ Lab提供的调试器是一个功能强大的工具，使用此调试器可以观察程序的运行时行为并确定逻辑错误的位置，可以中断程序的执行以检查代码，计算和编辑程序中的变量。为了顺利进行后续的各项实验，应该学会灵活使用这些调试功能。

## 使用断点中断执行
源代码的运行结果与预想的结果不一致，一般说明程序存在逻辑错误。此时，可以通过添加断点的方式解决此类问题。可以按照下面的步骤进行练习：
1.	打开main.c文件。
2.	在main函数中的代码行
`b = 456;`
上点击鼠标右键，在弹出的快捷菜单中选择“插入/删除断点”，会在此行左侧的空白处显示一个红色圆点，表明已经成功在此行代码上添加一个断点。
3.	在“调试”菜单中选择“启动调试”，Windows 控制台应用程序开始执行，并在刚刚添加断点的代码行左侧空白中显示一个黄色箭头，表示程序已经在此行代码处中断执行（注意，黄色箭头指向的代码行是下一个要执行的代码行，此行代码当前还没有执行）。

## 单步调试
按照下面的步骤练习使用“逐过程”功能：
1.	在“调试”菜单中选择“逐过程”，会执行黄色箭头当前指向的代码行，并将黄色箭头指向下一个要执行的代码行“sum = a + b”。
2.	继续使用“逐过程”单步调试源代码，体会此功能的作用。
3.	在“调试”菜单中选择“停止调试”，结束此次调试。

>
**`提示`** “逐语句”功能用于调试进入一个函数，也就是说，当黄色箭头指向一个函数调用语句时，如果选择“逐语句”，就会进入函数内部，可以继续调试函数内部的语句；否则，如果选择“逐过程”，就会直接运行函数。
当调试进入一个函数后，可以选择“调试”菜单“窗口”中的“调用堆栈”，打开“调用堆栈”窗口，在此窗口中可以查看函数的调用层次，双击函数所在行，可以切换到指定函数的上下文。
>

## 查看变量的值
在调试的过程中，C&C++ Lab提供了三种查看变量值的方法，按照下面的步骤练习这些方法：
1.	按F5启动调试，会在之前设置的断点处中断。
2.	将鼠标移动到源代码编辑器中变量b的名称上，会弹出一个窗口显示出变量b的值（由于此时还没有给变量b赋值，所以是一个随机值）。
3.	在源代码编辑器中变量b的名称上点击鼠标右键，在弹出的快捷菜单中选择“快速监视”，可以使用“快速监视”对话框查看b的值。可以点击“关闭”按钮关闭“快速监视”对话框。
4.	在源代码编辑器中变量b的名称上点击鼠标右键，在弹出的快捷菜单中选择“添加监视”，变量b就被添加到了“监视”窗口中。使用“监视”窗口可以随时查看变量的值和类型。此时按F10进行一次单步调试，可以看到“监视”窗口中变量b的值会变成456。
 
如果需要使用十六进制查看变量的值，可以点击工具栏上的“十六进制”按钮，从而在十六进制和十进制间切换。
练习使用不同的进制和不同的方法来查看变量的值和类型后，结束此次调试。

# 验证项目
这里介绍 C&C++ Lab 提供的一个重要功能：验证功能。当读者编写代码完毕后，往往需要使用调试功能、或者执行功能，来判断所编写的程序是否能够达到预期的效果。C&C++ Lab 提供的验证功能可以自动的、精确的完成这个验证过程。

按照下面的步骤启动验证功能：
1.	在“调试”菜单中选择“开始验证”（快捷键是Alt+F5）。在输出窗口中会显示验证的结果。

如果验证失败，可以使用“输出”窗口工具条上的“比较”按钮,查看用于对照的输出文件（左侧窗口）与读者编写程序产生的输出文件（右侧窗口）的不同之处，从而准确定位导致验证失败的原因。

![Image text](./img/com.png) 
 
#  推送项目
如果读者写完了程序并通过了自动化验证，可以将读者编写的源代码文件提交到 CodeCode.net 平台，供教师查看。步骤如下：
1. 在“项目管理器”窗口中，右键点击项目节点，打开右键菜单，选择“Git”中的“推送到 Git 远程库”，打开“推送到 Git 远程库”对话框。
2. 在对话框中填写提交信息后，点击“推送”按钮。
3. 在弹出的 Windows 控制台窗口中会显示推送的进度和结果。注意，推送过程中通常需要用户在 Windows 控制台窗口中输入 CodeCode.net 平台的密码。
4. 项目推送成功后，如果项目提供了在线验证功能（项目中包含 .gitlab-ci.yml 文件），会自动使用浏览器打开当前项目的流水线页面，查看在线验证的结果。

# 查看预处理命令
1.“项目管理器”窗口中，在项目节点单击右键选择“属性”，在弹出的对话框中，选择左侧“C&C++编译器(GCC)”的“常规”。将右侧属性页中的“显示包含的头文件”改为“是(-H)”并选择“确定”。  
![Image text](./img/1.png)  
2.在“生成”菜单中选择“重新生成项目”（快捷键是Ctrl+Alt+F7）。在“输出”窗口中显示了源文件在编译过程中所包含的头文件，并使用不同数量的“.”来表示文件之间的包含关系。双击文件路径可以打开这个头文件。  
3.在“输出”窗口中，双击“输出预处理文件: ………”可以打开编译过程中产生的预处理文件。观察这个文件可以理解文件包含的具体含义。  


# 线上查看任务的完成结果
读者提交项目之后，可以自动打开流水线[查看任务的完成结果](https://www.codecode.net/engintime/codecode/studentsmanual/blob/master/readme.md#%E7%BA%BF%E4%B8%8A%E6%9F%A5%E7%9C%8B%E4%BB%BB%E5%8A%A1%E7%9A%84%E5%AE%8C%E6%88%90%E7%BB%93%E6%9E%9C)

# 查看当前项目的代码质量分析的结果

当前项目的流水线执行完之后，可以[查看当前项目的代码质量分析的结果](https://www.codecode.net/engintime/codecode/studentsmanual/blob/master/readme.md#%E6%9F%A5%E7%9C%8B%E4%BB%A3%E7%A0%81%E8%B4%A8%E9%87%8F)

# 新建问题

在当前项目中，可以[新建问题](https://www.codecode.net/engintime/codecode/studentsmanual/blob/master/readme.md#%E6%96%B0%E5%BB%BA%E9%97%AE%E9%A2%98)，向小助同学请求帮助

# 添加评论

对当前项目已更新的代码，创建的合并请求，新建的问题，可以[添加评论](https://www.codecode.net/engintime/codecode/studentsmanual/blob/master/readme.md#%E6%B7%BB%E5%8A%A0%E8%AF%84%E8%AE%BA)


#  总结
读者使用 C&C++ Lab 进行程序设计实验的步骤可以总结如下：
1.	从 CodeCode.net 平台领取任务或者自行从实验模板 fork 一个新项目。
3.	将 Git 远程库（新项目）克隆到本地并打开项目。
4.	按照实验要求编写源代码。
5.	生成项目（排除所有的语法错误）。
6.	按“Ctrl+F5”执行程序，并判断执行的结果与实验要求是否一致。如果不一致，可以使用调试功能排除错误。
7.	使用验证功能最终确认程序执行的结果与实验要求是一致的。如果验证失败，可以使用“比较”功能查看错误的原因。
8.	推送项目到 CodeCode.net 平台。

# 获得帮助
如果读者在使用 C&C++ Lab 的过程中遇到问题需要专业的解答，或者有一些心得体会想和其他C&C++ Lab用户分享，欢迎加入CodeCode：
-	选择C&C++ Lab“帮助”菜单中的“提交问题或建议”。
-	直接访问https://www.codecode.net/engintime/cpp-lab/cpp-lab/issues。
-	通过[在线助手](https://www.codecode.net/engintime/codecode/studentsmanual#%E5%9C%A8%E7%BA%BF%E5%8A%A9%E6%89%8B)获取帮助。

# 可能遇到的问题和使用技巧
这里列出了读者在使用 C&C++ Lab 的过程中可能遇到的一些问题和使用技巧，用于帮助读者更好的使用 C&C++ Lab。
1.	读者时常会遇到在自己编写的源代码中存在死循环的情况，这就会造成 C&C++ Lab 的调试功能无法自行结束。此时，读者可以选择“调试”菜单中的“停止调试”（快捷键是Shift+F5）来强制结束。随后，读者可以检查自己编写的源代码，找到造成死循环的原因。
2.	如果验证功能无法自行结束，一种可能的原因是读者编写的程序存在死循环，另一种可能的原因是“输入文件”中的数据无法满足读者编写程序的需要，造成程序等待输入而无法结束，此时读者可以打开输入文件，参照其中的输入数据来修改程序。
3.	读者时常会遇到“数组越界访问”或者“野指针”。此时， C&C++ Lab 会弹出一个调试异常对话框，读者只要选择对话框中的“是”按钮，就可以立即定位到异常所在的代码行。
4.	C&C++ Lab 作为一个IDE环境，提供了强大的调试功能，包括单步调试、添加断点、查看变量的值、查看调用堆栈等。读者在调试过程中可以灵活使用这些功能，提高调试效率。
5.	“输出”窗口中的文本信息可以被选中并复制（但是不能修改），读者可以很方便的将这些信息保存下来，用于完成实验报告等工作。

