# 目录
[概述](#概述)  
[C语言程序设计实验](#c语言程序设计实验)  
[C++语言程序设计实验](#c语言程序设计实验-1)  
[EOJ题库](#eoj题库)  
[参考文献](#参考文献)  

# 概述
本教程可以用于 C 语言程序设计、 C++ 语言程序设计、数据结构、算法分析的实验课程。  
请读者`务必先阅读` [C&C++ Lab使用手册](app-manual.md)，然后再按照下面的内容完成实验。  

# C语言程序设计实验

C语言程序设计实验部分提供了14个实验题目，主要包含53个实验模板，涵盖了数据类型、运算符、输入输出，程序设计结构、数组、指针、自定义数据类型、文件、位运算等重要的知识点。  在每个实验题目下面包含了相应的实验模板，每个模板可以有针对性的对知识点进行练习，通过使用这些模板根据题目的要求完成实验，就可以对C语言中的绝大部分的知识进行强化。通过完成这些实验，可以提高编程水平，对以后从事相关方面的研发有很大的帮助作用。  

## 实验题目清单
[实验1 实验环境的使用](#实验1实验环境的使用)  
[实验2 数据类型、运算符和简单输入输出](#实验2数据类型运算符和简单输入输出)  
[实验3 顺序结构程序设计](#实验3顺序结构程序设计)  
[实验4 选择结构程序设计](#实验4选择结构程序设计)  
[实验5 循环结构程序设计](#实验5循环结构程序设计)  
[实验6 数组](#实验6数组)  
[实验7 函数（一）](#实验7函数一)  
[实验8 函数（二）](#实验8函数二)  
[实验9 指针（一）](#实验9指针一)  
[实验10 指针（二）](#实验10指针二)  
[实验11 自定义数据类型](#实验11自定义数据类型)  
[实验12 文件操作](#实验12文件操作)  
[实验13 预处理指令](#实验13预处理指令)  
[实验14 位运算](#实验14位运算)  

## 实验1实验环境的使用
建议学时：1学时

**`实验目的`**

- 熟悉C&C++ Lab的基本使用方法。
- 了解在C&C++ Lab上如何编辑、编译、链接和运行一个C程序。
- 通过运行简单的C程序，初步了解C源程序的特点。

**`实验任务`**

如果是第一次使用C&C++ Lab完成实验，请先阅读[《C&C++ Lab 使用手册》](./app-manual.md)，这样读者可以学习C&C++ Lab的使用方法，后面的实验按照使用手册供的实验步骤就可以顺利完成。  

请读者在本平台的[课程](https://www.codecode.net/dashboard/courses)中，通过领取教师在程序设计课程中布置的任务来分别新建项目，然后按照每个项目中readme.md文件中的要求完成实验。

>
教师用户应使用实验模板Lab001创建用于完成本次实验的第一个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab001.git)访问实验模板Lab001   
教师用户应使用实验模板Lab002创建用于完成本次实验的第二个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab002.git)访问实验模板Lab002
>

## 实验2数据类型运算符和简单输入输出
建议学时：1学时

**`实验目的`**
- 掌握C语言数据类型，了解字符型数据和整型数据的内在关系。
- 掌握对各种数值型数据的正确输入方法。
- 学会使用C的算术运算符，以及包含这些运算符的表达式，特别是自加（++）和自减（--）运算符的使用。

**`实验任务`**  

请读者在本平台的[课程](https://www.codecode.net/dashboard/courses)中，通过领取教师在程序设计课程中布置的任务来分别新建项目，然后按照每个项目中readme.md文件中的要求完成实验。

>  
教师用户应使用实验模板Lab003创建用于完成本次实验的第一个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab003.git)访问实验模板Lab003  
教师用户应使用实验模板Lab004创建用于完成本次实验的第二个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab004.git)访问实验模板Lab004    
教师用户应使用实验模板Lab005创建用于完成本次实验的第三个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab005.git)访问实验模板Lab005  
教师用户应使用实验模板Lab005-1创建用于完成本次实验的第四个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab005-1.git)访问实验模板Lab005-1  
教师用户应使用实验模板Lab005-2创建用于完成本次实验的第五个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab005-2.git)访问实验模板Lab005-2  
教师用户应使用实验模板Lab005-3创建用于完成本次实验的第六个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab005-3.git)访问实验模板Lab005-3  
教师用户应使用实验模板Lab005-4创建用于完成本次实验的第七个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab005-4.git)访问实验模板Lab005-4  
教师用户应使用实验模板Lab005-5创建用于完成本次实验的第八个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab005-5.git)访问实验模板Lab005-5  
教师用户应使用实验模板Lab006创建用于完成本次实验的第九个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab006.git)访问实验模板Lab006  
>

## 实验3顺序结构程序设计 

建议学时：1学时

**`实验目的`**
- 掌握C语言中使用最多的一种语句——赋值语句的使用方法。
- 掌握各种类型数据的输入输出的方法，能正确使用各种格式转换符。
- 进一步掌握编写程序和调试程序的方法。

**`实验任务`**

请读者在本平台的[课程](https://www.codecode.net/dashboard/courses)中，通过领取教师在程序设计课程中布置的任务来分别新建项目，然后按照每个项目中readme.md文件中的要求完成实验。

>   
教师用户应使用实验模板Lab007创建用于完成本次实验的第一个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab007.git)访问实验模板Lab007  
教师用户应使用实验模板Lab007-1创建用于完成本次实验的第二个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab007-1.git)访问实验模板Lab007-1  
教师用户应使用实验模板Lab008创建用于完成本次实验的第三个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab008.git)访问实验模板Lab008  
教师用户应使用实验模板Lab009创建用于完成本次实验的第四个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab009.git)访问实验模板Lab009  
教师用户应使用实验模板Lab010创建用于完成本次实验的第五个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab010.git)访问实验模板Lab010  
教师用户应使用实验模板Lab010-1创建用于完成本次实验的第六个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab010-1.git)访问实验模板Lab010-1  
教师用户应使用实验模板Lab010-2创建用于完成本次实验的第七个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab010-2.git) 访问实验模板Lab010-2 
>

## 实验4选择结构程序设计
建议学时：1学时

**`实验目的`**
- 了解C语言表示逻辑量的方法（以0代表“假”，以非0代表“真”）。
- 学会正确使用逻辑运算符和逻辑表达式。
- 熟练掌握if语句的使用（包括if语句的嵌套）。
- 熟练掌握多分支选择语句—switch语句。
- 结合程序掌握一些简单的算法。
- 进一步学习调试程序的方法。


**`实验任务`**

请读者在本平台的[课程](https://www.codecode.net/dashboard/courses)中，通过领取教师在程序设计课程中布置的任务来分别新建项目，然后按照每个项目中readme.md文件中的要求完成实验。

>  
教师用户应使用实验模板Lab011创建用于完成本次实验的第一个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab011.git)访问实验模板Lab011  
教师用户应使用实验模板Lab012创建用于完成本次实验的第二个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab012.git)访问实验模板Lab012  
教师用户应使用实验模板Lab013创建用于完成本次实验的第三个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab013.git)访问实验模板Lab013  
教师用户应使用实验模板Lab014创建用于完成本次实验的第四个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab014.git)访问实验模板Lab014  
>

## 实验5循环结构程序设计
建议学时：1学时

**`实验目的`**
- 熟悉掌握用while语句、do…while语句和for语句实现循环的方法。
- 掌握在程序设计中用循环的方法实现一些常用算法（如穷举、迭代、递推等）。
- 进一步学习调试程序。


**`实验任务`**

请读者在本平台的[课程](https://www.codecode.net/dashboard/courses)中，通过领取教师在程序设计课程中布置的任务来分别新建项目，然后按照每个项目中readme.md文件中的要求完成实验。

>   
教师用户应使用实验模板Lab015创建用于完成本次实验的第一个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab015.git)访问实验模板Lab015  
教师用户应使用实验模板Lab016创建用于完成本次实验的第二个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab016.git)访问实验模板Lab016  
教师用户应使用实验模板Lab017创建用于完成本次实验的第三个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab017.git)访问实验模板Lab017    
教师用户应使用实验模板Lab017-1创建用于完成本次实验的第四个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab017-1.git)访问实验模板Lab017-1    
>

## 实验6数组
建议学时：1学时

**`实验目的`**
- 掌握一维数组和二维数组的定义、赋值和输入输出的方法。
- 掌握字符数组和字符串函数的使用。
- 掌握与数组有关的算法（特别是排序算法）。

**`实验任务`**

请读者在本平台的[课程](https://www.codecode.net/dashboard/courses)中，通过领取教师在程序设计课程中布置的任务来分别新建项目，然后按照每个项目中readme.md文件中的要求完成实验。

>  
教师用户应使用实验模板Lab018创建用于完成本次实验的第一个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab018.git)访问实验模板Lab018  
教师用户应使用实验模板Lab019创建用于完成本次实验的第二个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab019.git)访问实验模板Lab019  
教师用户应使用实验模板Lab020创建用于完成本次实验的第三个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab020.git)访问实验模板Lab020  
教师用户应使用实验模板Lab021创建用于完成本次实验的第四个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab021.git)访问实验模板Lab021   
>

## 实验7函数一
建议学时：1学时

**`实验目的`**
- 掌握定义函数的方法。
- 熟悉声明函数的方法。
- 熟悉调用函数时实参和形参的对应关系，以及“值传递”的方式。
- 学习对多文件的程序的编译和运行。

**`实验任务`**

请读者在本平台的[课程](https://www.codecode.net/dashboard/courses)中，通过领取教师在程序设计课程中布置的任务来分别新建项目，然后按照每个项目中readme.md文件中的要求完成实验。

>  
教师用户应使用实验模板Lab022创建用于完成本次实验的第一个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab022.git)访问实验模板Lab022  
教师用户应使用实验模板Lab023创建用于完成本次实验的第二个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab023.git)访问实验模板Lab023  
教师用户应使用实验模板Lab024创建用于完成本次实验的第三个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab024.git)访问实验模板Lab024   
教师用户应使用实验模板Lab025创建用于完成本次实验的第四个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab025.git)访问实验模板Lab025   
>

## 实验8函数二
建议学时：1学时

**`实验目的`**
- 进一步熟悉怎样利用函数实现指定的任务。
- 熟悉函数的嵌套调用和递归调用的方法。
- 熟悉全局变量和局部变量的概念和用法。

**`实验任务`**

请读者在本平台的[课程](https://www.codecode.net/dashboard/courses)中，通过领取教师在程序设计课程中布置的任务来分别新建项目，然后按照每个项目中readme.md文件中的要求完成实验。

>    
教师用户应使用实验模板Lab026创建用于完成本次实验的第一个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab026.git)访问实验模板Lab026  
教师用户应使用实验模板Lab027创建用于完成本次实验的第二个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab027.git)访问实验模板Lab027  
教师用户应使用实验模板Lab028创建用于完成本次实验的第三个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab028.git)访问实验模板Lab028  
教师用户应使用实验模板Lab029创建用于完成本次实验的第四个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab029.git)访问实验模板Lab029  
>

## 实验9指针一
建议学时：1学时

**`实验目的`**
- 掌握指针和间接访问的概念，会定义和使用指针变量。
- 能正确使用数组的指针和指向数组的指针变量。
- 能正确使用字符串的指针和指向字符串的指针变量。

**`实验任务`**

请读者在本平台的[课程](https://www.codecode.net/dashboard/courses)中，通过领取教师在程序设计课程中布置的任务来分别新建项目，然后按照每个项目中readme.md文件中的要求完成实验。

>  
教师用户应使用实验模板Lab030创建用于完成本次实验的第一个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab030.git)访问实验模板Lab030  
教师用户应使用实验模板Lab031创建用于完成本次实验的第二个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab031.git)访问实验模板Lab031  
教师用户应使用实验模板Lab032创建用于完成本次实验的第三个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab032.git)访问实验模板Lab032   
教师用户应使用实验模板Lab033创建用于完成本次实验的第四个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab033.git)访问实验模板Lab033   
教师用户应使用实验模板Lab034创建用于完成本次实验的第五个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab034.git)访问实验模板Lab034   
>

## 实验10指针二
建议学时：1学时

**`实验目的`**
- 进一步掌握指针的应用。
- 能正确使用数组的指针和指向数组的指针变量。
- 能正确使用字符串的指针和指向字符串的指针变量。
- 了解指向指针的指针的用法。

**`实验任务`**

请读者在本平台的[课程](https://www.codecode.net/dashboard/courses)中，通过领取教师在程序设计课程中布置的任务来分别新建项目，然后按照每个项目中readme.md文件中的要求完成实验。

>   
教师用户应使用实验模板Lab035创建用于完成本次实验的第一个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab035.git)访问实验模板Lab035  
教师用户应使用实验模板Lab036创建用于完成本次实验的第二个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab036.git)访问实验模板Lab036  
教师用户应使用实验模板Lab037创建用于完成本次实验的第三个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab037.git)访问实验模板Lab037   
教师用户应使用实验模板Lab038创建用于完成本次实验的第四个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab038.git)访问实验模板Lab038   
>

## 实验11自定义数据类型
建议学时：1学时

**`实验目的`**
- 掌握结构体类型变量的定义和使用。
- 掌握结构体类型数组的概念和使用。
- 了解链表的概念和操作方法。

**`实验任务`**

请读者在本平台的[课程](https://www.codecode.net/dashboard/courses)中，通过领取教师在程序设计课程中布置的任务来分别新建项目，然后按照每个项目中readme.md文件中的要求完成实验。

>   
教师用户应使用实验模板Lab039创建用于完成本次实验的第一个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab039.git)访问实验模板Lab039  
教师用户应使用实验模板Lab040创建用于完成本次实验的第二个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab040.git)访问实验模板Lab040  
教师用户应使用实验模板Lab041创建用于完成本次实验的第三个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab041.git)访问实验模板Lab041   
>

## 实验12文件操作
建议学时：1学时

**`实验目的`**
- 了解文件和文件指针的概念。
- 学会使用文件操作函数实现对文件打开、关闭、读、写等操作。
- 学会对数据文件进行简单的操作。

**`实验任务`**

请读者在本平台的[课程](https://www.codecode.net/dashboard/courses)中，通过领取教师在程序设计课程中布置的任务来分别新建项目，然后按照每个项目中readme.md文件中的要求完成实验。

>   
教师用户应使用实验模板Lab042创建用于完成本次实验的第一个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab042.git)访问实验模板Lab042  
教师用户应使用实验模板Lab043创建用于完成本次实验的第二个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab043.git)访问实验模板Lab043  
教师用户应使用实验模板Lab044创建用于完成本次实验的第三个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab044.git)访问实验模板Lab044   
>

## 实验13预处理指令
建议学时：1学时

**`实验目的`**
- 了解预处理器的工作原理。
- 掌握预处理器的主要功能：宏定义、文件包含和条件编译。

**`实验任务`**

请读者在本平台的[课程](https://www.codecode.net/dashboard/courses)中，通过领取教师在程序设计课程中布置的任务来分别新建项目，然后按照每个项目中readme.md文件中的要求完成实验。

>   
教师用户应使用实验模板Lab053创建用于完成本次实验的第一个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab053.git)访问实验模板Lab053  
教师用户应使用实验模板Lab045创建用于完成本次实验的第二个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab045.git)访问实验模板Lab045  
教师用户应使用实验模板Lab046创建用于完成本次实验的第三个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab046.git)访问实验模板Lab046   
教师用户应使用实验模板Lab047创建用于完成本次实验的第四个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab047.git)访问实验模板Lab047  
教师用户应使用实验模板Lab048创建用于完成本次实验的第五个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab048.git)访问实验模板Lab048  
教师用户应使用实验模板Lab049创建用于完成本次实验的第六个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab049.git)访问实验模板Lab049  
>

## 实验14位运算  
建议学时：1学时  

**`实验目的`**
- 理解位运算并掌握各种位运算符的用法。
- 理解位段的含义和用法。

**`实验任务`**

请读者在本平台的[课程](https://www.codecode.net/dashboard/courses)中，通过领取教师在程序设计课程中布置的任务来分别新建项目，然后按照每个项目中readme.md文件中的要求完成实验。

>    
教师用户应使用实验模板Lab050创建用于完成本次实验的第一个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab050.git)访问实验模板Lab050  
教师用户应使用实验模板Lab051创建用于完成本次实验的第二个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab051.git)访问实验模板Lab051  
教师用户应使用实验模板Lab052创建用于完成本次实验的第三个任务，[domain relative url](engintime/cpp-lab/Project-Template/c-language/Lab052.git)访问实验模板Lab052    
>



# C++语言程序设计实验

C++语言程序设计实验部分提供了17个实验题目，主要包含61个实验模板，涵盖了输入输出、数据类型、函数、数组、指针、自定义数据类型、运算符、类和对象、运算符重载、多态、文件流、位运算等重要的知识点。  在每个实验题目下面包含了相应的实验模板，每个模板可以有针对性的对知识点进行练习，通过使用这些模板根据题目的要求完成实验，就可以对C++语言中的绝大部分的知识进行强化。通过完成这些实验，可以提高编程水平，对以后从事相关方面的研发有很大的帮助作用。  

## 实验题目清单
[实验1 实验环境的使用](#实验1实验环境的使用)  
[实验2 数据类型与表达式](#实验2数据类型与表达式)  
[实验3 C++程序设计初步](#实验3c程序设计初步)  
[实验4 函数](#实验4函数)  
[实验5 数组](#实验5数组)  
[实验6 指针](#实验6指针)  
[实验7 自定义数据类型（一）](#实验7自定义数据类型（一）)  
[实验8 自定义数据类型（二）](#实验8自定义数据类型（二）)  
[实验9 类和对象（一）](#实验9类和对象（一）)  
[实验10 类和对象（二）](#实验10类和对象（二）)  
[实验11 运算符重载](#实验11运算符重载)  
[实验12 继承与派生](#实验12继承与派生)  
[实验13 多态性与虚函数](#实验13多态性与虚函数)  
[实验14 输入输出流](#实验14输入输出流)  
[实验15 预处理指令](#实验15预处理指令)  
[实验16 位运算](#实验16位运算)  
[实验17 C++工具](#实验17c工具)  

## 实验1实验环境的使用
建议学时：1学时

**`实验目的`**

- 熟悉C&C++ Lab的基本使用方法。
- 了解在C&C++ Lab上如何编辑、编译、链接和运行一个C++程序。
- 通过运行简单的C++程序，初步了解C源程序的特点。

**`实验任务`**

如果是第一次使用C&C++ Lab完成实验，请先阅读[《C&C++ Lab 使用手册》](./app-manual.md)，这样读者可以学习C&C++ Lab的使用方法，后面的实验按照使用手册供的实验步骤就可以顺利完成。  

请读者在本平台的[课程](https://www.codecode.net/dashboard/courses)中，通过领取教师在程序设计课程中布置的任务来分别新建项目，然后按照每个项目中readme.md文件中的要求完成实验。

>
教师用户应使用实验模板Lab101创建用于完成本次实验的第一个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab101.git)访问实验模板Lab101   
教师用户应使用实验模板Lab102创建用于完成本次实验的第二个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab102.git)访问实验模板Lab102
>

## 实验2数据类型与表达式
建议学时：1学时

**`实验目的`**
- 掌握 C++语言数据类型，熟悉如何定义变量，以及对它们赋值的方法。
- 学会使用 C++有关算术运算符，以及包含这些运算符的表达式。
- 进一步熟悉 C++程序的数据结构。
- 进一步熟悉 C++程序的编辑、编译、连接和运行的过程。

**`实验任务`**  

请读者在本平台的[课程](https://www.codecode.net/dashboard/courses)中，通过领取教师在程序设计课程中布置的任务来分别新建项目，然后按照每个项目中readme.md文件中的要求完成实验。

>                                                                         
教师用户应使用实验模板Lab103创建用于完成本次实验的第一个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab103.git)访问实验模板Lab103  
教师用户应使用实验模板Lab104创建用于完成本次实验的第二个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab104.git)访问实验模板Lab104    
教师用户应使用实验模板Lab105创建用于完成本次实验的第三个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab105.git)访问实验模板Lab105  
教师用户应使用实验模板Lab105-1创建用于完成本次实验的第四个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab105-1.git)访问实验模板Lab105-1  
教师用户应使用实验模板Lab105-2创建用于完成本次实验的第五个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab105-2.git)访问实验模板Lab105-2  
教师用户应使用实验模板Lab105-3创建用于完成本次实验的第六个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab105-3.git)访问实验模板Lab105-3  
教师用户应使用实验模板Lab106创建用于完成本次实验的第七个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab106.git)访问实验模板Lab106  
教师用户应使用实验模板Lab106-1创建用于完成本次实验的第八个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab106.git)访问实验模板Lab106-1   
教师用户应使用实验模板Lab106-2创建用于完成本次实验的第九个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab106.git)访问实验模板Lab106-2   
>

## 实验3C++程序设计初步
建议学时：1学时

**`实验目的`**
- 掌握简单的 C++程序的编写和调试方法。
- 掌握 C++程序中使用最多的语句——赋值语句和输入输出的使用方法。
- 掌握结构化程序的 3 种基本结构（顺序结构、选择结构、循环结构）在 C++中的实现。

**`实验任务`**

请读者在本平台的[课程](https://www.codecode.net/dashboard/courses)中，通过领取教师在程序设计课程中布置的任务来分别新建项目，然后按照每个项目中readme.md文件中的要求完成实验。

>   
教师用户应使用实验模板Lab107创建用于完成本次实验的第一个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab107.git)访问实验模板Lab107   
教师用户应使用实验模板Lab108创建用于完成本次实验的第二个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab108.git)访问实验模板Lab108   
教师用户应使用实验模板Lab109创建用于完成本次实验的第三个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab109.git)访问实验模板Lab109   
教师用户应使用实验模板Lab109-1创建用于完成本次实验的第四个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab109-1.git)访问实验模板Lab109-1   
教师用户应使用实验模板Lab110创建用于完成本次实验的第五个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab110.git)访问实验模板Lab110   
>

## 实验4函数
建议学时：1学时

**`实验目的`**
- 掌握定义函数的方法、函数实参与形参的对应关系以及“值传递”的方式。
- 熟悉函数的嵌套调用和递归调用的方法。
- 熟悉全局变量、局部变量概念和使用方式。
- 掌握多文件的程序的编译和运行的方法。


**`实验任务`**

请读者在本平台的[课程](https://www.codecode.net/dashboard/courses)中，通过领取教师在程序设计课程中布置的任务来分别新建项目，然后按照每个项目中readme.md文件中的要求完成实验。

>  
教师用户应使用实验模板Lab111创建用于完成本次实验的第一个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab011.git)访问实验模板Lab111   
教师用户应使用实验模板Lab112创建用于完成本次实验的第二个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab112.git)访问实验模板Lab112  
教师用户应使用实验模板Lab113创建用于完成本次实验的第三个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab113.git)访问实验模板Lab113  
教师用户应使用实验模板Lab114创建用于完成本次实验的第四个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab114.git)访问实验模板Lab114  
>


## 实验5数组
建议学时：1学时

**`实验目的`**
- 掌握一维数组和二维数组的定义、赋值和输入输出的方法。
- 掌握字符数组和字符串函数的使用。
- 掌握与数组有关的算法（特别是排序算法）。


**`实验任务`**

请读者在本平台的[课程](https://www.codecode.net/dashboard/courses)中，通过领取教师在程序设计课程中布置的任务来分别新建项目，然后按照每个项目中readme.md文件中的要求完成实验。

>   
教师用户应使用实验模板Lab115创建用于完成本次实验的第一个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab115.git)访问实验模板Lab115   
教师用户应使用实验模板Lab115-1创建用于完成本次实验的第二个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab115-1.git)访问实验模板Lab115-1   
教师用户应使用实验模板Lab116创建用于完成本次实验的第三个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab116.git)访问实验模板Lab116   
教师用户应使用实验模板Lab117创建用于完成本次实验的第四个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab117.git)访问实验模板Lab117    
教师用户应使用实验模板Lab117-1创建用于完成本次实验的第五个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab117-1.git)访问实验模板Lab117-1   
教师用户应使用实验模板Lab117-2创建用于完成本次实验的第六个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab117-2.git)访问实验模板Lab117-2  
教师用户应使用实验模板Lab118创建用于完成本次实验的第七个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab118.git)访问实验模板Lab118  
教师用户应使用实验模板Lab119创建用于完成本次实验的第八个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab119.git)访问实验模板Lab119   
>
 
## 实验6指针
建议学时：1学时

**`实验目的`**
- 通过实验进一步掌握指针的概念，会定义和使用指针变量。
- 能正确使用数组的指针和指向数组的指针变量。
- 能正确使用字符串的指针和指向字符串的指针变量。
- 能正确使用引用型变量。

**`实验任务`**

请读者在本平台的[课程](https://www.codecode.net/dashboard/courses)中，通过领取教师在程序设计课程中布置的任务来分别新建项目，然后按照每个项目中readme.md文件中的要求完成实验。

>  
教师用户应使用实验模板Lab120创建用于完成本次实验的第一个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab120.git)访问实验模板Lab120  
教师用户应使用实验模板Lab121创建用于完成本次实验的第二个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab121.git)访问实验模板Lab121  
教师用户应使用实验模板Lab122创建用于完成本次实验的第三个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab122.git)访问实验模板Lab122  
教师用户应使用实验模板Lab123创建用于完成本次实验的第四个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab123.git)访问实验模板Lab123  
教师用户应使用实验模板Lab124创建用于完成本次实验的第五个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab124.git)访问实验模板Lab124  
>

 

## 实验7自定义数据类型（一）
建议学时：1学时

**`实验目的`**
- 掌握结构体类型变量的定义和使用。
- 掌握结构体类型数组的概念和使用。

**`实验任务`**

请读者在本平台的[课程](https://www.codecode.net/dashboard/courses)中，通过领取教师在程序设计课程中布置的任务来分别新建项目，然后按照每个项目中readme.md文件中的要求完成实验。

>  
教师用户应使用实验模板Lab125创建用于完成本次实验的第一个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab125.git)访问实验模板Lab125  
教师用户应使用实验模板Lab126创建用于完成本次实验的第二个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab126.git)访问实验模板Lab126  
教师用户应使用实验模板Lab127创建用于完成本次实验的第三个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab127.git)访问实验模板Lab127   
>
 

## 实验8自定义数据类型（二）
建议学时：1学时

**`实验目的`**
- 了解链表的概念和操作方法。

**`实验任务`**

请读者在本平台的[课程](https://www.codecode.net/dashboard/courses)中，通过领取教师在程序设计课程中布置的任务来分别新建项目，然后按照每个项目中readme.md文件中的要求完成实验。

>    
教师用户应使用实验模板Lab128创建用于完成本次实验的第一个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab128.git)访问实验模板Lab128  
教师用户应使用实验模板Lab129创建用于完成本次实验的第二个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab129.git)访问实验模板Lab129  
教师用户应使用实验模板Lab130创建用于完成本次实验的第三个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab130.git)访问实验模板Lab130  
>

 
## 实验9类和对象（一）
建议学时：1学时

**`实验目的`**
- 掌握声明类的方法，类和类的成员的概念以及定义对象的方法。
- 初步掌握用类和对象编制基于对象的程序。
- 学习检查和调试基于对象的程序。

**`实验任务`**

请读者在本平台的[课程](https://www.codecode.net/dashboard/courses)中，通过领取教师在程序设计课程中布置的任务来分别新建项目，然后按照每个项目中readme.md文件中的要求完成实验。

>  
教师用户应使用实验模板Lab131创建用于完成本次实验的第一个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab131.git)访问实验模板Lab131  
教师用户应使用实验模板Lab131-1创建用于完成本次实验的第二个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab131-1.git)访问实验模板Lab131-1   
教师用户应使用实验模板Lab132创建用于完成本次实验的第三任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab132.git)访问实验模板Lab132   
教师用户应使用实验模板Lab133创建用于完成本次实验的第四个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab133.git)访问实验模板Lab133  
>

## 实验10类和对象（二）
建议学时：1学时

**`实验目的`**
- 进一步加深对类和对象的理解。
- 掌握类的构造函数和析构函数的概念和使用方法。
- 掌握对象数组、对象的指针及其使用方法。
- 掌握友元的概念和使用。
- 了解类模板的使用方法。

**`实验任务`**

请读者在本平台的[课程](https://www.codecode.net/dashboard/courses)中，通过领取教师在程序设计课程中布置的任务来分别新建项目，然后按照每个项目中readme.md文件中的要求完成实验。

>    
教师用户应使用实验模板Lab134创建用于完成本次实验的第一个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab134.git)访问实验模板Lab134   
教师用户应使用实验模板Lab135创建用于完成本次实验的第二个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab135.git)访问实验模板Lab135  
教师用户应使用实验模板Lab136创建用于完成本次实验的第三个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab136.git)访问实验模板Lab136  
教师用户应使用实验模板Lab137创建用于完成本次实验的第四个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab137.git)访问实验模板Lab137  
教师用户应使用实验模板Lab137-1创建用于完成本次实验的第五个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab137-1.git)访问实验模板Lab137-1   
教师用户应使用实验模板Lab138创建用于完成本次实验的第六个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab138.git)访问实验模板Lab138  
教师用户应使用实验模板Lab138-1创建用于完成本次实验的第七个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab138-1.git)访问实验模板Lab138-1  
>


## 实验11运算符重载
建议学时：1学时

**`实验目的`**
- 进一步了解运算符重载的概念和使用方法。
- 掌握几种常用的运算符重载的方法。
- 了解转换构造函数的使用方法。

**`实验任务`**

请读者在本平台的[课程](https://www.codecode.net/dashboard/courses)中，通过领取教师在程序设计课程中布置的任务来分别新建项目，然后按照每个项目中readme.md文件中的要求完成实验。

>   
教师用户应使用实验模板Lab139创建用于完成本次实验的第一个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab139.git)访问实验模板Lab139  
教师用户应使用实验模板Lab140创建用于完成本次实验的第二个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab140.git)访问实验模板Lab140  
教师用户应使用实验模板Lab141创建用于完成本次实验的第三个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab141.git)访问实验模板Lab141  
教师用户应使用实验模板Lab142创建用于完成本次实验的第四个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab142.git)访问实验模板Lab142    
>


## 实验12继承与派生
建议学时：1学时

**`实验目的`**
- 了解继承在面向对象程序程序设计中的重要作用。
- 进一步理解继承与派生的概念。
- 掌握通过继承派生出一个新的类的方法。

**`实验任务`**

请读者在本平台的[课程](https://www.codecode.net/dashboard/courses)中，通过领取教师在程序设计课程中布置的任务来分别新建项目，然后按照每个项目中readme.md文件中的要求完成实验。

>   
教师用户应使用实验模板Lab143创建用于完成本次实验的第一个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab143.git)访问实验模板Lab143   
教师用户应使用实验模板Lab144创建用于完成本次实验的第二个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab144.git)访问实验模板Lab144     
教师用户应使用实验模板Lab145创建用于完成本次实验的第三个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab145.git)访问实验模板Lab145   
教师用户应使用实验模板Lab146创建用于完成本次实验的第四个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab146.git)访问实验模板Lab146   
>


## 实验13多态性与虚函数
建议学时：1学时

**`实验目的`**
- 了解多态性的概念。
- 了解虚函数的作用及使用方法。
- 了解静态关联和动态关联的概念和用法。
- 了解纯虚函数和抽象类的概念和用法。

**`实验任务`**

请读者在本平台的[课程](https://www.codecode.net/dashboard/courses)中，通过领取教师在程序设计课程中布置的任务来分别新建项目，然后按照每个项目中readme.md文件中的要求完成实验。

>      
教师用户应使用实验模板Lab147创建用于完成本次实验的第一个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab147.git)访问实验模板Lab147  
教师用户应使用实验模板Lab148创建用于完成本次实验的第二个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab148.git)访问实验模板Lab148  
教师用户应使用实验模板Lab149创建用于完成本次实验的第三个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab149.git)访问实验模板Lab149  
>
 

## 实验14输入输出流
建议学时：1学时  

**`实验目的`**
- 深入理解 C++的输入输出的含义及其实现方法。
- 掌握标准输入输出流的应用，包括格式输入输出。
- 掌握对文件的输入输出。

**`实验任务`**

请读者在本平台的[课程](https://www.codecode.net/dashboard/courses)中，通过领取教师在程序设计课程中布置的任务来分别新建项目，然后按照每个项目中readme.md文件中的要求完成实验。

>    
教师用户应使用实验模板Lab150创建用于完成本次实验的第一个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab150.git)访问实验模板Lab150  
教师用户应使用实验模板Lab151创建用于完成本次实验的第二个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab151.git)访问实验模板Lab151  
教师用户应使用实验模板Lab152创建用于完成本次实验的第三个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab152.git)访问实验模板Lab152    
>


## 实验15预处理指令
建议学时：1学时  

**`实验目的`**
- 深入理解 C++的输入输出的含义及其实现方法。
- 掌握标准输入输出流的应用，包括格式输入输出。
- 掌握对文件的输入输出。

**`实验任务`**

请读者在本平台的[课程](https://www.codecode.net/dashboard/courses)中，通过领取教师在程序设计课程中布置的任务来分别新建项目，然后按照每个项目中readme.md文件中的要求完成实验。

>    
教师用户应使用实验模板Lab153创建用于完成本次实验的第一个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab153.git)访问实验模板Lab153  
教师用户应使用实验模板Lab154创建用于完成本次实验的第二个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab154.git)访问实验模板Lab154  
教师用户应使用实验模板Lab155创建用于完成本次实验的第三个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab155.git)访问实验模板Lab155  
教师用户应使用实验模板Lab156创建用于完成本次实验的第四个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab156.git)访问实验模板Lab156   
>
 
## 实验16位运算
建议学时：1学时  

**`实验目的`**
- 理解位运算并掌握各种位运算符的用法。
- 理解位段的含义和用法。

**`实验任务`**

请读者在本平台的[课程](https://www.codecode.net/dashboard/courses)中，通过领取教师在程序设计课程中布置的任务来分别新建项目，然后按照每个项目中readme.md文件中的要求完成实验。

>    
教师用户应使用实验模板Lab157创建用于完成本次实验的第一个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab157.git)访问实验模板Lab157  
教师用户应使用实验模板Lab158创建用于完成本次实验的第二个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab158.git)访问实验模板Lab158   
教师用户应使用实验模板Lab159创建用于完成本次实验的第三个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab159.git)访问实验模板Lab159   
>



## 实验17C++工具
建议学时：1学时  

**`实验目的`**
- 学会使用 C++的异常处理机制进行程序的调试。
- 学会使用命名空间解决名字冲突。

**`实验任务`**

请读者在本平台的[课程](https://www.codecode.net/dashboard/courses)中，通过领取教师在程序设计课程中布置的任务来分别新建项目，然后按照每个项目中readme.md文件中的要求完成实验。

>    
教师用户应使用实验模板Lab160创建用于完成本次实验的第一个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab160.git)访问实验模板Lab160  
教师用户应使用实验模板Lab161创建用于完成本次实验的第二个任务，[domain relative url](engintime/cpp-lab/Project-Template/cpp-language/Lab161.git)访问实验模板Lab161   
>

# EOJ题库

`Coming soon`

# 参考文献

`Coming soon`