#include "console.h"

int SectionCnt;   								// ڵ
DWORD dwExportVA, dwExPointerToRawData;			// 浼ĵַϢ
DWORD dwImportVA, dwImPointerToRawData;

// ַļеλת
DWORD OnConvertVAToRawA(DWORD dwTransVA, DWORD dwSectionVA, DWORD dwPointerToRawData)
{
	// ַƫټڽڵPointerToRawDataɽַתļеλ
	// תõĵַ
	return dwTransVA - dwSectionVA + dwPointerToRawData;
}

void ReadDosHeader()
{
	// DOS Header ļʼ
	fseek(g_pFile, 0, SEEK_SET);
	fread(&g_DosHeader, sizeof(g_DosHeader), 1, g_pFile);
	
	// жDOSͷǷϷ
	if(g_DosHeader.e_magic != 0x5A4D)
	{
		printf("DOSͷϷ\n");
		exit(1);
	}
	
	// ӡ
	printf("****** DOS Header ******\n");
	printf("magic: %.4s\n", (CHAR*)&g_DosHeader.e_magic);
	printf("e_lfanew: 0x%X\n\n",g_DosHeader.e_lfanew);

}

void ReadNTHeader()
{
	// DOS Header е e_lfanew 洢 NT Header ļʼƫֵ
	fseek(g_pFile, g_DosHeader.e_lfanew, SEEK_SET);
	fread(&g_NTHeaders, sizeof(g_NTHeaders), 1, g_pFile);
	
	// жǷΪЧPEļ
	if(g_NTHeaders.Signature != 0x4550)
	{
		printf("ЧPEļ\n");
		exit(1);
	}
	
	// ڵ
	SectionCnt = g_NTHeaders.FileHeader.NumberOfSections;

	// ӡ
	printf("****** NT Header ******\n");
	printf("Signature: %.4s\n", (CHAR*)&g_NTHeaders.Signature);
	printf("NumberOfSections: %d\n", g_NTHeaders.FileHeader.NumberOfSections);
	printf("SizeOfOptionalHeader: 0x%X\n", g_NTHeaders.FileHeader.SizeOfOptionalHeader);
	printf("AddressOfEntryPoint: 0x%X\n", g_NTHeaders.OptionalHeader.AddressOfEntryPoint);
	printf("BaseOfCode: 0x%X\n", g_NTHeaders.OptionalHeader.BaseOfCode);
	printf("BaseOfData: 0x%X\n", g_NTHeaders.OptionalHeader.BaseOfData);
	printf("ImageBase: 0x%X\n", g_NTHeaders.OptionalHeader.ImageBase);
	printf("SectionAlignment: 0x%X\n", g_NTHeaders.OptionalHeader.SectionAlignment);
	printf("FileAlignment: 0x%X\n\n", g_NTHeaders.OptionalHeader.FileAlignment);
}

void ReadSectionTable()
{
	// Section Table  NT Header ֮󡣵ǲӦʹ NT Header ĴС
	// ֱӼλãӦʹ File Header е SizeOfOptionalHeader 㡣
	//  Optional Header 仯¼ʹá
	ULONG FileOffset;
	ULONG SectionTableSize;

	FileOffset = g_DosHeader.e_lfanew + sizeof(g_NTHeaders.Signature)
		+ sizeof(g_NTHeaders.FileHeader) + g_NTHeaders.FileHeader.SizeOfOptionalHeader;
	SectionTableSize = g_NTHeaders.FileHeader.NumberOfSections * sizeof(PE_IMAGE_SECTION_HEADER);

	g_pSectionTable = (PE_IMAGE_SECTION_HEADER*)malloc(SectionTableSize);

    // ļָλãļͷʼsectiontableƫFileOffset
	fseek(g_pFile, FileOffset, SEEK_SET);
	
	// ļжȡһSectionTableSizeСݴŵg_pSectionTableָĻַС
	fread(g_pSectionTable, SectionTableSize, 1, g_pFile);
	
	// ӡ
	printf("****** Section Table ******\n");
	for(int i = 0; i < SectionCnt; i++, g_pSectionTable++)
	{
		// ȡõĵַϢ
		if(strcmp(g_pSectionTable->Name, ".edata") == 0)
		{
			dwExportVA = g_pSectionTable->VirtualAddress;
			dwExPointerToRawData = g_pSectionTable->PointerToRawData;
		}
		// ȡõĵַϢ
		if(strcmp(g_pSectionTable->Name, ".idata") == 0)
		{
			dwImportVA = g_pSectionTable->VirtualAddress;
			dwImPointerToRawData = g_pSectionTable->PointerToRawData;
		}
		
		printf("Number%d\n", i+1);
		printf("Name%.8s\n", g_pSectionTable->Name);
		printf("VirtualSize%08x\n", g_pSectionTable->Misc.VirtualSize);
		printf("VirtualAddress0x%08x\n", g_pSectionTable->VirtualAddress);
		printf("SizeOfRawData0x%08x\n", g_pSectionTable->SizeOfRawData);
		printf("PointerToRawData0x%08x\n", g_pSectionTable->PointerToRawData);
		printf("PointerToRelocations0x%08x\n", g_pSectionTable->PointerToRelocations);
		printf("PointerToLinenumbers0x%08x\n", g_pSectionTable->PointerToLinenumbers);
		printf("NumberOfRelocations0x%04x\n", g_pSectionTable->NumberOfRelocations);
		printf("NumberOfLinenumbers0x%04x\n", g_pSectionTable->NumberOfLinenumbers);
		printf("Characteristics0x%08x\n\n", g_pSectionTable->Characteristics);
	}
	
}

// ӡ
void ReadImportTable()
{
	// ӡ
	printf("\n****** Import Table ******\n");
	
	// Ŀ¼ĵڶԪΪ
	printf("ƫƵַ%04x\n", g_NTHeaders.OptionalHeader.DataDirectory[1].VirtualAddress);
	printf("ĴС%04x\n\n", g_NTHeaders.OptionalHeader.DataDirectory[1].Size);
	
	DWORD dwFileOffset;
	
	// ݷǿ
	if (g_NTHeaders.OptionalHeader.DataDirectory[1].VirtualAddress != 0)
	{
		// VAתΪļƫ
		dwFileOffset = OnConvertVAToRawA(g_NTHeaders.OptionalHeader.DataDirectory[1].VirtualAddress, dwImportVA, dwImPointerToRawData);

  		printf("ļƫΪ%08x\n", dwFileOffset);

   		// DLL	
  		g_ImportDsr = (PE_IMAGE_IMPORT_DESCRIPTOR *)malloc(sizeof(PE_IMAGE_IMPORT_DESCRIPTOR));
  		
  		// ļƫ
  		fseek(g_pFile, dwFileOffset, SEEK_SET);
  		fread(g_ImportDsr, sizeof(PE_IMAGE_IMPORT_DESCRIPTOR), 1, g_pFile);
  		
  		// õDLL
  		int nDllCount = 0;
  		while ((0 != g_ImportDsr->FirstThunk) || (0 != g_ImportDsr->ForwarderChain) || (0 != g_ImportDsr->Name) 
  		|| (0 != g_ImportDsr->u.OriginalFirstThunk) || (0 != g_ImportDsr->u.Characteristics) || (0 != g_ImportDsr->TimeDateStamp) )
  		{
    		nDllCount++;
    		fread(g_ImportDsr, sizeof(PE_IMAGE_IMPORT_DESCRIPTOR), 1, g_pFile);
  		}
  		printf("\nDLLΪ%d\n", nDllCount);
  		
  		// dllΪ0dllֺ͵úĸ
  		if(nDllCount != 0)
  		{
  			PE_IMAGE_IMPORT_DESCRIPTOR *pg_ImportDsr = (PE_IMAGE_IMPORT_DESCRIPTOR *)calloc(nDllCount, sizeof(PE_IMAGE_IMPORT_DESCRIPTOR)); // prince 01
  			fseek(g_pFile, dwFileOffset, SEEK_SET);
  			fread(pg_ImportDsr, sizeof(PE_IMAGE_IMPORT_DESCRIPTOR), nDllCount, g_pFile);
		
			// dll
  			DWORD *pNameFileOffset = (DWORD *)malloc(sizeof(DWORD) * nDllCount); // prince 02
  			DWORD *pOriginalFirstThunkFileOffset = (ULONG *)malloc(sizeof(ULONG) * nDllCount); // prince 02

  			// ȡЩDllNameVAתΪpNameFileOffsetpNamefileOffset
    		*pNameFileOffset = OnConvertVAToRawA(pg_ImportDsr->Name, dwImportVA, dwImPointerToRawData);
    		*pOriginalFirstThunkFileOffset = OnConvertVAToRawA(pg_ImportDsr->FirstThunk, dwImportVA, dwImPointerToRawData);
  		
  			DWORD *pName = (DWORD *)calloc(nDllCount, sizeof(DWORD));  
  		
    		//ÿοһchName[16]ڴName
    		char *pchName = (char *)malloc(sizeof(char) * 16);     
    		
    		// ڴĵַ浽*pName
    		*pName = (DWORD)pchName;

			// ļȡDLL
    		DWORD dwDllName = *pNameFileOffset;
    		fseek(g_pFile, dwDllName, SEEK_SET);
    		char chTemp[16] = {0};
    		fread((void *)*pName, 16, 1, g_pFile);
  			printf("\nһDLL֣%s\n", *pName);
  	
			// DLLеúĸ
			int *pnFunctionCountPerDll = (int *)calloc(nDllCount, sizeof(int));                  

  			IMAGE_THUNK_DATA *pITD = (IMAGE_THUNK_DATA *)malloc(sizeof(IMAGE_THUNK_DATA));   
	
  			for (int i = 0; i < nDllCount; i++, pnFunctionCountPerDll++, pOriginalFirstThunkFileOffset++)
  			{
    			fseek(g_pFile, *pOriginalFirstThunkFileOffset, SEEK_SET);
    			fread(pITD, sizeof(IMAGE_THUNK_DATA), 1, g_pFile);
    			int nFunctionCount = 0;
    			while ((pITD->u1.ForwarderString != 0) || (pITD->u1.Function != 0) || (pITD->u1.Ordinal != 0) || (pITD->u1.AddressOfData != 0))
    			{
      				nFunctionCount++;
      				fread(pITD, sizeof(IMAGE_THUNK_DATA), 1, g_pFile);
      			
    			}    		
    			*pnFunctionCountPerDll = nFunctionCount;
  			}
	
  			pOriginalFirstThunkFileOffset -= nDllCount;
  			pnFunctionCountPerDll  -= nDllCount;
  	
  			printf("\nһDLLеĺ%d\n", *pnFunctionCountPerDll);
  				
  		}					
	}
	else
	{
		printf("ļ޵\n");
	}

}
