#include "DoubleLinkList.h"
#include <stdlib.h>

int main(int argc, char* argv[])
{
	int i;
	ElemType Elem;
	// A pointer to the head of a bidirectional circular list,Points to the header node
	DuLinkList* pListHead;	
	DuLinkList* pListNode;	// Bidirectional circular list node pointer
	DuLinkList* pListHeadTemp;	
	//
	// Initializes a pointer to the head node of a bidirectional circular list
	//
	pListHead = (DuLinkList*)malloc(sizeof(DuLinkList));
	pListHead->prior = pListHead;
	pListHead->next = pListHead;
	
	//
	// Initializes the nodes of a bidirectional circular list
	//
	for (i=8; i>0; i--)
	{
		pListNode = (DuLinkList*)malloc(sizeof(DuLinkList));
		pListNode->data = i;
		
		pListNode->next = pListHead->next;
		pListNode->prior = pListHead;
		pListHead->next->prior = pListNode;		
		pListHead->next = pListNode;
	}
	
	//
	// Delete the ith node
	//
	Delete(pListHead,  3, &Elem);
	Delete(pListHead, 20, &Elem);	// Illegal deletion of location. Deletion failed.
	
	pListHeadTemp = pListHead;
	pListNode = pListHeadTemp->next;
	while (pListNode != pListHeadTemp)
	{
		printf("%d ", pListNode->data);
		pListNode = pListNode->next;		
	}
	printf("\n");
	
	//
	// Destroy bidirectional circular linked list
	//
	while (pListHead->next != pListHead)
	{
		pListNode = pListHead->next;
		pListHead->next = pListNode->next;
		pListNode->next->prior = pListHead;
		
		free(pListNode);
	}
	free(pListHead);

	return 0;
}

/*
function:
	Delete the ith node.

parameter:
	pListHead -- A pointer to the head of a bidirectional circular list
	i -- Delete the location of the node.Count from 1.
	pElem -- Returns the value of the deleted node.
	  
returned value:
	Returns 1 if deletion succeeds
	Returns 1 if deletion fails
*/
int Delete(DuLinkList* pListHead, int i, ElemType* pElem)
{
	DuLinkList* pListNode;			// Node pointer
	
	//
	// TODO: Add the code here
	//	
	
	return 0;
}

