#include "BinaryTree.h"
#include <stdlib.h>

int main(int argc, char* argv[])
{
	BiTree pTree;	// pointer to a binary tree
	int i;
	
	//
	// CreatBiTree
	//
	pTree = InitTree();
	
	//
	// Middle order traverses binary trees
	//
	InOrder(pTree);

	for (i = 0; i < g_length - 1; i++)
	{
		printf("%c", g_string[i]);
	} 
	printf("\n");
	
	//
	// Destroy the binary tree
	//
	DeleteTree(pTree);

	return 0;
}

/*
function:
	Middle order traverses binary trees.Stack implementation of non - recursive algorithm.

parameter:
	BiTree -- pointer to a binary tree
  
returned value:
	Returns 1 if the traversal succeeds
	Returns 0 if the traversal fails
*/

// String. Used to save the middle order sequence of a binary tree during traversal
char g_string[MAX_STRING_SIZE];		
int g_length = 0;				// The string length.0 indicates an empty string
int InOrder(BiTree pTree)
{
	BiTNode* Stack[MAX_STACK_SIZE];		// Stack. Used to store parent nodes
	int top = 0;						// The top of the stack.0 means empty stack
	
	BiTNode* pNode;						// Binary tree node pointer
	
	//
	// TODO: Add the code here
	//
	
	return 0;
}

/*
function:
	Create a node in the binary tree.

parameter:
	data -- Binary tree nodes store data
  
returned value:
	Return node pointer
*/
BiTNode* CreateNode(ElemType data)
{
	BiTNode* pNode = (BiTNode*)malloc(sizeof(BiTNode));
	
	pNode->data = data;
	pNode->lchild = NULL;
	pNode->rchild = NULL;
	
	return pNode;
}


// A binary tree preordered sequence string.
// notice:Using only preordered sequences does not determine a unique binary tree.
// So, two Spaces after the leaf node,
// Also, the sequence ends with the character '\0' at the end of the string.
// In this way, the preordering sequence determines the unique binary tree.
static const char* data = "-*a  -b  c  /d  e";
static int nIndex = 0;	// The index of the binary tree first order sequence

/*
function:
	Create a binary tree from the preordered sequence of the binary tree.
  
returned value:
	Return pointer to a binary tree
*/
BiTree InitTree()
{
	BiTNode* pRootNode;
	
	if ('\0' == data[nIndex])	// End of preordering sequence string of binary tree
	{
		pRootNode = NULL;		
	}
	else
	{
		//
		// Create parent node,Empty nodes must be ignored
		//
		pRootNode = (' ' == data[nIndex] ? NULL : CreateNode(data[nIndex]));	
		nIndex++;
	}
	
	if (pRootNode != NULL)
	{
		//
		// Recursion is used to implement the first order traversal algorithm
		//
		pRootNode->lchild = InitTree();
		pRootNode->rchild = InitTree();
	}
	
	return pRootNode;
}

/*
function:
	Destroy the binary tree.

parameter:
	pTree -- pointer to a binary tree.
  
returned value:
	nothing
*/
void DeleteTree(BiTree pTree)
{
	//
	// The sequential traversal algorithm is implemented by recursion
	//
	if (pTree != NULL)
	{
		DeleteTree(pTree->lchild);
		DeleteTree(pTree->rchild);
		
		free(pTree);
	}
}
