#ifndef BINARYTREE_H_
#define BINARYTREE_H_


//
// Include the C standard library header file here
//

#include <stdio.h>


//
// Other header files are included here
//




//
// Define the data structure here
//

#define MAX_STACK_SIZE 20	// The size of the stack storage space
#define MAX_STRING_SIZE 20	// The size of the string storage space

typedef char ElemType;

typedef struct BiTNode{
	ElemType data;				// Binary tree node data
	struct BiTNode* lchild;		// Left child pointer
	struct BiTNode* rchild;		// Right child pointer
}BiTNode, *BiTree;

typedef enum PushTimes{
	FirstTime,
	SecondTime
}PushTimes;


//
// Declare the function here
//

int PostOrder(BiTree pTree);
BiTNode* CreateNode(ElemType data);
BiTree InitTree();
void DeleteTree(BiTree pTree);


//
// Declare global variables here
//
extern char g_string[MAX_STRING_SIZE];
extern int g_length;


#endif /* BINARYTREE_H_ */
