#include "HuffmanTree.h"
#include <stdlib.h>

int main(int argc, char* argv[])
{
	int i;
	
	//
	// Initializing array
	//
	int WeightArray[] = {2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41};
	int Count = sizeof(WeightArray) / sizeof(WeightArray[0]);
	int HuffmanLength = 2 * Count - 1;
	
	//
	// Initialize the Huffman tree
	//
	PHtTree pTree = (PHtTree)malloc(sizeof(HtTree));
	pTree->HtArray = (HtNode*)malloc(sizeof(HtNode) * HuffmanLength);

	for (i = 0; i < HuffmanLength; i++)
	{
		pTree->HtArray[i].lchild = -1;
		pTree->HtArray[i].rchild = -1;
		pTree->HtArray[i].parent = -1;
		pTree->HtArray[i].Weight = i < Count ? WeightArray[i] : -1;	
	}
	
	//
	// Construction of Huffman tree
	//
	pTree = HuffmanTree(pTree, Count);
	
	OutputResult(pTree, HuffmanLength);
	
	//
	// Destruction tree hoffman
	//
	free(pTree->HtArray);
	free(pTree);
	
	return 0;
}

/*
function:
	Hoffman tree is constructed using a given set of weights.

parameter:
	pTree -- Hoffman tree structure pointer
	Count -- The count of array elements
	
returned value:
	Returns the pointer to the Huffman tree structure.
*/
PHtTree HuffmanTree(PHtTree pTree, int Count)  
{
	// Cursor, which is mainly used to find the index of the smallest node and the second smallest node
	int i, j;           	
	int Index1, Index2;		// Holds the subscript of the smallest and subsmallest nodes       
	int Number1, Number2;	// Store minimum and sub - small node weights 
	
	//
	// TODO: Add the code here
	//	
	
	return pTree;
}

void OutputResult(PHtTree pTree, int Length)
{
	int i;
	printf("subscript\tweight\tparent\tlchild\trchild\n");
	for (i = 0; i < Length; i++)
	{
		printf("%d", i);
		printf("\t\t%d", pTree->HtArray[i].Weight);
		printf("\t\t%d", pTree->HtArray[i].parent);
		printf("\t\t%d", pTree->HtArray[i].lchild);
		printf("\t\t%d\n", pTree->HtArray[i].rchild);	
	}
}
