#ifndef HUFFMANTREE_H_
#define HUFFMANTREE_H_


//
// Include the C standard library header file here
//

#include <stdio.h>


//
// Other header files are included here
//


//
// Define the data structure here
//
 
#define MAXVALUE 1000       // Define the maximum value

// Node structure
typedef struct HtNode{
	int Weight;        			// The node weight
	int parent, lchild, rchild; // The parent and the left and right child are subscripts in the array	
}HtNode;

// The structure of a Huffman tree
typedef struct _HtTree{
	int Count;				  // Number of leaf nodes
	int Root;			  	  // The index of the Huffman root node in the array
	struct HtNode *HtArray;   // The subscript of the Huffman root in an array of 2*Count-1 nodes				
}HtTree, *PHtTree;

//
// Declare the function here
//

PHtTree HuffmanTree(PHtTree pTree, int Count);  // The constructor for the Huffman tree
void OutputResult(PHtTree pTree, int Length);

//
// Declare global variables here
//

#endif /* HUFFMANTREE_H_ */
