#ifndef CSTREE_H_
#define CSTREE_H_


//
// Include the C standard library header file here
//

#include <stdio.h>


//
// Other header files are included here
//

#include "Stack.h"

//
// Define the data structure here
//

#define MAX_NUMBER 50

typedef struct CSNode{
	char data;					// Node data
	struct CSNode *firstchild;	// Child Node
	struct CSNode *nextsibling;	// Brother Node
}CSNode, *CSTree;

//
// Declare the function here
//

CSTree InitTree();
int PreOrder(CSTree pTree);
CSNode* CreateNode(char data);
CSNode* PreOrderCreate(CSTree pTree, char Key);
void CreateSubTree(char* data, CSTree pRootNode);
void DeleteTree(CSTree pTree);
void OutputResult();

//
// Declare global variables here
//

extern Stack stack;
extern char g_string[MAX_NUMBER];
extern int g_length;

#endif /* _CSTREE_H_ */
