#include "Stack.h"


/*
function:
	Initialize the stack.

parameter:
	pS -- The stack pointer
*/
void InitStack(Stack* pS)
{
	pS->top = -1;
}

/*
function:
	Push elements on the stack.

parameter:
	pS -- The stack pointer
	Elem -- Pushed elements
  
returned value:
	Returns the value of the pushed element if the insert succeeds.
	Returns -1 if insert fails.
*/
struct CSNode* Push(Stack* pS, struct CSNode* Elem)
{
	//
	// Stack full, push failed.
	//
	if(MAX_STACK_LENGTH < pS->top)
		return 0;
		
	pS->top++;
	pS->buffer[pS->top] = Elem; // Insert the element at the top of the stack
	
	return Elem;
}

/*
function:
	Pop the top element of the stack

parameter:
	pS -- The stack pointer
  
returned value:
	If the pop succeeds, the value of the pop element is returned.
	Returns -1 if pop fails.
*/
struct CSNode* Pop(Stack* pS)
{
	struct CSNode* Elem;
	//
	// The stack is empty and the pop fails
	//	
	if(StackEmpty(pS))
		return 0;
	
	Elem = pS->buffer[pS->top];
	pS->top--;
	
	return Elem;
}

/*
function:
	Determines whether the stack is empty.

parameter:
	pQ -- The stack pointer
  
returned value:
	Returns 1 if stack is empty.
	Returns 0 if the stack is not empty.
*/
int StackEmpty(Stack* pS)
{
	return -1 == pS->top ? 1 : 0;
}
