#include "CSTree.h"

Stack stack;        // Stack. Used to store nodes

int main(int argc, char* argv[])
{
	CSTree pTree;	// Pointer to a tree
	
	//
	// Initialize the stack
	//
	InitStack(&stack); 
	
	//
	// Create a tree, Use binary linked list notation
	//
	pTree = InitTree();
	
	//
	// The first sequence traversal tree
	//
	PreOrder(pTree);
	
	//
	// output result
	//	
	OutputResult();
	
	//
	// Destruction of the tree
	//
	DeleteTree(pTree);

	return 0;
}

/*
function:
	The first sequence traversal tree.Stack implementation of non - recursive algorithm.

parameter:
	pTree -- The tree pointer.
  
returned value:
	Returns 1 if the traversal succeeds
	Returns 0 if the traversal fails
*/
char g_string[MAX_NUMBER];			// String. Used to save the preordered sequence of a tree during traversal
int g_length = 0;					// The string length.0 indicates an empty string
int PreOrder(CSTree pTree)
{
	CSNode* pNode;					// Tree node pointer
	
	//
	// TODO: Add the code here
	//	
	
	return 0;
}

/*
function:
	Create a node in the tree.

parameter:
	data -- Data saved by tree nodes
  
returned value:
	Return node pointer
*/
CSNode* CreateNode(char data)
{
	CSNode* pNode = (CSNode*)malloc(sizeof(CSNode));
	
	pNode->data = data;
	pNode->firstchild = NULL;
	pNode->nextsibling = NULL;
	
	return pNode;
}

/*
function:
	Create a subtree.

parameter:
	data -- Data saved by tree nodes
	pRootNode -- Pointer to a tree
  
returned value:
		nothing
*/
void CreateSubTree(char* data, CSTree pRootNode)
{
	int i;
	CSTree pFirstChild;
		
	pRootNode->firstchild = CreateNode(data[1]);
	pFirstChild = pRootNode->firstchild;
		
	for(i = 2; data[i] != '\0'; i++)
	{
		pFirstChild->nextsibling = CreateNode(data[i]);
		pFirstChild = pFirstChild->nextsibling; 
	}	
}

/*
function:
	Create a tree using a preorder traversal algorithm.

parameter:
	CSTree -- Pointer to a tree
  
returned value:
	Returns a pointer to a node whose data is Key
*/
CSNode* PreOrderCreate(CSTree pTree, char Key)
{
	CSNode* pNode = NULL;
	
	if(pTree != NULL)
	{	
		if(pTree->data == Key)
			return pTree;
			
		pNode = PreOrderCreate(pTree->firstchild, Key);
		if(pNode != NULL)
			return pNode;
		pNode = PreOrderCreate(pTree->nextsibling, Key);	
		if(pNode != NULL)
			return pNode;
	}

	return NULL;
}

/*
function:
	Initialize the tree with a two-dimensional array.
  
returned value:
	Return tree pointer
*/
const char data[MAX_NUMBER][MAX_NUMBER] = 
{ { 'R', 'A', 'B', 'C' },	  	  // Two dimensional array for initializing the tree, one subtree for each row of the two dimensional array,
  { 'A', 'D', 'E'      },	  	  // The first character initializes the root node of the subtree,The second character initializes the child node,
  { 'C', 'F'    	   },	      // The rest of the characters are used to initialize sibling nodes.notice:
  { 'F', 'G', 'H', 'K' } };		  // The first character of the first line is used to construct the root node of the entire tree,
						 		  // The first character of the remaining lines should be the child or sibling of the previous line.

CSTree InitTree()
{	
	int i = 0;
	CSNode* pNode = NULL;
	CSTree pRootNode = CreateNode(data[0][0]); 
	
	for(i = 0; data[i][0] != 0; i++)
	{
		pNode = PreOrderCreate(pRootNode, data[i][0]);	
		CreateSubTree((char*)data[i], pNode);
	}
	
	return pRootNode;
}

/*
function:
	Destruction of the tree.

parameter:
	pTree -- The tree pointer.
  
returned value:
	nothing
*/
void DeleteTree(CSTree pTree)
{
	//
	// The sequential traversal algorithm is implemented by recursion
	//
	if(pTree != NULL)
	{	
		DeleteTree(pTree->firstchild);
		DeleteTree(pTree->nextsibling);
		
		free(pTree);
	}
}

/*
function:
	output result.

parameter:
	nothing
  
returned value:
	nothing
*/
void OutputResult()
{
	int i;
	for(i = 0; i < g_length - 1; i++)
	{
		printf("%c", g_string[i]);
	} 
	printf("\n");
}

