#include "Stack.h"


/*
功能：
	初始化栈。

参数：
	pS -- 栈的指针
*/
void InitStack(Stack* pS)
{
	pS->top = -1;
}

/*
功能：
	将元素入栈。

参数：
	pS -- 栈的指针
	Elem -- 入栈的元素
  
返回值：
	如果插入成功返回入栈元素的值。
	如果插入失败返回 -1。
*/
struct CSNode* Push(Stack* pS, struct CSNode* Elem)
{
	//
	// 栈满，入栈失败。
	//
	if(MAX_STACK_LENGTH < pS->top)
		return 0;
		
	pS->top++;
	pS->buffer[pS->top] = Elem; // 将元素插入栈顶
	
	return Elem;
}

/*
功能：
	将栈顶元素出栈

参数：
	pS -- 栈的指针
  
返回值：
	如果出栈成功返回出栈元素的值。
	如果出栈失败返回 -1。
*/
struct CSNode* Pop(Stack* pS)
{
	struct CSNode* Elem;
	//
	// 栈为空，出栈失败
	//	
	if(StackEmpty(pS))
		return 0;
	
	Elem = pS->buffer[pS->top];
	pS->top--;
	
	return Elem;
}

/*
功能：
	判断栈是否为空。

参数：
	pQ -- 栈的指针
  
返回值：
	如果栈空返回 1（真）
	如果栈非空返回 0（假）
*/
int StackEmpty(Stack* pS)
{
	return -1 == pS->top ? 1 : 0;
}
