#include "Graph.h"
#include <stdlib.h>

// Array of vertex access flags.0 means no access; Greater than 0 indicates the order of access.
int visited[MAX_VERTEX_NUM];	

int main(int argc, char* argv[])
{
	Graph graph;
	int i;
	
	//
	// Initialize the figure
	//
	InitGraph(&graph);
	
	//
	// Initializes an array of access flags
	//
	for (i=0; i<graph.length; i++)
	{
		visited[i] = 0;
	}

	//
	// Depth-first search
	//
	DepthFirstSearch(&graph);
	
	//
	// output result
	//
	OutputResult(&graph);
	
	//
	// Destruction of figure
	//
	DeleteGraph(&graph);

	return 0;
}

/*
function:
	Depth-first search.Stack implementation of non - recursive algorithm.

parameter:
	pGraph -- Figure pointer
*/
void DepthFirstSearch(Graph* pGraph)
{
	ArcNode* Stack[MAX_VERTEX_NUM];		// Stack.
	int top = 0;						// The top of the stack.0 means empty stack

	ArcNode* pArcNode;		// Edge (arc) node pointer
	int i, v;				// Vertex ordinal. Counts from 0.
	int nVisitCount = 0;	// Access counter.
	
	//
	// TODO: Add the code here
	//
	
	return;
}

/*
function:
	Initializes the graph's adjacency list with the given data

parameter:
	pGraph -- Figure pointer
*/
typedef struct VertexArrayEntry 
{
	// Name of the vertices.NULL indicates the end of the vertex sequence.
	const char* name;				
	// The sequence of vertices adjacent to this vertex.-1 indicates the end of the sequence.
	int VexIndex[MAX_VERTEX_NUM];	
}VertexArrayEntry;
const VertexArrayEntry VertexArray[] = 
{
	{ "V0", {2, 5, 6, 1, -1}	},
	{ "V1", {3, 6, 4, 2, -1}	},
	{ "V2", {0, 3, 6, 1, -1}	},
	{ "V3", {1, 2, 4, -1}		},
	{ "V4", {1, 3, -1}			},
	{ "V5", {0, 6, -1}			},
	{ "V6", {2, 5, 0, -1}		},
	{ NULL 						}	// End mark
};
void InitGraph(Graph* pGraph)
{
	int i, j;
	ArcNode** pArcNodePtr;	// Pointer to pointer
	
	//
	// Reset the length of the data in the graph
	//
	pGraph->length = 0;
	
	//
	// Initializes the graph's adjacency list with the given data
	//
	for (i=0; i<MAX_VERTEX_NUM ;i++)
	{
		if (NULL == VertexArray[i].name)
		{
			break;
		}
			
		pGraph->vexlist[i].name = VertexArray[i].name;
		
		pArcNodePtr = &pGraph->vexlist[i].firstarc;
		for (j=0; j<MAX_VERTEX_NUM; j++)
		{
			if (-1 == VertexArray[i].VexIndex[j])
			{
				*pArcNodePtr = NULL;
				break;
			}
			
			*pArcNodePtr = (ArcNode*)malloc(sizeof(ArcNode));
			(*pArcNodePtr)->vertex = VertexArray[i].VexIndex[j];
			pArcNodePtr = &(*pArcNodePtr)->next;
		}
		
		pGraph->length++;
	}
}

/*
function:
	Destruction of figure

parameter:
	pGraph -- Figure pointer
*/
void DeleteGraph(Graph* pGraph)
{
	int i;
	ArcNode* pArcNode;
	
	for (i=0; i<pGraph->length; i++)
	{
		while (pGraph->vexlist[i].firstarc != NULL)
		{
			pArcNode = pGraph->vexlist[i].firstarc;
			pGraph->vexlist[i].firstarc = pArcNode->next;
			free(pArcNode);
		}
	}
	
	pGraph->length = 0;
}

/*
function:
	output result.

parameter:
	pGraph -- Figure pointer
*/
void OutputResult(Graph* pGraph)
{
	int i, j;
	for (i=0; i< pGraph->length; i++)
	{
		for (j=0; j< pGraph->length; j++)
		{
			if (visited[j] == i+1)
			{
				printf("%s ", pGraph->vexlist[j].name);
			}
		}	
	}
	printf("\n");
}
