#ifndef GRAPH_H_
#define GRAPH_H_

//
// Include the C standard library header file here
//

#include <stdio.h>

//
// Other header files are included here
//

//
// Define the data structure here
//

#define MAX_VERTEX_NUM 50	// Maximum number of vertices

// Edge (arc)
typedef struct ArcNode 
{
	int vertex;				// Vertex field. That is, the index of the vertex in the vertex array.
	struct ArcNode* next;	// Chain domain. Point to the next Edge (arc).
}ArcNode;

// vertex
typedef struct VexNode 
{
	// Use a string as the vertex's stored value. You can also think of it as the vertex's name.
	const char* name;			
	struct ArcNode* firstarc;	// Pointing to the first side arc.
}VexNode;

// Graph. Use adjacency list storage
typedef struct Graph 
{
	VexNode vexlist[MAX_VERTEX_NUM];	// Vertex table
	int length;							// Vertex number
}Graph;

//
// Declare the function here
//

void DepthFirstSearch(Graph* pGraph);
void InitGraph(Graph* pGraph);
void DeleteGraph(Graph* pGraph);
void OutputResult(Graph* pGraph);

//
// Declare global variables here
//
extern int visited[MAX_VERTEX_NUM];

#endif /* GRAPH_H_ */
