﻿# 阅读实验源代码
**main.c文件**   
在main函数中首先初始化了图，然后调用DepthFirstSearch函数对图进行深度优先搜索操作，并在全局变量visited中记录下了顶点访问的先后次序,最后销毁了图。   
在main函数的后面，分别定义了图的深度优先搜索函数DepthFirstSearch，以及图的初始化函数和销毁函数。其中，深度优先搜索函数DepthFirstSearch的函数体还不完整，留给读者完成。   
**Graph.h文件**   
定义了与图相关的数据结构并声明了相关的操作函数和全局变量。   
# 在演示模式下调试项目
**按照下面的步骤调试项目：**
1.	按F7生成项目。
2.	在演示模式下，按F5启动调试项目。程序会在观察点函数的开始位置中断。
3.	重复按F5，直到调试过程结束。

在调试的过程中，每执行“演示流程”窗口中的一行后，仔细观察“可视化数据”窗口内容所发生的变化，理解深度优先搜索的执行过程。“可视化数据”窗口显示的数据信息（如下图所示），包括：
-	对图进行深度优先搜索时产生的顶点访问序列。  
-	图的邻接表。  
a)	包括顶点访问标志（0表示顶点未被访问，大于0表示顶点被访问的先后次序，使用白色的字体表示）、顶点名称字符串，已访问过的顶点的填充色为灰色。   
b)	顶点的邻接点（即图中的边、或者弧），如果该邻接顶点在栈中，填充色为绿色。   
c)	在调试的过程中可以看到游标的移动。   
-	深度优先搜索使用的栈。包括了邻接点的地址、值，以及数组下标。   
-	在图中，顶点与边的关系。   
a)	已访问过的顶点的填充色为灰色，并使用白色的字体标出了顶点的访问序列。   
b)	相邻顶点连接的边，如果是游标指向的当前边，用红色表示，如果在栈中，用绿色表示。   
c)	在调试的过程中，可以看到游标的移动。   

![图的深度优先搜索1](./img/15_1.png)
![图的深度优先搜索2](./img/15_2.png)


# 编写源代码并通过验证
**按照下面的步骤继续实验：**
1.	为DepthFirstSearch函数编写源代码，要求利用栈实现非递归的深度优先搜索算法。注意，尽量使用已定义的局部变量。
2.	按F7生成项目。如果生成失败，根据“输出”窗口中的提示信息修改源代码中的语法错误。
3.	按Alt+F5启动验证。如果验证失败，可以使用“输出”窗口中的“比较”功能，或者在“非演示模式”下按F5启动调试后重复按F10单步调试读者编写的源代码，从而定位错误的位置，然后回到步骤1。  

>
**`提示：`** 在验证过程中，主要是检测顶点访问序列、以及顶点访问数组生成的是否正确，所以，为了顺利通过验证，请读者在对图进行搜索的同时一定要在全局变量visited中记录下顶点访问的先后次序。
>

# 教师参考答案
请教师用户首先访问[教师项目群组](https://www.codecode.net/engintime/ds-lab/teachers-packet),申请权限并审核通过后，再[domain relative url](engintime/ds-lab/teachers-packet/Lab015.git)访问本项目的参考答案
